/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.policy.AspectDetails;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyScope
extends AspectDetails {
    protected Map<QName, AspectDetails> aspectCopyDetails = new HashMap<QName, AspectDetails>();

    public PolicyScope(QName classRef) {
        super(classRef);
    }

    public void addProperty(QName classRef, QName qName, Serializable value) {
        if (classRef.equals((Object)this.classRef)) {
            this.addProperty(qName, value);
        } else {
            AspectDetails aspectDetails = this.aspectCopyDetails.get(classRef);
            if (aspectDetails == null) {
                aspectDetails = this.addAspect(classRef);
            }
            aspectDetails.addProperty(qName, value);
        }
    }

    public void removeProperty(QName classRef, QName qName) {
        if (classRef.equals((Object)this.classRef)) {
            this.removeProperty(qName);
        } else {
            AspectDetails aspectDetails = this.aspectCopyDetails.get(classRef);
            if (aspectDetails != null) {
                aspectDetails.removeProperty(qName);
            }
        }
    }

    public Map<QName, Serializable> getProperties(QName classRef) {
        Map<QName, Serializable> result = null;
        if (classRef.equals((Object)this.classRef)) {
            result = this.getProperties();
        } else {
            AspectDetails aspectDetails = this.aspectCopyDetails.get(classRef);
            if (aspectDetails != null) {
                result = aspectDetails.getProperties();
            }
        }
        return result;
    }

    public void addChildAssociation(QName classRef, ChildAssociationRef childAssocRef) {
        if (classRef.equals((Object)this.classRef)) {
            this.addChildAssociation(childAssocRef);
        } else {
            AspectDetails aspectDetails = this.aspectCopyDetails.get(classRef);
            if (aspectDetails == null) {
                aspectDetails = this.addAspect(classRef);
            }
            aspectDetails.addChildAssociation(childAssocRef);
        }
    }

    public void addChildAssociation(QName classRef, ChildAssociationRef childAssocRef, boolean alwaysTraverseAssociation) {
        if (classRef.equals((Object)this.classRef)) {
            this.addChildAssociation(childAssocRef, alwaysTraverseAssociation);
        } else {
            AspectDetails aspectDetails = this.aspectCopyDetails.get(classRef);
            if (aspectDetails == null) {
                aspectDetails = this.addAspect(classRef);
            }
            aspectDetails.addChildAssociation(childAssocRef, alwaysTraverseAssociation);
        }
    }

    public List<ChildAssociationRef> getChildAssociations(QName classRef) {
        List<ChildAssociationRef> result = null;
        if (classRef.equals((Object)this.classRef)) {
            result = this.getChildAssociations();
        } else {
            AspectDetails aspectDetails = this.aspectCopyDetails.get(classRef);
            if (aspectDetails != null) {
                result = aspectDetails.getChildAssociations();
            }
        }
        return result;
    }

    public boolean isChildAssociationRefAlwaysTraversed(QName classRef, ChildAssociationRef childAssocRef) {
        boolean result = false;
        if (classRef.equals((Object)this.classRef)) {
            result = this.isChildAssociationRefAlwaysTraversed(childAssocRef);
        } else {
            AspectDetails aspectDetails = this.aspectCopyDetails.get(classRef);
            if (aspectDetails != null) {
                result = aspectDetails.isChildAssociationRefAlwaysTraversed(childAssocRef);
            }
        }
        return result;
    }

    public void addAssociation(QName classRef, AssociationRef nodeAssocRef) {
        if (classRef.equals((Object)this.classRef)) {
            this.addAssociation(nodeAssocRef);
        } else {
            AspectDetails aspectDetails = this.aspectCopyDetails.get(classRef);
            if (aspectDetails == null) {
                aspectDetails = this.addAspect(classRef);
            }
            aspectDetails.addAssociation(nodeAssocRef);
        }
    }

    public List<AssociationRef> getAssociations(QName classRef) {
        List<AssociationRef> result = null;
        if (classRef.equals((Object)this.classRef)) {
            result = this.getAssociations();
        } else {
            AspectDetails aspectDetails = this.aspectCopyDetails.get(classRef);
            if (aspectDetails != null) {
                result = aspectDetails.getAssociations();
            }
        }
        return result;
    }

    public AspectDetails addAspect(QName aspect) {
        AspectDetails result = new AspectDetails(aspect);
        this.aspectCopyDetails.put(aspect, result);
        return result;
    }

    public void removeAspect(QName aspect) {
        this.aspectCopyDetails.remove(aspect);
    }

    public Set<QName> getAspects() {
        return this.aspectCopyDetails.keySet();
    }
}

