/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.model.RenditionModel;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.rendition.RenditionLocation;
import org.alfresco.repo.rendition.executer.AbstractRenderingEngine;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.rendition.RenditionServiceException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RenditionNodeManager {
    private static Log logger = LogFactory.getLog(RenditionNodeManager.class);
    private static final List<QName> unchangedProperties = Arrays.asList(ContentModel.PROP_NODE_REF, ContentModel.PROP_STORE_NAME);
    private static final String LINE_BREAK = System.getProperty("line.separator", "\n");
    private final NodeRef sourceNode;
    private final NodeRef tempRenditionNode;
    private final RenditionDefinition renditionDefinition;
    private final RenditionLocation location;
    private final NodeService nodeService;
    private BehaviourFilter behaviourFilter;
    private final RenditionService renditionService;
    private final NodeRef existingLinkedRendition;
    private ChildAssociationRef finalRenditionAssoc;

    public RenditionNodeManager(NodeRef sourceNode, NodeRef tempRenditionNode, RenditionLocation location, RenditionDefinition renditionDefinition, NodeService nodeService, RenditionService renditionService, BehaviourFilter behaviourFilter) {
        this.sourceNode = sourceNode;
        this.tempRenditionNode = tempRenditionNode;
        this.location = location;
        this.renditionDefinition = renditionDefinition;
        this.nodeService = nodeService;
        this.renditionService = renditionService;
        this.behaviourFilter = behaviourFilter;
        this.existingLinkedRendition = this.getExistingRendition(sourceNode, renditionDefinition);
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Creating/updating rendition based on:").append(LINE_BREAK).append("    sourceNode: ").append(sourceNode).append(LINE_BREAK).append("    tempRendition: ").append(tempRenditionNode).append(LINE_BREAK).append("    parentNode: ").append(location.getParentRef()).append(LINE_BREAK).append("    childNode: ").append(location.getChildRef()).append(LINE_BREAK).append("    childName: ").append(location.getChildName()).append(LINE_BREAK).append("    renditionDefinition.name: ").append(renditionDefinition.getRenditionName());
            logger.debug((Object)msg.toString());
        }
    }

    public ChildAssociationRef findOrCreateRenditionNode() {
        QName renditionName = this.renditionDefinition.getRenditionName();
        if (this.existingLinkedRendition == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No existing rendition was found to be linked from the source node.");
            }
            this.finalRenditionAssoc = this.getSpecifiedRenditionOrCreateNewRendition(renditionName);
        } else if (this.isOldRenditionInCorrectLocation()) {
            this.finalRenditionAssoc = this.nodeService.getPrimaryParent(this.existingLinkedRendition);
        } else {
            if (this.isOrphaningRequired()) {
                this.orphanOldRendition((QNamePattern)renditionName);
                this.finalRenditionAssoc = this.getSpecifiedRenditionOrCreateNewRendition(renditionName);
            }
            this.finalRenditionAssoc = this.moveOldRendition(renditionName);
        }
        return this.finalRenditionAssoc;
    }

    private ChildAssociationRef moveOldRendition(QName associationName) {
        NodeRef parent = this.location.getParentRef();
        QName assocType = this.sourceNode.equals((Object)parent) ? RenditionModel.ASSOC_RENDITION : ContentModel.ASSOC_CONTAINS;
        ChildAssociationRef result = this.nodeService.moveNode(this.existingLinkedRendition, parent, assocType, associationName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("The old rendition was moved to " + result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void orphanOldRendition(QNamePattern renditionName) {
        ChildAssociationRef parentAssoc;
        List parents = this.nodeService.getParentAssocs(this.existingLinkedRendition, (QNamePattern)RenditionModel.ASSOC_RENDITION, renditionName);
        if (parents.size() == 1 && (parentAssoc = (ChildAssociationRef)parents.get(0)).getParentRef().equals((Object)this.sourceNode)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Orphaning old rendition node " + this.existingLinkedRendition));
            }
            this.behaviourFilter.disableBehaviour(this.existingLinkedRendition, ContentModel.ASPECT_AUDITABLE);
            try {
                this.nodeService.removeAspect(this.existingLinkedRendition, RenditionModel.ASPECT_HIDDEN_RENDITION);
                this.nodeService.removeAspect(this.existingLinkedRendition, RenditionModel.ASPECT_VISIBLE_RENDITION);
                Object var5_4 = null;
                this.behaviourFilter.enableBehaviour(this.existingLinkedRendition, ContentModel.ASPECT_AUDITABLE);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.behaviourFilter.enableBehaviour(this.existingLinkedRendition, ContentModel.ASPECT_AUDITABLE);
                throw throwable;
            }
            this.nodeService.removeChildAssociation(parentAssoc);
            return;
        }
        String msg = "Node: " + this.existingLinkedRendition + " is not a rendition of type: " + renditionName + " for source node: " + this.sourceNode;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)msg);
        }
        throw new RenditionServiceException(msg);
    }

    private boolean isOrphaningRequired() {
        boolean result = this.location.getChildRef() != null ? true : AbstractRenderingEngine.getParamWithDefault("orphan-existing-rendition", Boolean.FALSE, this.renditionDefinition);
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("The old rendition does ");
            if (!result) {
                msg.append("not ");
            }
            msg.append("require orphaning.");
            logger.debug((Object)msg.toString());
        }
        return result;
    }

    private boolean isOldRenditionInCorrectLocation() {
        boolean result;
        NodeRef destination = this.location.getChildRef();
        if (destination != null) {
            result = destination.equals((Object)this.existingLinkedRendition);
        } else {
            ChildAssociationRef oldParentAssoc = this.nodeService.getPrimaryParent(this.existingLinkedRendition);
            NodeRef oldParent = oldParentAssoc.getParentRef();
            if (oldParent.equals((Object)this.location.getParentRef())) {
                String childName = this.location.getChildName();
                if (childName == null) {
                    result = true;
                } else {
                    Serializable oldName = this.nodeService.getProperty(this.existingLinkedRendition, ContentModel.PROP_NAME);
                    result = childName.equals(oldName);
                }
            }
            result = false;
        }
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("The old rendition was ");
            if (!result) {
                msg.append("not ");
            }
            msg.append("in the correct location");
            logger.debug((Object)msg.toString());
        }
        return result;
    }

    private ChildAssociationRef getSpecifiedRenditionOrCreateNewRendition(QName renditionName) {
        ChildAssociationRef result;
        NodeRef destination = this.location.getChildRef();
        if (destination != null) {
            this.checkDestinationNodeIsAcceptable(destination);
            ChildAssociationRef existingSrcNode = this.renditionService.getSourceNode(destination);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Using destination node " + destination + " with existing srcNode: " + existingSrcNode));
            }
            result = this.nodeService.getPrimaryParent(destination);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Destination was not null. Using primary parent of " + destination));
            }
        } else {
            result = this.createNewRendition(renditionName);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using rendition " + result));
        }
        return result;
    }

    private void checkDestinationNodeIsAcceptable(NodeRef destination) {
        if (!this.nodeService.exists(destination)) {
            return;
        }
        if (!this.renditionService.isRendition(destination)) {
            throw new RenditionServiceException("Cannot perform a rendition to an existing node that is not a rendition.");
        }
        if (!this.renditionService.getSourceNode(destination).getParentRef().equals((Object)this.sourceNode)) {
            throw new RenditionServiceException("Cannot perform a rendition to an existing rendition node whose source is different.");
        }
        if (!this.renditionService.getSourceNode(destination).getQName().equals((Object)this.renditionDefinition.getRenditionName())) {
            throw new RenditionServiceException("Cannot perform a rendition to an existing rendition node whose rendition name is different.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChildAssociationRef createNewRendition(QName renditionName) {
        NodeRef parentRef = this.location.getParentRef();
        boolean parentIsSource = parentRef.equals((Object)this.sourceNode);
        QName renditionType = RenditionModel.ASSOC_RENDITION;
        QName assocTypeQName = parentIsSource ? renditionType : ContentModel.ASSOC_CONTAINS;
        QName nodeTypeQName = ContentModel.TYPE_CONTENT;
        ChildAssociationRef primaryAssoc = this.nodeService.createNode(parentRef, assocTypeQName, renditionName, nodeTypeQName);
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Created final rendition node ").append(primaryAssoc);
            logger.debug((Object)msg.toString());
        }
        if (!parentIsSource) {
            NodeRef rendition = primaryAssoc.getChildRef();
            ChildAssociationRef newChild = null;
            this.behaviourFilter.disableBehaviour(this.sourceNode, ContentModel.ASPECT_AUDITABLE);
            try {
                newChild = this.nodeService.addChild(this.sourceNode, rendition, renditionType, renditionName);
                Object var11_10 = null;
                this.behaviourFilter.enableBehaviour(this.sourceNode, ContentModel.ASPECT_AUDITABLE);
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                this.behaviourFilter.enableBehaviour(this.sourceNode, ContentModel.ASPECT_AUDITABLE);
                throw throwable;
            }
            if (logger.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Added new rendition node as child of source node ").append(newChild);
                logger.debug((Object)msg.toString());
            }
        }
        return primaryAssoc;
    }

    private NodeRef getExistingRendition(NodeRef sourceNode, RenditionDefinition renditionDefinition) {
        NodeRef result;
        QName renditionName = renditionDefinition.getRenditionName();
        ChildAssociationRef renditionAssoc = this.renditionService.getRenditionByName(sourceNode, renditionName);
        NodeRef nodeRef = result = renditionAssoc == null ? null : renditionAssoc.getChildRef();
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Existing rendition with name ").append(renditionName).append(": ").append(result);
            logger.debug((Object)msg.toString());
        }
        return result;
    }

    public void transferNodeProperties() {
        NodeRef targetNode = this.finalRenditionAssoc.getChildRef();
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Transferring some properties from ").append(this.tempRenditionNode).append(" to ").append(targetNode);
            logger.debug((Object)msg.toString());
        }
        QName type = this.nodeService.getType(this.tempRenditionNode);
        this.nodeService.setType(targetNode, type);
        HashMap newProps = new HashMap();
        for (Map.Entry entry : this.nodeService.getProperties(this.tempRenditionNode).entrySet()) {
            QName propKey = (QName)entry.getKey();
            if (unchangedProperties.contains(propKey) || "http://www.alfresco.org/model/system/1.0".equals(propKey.getNamespaceURI())) continue;
            newProps.put(propKey, entry.getValue());
        }
        this.nodeService.setProperties(targetNode, newProps);
    }
}

