/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import net.sf.acegisecurity.Authentication;
import org.alfresco.repo.security.authentication.AbstractAuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractChainingAuthenticationComponent
extends AbstractAuthenticationComponent {
    protected abstract Collection<AuthenticationComponent> getUsableAuthenticationComponents();

    @Override
    protected void authenticateImpl(String userName, char[] password) {
        for (AuthenticationComponent authComponent : this.getUsableAuthenticationComponents()) {
            try {
                authComponent.authenticate(userName, password);
                return;
            }
            catch (AuthenticationException e) {
            }
        }
        throw new AuthenticationException("Failed to authenticate");
    }

    @Override
    protected boolean implementationAllowsGuestLogin() {
        for (AuthenticationComponent authComponent : this.getUsableAuthenticationComponents()) {
            if (!authComponent.guestUserAuthenticationAllowed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Authentication setCurrentUser(String userName, AuthenticationComponent.UserNameValidationMode validationMode) {
        for (AuthenticationComponent authComponent : this.getUsableAuthenticationComponents()) {
            try {
                return authComponent.setCurrentUser(userName, validationMode);
            }
            catch (AuthenticationException e) {
            }
        }
        throw new AuthenticationException("Failed to set current user " + userName);
    }

    @Override
    public Authentication setCurrentUser(String userName) {
        for (AuthenticationComponent authComponent : this.getUsableAuthenticationComponents()) {
            try {
                return authComponent.setCurrentUser(userName);
            }
            catch (AuthenticationException e) {
            }
        }
        throw new AuthenticationException("Failed to set current user " + userName);
    }

    @Override
    public Set<String> getDefaultAdministratorUserNames() {
        TreeSet<String> defaultAdministratorUserNames = new TreeSet<String>();
        for (AuthenticationComponent authComponent : this.getUsableAuthenticationComponents()) {
            defaultAdministratorUserNames.addAll(authComponent.getDefaultAdministratorUserNames());
        }
        return defaultAdministratorUserNames;
    }

    @Override
    public Set<String> getDefaultGuestUserNames() {
        TreeSet<String> defaultGuestUserNames = new TreeSet<String>();
        for (AuthenticationComponent authComponent : this.getUsableAuthenticationComponents()) {
            defaultGuestUserNames.addAll(authComponent.getDefaultGuestUserNames());
        }
        return defaultGuestUserNames;
    }
}

