/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.impl.PermissionReferenceImpl;
import org.alfresco.repo.security.permissions.impl.model.AbstractPermission;
import org.alfresco.repo.security.permissions.impl.model.PermissionModel;
import org.alfresco.repo.security.permissions.impl.model.PermissionModelException;
import org.alfresco.repo.security.permissions.impl.model.XMLModelInitialisable;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.dom4j.Attribute;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Permission
extends AbstractPermission
implements XMLModelInitialisable {
    private static final long serialVersionUID = -4560426591597681329L;
    private static final String GRANTED_TO_GROUP = "grantedToGroup";
    private static final String GTG_NAME = "permissionGroup";
    private static final String GTG_TYPE = "type";
    private Set<PermissionReference> grantedToGroups = new HashSet<PermissionReference>();
    private static final String DENY = "deny";
    private static final String ALLOW = "allow";
    private static final String DEFAULT_PERMISSION = "defaultPermission";
    private static final String EXPOSE = "expose";
    private static final String REQUIRES_TYPE = "requiresType";
    private AccessStatus defaultPermission;
    private boolean isExposed;
    private boolean requiresType;

    public Permission(QName typeQName) {
        super(typeQName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void initialise(Element element, NamespacePrefixResolver nspr, PermissionModel permissionModel) {
        super.initialise(element, nspr, permissionModel);
        Attribute att = element.attribute(EXPOSE);
        this.isExposed = att != null ? Boolean.parseBoolean(att.getStringValue()) : true;
        att = element.attribute(REQUIRES_TYPE);
        this.requiresType = att != null ? Boolean.parseBoolean(att.getStringValue()) : true;
        Attribute defaultPermissionAttribute = element.attribute(DEFAULT_PERMISSION);
        if (defaultPermissionAttribute != null) {
            if (defaultPermissionAttribute.getStringValue().equalsIgnoreCase(ALLOW)) {
                this.defaultPermission = AccessStatus.ALLOWED;
            } else {
                if (!defaultPermissionAttribute.getStringValue().equalsIgnoreCase(DENY)) throw new PermissionModelException("The default permission must be deny or allow");
                this.defaultPermission = AccessStatus.DENIED;
            }
        } else {
            this.defaultPermission = AccessStatus.DENIED;
        }
        Iterator gtgit = element.elementIterator(GRANTED_TO_GROUP);
        while (gtgit.hasNext()) {
            Element grantedToGroupsElement = (Element)gtgit.next();
            Attribute typeAttribute = grantedToGroupsElement.attribute(GTG_TYPE);
            QName qName = typeAttribute != null ? QName.createQName((String)typeAttribute.getStringValue(), (NamespacePrefixResolver)nspr) : this.getTypeQName();
            String grantedName = grantedToGroupsElement.attributeValue(GTG_NAME);
            this.grantedToGroups.add(PermissionReferenceImpl.getPermissionReference(qName, grantedName));
        }
    }

    public AccessStatus getDefaultPermission() {
        return this.defaultPermission;
    }

    public Set<PermissionReference> getGrantedToGroups() {
        return Collections.unmodifiableSet(this.grantedToGroups);
    }

    public boolean isExposed() {
        return this.isExposed;
    }

    public boolean isTypeRequired() {
        return this.requiresType;
    }
}

