/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.person;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.person.HomeFolderProvider;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;

public class HomeFolderManager
implements NodeServicePolicies.OnCreateNodePolicy {
    private PolicyComponent policyComponent;
    private NodeService nodeService;
    private boolean enableHomeFolderCreationAsPeopleAreCreated = false;
    private HomeFolderProvider defaultProvider;
    private Map<String, HomeFolderProvider> providers = new HashMap<String, HomeFolderProvider>();

    public void init() throws Exception {
        if (this.enableHomeFolderCreationAsPeopleAreCreated) {
            this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onCreateNode"), ContentModel.TYPE_PERSON, (Behaviour)new JavaBehaviour(this, "onCreateNode"));
        }
    }

    public void setEnableHomeFolderCreationAsPeopleAreCreated(boolean enableHomeFolderCreationAsPeopleAreCreated) {
        this.enableHomeFolderCreationAsPeopleAreCreated = enableHomeFolderCreationAsPeopleAreCreated;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void addProvider(HomeFolderProvider provider) {
        this.providers.put(provider.getName(), provider);
    }

    public void setDefaultProvider(HomeFolderProvider defaultProvider) {
        this.defaultProvider = defaultProvider;
    }

    public void onCreateNode(ChildAssociationRef childAssocRef) {
        if (this.enableHomeFolderCreationAsPeopleAreCreated) {
            this.makeHomeFolder(childAssocRef);
        }
    }

    public void makeHomeFolder(ChildAssociationRef childAssocRef) {
        HomeFolderProvider provider = this.defaultProvider;
        String providerName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(childAssocRef.getChildRef(), ContentModel.PROP_HOME_FOLDER_PROVIDER));
        if (providerName != null && (provider = this.providers.get(providerName)) == null) {
            provider = this.defaultProvider;
        }
        if (provider != null) {
            provider.onCreateNode(childAssocRef);
        }
    }
}

