/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.site.script;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.site.script.Site;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.springframework.extensions.surf.util.ParameterCheck;

public class ScriptSiteService
extends BaseScopableProcessorExtension {
    public static final String PUBLIC_SITE = "PUBLIC";
    public static final String MODERATED_SITE = "MODERATED";
    public static final String PRIVATE_SITE = "PRIVATE";
    private ServiceRegistry serviceRegistry;
    private SiteService siteService;

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public Site createSite(String sitePreset, String shortName, String title, String description, boolean isPublic) {
        SiteInfo siteInfo = this.siteService.createSite(sitePreset, shortName, title, description, isPublic);
        return new Site(siteInfo, this.serviceRegistry, this.siteService, this.getScope());
    }

    public Site createSite(String sitePreset, String shortName, String title, String description, String visibility) {
        ParameterCheck.mandatoryString((String)"visibility", (String)visibility);
        SiteVisibility siteVisibility = SiteVisibility.valueOf(visibility);
        SiteInfo siteInfo = this.siteService.createSite(sitePreset, shortName, title, description, siteVisibility);
        return new Site(siteInfo, this.serviceRegistry, this.siteService, this.getScope());
    }

    public boolean hasCreateSitePermissions() {
        return this.siteService.hasCreateSitePermissions();
    }

    public Site[] listSites(String nameFilter, String sitePresetFilter) {
        return this.listSites(nameFilter, sitePresetFilter, 0);
    }

    public Site[] listSites(String nameFilter, String sitePresetFilter, int size) {
        List<SiteInfo> siteInfos = this.siteService.listSites(nameFilter, sitePresetFilter, size);
        ArrayList<Site> sites = new ArrayList<Site>(siteInfos.size());
        for (SiteInfo siteInfo : siteInfos) {
            sites.add(new Site(siteInfo, this.serviceRegistry, this.siteService, this.getScope()));
        }
        return sites.toArray(new Site[sites.size()]);
    }

    public Site[] listUserSites(String userName) {
        List<SiteInfo> siteInfos = this.siteService.listSites(userName);
        ArrayList<Site> sites = new ArrayList<Site>(siteInfos.size());
        for (SiteInfo siteInfo : siteInfos) {
            sites.add(new Site(siteInfo, this.serviceRegistry, this.siteService, this.getScope()));
        }
        return sites.toArray(new Site[sites.size()]);
    }

    public Site getSite(String shortName) {
        Site site = null;
        SiteInfo siteInfo = this.siteService.getSite(shortName);
        if (siteInfo != null) {
            site = new Site(siteInfo, this.serviceRegistry, this.siteService, this.getScope());
        }
        return site;
    }

    public String[] listSiteRoles() {
        List<String> roles = this.siteService.getSiteRoles();
        return roles.toArray(new String[roles.size()]);
    }
}

