/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.template;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.template.AVM;
import org.alfresco.repo.template.AVMTemplateNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.TemplateImageResolver;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVMTemplateStore {
    private ServiceRegistry services;
    private AVMStoreDescriptor descriptor;
    private TemplateImageResolver resolver;

    public AVMTemplateStore(ServiceRegistry services, TemplateImageResolver resolver, AVMStoreDescriptor store) {
        this.descriptor = store;
        this.services = services;
        this.resolver = resolver;
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public String getId() {
        return this.descriptor.getName();
    }

    public String getCreator() {
        return this.descriptor.getCreator();
    }

    public Date getCreatedDate() {
        return new Date(this.descriptor.getCreateDate());
    }

    public AVMTemplateNode getLookupRoot() {
        AVMTemplateNode rootNode = null;
        String rootPath = this.descriptor.getName() + ':' + AVM.getWebappsFolderPath();
        AVMNodeDescriptor nodeDesc = this.services.getAVMService().lookup(-1, rootPath);
        if (nodeDesc != null) {
            rootNode = new AVMTemplateNode(rootPath, -1, this.services, this.resolver);
        }
        return rootNode;
    }

    public AVMTemplateNode lookupNode(String path) {
        AVMTemplateNode node = null;
        if (path != null && path.length() != 0) {
            if (path.charAt(0) != '/') {
                path = '/' + path;
            }
            path = this.descriptor.getName() + ':' + AVM.getWebappsFolderPath() + path;
            AVMNodeDescriptor nodeDesc = this.services.getAVMService().lookup(-1, path);
            if (nodeDesc != null) {
                node = new AVMTemplateNode(path, -1, this.services, this.resolver);
            }
        }
        return node;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<AVMTemplateNode> luceneSearch(String query) {
        ArrayList<AVMTemplateNode> arrayList;
        ArrayList<AVMTemplateNode> nodes;
        block7: {
            nodes = null;
            ResultSet results = null;
            try {
                try {
                    results = this.services.getSearchService().query(new StoreRef("avm", this.descriptor.getName()), "lucene", query);
                    if (results.length() != 0) {
                        nodes = new ArrayList<AVMTemplateNode>(results.length());
                        for (ResultSetRow row : results) {
                            NodeRef nodeRef = row.getNodeRef();
                            nodes.add(new AVMTemplateNode(nodeRef, this.services, this.resolver));
                        }
                    }
                    Object var8_8 = null;
                    if (results == null) break block7;
                }
                catch (Throwable err) {
                    throw new AlfrescoRuntimeException("Failed to execute search: " + query, err);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (results == null) throw throwable;
                results.close();
                throw throwable;
            }
            results.close();
        }
        if (nodes != null) {
            arrayList = nodes;
            return arrayList;
        }
        arrayList = Collections.emptyList();
        return arrayList;
    }
}

