/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transaction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransactionalResourceHelper {
    public static final <K, V> Map<K, V> getMap(Object resourceKey) {
        HashMap map = (HashMap)AlfrescoTransactionSupport.getResource(resourceKey);
        if (map == null) {
            map = new HashMap(29);
            AlfrescoTransactionSupport.bindResource(resourceKey, map);
        }
        return map;
    }

    public static final <V> Set<V> getSet(Object resourceKey) {
        HashSet set = (HashSet)AlfrescoTransactionSupport.getResource(resourceKey);
        if (set == null) {
            set = new HashSet(29);
            AlfrescoTransactionSupport.bindResource(resourceKey, set);
        }
        return set;
    }

    public static final <V> TreeSet<V> getTreeSet(Object resourceKey) {
        TreeSet set = (TreeSet)AlfrescoTransactionSupport.getResource(resourceKey);
        if (set == null) {
            set = new TreeSet();
            AlfrescoTransactionSupport.bindResource(resourceKey, set);
        }
        return set;
    }

    public static final <V> List<V> getList(Object resourceKey) {
        ArrayList list = (ArrayList)AlfrescoTransactionSupport.getResource(resourceKey);
        if (list == null) {
            list = new ArrayList(29);
            AlfrescoTransactionSupport.bindResource(resourceKey, list);
        }
        return list;
    }

    public static final boolean setBoolean(Object resourceKey) {
        Boolean value = (Boolean)AlfrescoTransactionSupport.getResource(resourceKey);
        if (value == null) {
            AlfrescoTransactionSupport.bindResource(resourceKey, Boolean.TRUE);
            return true;
        }
        return false;
    }

    public static final void resetBoolean(Object resourceKey) {
        Boolean value = (Boolean)AlfrescoTransactionSupport.getResource(resourceKey);
        if (value == null) {
            AlfrescoTransactionSupport.unbindResource(resourceKey);
        }
    }

    public static final boolean testBoolean(Object resourceKey) {
        Boolean value = (Boolean)AlfrescoTransactionSupport.getResource(resourceKey);
        return value != null;
    }
}

