/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.usage;

import java.io.Serializable;
import java.util.HashMap;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.usage.UserUsageTrackingComponent;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.usage.ContentUsageService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class UserUsageTrackingComponentTest
extends TestCase {
    private static ApplicationContext applicationContext = ApplicationContextHelper.getApplicationContext();
    private boolean clean = true;
    private MutableAuthenticationService authenticationService;
    private ContentService contentService;
    private TransactionService transactionService;
    private PersonService personService;
    private NodeService nodeService;
    private UserUsageTrackingComponent userUsageTrackingComponent;
    private ContentUsageService contentUsageService;
    private UserTransaction testTX;
    public static StoreRef SPACES_STORE = new StoreRef("workspace", "SpacesStore");
    private static final String TEST_RUN = System.currentTimeMillis() + "";
    private static final String TEST_USER_PREFIX = "user-" + TEST_RUN + "-";
    private static final int MAX_USERS = 5;
    private static final int BATCH_SIZE = 5;
    private static final int PROGRESS_SIZE = 100;

    protected void setUp() throws Exception {
        this.nodeService = (NodeService)applicationContext.getBean("NodeService");
        this.authenticationService = (MutableAuthenticationService)applicationContext.getBean("authenticationService");
        this.transactionService = (TransactionService)applicationContext.getBean("transactionComponent");
        this.personService = (PersonService)applicationContext.getBean("PersonService");
        this.contentService = (ContentService)applicationContext.getBean("ContentService");
        this.contentUsageService = (ContentUsageService)applicationContext.getBean("ContentUsageService");
        this.userUsageTrackingComponent = (UserUsageTrackingComponent)((Object)applicationContext.getBean("userUsageTrackingComponent"));
        AuthenticationUtil.setRunAsUserSystem();
        this.createUsersAndContent();
    }

    protected void tearDown() throws Exception {
        if (this.clean) {
            this.deleteUsersAndContent();
        }
        super.tearDown();
    }

    private void createUsersAndContent() {
        long start = System.currentTimeMillis();
        long progressStart = System.currentTimeMillis();
        try {
            int count = 0;
            int batch = 0;
            for (int i = 1; i <= 5; ++i) {
                if (count == 0) {
                    ++batch;
                    this.testTX = this.transactionService.getUserTransaction();
                    this.testTX.begin();
                }
                ++count;
                String userName = TEST_USER_PREFIX + i;
                if (!this.authenticationService.authenticationExists(userName)) {
                    HashMap<QName, Serializable> props = new HashMap<QName, Serializable>();
                    props.put(ContentModel.PROP_USERNAME, (Serializable)((Object)userName));
                    this.personService.createPerson(props);
                    this.authenticationService.createAuthentication(userName, userName.toCharArray());
                    NodeRef homeFolder = this.getHomeSpaceFolderNode(userName);
                    StringBuilder sb = new StringBuilder();
                    for (int j = 1; j <= i; ++j) {
                        int k = j % 10;
                        sb.append(k);
                    }
                    AuthenticationUtil.setFullyAuthenticatedUser((String)userName);
                    this.addTextContent(homeFolder, "a-" + userName + ".txt", sb.toString());
                    this.addTextContent(homeFolder, "b-" + userName + ".txt", sb.toString());
                }
                AuthenticationUtil.setRunAsUserSystem();
                if (count == 5 || i == 5) {
                    this.testTX.commit();
                    count = 0;
                }
                if (i % 100 != 0 || i == 5) continue;
                System.out.println("Progress: 100 users created in " + (System.currentTimeMillis() - progressStart) / 1000L + " secs");
                progressStart = System.currentTimeMillis();
            }
            System.out.println("Total: 5 users created in " + (System.currentTimeMillis() - start) / 1000L + " secs");
        }
        catch (Throwable t) {
            t.printStackTrace();
            try {
                this.testTX.rollback();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void testEnableDisableCollapse() {
        NodeRef homeFolder;
        String userName;
        int i;
        this.userUsageTrackingComponent.setEnabled(false);
        this.userUsageTrackingComponent.bootstrapInternal();
        System.out.println("Cleared usages");
        this.checkCleared();
        this.userUsageTrackingComponent.setEnabled(true);
        this.userUsageTrackingComponent.bootstrapInternal();
        System.out.println("Recalculated usages");
        this.checkCalculated(2L);
        this.checkUsage(2L);
        for (i = 1; i <= 5; ++i) {
            userName = TEST_USER_PREFIX + i;
            homeFolder = this.getHomeSpaceFolderNode(userName);
            AuthenticationUtil.setFullyAuthenticatedUser((String)userName);
            StringBuilder sb = new StringBuilder();
            for (int j = 1; j <= i; ++j) {
                int k = j % 10;
                sb.append(k);
            }
            this.addTextContent(homeFolder, "c-" + userName + ".txt", sb.toString());
            this.addTextContent(homeFolder, "d-" + userName + ".txt", sb.toString());
            AuthenticationUtil.setRunAsUserSystem();
        }
        System.out.println("Added content");
        this.checkUsage(4L);
        this.userUsageTrackingComponent.execute();
        System.out.println("Collapsed usages");
        this.checkUsage(4L);
        for (i = 1; i <= 5; ++i) {
            userName = TEST_USER_PREFIX + i;
            homeFolder = this.getHomeSpaceFolderNode(userName);
            AuthenticationUtil.setFullyAuthenticatedUser((String)userName);
            NodeRef childNodeRef = this.nodeService.getChildByName(homeFolder, ContentModel.ASSOC_CONTAINS, "a-" + userName + ".txt");
            this.nodeService.deleteNode(childNodeRef);
            childNodeRef = this.nodeService.getChildByName(homeFolder, ContentModel.ASSOC_CONTAINS, "b-" + userName + ".txt");
            this.nodeService.deleteNode(childNodeRef);
            AuthenticationUtil.setRunAsUserSystem();
        }
        System.out.println("Deleted content");
        this.checkUsage(2L);
        this.userUsageTrackingComponent.execute();
        System.out.println("Collapsed usages");
        this.checkUsage(2L);
        this.userUsageTrackingComponent.setEnabled(false);
        this.userUsageTrackingComponent.bootstrapInternal();
        System.out.println("Cleared usages");
        this.checkCleared();
    }

    private void checkCalculated(long factor) {
        for (int i = 1; i <= 5; ++i) {
            String userName = TEST_USER_PREFIX + i;
            NodeRef personNodeRef = this.personService.getPerson(userName);
            Long sizeProp = (Long)this.nodeService.getProperty(personNodeRef, ContentModel.PROP_SIZE_CURRENT);
            UserUsageTrackingComponentTest.assertNotNull((String)("Property " + ContentModel.PROP_SIZE_CURRENT + "does not exist, yet"), (Object)sizeProp);
            UserUsageTrackingComponentTest.assertEquals((String)userName, (long)((long)i * factor), (long)sizeProp);
        }
    }

    private void checkUsage(long factor) {
        for (int i = 1; i <= 5; ++i) {
            String userName = TEST_USER_PREFIX + i;
            UserUsageTrackingComponentTest.assertEquals((String)userName, (long)((long)i * factor), (long)this.contentUsageService.getUserUsage(userName));
        }
    }

    private void checkCleared() {
        for (int i = 1; i <= 5; ++i) {
            String userName = TEST_USER_PREFIX + i;
            NodeRef personNodeRef = this.personService.getPerson(userName);
            UserUsageTrackingComponentTest.assertNull((Object)this.nodeService.getProperty(personNodeRef, ContentModel.PROP_SIZE_CURRENT));
        }
    }

    private void deleteUsersAndContent() {
        long start = System.currentTimeMillis();
        try {
            int count = 0;
            int batch = 0;
            int deleteCount = 0;
            for (int i = 1; i <= 5; ++i) {
                if (count == 0) {
                    ++batch;
                    this.testTX = this.transactionService.getUserTransaction();
                    this.testTX.begin();
                }
                ++count;
                String userName = TEST_USER_PREFIX + i;
                if (this.authenticationService.authenticationExists(userName)) {
                    NodeRef homeFolder = this.getHomeSpaceFolderNode(userName);
                    this.nodeService.deleteNode(homeFolder);
                    this.personService.deletePerson(userName);
                    ++deleteCount;
                }
                if (count != 5 && i != 5) continue;
                this.testTX.commit();
                count = 0;
            }
            System.out.println("Total: " + deleteCount + " users deleted in " + (System.currentTimeMillis() - start) / 1000L + " secs");
        }
        catch (Throwable t) {
            t.printStackTrace();
            try {
                this.testTX.rollback();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private NodeRef getHomeSpaceFolderNode(String userName) {
        return (NodeRef)this.nodeService.getProperty(this.personService.getPerson(userName), ContentModel.PROP_HOMEFOLDER);
    }

    private NodeRef addTextContent(NodeRef spaceRef, String fileName, String textData) {
        HashMap<QName, String> contentProps = new HashMap<QName, String>();
        contentProps.put(ContentModel.PROP_NAME, fileName);
        ChildAssociationRef association = this.nodeService.createNode(spaceRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)fileName), ContentModel.TYPE_CONTENT, contentProps);
        NodeRef content = association.getChildRef();
        HashMap<QName, String> titledProps = new HashMap<QName, String>();
        titledProps.put(ContentModel.PROP_TITLE, fileName);
        titledProps.put(ContentModel.PROP_DESCRIPTION, fileName);
        this.nodeService.addAspect(content, ContentModel.ASPECT_TITLED, titledProps);
        ContentWriter writer = this.contentService.getWriter(content, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent(textData);
        return content;
    }
}

