/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.version.BaseVersionStoreTest;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.Version;

public class ContentServiceImplTest
extends BaseVersionStoreTest {
    private static final String UPDATED_CONTENT = "This content has been updated with a new value.";
    private ContentService contentService;

    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
    }

    public void testGetReader() {
        NodeRef versionableNode = this.createNewVersionableNode();
        Version version = this.createVersion(versionableNode, this.versionProperties);
        NodeRef versionNodeRef = version.getFrozenStateNodeRef();
        ContentReader contentReader = this.contentService.getReader(versionNodeRef, ContentModel.PROP_CONTENT);
        ContentServiceImplTest.assertNotNull((Object)contentReader);
        ContentServiceImplTest.assertEquals((String)"This is the versioned test content.", (String)contentReader.getContentString());
        ContentWriter contentWriter = this.contentService.getWriter(versionableNode, ContentModel.PROP_CONTENT, true);
        ContentServiceImplTest.assertNotNull((Object)contentWriter);
        contentWriter.putContent(UPDATED_CONTENT);
        Version version2 = this.createVersion(versionableNode, this.versionProperties);
        NodeRef version2NodeRef = version2.getFrozenStateNodeRef();
        ContentReader contentReader2 = this.contentService.getReader(version2NodeRef, ContentModel.PROP_CONTENT);
        ContentServiceImplTest.assertNotNull((Object)contentReader2);
        ContentServiceImplTest.assertEquals((String)UPDATED_CONTENT, (String)contentReader2.getContentString());
    }

    public void testGetWriter() {
        NodeRef versionableNode = this.createNewVersionableNode();
        Version version = this.createVersion(versionableNode, this.versionProperties);
        try {
            ContentWriter contentWriter = this.contentService.getWriter(version.getFrozenStateNodeRef(), ContentModel.PROP_CONTENT, true);
            contentWriter.putContent("bobbins");
            ContentServiceImplTest.fail((String)"This operation is not supported.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

