/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import java.io.Serializable;
import java.util.Date;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.workflow.StartWorkflowActionExecuter;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;

public class StartWorkflowActionExecuterTest
extends BaseSpringTest {
    private NodeService nodeService;
    private NamespaceService namespaceService;
    private PersonService personService;
    private NodeRef rootNodeRef;
    private NodeRef nodeRef;
    private StartWorkflowActionExecuter executer;

    protected void onSetUpInTransaction() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.namespaceService = (NamespaceService)this.applicationContext.getBean("namespaceService");
        this.personService = (PersonService)this.applicationContext.getBean("personService");
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        authenticationComponent.setCurrentUser(authenticationComponent.getSystemUserName());
        this.rootNodeRef = this.nodeService.getRootNode(new StoreRef("workspace", "SpacesStore"));
        this.nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode"), ContentModel.TYPE_CONTENT).getChildRef();
        this.executer = (StartWorkflowActionExecuter)this.applicationContext.getBean("start-workflow");
    }

    public void testExecution() {
        ActionImpl action = new ActionImpl(null, GUID.generate(), "start-workflow", null);
        action.setParameterValue("workflowName", (Serializable)((Object)"jbpm$wf:review"));
        action.setParameterValue(WorkflowModel.PROP_WORKFLOW_DUE_DATE.toPrefixString((NamespacePrefixResolver)this.namespaceService), new Date());
        NodeRef reviewer = this.personService.getPerson(AuthenticationUtil.getAdminUserName());
        action.setParameterValue(WorkflowModel.ASSOC_ASSIGNEE.toPrefixString((NamespacePrefixResolver)this.namespaceService), (Serializable)reviewer);
        this.executer.execute(action, this.nodeRef);
    }
}

