/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.site;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.alfresco.service.Auditable;
import org.alfresco.service.NotAuditable;
import org.alfresco.service.PublicService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicService
public interface SiteService {
    @Auditable(parameters={"sitePreset", "shortName"})
    public SiteInfo createSite(String var1, String var2, String var3, String var4, boolean var5);

    @Auditable(parameters={"sitePreset", "shortName"})
    public SiteInfo createSite(String var1, String var2, String var3, String var4, SiteVisibility var5);

    @NotAuditable
    public boolean hasCreateSitePermissions();

    @NotAuditable
    public List<SiteInfo> listSites(String var1, String var2, int var3);

    @NotAuditable
    public List<SiteInfo> listSites(String var1, String var2);

    @NotAuditable
    public List<SiteInfo> listSites(String var1);

    @NotAuditable
    public SiteInfo getSite(String var1);

    @NotAuditable
    public SiteInfo getSite(NodeRef var1);

    @Auditable
    public void updateSite(SiteInfo var1);

    @Auditable(parameters={"shortName"})
    public void deleteSite(String var1);

    @NotAuditable
    public Map<String, String> listMembers(String var1, String var2, String var3, int var4);

    @NotAuditable
    public Map<String, String> listMembers(String var1, String var2, String var3, int var4, boolean var5);

    @NotAuditable
    public String getMembersRole(String var1, String var2);

    @NotAuditable
    public boolean isMember(String var1, String var2);

    @Auditable(parameters={"shortName", "authorityName", "role"})
    public void setMembership(String var1, String var2, String var3);

    @Auditable(parameters={"shortName", "authorityName"})
    public void removeMembership(String var1, String var2);

    @NotAuditable
    public NodeRef createContainer(String var1, String var2, QName var3, Map<QName, Serializable> var4);

    @NotAuditable
    public NodeRef getContainer(String var1, String var2);

    @NotAuditable
    public boolean hasContainer(String var1, String var2);

    @NotAuditable
    public List<String> getSiteRoles();

    @NotAuditable
    public String getSiteGroup(String var1);

    @NotAuditable
    public String getSiteRoleGroup(String var1, String var2);
}

