/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.actions;

import java.util.List;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.wcm.sandbox.SandboxService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WCMSandboxSubmitAction
extends ActionExecuterAbstractBase {
    public static String NAME = "wcm-submit";
    public static final String PARAM_PATH_LIST = "path-list";
    public static final String PARAM_SANDBOX_ID = "sandbox-id";
    private SandboxService sbService;

    public void setSandboxService(SandboxService sbService) {
        this.sbService = sbService;
    }

    @Override
    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        String sbStoreId = (String)((Object)action.getParameterValue(PARAM_SANDBOX_ID));
        List relativePaths = (List)((Object)action.getParameterValue(PARAM_PATH_LIST));
        if (relativePaths == null || relativePaths.size() == 0) {
            this.sbService.submitAll(sbStoreId, "Submit Action", "Submit all changed items in sandbox: " + sbStoreId);
        } else {
            this.sbService.submitList(sbStoreId, relativePaths, "Submit Action", "Submit list of changed items in sandbox: " + sbStoreId);
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_PATH_LIST, DataTypeDefinition.ANY, false, this.getParamDisplayLabel(PARAM_PATH_LIST)));
        paramList.add(new ParameterDefinitionImpl(PARAM_SANDBOX_ID, DataTypeDefinition.TEXT, true, this.getParamDisplayLabel(PARAM_SANDBOX_ID)));
    }
}

