/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.sandbox;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.mbeans.VirtServerRegistry;
import org.alfresco.model.WCMAppModel;
import org.alfresco.model.WCMWorkflowModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.avm.util.AVMUtil;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.VersionDescriptor;
import org.alfresco.service.cmr.avm.locking.AVMLockingService;
import org.alfresco.service.cmr.avmsync.AVMDifference;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.NameMatcher;
import org.alfresco.util.Pair;
import org.alfresco.util.VirtServerUtils;
import org.alfresco.wcm.asset.AssetInfo;
import org.alfresco.wcm.asset.AssetInfoImpl;
import org.alfresco.wcm.asset.AssetService;
import org.alfresco.wcm.sandbox.SandboxFactory;
import org.alfresco.wcm.sandbox.SandboxInfo;
import org.alfresco.wcm.sandbox.SandboxService;
import org.alfresco.wcm.sandbox.SandboxVersion;
import org.alfresco.wcm.sandbox.SandboxVersionImpl;
import org.alfresco.wcm.util.WCMUtil;
import org.alfresco.wcm.util.WCMWorkflowUtil;
import org.alfresco.wcm.webproject.WebProjectInfo;
import org.alfresco.wcm.webproject.WebProjectService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SandboxServiceImpl
implements SandboxService {
    private static Log logger = LogFactory.getLog(SandboxServiceImpl.class);
    private static final String WORKFLOW_SUBMITDIRECT = "jbpm$wcmwf:submitdirect";
    private WebProjectService wpService;
    private SandboxFactory sandboxFactory;
    private AVMService avmService;
    private AVMSyncService avmSyncService;
    private NameMatcher nameMatcher;
    private VirtServerRegistry virtServerRegistry;
    private WorkflowService workflowService;
    private AssetService assetService;
    private TransactionService transactionService;
    private AVMLockingService avmLockingService;

    public void setWebProjectService(WebProjectService wpService) {
        this.wpService = wpService;
    }

    public void setSandboxFactory(SandboxFactory sandboxFactory) {
        this.sandboxFactory = sandboxFactory;
    }

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    public void setAvmLockingService(AVMLockingService avmLockingService) {
        this.avmLockingService = avmLockingService;
    }

    public void setAvmSyncService(AVMSyncService avmSyncService) {
        this.avmSyncService = avmSyncService;
    }

    public void setNameMatcher(NameMatcher nameMatcher) {
        this.nameMatcher = nameMatcher;
    }

    public void setVirtServerRegistry(VirtServerRegistry virtServerRegistry) {
        this.virtServerRegistry = virtServerRegistry;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public void setAssetService(AssetService assetService) {
        this.assetService = assetService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    @Override
    public SandboxInfo createAuthorSandbox(String wpStoreId) {
        ParameterCheck.mandatoryString((String)"wpStoreId", (String)wpStoreId);
        String currentUserName = AuthenticationUtil.getFullyAuthenticatedUser();
        SandboxInfo sbInfo = null;
        if (!this.wpService.isWebUser(wpStoreId, currentUserName)) {
            throw new AccessDeniedException("Only web project users may create their own (author) sandbox for '" + currentUserName + "' (store id: " + wpStoreId + ")");
        }
        sbInfo = this.createAuthorSandboxImpl(wpStoreId, currentUserName);
        return sbInfo;
    }

    @Override
    public SandboxInfo createAuthorSandbox(String wpStoreId, String userName) {
        ParameterCheck.mandatoryString((String)"wpStoreId", (String)wpStoreId);
        ParameterCheck.mandatoryString((String)"userName", (String)userName);
        if (!this.wpService.isContentManager(wpStoreId)) {
            throw new AccessDeniedException("Only content managers may create author sandbox for '" + userName + "' (store id: " + wpStoreId + ")");
        }
        return this.createAuthorSandboxImpl(wpStoreId, userName);
    }

    private SandboxInfo createAuthorSandboxImpl(String wpStoreId, String userName) {
        long start = System.currentTimeMillis();
        WebProjectInfo wpInfo = this.wpService.getWebProject(wpStoreId);
        final NodeRef wpNodeRef = wpInfo.getNodeRef();
        final ArrayList<String> managers = new ArrayList<String>(4);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                Map<String, String> existingUserRoles = SandboxServiceImpl.this.wpService.listWebUsers(wpNodeRef);
                for (Map.Entry<String, String> userRole : existingUserRoles.entrySet()) {
                    String username = userRole.getKey();
                    String userrole = userRole.getValue();
                    if (!"ContentManager".equals(userrole) || managers.contains(username)) continue;
                    managers.add(username);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        String role = this.wpService.getWebUserRole(wpNodeRef, userName);
        SandboxInfo sbInfo = this.sandboxFactory.createUserSandbox(wpStoreId, managers, userName, role);
        LinkedList<SandboxInfo> sandboxInfoList = new LinkedList<SandboxInfo>();
        sandboxInfoList.add(sbInfo);
        CreateSandboxTransactionListener tl = new CreateSandboxTransactionListener(sandboxInfoList, this.wpService.listWebApps(wpNodeRef));
        AlfrescoTransactionSupport.bindListener(tl);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("createAuthorSandboxImpl: " + sbInfo.getSandboxId() + " in " + (System.currentTimeMillis() - start) + " ms (web project id: " + wpStoreId + ")"));
        }
        return sbInfo;
    }

    @Override
    public List<SandboxInfo> listSandboxes(String wpStoreId) {
        long start = System.currentTimeMillis();
        ParameterCheck.mandatoryString((String)"wpStoreId", (String)wpStoreId);
        List<SandboxInfo> sbInfos = null;
        String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        String userRole = this.wpService.getWebUserRole(wpStoreId, currentUser);
        if ("ContentManager".equals(userRole) || "ContentPublisher".equals(userRole)) {
            sbInfos = this.sandboxFactory.listAllSandboxes(wpStoreId);
        } else {
            sbInfos = new ArrayList<SandboxInfo>(1);
            if (userRole != null) {
                SandboxInfo authorSandbox = this.getAuthorSandbox(wpStoreId, currentUser);
                if (authorSandbox != null) {
                    sbInfos.add(authorSandbox);
                }
                sbInfos.add(this.getSandbox(WCMUtil.buildStagingStoreName(wpStoreId)));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("listSandboxes: " + wpStoreId + " in " + (System.currentTimeMillis() - start) + " ms (web project id: " + wpStoreId + ")"));
        }
        return sbInfos;
    }

    @Override
    public List<SandboxInfo> listSandboxes(final String wpStoreId, String userName) {
        ParameterCheck.mandatoryString((String)"wpStoreId", (String)wpStoreId);
        ParameterCheck.mandatoryString((String)"userName", (String)userName);
        String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        String userRole = this.wpService.getWebUserRole(wpStoreId, currentUser);
        if ("ContentManager".equals(userRole) || "ContentPublisher".equals(userRole)) {
            throw new AccessDeniedException("Only content managers or content publishers may list sandboxes for '" + userName + "' (web project id: " + wpStoreId + ")");
        }
        return (List)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<List<SandboxInfo>>(){

            public List<SandboxInfo> doWork() throws Exception {
                return SandboxServiceImpl.this.listSandboxes(wpStoreId);
            }
        }, (String)userName);
    }

    @Override
    public boolean isSandboxType(String sbStoreId, QName sandboxType) {
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        ParameterCheck.mandatory((String)"sandboxType", (Object)sandboxType);
        SandboxInfo sbInfo = this.getSandbox(sbStoreId);
        if (sbInfo != null) {
            return sbInfo.getSandboxType().equals((Object)sandboxType);
        }
        return false;
    }

    @Override
    public SandboxInfo getSandbox(String sbStoreId) {
        long start = System.currentTimeMillis();
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        String wpStoreId = WCMUtil.getWebProjectStoreId(sbStoreId);
        if (!this.wpService.isWebUser(wpStoreId)) {
            return null;
        }
        if (!WCMUtil.isStagingStore(sbStoreId)) {
            String userRole;
            String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
            if (!(WCMUtil.getUserName(sbStoreId).equals(currentUser) || "ContentManager".equals(userRole = this.wpService.getWebUserRole(wpStoreId, currentUser)) || "ContentPublisher".equals(userRole))) {
                throw new AccessDeniedException("Only content managers or content publishers may get sandbox '" + sbStoreId + "' (web project id: " + wpStoreId + ")");
            }
        }
        SandboxInfo sbInfo = this.sandboxFactory.getSandbox(sbStoreId);
        if (logger.isTraceEnabled()) {
            if (sbInfo != null) {
                logger.trace((Object)("getSandbox: " + sbInfo.getSandboxId() + " in " + (System.currentTimeMillis() - start) + " ms (web project id: " + wpStoreId + ")"));
            } else {
                logger.trace((Object)("getSandbox: " + sbStoreId + " (does not exist)  in " + (System.currentTimeMillis() - start) + " ms (web project id: " + wpStoreId + ")"));
            }
        }
        return sbInfo;
    }

    @Override
    public SandboxInfo getAuthorSandbox(String wpStoreId) {
        ParameterCheck.mandatoryString((String)"wpStoreId", (String)wpStoreId);
        String currentUserName = AuthenticationUtil.getFullyAuthenticatedUser();
        return this.getSandbox(WCMUtil.buildUserMainStoreName(WCMUtil.buildStagingStoreName(wpStoreId), currentUserName));
    }

    @Override
    public SandboxInfo getAuthorSandbox(String wpStoreId, String userName) {
        ParameterCheck.mandatoryString((String)"wpStoreId", (String)wpStoreId);
        ParameterCheck.mandatoryString((String)"userName", (String)userName);
        return this.getSandbox(WCMUtil.buildUserMainStoreName(WCMUtil.buildStagingStoreName(wpStoreId), userName));
    }

    @Override
    public SandboxInfo getStagingSandbox(String wpStoreId) {
        ParameterCheck.mandatoryString((String)"wpStoreId", (String)wpStoreId);
        return this.getSandbox(WCMUtil.buildStagingStoreName(wpStoreId));
    }

    @Override
    public void deleteSandbox(String sbStoreId) {
        long start = System.currentTimeMillis();
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        String wpStoreId = WCMUtil.getWebProjectStoreId(sbStoreId);
        if (AuthenticationUtil.isRunAsUserTheSystemUser()) {
            this.sandboxFactory.deleteSandbox(sbStoreId);
        } else {
            String currentUserName = AuthenticationUtil.getFullyAuthenticatedUser();
            if (sbStoreId.equals(WCMUtil.buildUserMainStoreName(wpStoreId, currentUserName))) {
                this.sandboxFactory.deleteSandbox(sbStoreId);
            } else {
                if (!this.wpService.isContentManager(wpStoreId, currentUserName)) {
                    throw new AccessDeniedException("Only content managers may delete sandbox '" + sbStoreId + "' (web project id: " + wpStoreId + ")");
                }
                if (sbStoreId.equals(wpStoreId)) {
                    throw new AccessDeniedException("Cannot delete staging sandbox '" + sbStoreId + "' (web project id: " + wpStoreId + ")");
                }
                this.sandboxFactory.deleteSandbox(sbStoreId);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("deleteSandbox: " + sbStoreId + " in " + (System.currentTimeMillis() - start) + " ms (web project id: " + wpStoreId + ")"));
        }
    }

    @Override
    public List<AssetInfo> listChangedAll(String sbStoreId, boolean includeDeleted) {
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        String avmDirectoryPath = WCMUtil.buildSandboxRootPath(sbStoreId);
        return this.listChanged(sbStoreId, WCMUtil.getStoreRelativePath(avmDirectoryPath), includeDeleted);
    }

    @Override
    public List<AssetInfo> listChangedWebApp(String sbStoreId, String webApp, boolean includeDeleted) {
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        ParameterCheck.mandatoryString((String)"webApp", (String)webApp);
        String avmDirectoryPath = WCMUtil.buildStoreWebappPath(sbStoreId, webApp);
        return this.listChanged(sbStoreId, WCMUtil.getStoreRelativePath(avmDirectoryPath), includeDeleted);
    }

    @Override
    public List<AssetInfo> listChanged(String sbStoreId, String relativePath, boolean includeDeleted) {
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        ParameterCheck.mandatoryString((String)"relativePath", (String)relativePath);
        if (!WCMUtil.isUserStore(sbStoreId)) {
            throw new AlfrescoRuntimeException("Not an author sandbox: " + sbStoreId);
        }
        String wpStoreId = WCMUtil.getWebProjectStoreId(sbStoreId);
        String stagingSandboxId = WCMUtil.buildStagingStoreName(wpStoreId);
        return this.listChanged(sbStoreId, relativePath, stagingSandboxId, relativePath, includeDeleted);
    }

    @Override
    public List<AssetInfo> listChanged(String srcSandboxStoreId, String srcRelativePath, String dstSandboxStoreId, String dstRelativePath, boolean includeDeleted) {
        ParameterCheck.mandatoryString((String)"srcSandboxStoreId", (String)srcSandboxStoreId);
        ParameterCheck.mandatoryString((String)"srcRelativePath", (String)srcRelativePath);
        ParameterCheck.mandatoryString((String)"dstSandboxStoreId", (String)dstSandboxStoreId);
        ParameterCheck.mandatoryString((String)"dstRelativePath", (String)dstRelativePath);
        this.getSandbox(srcSandboxStoreId);
        this.getSandbox(dstSandboxStoreId);
        String avmSrcPath = AVMUtil.buildAVMPath(srcSandboxStoreId, srcRelativePath);
        String avmDstPath = AVMUtil.buildAVMPath(dstSandboxStoreId, dstRelativePath);
        return this.listChanged(-1, avmSrcPath, -1, avmDstPath, includeDeleted);
    }

    private List<AssetInfo> listChanged(int srcVersion, String srcPath, int dstVersion, String dstPath, boolean includeDeleted) {
        long start = System.currentTimeMillis();
        List<AVMDifference> diffs = this.avmSyncService.compare(srcVersion, srcPath, dstVersion, dstPath, this.nameMatcher);
        ArrayList<AssetInfo> assets = new ArrayList<AssetInfo>(diffs.size());
        for (AVMDifference diff : diffs) {
            String sourcePath = diff.getSourcePath();
            String[] parts = WCMUtil.splitPath(sourcePath);
            AssetInfo asset = this.assetService.getAsset(parts[0], -1, parts[1], includeDeleted);
            if (asset == null) continue;
            ((AssetInfoImpl)asset).setDiffCode(diff.getDifferenceCode());
            assets.add(asset);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("listChanged: " + assets.size() + " assets in " + (System.currentTimeMillis() - start) + " ms (between " + srcVersion + "," + srcPath + " and " + dstVersion + "," + dstPath));
        }
        return assets;
    }

    @Override
    public void submitAll(String sbStoreId, String submitLabel, String submitComment) {
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        String avmDirectoryPath = WCMUtil.buildSandboxRootPath(sbStoreId);
        this.submit(sbStoreId, WCMUtil.getStoreRelativePath(avmDirectoryPath), submitLabel, submitComment);
    }

    @Override
    public void submitWebApp(String sbStoreId, String webApp, String submitLabel, String submitComment) {
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        ParameterCheck.mandatoryString((String)"webApp", (String)webApp);
        String avmDirectoryPath = WCMUtil.buildStoreWebappPath(sbStoreId, webApp);
        this.submit(sbStoreId, WCMUtil.getStoreRelativePath(avmDirectoryPath), submitLabel, submitComment);
    }

    @Override
    public void submit(String sbStoreId, String relativePath, String submitLabel, String submitComment) {
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        ParameterCheck.mandatoryString((String)"relativePath", (String)relativePath);
        List<AssetInfo> assets = this.listChanged(sbStoreId, relativePath, true);
        this.submitListAssets(sbStoreId, assets, submitLabel, submitComment);
    }

    @Override
    public void submitList(String sbStoreId, List<String> relativePaths, String submitLabel, String submitComment) {
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        ArrayList<AssetInfo> assets = new ArrayList<AssetInfo>(relativePaths.size());
        for (String relativePath : relativePaths) {
            AssetInfo asset = this.assetService.getAsset(sbStoreId, -1, relativePath, true);
            if (asset == null) continue;
            assets.add(asset);
        }
        this.submitListAssets(sbStoreId, assets, submitLabel, submitComment);
    }

    @Override
    public void submitListAssets(String sbStoreId, List<AssetInfo> assets, String submitLabel, String submitComment) {
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        ParameterCheck.mandatoryString((String)"submitLabel", (String)submitLabel);
        if (!WCMUtil.isUserStore(sbStoreId)) {
            throw new AlfrescoRuntimeException("Not an author sandbox: " + sbStoreId);
        }
        ArrayList<String> relativePaths = new ArrayList<String>(assets.size());
        for (AssetInfo asset : assets) {
            relativePaths.add(asset.getPath());
        }
        this.submitViaWorkflow(sbStoreId, relativePaths, null, null, submitLabel, submitComment, null, null, false);
    }

    @Override
    public void submitListAssets(String sbStoreId, List<String> relativePaths, String workflowName, Map<QName, Serializable> workflowParams, String submitLabel, String submitComment, Map<String, Date> expirationDates, Date launchDate, boolean autoDeploy) {
        this.submitViaWorkflow(sbStoreId, relativePaths, workflowName, workflowParams, submitLabel, submitComment, expirationDates, launchDate, autoDeploy);
    }

    private void submitViaWorkflow(final String sbStoreId, List<String> relativePaths, String workflowName, Map<QName, Serializable> workflowParams, final String submitLabel, final String submitComment, final Map<String, Date> expirationDates, final Date launchDate, final boolean autoDeploy) {
        Map<Object, Object> finalWorkflowParams;
        String finalWorkflowName;
        long start = System.currentTimeMillis();
        this.getSandbox(sbStoreId);
        final String wpStoreId = WCMUtil.getWebProjectStoreId(sbStoreId);
        final String stagingSandboxId = WCMUtil.buildStagingStoreName(wpStoreId);
        boolean isSubmitDirectWorkflowSandbox = false;
        if (workflowName == null || workflowName.equals("")) {
            finalWorkflowName = WORKFLOW_SUBMITDIRECT;
            finalWorkflowParams = new HashMap();
            isSubmitDirectWorkflowSandbox = true;
        } else {
            finalWorkflowName = workflowName;
            finalWorkflowParams = workflowParams;
        }
        RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
        final ArrayList<String> srcPaths = new ArrayList<String>(relativePaths.size());
        for (String relativePath : relativePaths) {
            srcPaths.add(AVMUtil.buildAVMPath(sbStoreId, relativePath));
        }
        final String webApp = WCMUtil.getCommonWebApp(sbStoreId, relativePaths);
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<SandboxInfo, String>> sandboxCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<SandboxInfo, String>>(){

            @Override
            public Pair<SandboxInfo, String> execute() throws Throwable {
                return SandboxServiceImpl.this.createWorkflowSandbox(finalWorkflowName, finalWorkflowParams, stagingSandboxId, srcPaths, expirationDates);
            }
        };
        Pair<SandboxInfo, String> workflowInfo = txnHelper.doInTransaction(sandboxCallback, false, true);
        if (workflowInfo != null) {
            final SandboxInfo wfSandboxInfo = (SandboxInfo)workflowInfo.getFirst();
            String virtUpdatePath = (String)workflowInfo.getSecond();
            if (virtUpdatePath != null && !isSubmitDirectWorkflowSandbox) {
                WCMUtil.updateVServerWebapp(this.virtServerRegistry, virtUpdatePath, true);
            }
            try {
                RetryingTransactionHelper.RetryingTransactionCallback<String> workflowCallback = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                    @Override
                    public String execute() throws Throwable {
                        SandboxServiceImpl.this.startWorkflow(wpStoreId, sbStoreId, wfSandboxInfo, webApp, finalWorkflowName, finalWorkflowParams, submitLabel, submitComment, launchDate, autoDeploy);
                        return null;
                    }
                };
                txnHelper.doInTransaction(workflowCallback, false, true);
            }
            catch (Throwable err) {
                this.cleanupWorkflowSandbox(wfSandboxInfo);
                throw new AlfrescoRuntimeException("Failed to submit to workflow", err);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("submitViaWorkflow: " + sbStoreId + " [" + submitLabel + ", " + finalWorkflowName + "] in " + (System.currentTimeMillis() - start) + " ms (web project id: " + wpStoreId + ")"));
        }
    }

    protected Pair<SandboxInfo, String> createWorkflowSandbox(String workflowName, Map<QName, Serializable> workflowParams, String stagingSandboxId, List<String> srcPaths, Map<String, Date> expirationDates) {
        String virtUpdatePath = null;
        SandboxInfo sandboxInfo = null;
        sandboxInfo = !workflowName.equals(WORKFLOW_SUBMITDIRECT) ? this.sandboxFactory.createWorkflowSandbox(stagingSandboxId) : this.sandboxFactory.createReadOnlyWorkflowSandbox(stagingSandboxId);
        String workflowMainStoreName = sandboxInfo.getMainStoreName();
        final ArrayList<AVMDifference> diffs = new ArrayList<AVMDifference>(srcPaths.size());
        for (String srcPath : srcPaths) {
            if (virtUpdatePath == null) {
                virtUpdatePath = WCMUtil.getCorrespondingPath(srcPath, workflowMainStoreName);
            }
            if (expirationDates != null && !expirationDates.isEmpty()) {
                this.processExpirationDate(srcPath, expirationDates);
            }
            diffs.add(new AVMDifference(-1, srcPath, -1, WCMUtil.getCorrespondingPath(srcPath, workflowMainStoreName), 0));
        }
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                SandboxServiceImpl.this.avmSyncService.update(diffs, null, false, false, false, false, null, null);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        return new Pair((Object)sandboxInfo, (Object)virtUpdatePath);
    }

    protected void startWorkflow(String wpStoreId, String sbStoreId, SandboxInfo wfSandboxInfo, String webApp, String workflowName, Map<QName, Serializable> workflowParams, String submitLabel, String submitComment, Date launchDate, boolean autoDeploy) {
        List<WorkflowTask> tasks;
        ParameterCheck.mandatoryString((String)"workflowName", (String)workflowName);
        ParameterCheck.mandatory((String)"workflowParams", workflowParams);
        WorkflowDefinition wfDef = this.workflowService.getDefinitionByName(workflowName);
        WorkflowPath path = this.workflowService.startWorkflow(wfDef.id, null);
        if (path != null && (tasks = this.workflowService.getTasksForWorkflowPath(path.id)).size() == 1) {
            WorkflowTask startTask = tasks.get(0);
            if (startTask.state == WorkflowTaskState.IN_PROGRESS) {
                NodeRef workflowPackage = WCMWorkflowUtil.createWorkflowPackage(this.workflowService, this.avmService, wfSandboxInfo);
                workflowParams.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)workflowPackage);
                workflowParams.put(WorkflowModel.PROP_WORKFLOW_DESCRIPTION, (Serializable)((Object)submitComment));
                workflowParams.put(WCMWorkflowModel.PROP_LABEL, (Serializable)((Object)submitLabel));
                workflowParams.put(WCMWorkflowModel.PROP_FROM_PATH, (Serializable)((Object)WCMUtil.buildStoreRootPath(sbStoreId)));
                workflowParams.put(WCMWorkflowModel.PROP_LAUNCH_DATE, launchDate);
                workflowParams.put(WCMWorkflowModel.PROP_AUTO_DEPLOY, new Boolean(autoDeploy));
                workflowParams.put(WCMWorkflowModel.PROP_WEBAPP, (Serializable)((Object)webApp));
                workflowParams.put(WCMWorkflowModel.ASSOC_WEBPROJECT, (Serializable)this.wpService.getWebProjectNodeFromStore(wpStoreId));
                this.workflowService.updateTask(startTask.id, workflowParams, null, null);
                this.workflowService.endTask(startTask.id, null);
            }
        }
    }

    private void cleanupWorkflowSandbox(final SandboxInfo sandboxInfo) {
        RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<String> callback = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            @Override
            public String execute() throws Throwable {
                SandboxServiceImpl.this.sandboxFactory.deleteSandbox(sandboxInfo.getSandboxId());
                return null;
            }
        };
        try {
            txnHelper.doInTransaction(callback);
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to cleanup workflow sandbox after workflow failure", e);
        }
    }

    @Override
    public void revertAll(String sbStoreId) {
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        String avmDirectoryPath = WCMUtil.buildSandboxRootPath(sbStoreId);
        this.revert(sbStoreId, WCMUtil.getStoreRelativePath(avmDirectoryPath));
    }

    @Override
    public void revertWebApp(String sbStoreId, String webApp) {
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        ParameterCheck.mandatoryString((String)"webApp", (String)webApp);
        String avmDirectoryPath = WCMUtil.buildStoreWebappPath(sbStoreId, webApp);
        this.revert(sbStoreId, WCMUtil.getStoreRelativePath(avmDirectoryPath));
    }

    @Override
    public void revert(String sbStoreId, String relativePath) {
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        ParameterCheck.mandatoryString((String)"relativePath", (String)relativePath);
        List<AssetInfo> assets = this.listChanged(sbStoreId, relativePath, true);
        this.revertListAssets(sbStoreId, assets);
    }

    @Override
    public void revertList(String sbStoreId, List<String> relativePaths) {
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        ArrayList<AssetInfo> assets = new ArrayList<AssetInfo>(relativePaths.size());
        for (String relativePath : relativePaths) {
            AssetInfo asset = this.assetService.getAsset(sbStoreId, -1, relativePath, true);
            if (asset == null) continue;
            assets.add(asset);
        }
        this.revertListAssets(sbStoreId, assets);
    }

    @Override
    public void revertListAssets(String sbStoreId, List<AssetInfo> assets) {
        long start = System.currentTimeMillis();
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        this.getSandbox(sbStoreId);
        String wpStoreId = WCMUtil.getWebProjectStoreId(sbStoreId);
        ArrayList<AssetInfo> assetsToRevert = new ArrayList<AssetInfo>(assets.size());
        List<String> wfRelativePaths = WCMWorkflowUtil.getAssociatedPathsForSandbox(this.avmSyncService, this.workflowService, sbStoreId);
        for (AssetInfo asset : assets) {
            if (!asset.getSandboxId().equals(sbStoreId)) {
                logger.warn((Object)("revertListAssets: Skip assert " + asset.getPath() + " (was " + asset.getSandboxId() + ", expected " + sbStoreId + ")"));
                continue;
            }
            if (wfRelativePaths.contains(asset.getPath())) continue;
            assetsToRevert.add(asset);
            if (!VirtServerUtils.requiresUpdateNotification((String)asset.getAvmPath())) continue;
            UpdateSandboxTransactionListener tl = new UpdateSandboxTransactionListener(asset.getAvmPath());
            AlfrescoTransactionSupport.bindListener(tl);
        }
        for (AssetInfo asset : assetsToRevert) {
            String[] parentChild = AVMNodeConverter.SplitBase(asset.getAvmPath());
            if (parentChild.length != 2) continue;
            AVMNodeDescriptor parent = this.avmService.lookup(-1, parentChild[0], true);
            if (parent.isLayeredDirectory()) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("reverting " + parentChild[1] + " in " + parentChild[0]));
                }
                this.avmService.makeTransparent(parentChild[0], parentChild[1]);
            }
            if (!asset.isFile()) continue;
            String relativePath = asset.getPath();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("unlocking file " + relativePath + " in web project " + wpStoreId));
            }
            if (this.avmLockingService.getLockOwner(wpStoreId, relativePath) != null) {
                this.avmLockingService.removeLock(wpStoreId, relativePath);
                continue;
            }
            if (!logger.isWarnEnabled()) continue;
            logger.warn((Object)("expected file " + relativePath + " in " + wpStoreId + " to be locked"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("revertListAssets: " + sbStoreId + " [" + assets.size() + ", " + assetsToRevert.size() + "] in " + (System.currentTimeMillis() - start) + " ms (web project id: " + wpStoreId + ")"));
        }
    }

    @Override
    public List<SandboxVersion> listSnapshots(String sbStoreId, boolean includeSystemGenerated) {
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        String wpStoreId = WCMUtil.getWebProjectStoreId(sbStoreId);
        if (!this.wpService.isContentManager(wpStoreId)) {
            throw new AccessDeniedException("Only content managers may list snapshots '" + sbStoreId + "' (web project id: " + wpStoreId + ")");
        }
        return this.listSnapshots(sbStoreId, null, null, includeSystemGenerated);
    }

    @Override
    public List<SandboxVersion> listSnapshots(String sbStoreId, Date from, Date to, boolean includeSystemGenerated) {
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        String wpStoreId = WCMUtil.getWebProjectStoreId(sbStoreId);
        if (!this.wpService.isContentManager(wpStoreId)) {
            throw new AccessDeniedException("Only content managers may list snapshots '" + sbStoreId + "' (web project id: " + wpStoreId + ")");
        }
        return this.listSnapshotsImpl(sbStoreId, from, to, includeSystemGenerated);
    }

    private List<SandboxVersion> listSnapshotsImpl(String sbStoreId, Date from, Date to, boolean includeSystemGenerated) {
        long start = System.currentTimeMillis();
        List<VersionDescriptor> versionsToFilter = null;
        versionsToFilter = from != null && to != null ? this.avmService.getStoreVersions(sbStoreId, from, to) : this.avmService.getStoreVersions(sbStoreId);
        ArrayList<SandboxVersion> versions = new ArrayList<SandboxVersion>(versionsToFilter.size());
        for (int i = versionsToFilter.size() - 1; i >= 0; --i) {
            VersionDescriptor item = versionsToFilter.get(i);
            if (!includeSystemGenerated && (item.getTag() == null || item.getVersionID() == 0)) continue;
            versions.add(new SandboxVersionImpl(item));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("listSnapshotsImpl: " + sbStoreId + " [" + from + ", " + to + ", " + versions.size() + "] in " + (System.currentTimeMillis() - start) + " ms (web project id: " + WCMUtil.getWebProjectStoreId(sbStoreId) + ")"));
        }
        return versions;
    }

    @Override
    public void revertSnapshot(final String sbStoreId, final int revertVersion) {
        long start = System.currentTimeMillis();
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        String wpStoreId = WCMUtil.getWebProjectStoreId(sbStoreId);
        if (!this.wpService.isContentManager(wpStoreId)) {
            throw new AccessDeniedException("Only content managers may revert staging sandbox '" + sbStoreId + "' (web project id: " + wpStoreId + ")");
        }
        List diffs = (List)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<List<AVMDifference>>(){

            public List<AVMDifference> doWork() throws Exception {
                String sandboxPath = AVMUtil.buildAVMPath(sbStoreId, "/");
                List<AVMDifference> diffs = SandboxServiceImpl.this.avmSyncService.compare(revertVersion, sandboxPath, -1, sandboxPath, null);
                String message = "Reverted to Version " + revertVersion + ".";
                SandboxServiceImpl.this.avmSyncService.update(diffs, null, false, false, true, true, message, message);
                return diffs;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        for (AVMDifference diff : diffs) {
            if (!VirtServerUtils.requiresUpdateNotification((String)diff.getSourcePath())) continue;
            UpdateSandboxTransactionListener tl = new UpdateSandboxTransactionListener(diff.getSourcePath());
            AlfrescoTransactionSupport.bindListener(tl);
            break;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("revertSnapshot: " + sbStoreId + " [" + revertVersion + "] in " + (System.currentTimeMillis() - start) + " ms (web project id: " + WCMUtil.getWebProjectStoreId(sbStoreId) + ")"));
        }
    }

    private void processExpirationDate(String srcPath, Map<String, Date> expirationDates) {
        Date expirationDate = expirationDates.get(srcPath);
        if (expirationDate == null) {
            return;
        }
        if (!this.avmService.hasAspect(-1, srcPath, WCMAppModel.ASPECT_EXPIRES)) {
            this.avmService.addAspect(srcPath, WCMAppModel.ASPECT_EXPIRES);
        }
        this.avmService.setNodeProperty(srcPath, WCMAppModel.PROP_EXPIRATIONDATE, new PropertyValue(DataTypeDefinition.DATETIME, expirationDate));
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Set expiration date of " + expirationDate + " for " + srcPath));
        }
    }

    private class UpdateSandboxTransactionListener
    extends TransactionListenerAdapter {
        private String virtUpdatePath;

        public UpdateSandboxTransactionListener(String virtUpdatePath) {
            this.virtUpdatePath = virtUpdatePath;
        }

        public void afterCommit() {
            if (this.virtUpdatePath != null) {
                WCMUtil.updateVServerWebapp(SandboxServiceImpl.this.virtServerRegistry, this.virtUpdatePath, true);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CreateSandboxTransactionListener
    extends TransactionListenerAdapter {
        private List<SandboxInfo> sandboxInfoList;
        private List<String> webAppNames;

        public CreateSandboxTransactionListener(List<SandboxInfo> sandboxInfoList, List<String> webAppNames) {
            this.sandboxInfoList = sandboxInfoList;
            this.webAppNames = webAppNames;
        }

        @Override
        public void afterCommit() {
            for (SandboxInfo sandboxInfo : this.sandboxInfoList) {
                String newlyInvitedStoreName = WCMUtil.buildStagingStoreName(sandboxInfo.getMainStoreName());
                for (String webAppName : this.webAppNames) {
                    String path = WCMUtil.buildStoreWebappPath(newlyInvitedStoreName, webAppName);
                    WCMUtil.updateVServerWebapp(SandboxServiceImpl.this.virtServerRegistry, path, true);
                }
            }
        }
    }
}

