/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.catalina.Host;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExpandWar {
    private static Log log = LogFactory.getLog((Class)ExpandWar.class);
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");

    public static String expand(Host host, URL war) throws IOException {
        int slash;
        int period;
        String pathname;
        if (host.getLogger().isDebugEnabled()) {
            host.getLogger().debug((Object)("expand(" + war.toString() + ")"));
        }
        if ((pathname = war.toString().replace('\\', '/')).endsWith("!/")) {
            pathname = pathname.substring(0, pathname.length() - 2);
        }
        if ((period = pathname.lastIndexOf(46)) >= pathname.length() - 4) {
            pathname = pathname.substring(0, period);
        }
        if ((slash = pathname.lastIndexOf(47)) >= 0) {
            pathname = pathname.substring(slash + 1);
        }
        if (host.getLogger().isDebugEnabled()) {
            host.getLogger().debug((Object)("  Proposed directory name: " + pathname));
        }
        return ExpandWar.expand(host, war, pathname);
    }

    public static String expand(Host host, URL war, String pathname) throws IOException {
        File appBase = new File(host.getAppBase());
        if (!appBase.isAbsolute()) {
            appBase = new File(System.getProperty("catalina.base"), host.getAppBase());
        }
        if (!appBase.exists() || !appBase.isDirectory()) {
            throw new IOException(sm.getString("hostConfig.appBase", appBase.getAbsolutePath()));
        }
        File docBase = new File(appBase, pathname);
        if (docBase.exists()) {
            return docBase.getAbsolutePath();
        }
        docBase.mkdir();
        JarURLConnection juc = (JarURLConnection)war.openConnection();
        juc.setUseCaches(false);
        JarFile jarFile = null;
        InputStream input = null;
        try {
            jarFile = juc.getJarFile();
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                String name = jarEntry.getName();
                int last = name.lastIndexOf(47);
                if (last >= 0) {
                    File parent = new File(docBase, name.substring(0, last));
                    parent.mkdirs();
                }
                if (name.endsWith("/")) continue;
                input = jarFile.getInputStream(jarEntry);
                File expandedFile = ExpandWar.expand(input, docBase, name);
                long lastModified = jarEntry.getTime();
                if (lastModified != -1L && lastModified != 0L && expandedFile != null) {
                    expandedFile.setLastModified(lastModified);
                }
                input.close();
                input = null;
            }
        }
        catch (IOException e) {
            ExpandWar.deleteDir(docBase);
            throw e;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Throwable t) {}
                input = null;
            }
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Throwable t) {}
                jarFile = null;
            }
        }
        return docBase.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(File src, File dest) {
        boolean result = true;
        String[] files = null;
        if (src.isDirectory()) {
            files = src.list();
            result = dest.mkdir();
        } else {
            files = new String[]{""};
        }
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length && result; ++i) {
            File fileSrc = new File(src, files[i]);
            File fileDest = new File(dest, files[i]);
            if (fileSrc.isDirectory()) {
                result = ExpandWar.copy(fileSrc, fileDest);
                continue;
            }
            FileChannel ic = null;
            AbstractInterruptibleChannel oc = null;
            try {
                ic = new FileInputStream(fileSrc).getChannel();
                oc = new FileOutputStream(fileDest).getChannel();
                ic.transferTo(0L, ic.size(), (WritableByteChannel)((Object)oc));
                continue;
            }
            catch (IOException e) {
                log.error((Object)sm.getString("expandWar.copy", fileSrc, fileDest), (Throwable)e);
                result = false;
                continue;
            }
            finally {
                if (ic != null) {
                    try {
                        ic.close();
                    }
                    catch (IOException e) {}
                }
                if (oc != null) {
                    try {
                        oc.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return result;
    }

    public static boolean delete(File dir) {
        if (dir.isDirectory()) {
            return ExpandWar.deleteDir(dir);
        }
        return dir.delete();
    }

    public static boolean deleteDir(File dir) {
        String[] files = dir.list();
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length; ++i) {
            File file = new File(dir, files[i]);
            if (file.isDirectory()) {
                ExpandWar.deleteDir(file);
                continue;
            }
            file.delete();
        }
        return dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static File expand(InputStream input, File docBase, String name) throws IOException {
        File file = new File(docBase, name);
        FilterOutputStream output = null;
        try {
            int n;
            output = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buffer = new byte[2048];
            while ((n = input.read(buffer)) > 0) {
                ((BufferedOutputStream)output).write(buffer, 0, n);
            }
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {}
            }
        }
        return file;
    }
}

