/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.alfresco.util.EqualsHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Pair<F, S>
implements Serializable {
    public static final Pair NULL_PAIR = new Pair<Object, Object>(null, null);
    private static final long serialVersionUID = -7406248421185630612L;
    private F first;
    private S second;

    public static final <X, Y> Pair<X, Y> nullPair() {
        return NULL_PAIR;
    }

    public Pair(F first, S second) {
        this.first = first;
        this.second = second;
    }

    public F getFirst() {
        return this.first;
    }

    public S getSecond() {
        return this.second;
    }

    public void setFirst(F first) {
        this.first = first;
    }

    public void setSecond(S second) {
        this.second = second;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof Pair)) {
            return false;
        }
        Pair o = (Pair)other;
        return EqualsHelper.nullSafeEquals(this.first, o.first) && EqualsHelper.nullSafeEquals(this.second, o.second);
    }

    public int hashCode() {
        return (this.first == null ? 0 : this.first.hashCode()) + (this.second == null ? 0 : this.second.hashCode());
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ")";
    }

    private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField fields = is.readFields();
        if (fields.defaulted("first")) {
            this.first = fields.get("fFirst", null);
            this.second = fields.get("fSecond", null);
        } else {
            this.first = fields.get("first", null);
            this.second = fields.get("second", null);
        }
    }
}

