/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.jni.Address;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.File;
import org.apache.tomcat.jni.Library;
import org.apache.tomcat.jni.OS;
import org.apache.tomcat.jni.Poll;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.jni.SSLContext;
import org.apache.tomcat.jni.SSLSocket;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.jni.Status;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.threads.ThreadWithAttributes;

public class AprEndpoint {
    protected static Log log = LogFactory.getLog(AprEndpoint.class);
    protected static StringManager sm = StringManager.getManager("org.apache.tomcat.util.net.res");
    public static final String CIPHER_SUITE_KEY = "javax.servlet.request.cipher_suite";
    public static final String KEY_SIZE_KEY = "javax.servlet.request.key_size";
    public static final String CERTIFICATE_KEY = "javax.servlet.request.X509Certificate";
    public static final String SESSION_ID_KEY = "javax.servlet.request.ssl_session";
    protected WorkerStack workers = null;
    protected volatile boolean running = false;
    protected volatile boolean paused = false;
    protected boolean initialized = false;
    protected int curThreadsBusy = 0;
    protected int curThreads = 0;
    protected int sequence = 0;
    protected long rootPool = 0L;
    protected long serverSock = 0L;
    protected long serverSockPool = 0L;
    protected long sslContext = 0L;
    protected int maxThreads = 40;
    protected int threadPriority = 5;
    protected int pollerSize = 8192;
    protected int sendfileSize = 1024;
    protected int port;
    protected InetAddress address;
    protected Handler handler = null;
    protected int backlog = 100;
    protected boolean tcpNoDelay = false;
    protected int soLinger = 100;
    protected int soTimeout = -1;
    protected int firstReadTimeout = -1;
    protected int pollTime = 2000;
    protected boolean daemon = true;
    protected String name = "TP";
    protected boolean useSendfile = Library.APR_HAS_SENDFILE;
    protected int acceptorThreadCount = 0;
    protected int sendfileThreadCount = 0;
    protected int pollerThreadCount = 0;
    protected Poller[] pollers = null;
    protected int pollerRoundRobin = 0;
    protected Sendfile[] sendfiles = null;
    protected int sendfileRoundRobin = 0;
    protected String SSLEngine = "off";
    protected String SSLProtocol = "all";
    protected String SSLPassword = null;
    protected String SSLCipherSuite = "ALL";
    protected String SSLCertificateFile = null;
    protected String SSLCertificateKeyFile = null;
    protected String SSLCertificateChainFile = null;
    protected String SSLCACertificatePath = null;
    protected String SSLCACertificateFile = null;
    protected String SSLCARevocationPath = null;
    protected String SSLCARevocationFile = null;
    protected String SSLVerifyClient = "none";
    protected int SSLVerifyDepth = 10;

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public void setPollerSize(int pollerSize) {
        this.pollerSize = pollerSize;
    }

    public int getPollerSize() {
        return this.pollerSize;
    }

    public void setSendfileSize(int sendfileSize) {
        this.sendfileSize = sendfileSize;
    }

    public int getSendfileSize() {
        return this.sendfileSize;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void setBacklog(int backlog) {
        if (backlog > 0) {
            this.backlog = backlog;
        }
    }

    public int getBacklog() {
        return this.backlog;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public void setSoLinger(int soLinger) {
        this.soLinger = soLinger;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public int getFirstReadTimeout() {
        return this.firstReadTimeout;
    }

    public void setFirstReadTimeout(int firstReadTimeout) {
        this.firstReadTimeout = firstReadTimeout;
    }

    public int getPollTime() {
        return this.pollTime;
    }

    public void setPollTime(int pollTime) {
        if (pollTime > 0) {
            this.pollTime = pollTime;
        }
    }

    public void setDaemon(boolean b) {
        this.daemon = b;
    }

    public boolean getDaemon() {
        return this.daemon;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setUseSendfile(boolean useSendfile) {
        this.useSendfile = useSendfile;
    }

    public boolean getUseSendfile() {
        return this.useSendfile;
    }

    public void setAcceptorThreadCount(int acceptorThreadCount) {
        this.acceptorThreadCount = acceptorThreadCount;
    }

    public int getAcceptorThreadCount() {
        return this.acceptorThreadCount;
    }

    public void setSendfileThreadCount(int sendfileThreadCount) {
        this.sendfileThreadCount = sendfileThreadCount;
    }

    public int getSendfileThreadCount() {
        return this.sendfileThreadCount;
    }

    public void setPollerThreadCount(int pollerThreadCount) {
        this.pollerThreadCount = pollerThreadCount;
    }

    public int getPollerThreadCount() {
        return this.pollerThreadCount;
    }

    public Poller getPoller() {
        this.pollerRoundRobin = (this.pollerRoundRobin + 1) % this.pollers.length;
        return this.pollers[this.pollerRoundRobin];
    }

    public Sendfile getSendfile() {
        this.sendfileRoundRobin = (this.sendfileRoundRobin + 1) % this.sendfiles.length;
        return this.sendfiles[this.sendfileRoundRobin];
    }

    public int getMaxSpareThreads() {
        return 0;
    }

    public int getMinSpareThreads() {
        return 0;
    }

    public String getSSLEngine() {
        return this.SSLEngine;
    }

    public void setSSLEngine(String SSLEngine) {
        this.SSLEngine = SSLEngine;
    }

    public String getSSLProtocol() {
        return this.SSLProtocol;
    }

    public void setSSLProtocol(String SSLProtocol) {
        this.SSLProtocol = SSLProtocol;
    }

    public String getSSLPassword() {
        return this.SSLPassword;
    }

    public void setSSLPassword(String SSLPassword) {
        this.SSLPassword = SSLPassword;
    }

    public String getSSLCipherSuite() {
        return this.SSLCipherSuite;
    }

    public void setSSLCipherSuite(String SSLCipherSuite) {
        this.SSLCipherSuite = SSLCipherSuite;
    }

    public String getSSLCertificateFile() {
        return this.SSLCertificateFile;
    }

    public void setSSLCertificateFile(String SSLCertificateFile) {
        this.SSLCertificateFile = SSLCertificateFile;
    }

    public String getSSLCertificateKeyFile() {
        return this.SSLCertificateKeyFile;
    }

    public void setSSLCertificateKeyFile(String SSLCertificateKeyFile) {
        this.SSLCertificateKeyFile = SSLCertificateKeyFile;
    }

    public String getSSLCertificateChainFile() {
        return this.SSLCertificateChainFile;
    }

    public void setSSLCertificateChainFile(String SSLCertificateChainFile) {
        this.SSLCertificateChainFile = SSLCertificateChainFile;
    }

    public String getSSLCACertificatePath() {
        return this.SSLCACertificatePath;
    }

    public void setSSLCACertificatePath(String SSLCACertificatePath) {
        this.SSLCACertificatePath = SSLCACertificatePath;
    }

    public String getSSLCACertificateFile() {
        return this.SSLCACertificateFile;
    }

    public void setSSLCACertificateFile(String SSLCACertificateFile) {
        this.SSLCACertificateFile = SSLCACertificateFile;
    }

    public String getSSLCARevocationPath() {
        return this.SSLCARevocationPath;
    }

    public void setSSLCARevocationPath(String SSLCARevocationPath) {
        this.SSLCARevocationPath = SSLCARevocationPath;
    }

    public String getSSLCARevocationFile() {
        return this.SSLCARevocationFile;
    }

    public void setSSLCARevocationFile(String SSLCARevocationFile) {
        this.SSLCARevocationFile = SSLCARevocationFile;
    }

    public String getSSLVerifyClient() {
        return this.SSLVerifyClient;
    }

    public void setSSLVerifyClient(String SSLVerifyClient) {
        this.SSLVerifyClient = SSLVerifyClient;
    }

    public int getSSLVerifyDepth() {
        return this.SSLVerifyDepth;
    }

    public void setSSLVerifyDepth(int SSLVerifyDepth) {
        this.SSLVerifyDepth = SSLVerifyDepth;
    }

    public int getKeepAliveCount() {
        if (this.pollers == null) {
            return 0;
        }
        int keepAliveCount = 0;
        for (int i = 0; i < this.pollers.length; ++i) {
            keepAliveCount += this.pollers[i].getKeepAliveCount();
        }
        return keepAliveCount;
    }

    public int getSendfileCount() {
        if (this.sendfiles == null) {
            return 0;
        }
        int sendfileCount = 0;
        for (int i = 0; i < this.sendfiles.length; ++i) {
            sendfileCount += this.sendfiles[i].getSendfileCount();
        }
        return sendfileCount;
    }

    public int getCurrentThreadCount() {
        return this.curThreads;
    }

    public int getCurrentThreadsBusy() {
        return this.curThreadsBusy;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void init() throws Exception {
        if (this.initialized) {
            return;
        }
        this.rootPool = Pool.create((long)0L);
        this.serverSockPool = Pool.create((long)this.rootPool);
        String addressStr = null;
        addressStr = this.address == null ? null : this.address.getHostAddress();
        int family = 1;
        if (Library.APR_HAVE_IPV6) {
            if (addressStr == null) {
                family = 0;
            } else if (addressStr.indexOf(58) >= 0) {
                family = 0;
            }
        }
        long inetAddress = Address.info((String)addressStr, (int)family, (int)this.port, (int)0, (long)this.rootPool);
        this.serverSock = Socket.create((int)family, (int)0, (int)6, (long)this.rootPool);
        if (OS.IS_UNIX) {
            Socket.optSet((long)this.serverSock, (int)16, (int)1);
        }
        Socket.optSet((long)this.serverSock, (int)2, (int)1);
        int ret = Socket.bind((long)this.serverSock, (long)inetAddress);
        if (ret != 0) {
            throw new Exception(sm.getString("endpoint.init.bind", "" + ret, Error.strerror((int)ret)));
        }
        ret = Socket.listen((long)this.serverSock, (int)this.backlog);
        if (ret != 0) {
            throw new Exception(sm.getString("endpoint.init.listen", "" + ret, Error.strerror((int)ret)));
        }
        if (OS.IS_WIN32 || OS.IS_WIN64) {
            Socket.optSet((long)this.serverSock, (int)16, (int)1);
        }
        if (this.useSendfile && !Library.APR_HAS_SENDFILE) {
            log.warn((Object)sm.getString("endpoint.sendfile.nosupport"));
            this.useSendfile = false;
        }
        if (this.acceptorThreadCount == 0) {
            this.acceptorThreadCount = 1;
        }
        if (this.pollerThreadCount == 0) {
            if ((OS.IS_WIN32 || OS.IS_WIN64) && this.pollerSize > 1024) {
                this.pollerThreadCount = this.pollerSize / 1024;
                this.pollerSize -= this.pollerSize % 1024;
            } else {
                this.pollerThreadCount = 1;
            }
        }
        if (this.sendfileThreadCount == 0) {
            if ((OS.IS_WIN32 || OS.IS_WIN64) && this.sendfileSize > 1024) {
                this.sendfileThreadCount = this.sendfileSize / 1024;
                this.sendfileSize -= this.sendfileSize % 1024;
            } else {
                this.sendfileThreadCount = 1;
            }
        }
        Socket.optSet((long)this.serverSock, (int)32768, (int)1);
        if (!"off".equalsIgnoreCase(this.SSLEngine)) {
            if ("on".equalsIgnoreCase(this.SSLEngine)) {
                SSL.initialize(null);
            } else {
                SSL.initialize((String)this.SSLEngine);
            }
            int value = 7;
            if ("SSLv2".equalsIgnoreCase(this.SSLProtocol)) {
                value = 1;
            } else if ("SSLv3".equalsIgnoreCase(this.SSLProtocol)) {
                value = 2;
            } else if ("TLSv1".equalsIgnoreCase(this.SSLProtocol)) {
                value = 4;
            } else if ("SSLv2+SSLv3".equalsIgnoreCase(this.SSLProtocol)) {
                value = 3;
            }
            this.sslContext = SSLContext.make((long)this.rootPool, (int)value, (int)1);
            SSLContext.setCipherSuite((long)this.sslContext, (String)this.SSLCipherSuite);
            SSLContext.setCertificate((long)this.sslContext, (String)this.SSLCertificateFile, (String)this.SSLCertificateKeyFile, (String)this.SSLPassword, (int)0);
            SSLContext.setCertificateChainFile((long)this.sslContext, (String)this.SSLCertificateChainFile, (boolean)false);
            SSLContext.setCACertificate((long)this.sslContext, (String)this.SSLCACertificateFile, (String)this.SSLCACertificatePath);
            SSLContext.setCARevocation((long)this.sslContext, (String)this.SSLCARevocationFile, (String)this.SSLCARevocationPath);
            value = 0;
            if ("optional".equalsIgnoreCase(this.SSLVerifyClient)) {
                value = 1;
            } else if ("require".equalsIgnoreCase(this.SSLVerifyClient)) {
                value = 2;
            } else if ("optionalNoCA".equalsIgnoreCase(this.SSLVerifyClient)) {
                value = 3;
            }
            SSLContext.setVerify((long)this.sslContext, (int)value, (int)this.SSLVerifyDepth);
            this.useSendfile = false;
        }
        this.initialized = true;
    }

    public void start() throws Exception {
        if (!this.initialized) {
            this.init();
        }
        if (!this.running) {
            int i;
            this.running = true;
            this.paused = false;
            this.workers = new WorkerStack(this.maxThreads);
            for (i = 0; i < this.acceptorThreadCount; ++i) {
                Thread acceptorThread = new Thread((Runnable)new Acceptor(), this.getName() + "-Acceptor-" + i);
                acceptorThread.setPriority(this.threadPriority);
                acceptorThread.setDaemon(this.daemon);
                acceptorThread.start();
            }
            this.pollers = new Poller[this.pollerThreadCount];
            for (i = 0; i < this.pollerThreadCount; ++i) {
                this.pollers[i] = new Poller();
                this.pollers[i].init();
                Thread pollerThread = new Thread((Runnable)this.pollers[i], this.getName() + "-Poller-" + i);
                pollerThread.setPriority(this.threadPriority);
                pollerThread.setDaemon(true);
                pollerThread.start();
            }
            if (this.useSendfile) {
                this.sendfiles = new Sendfile[this.sendfileThreadCount];
                for (i = 0; i < this.sendfileThreadCount; ++i) {
                    this.sendfiles[i] = new Sendfile();
                    this.sendfiles[i].init();
                    Thread sendfileThread = new Thread((Runnable)this.sendfiles[i], this.getName() + "-Sendfile-" + i);
                    sendfileThread.setPriority(this.threadPriority);
                    sendfileThread.setDaemon(true);
                    sendfileThread.start();
                }
            }
        }
    }

    public void pause() {
        if (this.running && !this.paused) {
            this.paused = true;
            this.unlockAccept();
        }
    }

    public void resume() {
        if (this.running) {
            this.paused = false;
        }
    }

    public void stop() {
        if (this.running) {
            int i;
            this.running = false;
            this.unlockAccept();
            for (i = 0; i < this.pollers.length; ++i) {
                this.pollers[i].destroy();
            }
            this.pollers = null;
            if (this.useSendfile) {
                for (i = 0; i < this.sendfiles.length; ++i) {
                    this.sendfiles[i].destroy();
                }
                this.sendfiles = null;
            }
        }
    }

    public void destroy() throws Exception {
        if (this.running) {
            this.stop();
        }
        Pool.destroy((long)this.serverSockPool);
        this.serverSockPool = 0L;
        Socket.close((long)this.serverSock);
        this.serverSock = 0L;
        this.sslContext = 0L;
        Pool.destroy((long)this.rootPool);
        this.rootPool = 0L;
        this.initialized = false;
    }

    protected int getSequence() {
        return this.sequence++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockAccept() {
        java.net.Socket s = null;
        try {
            if (this.address == null) {
                s = new java.net.Socket("127.0.0.1", this.port);
            } else {
                s = new java.net.Socket(this.address, this.port);
                s.setSoLinger(true, 0);
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("endpoint.debug.unlock", "" + this.port), (Throwable)e);
            }
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected boolean setSocketOptions(long socket) {
        int step = 1;
        try {
            if (this.soLinger >= 0) {
                Socket.optSet((long)socket, (int)1, (int)this.soLinger);
            }
            if (this.tcpNoDelay) {
                Socket.optSet((long)socket, (int)512, (int)(this.tcpNoDelay ? 1 : 0));
            }
            if (this.soTimeout > 0) {
                Socket.timeoutSet((long)socket, (long)(this.soTimeout * 1000));
            }
            step = 2;
            if (this.sslContext != 0L) {
                SSLSocket.attach((long)this.sslContext, (long)socket);
                if (SSLSocket.handshake((long)socket) != 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(sm.getString("endpoint.err.handshake") + ": " + SSL.getLastError()));
                    }
                    return false;
                }
            }
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                if (step == 2) {
                    log.debug((Object)sm.getString("endpoint.err.handshake"), t);
                } else {
                    log.debug((Object)sm.getString("endpoint.err.unexpected"), t);
                }
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Worker createWorkerThread() {
        WorkerStack workerStack = this.workers;
        synchronized (workerStack) {
            if (this.workers.size() > 0) {
                ++this.curThreadsBusy;
                return this.workers.pop();
            }
            if (this.maxThreads > 0 && this.curThreads < this.maxThreads) {
                ++this.curThreadsBusy;
                return this.newWorkerThread();
            }
            if (this.maxThreads < 0) {
                ++this.curThreadsBusy;
                return this.newWorkerThread();
            }
            return null;
        }
    }

    protected Worker newWorkerThread() {
        Worker workerThread = new Worker();
        workerThread.start();
        return workerThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Worker getWorkerThread() {
        Worker workerThread = this.createWorkerThread();
        while (workerThread == null) {
            try {
                WorkerStack workerStack = this.workers;
                synchronized (workerStack) {
                    this.workers.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            workerThread = this.createWorkerThread();
        }
        return workerThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recycleWorkerThread(Worker workerThread) {
        WorkerStack workerStack = this.workers;
        synchronized (workerStack) {
            this.workers.push(workerThread);
            --this.curThreadsBusy;
            this.workers.notify();
        }
    }

    protected long allocatePoller(int size, long pool, int timeout) {
        try {
            return Poll.create((int)size, (long)pool, (int)0, (long)(timeout * 1000));
        }
        catch (Error e) {
            if (Status.APR_STATUS_IS_EINVAL((int)e.getError())) {
                log.info((Object)sm.getString("endpoint.poll.limitedpollsize", "" + size));
                return 0L;
            }
            log.error((Object)sm.getString("endpoint.poll.initfail"), (Throwable)e);
            return -1L;
        }
    }

    public class WorkerStack {
        protected Worker[] workers = null;
        protected int end = 0;

        public WorkerStack(int size) {
            this.workers = new Worker[size];
        }

        public void push(Worker worker) {
            this.workers[this.end++] = worker;
        }

        public Worker pop() {
            if (this.end > 0) {
                return this.workers[--this.end];
            }
            return null;
        }

        public Worker peek() {
            return this.workers[this.end];
        }

        public boolean isEmpty() {
            return this.end == 0;
        }

        public int size() {
            return this.end;
        }
    }

    public static interface Handler {
        public boolean process(long var1);
    }

    public class Sendfile
    implements Runnable {
        protected long sendfilePollset = 0L;
        protected long pool = 0L;
        protected long[] desc;
        protected HashMap sendfileData;
        protected int sendfileCount;
        protected ArrayList addS;

        public int getSendfileCount() {
            return this.sendfileCount;
        }

        protected void init() {
            this.pool = Pool.create((long)AprEndpoint.this.serverSockPool);
            int size = AprEndpoint.this.sendfileSize / AprEndpoint.this.sendfileThreadCount;
            this.sendfilePollset = AprEndpoint.this.allocatePoller(size, this.pool, AprEndpoint.this.soTimeout);
            if (this.sendfilePollset == 0L && size > 1024) {
                size = 1024;
                this.sendfilePollset = AprEndpoint.this.allocatePoller(size, this.pool, AprEndpoint.this.soTimeout);
            }
            if (this.sendfilePollset == 0L) {
                size = 62;
                this.sendfilePollset = AprEndpoint.this.allocatePoller(size, this.pool, AprEndpoint.this.soTimeout);
            }
            this.desc = new long[size * 2];
            this.sendfileData = new HashMap(size);
            this.addS = new ArrayList();
        }

        protected void destroy() {
            for (int i = this.addS.size() - 1; i >= 0; --i) {
                SendfileData data = (SendfileData)this.addS.get(i);
                Socket.destroy((long)data.socket);
            }
            int rv = Poll.pollset((long)this.sendfilePollset, (long[])this.desc);
            if (rv > 0) {
                for (int n = 0; n < rv; ++n) {
                    Socket.destroy((long)this.desc[n * 2 + 1]);
                }
            }
            Pool.destroy((long)this.pool);
            this.sendfileData.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(SendfileData data) {
            block8: {
                try {
                    data.fdpool = Socket.pool((long)data.socket);
                    data.fd = File.open((String)data.fileName, (int)4129, (int)0, (long)data.fdpool);
                    data.pos = data.start;
                    Socket.timeoutSet((long)data.socket, (long)0L);
                    do {
                        long nw;
                        if ((nw = Socket.sendfilen((long)data.socket, (long)data.fd, (long)data.pos, (long)(data.end - data.pos), (int)0)) < 0L) {
                            if (-nw != 120002L) {
                                Socket.destroy((long)data.socket);
                                data.socket = 0L;
                                return false;
                            }
                            break block8;
                        }
                        data.pos += nw;
                    } while (data.pos < data.end);
                    Pool.destroy((long)data.fdpool);
                    Socket.timeoutSet((long)data.socket, (long)(AprEndpoint.this.soTimeout * 1000));
                    return true;
                }
                catch (Exception e) {
                    log.error((Object)sm.getString("endpoint.sendfile.error"), (Throwable)e);
                    return false;
                }
            }
            Sendfile sendfile = this;
            synchronized (sendfile) {
                this.addS.add(data);
                this.notify();
            }
            return false;
        }

        protected void remove(SendfileData data) {
            int rv = Poll.remove((long)this.sendfilePollset, (long)data.socket);
            if (rv == 0) {
                --this.sendfileCount;
            }
            this.sendfileData.remove(data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (AprEndpoint.this.running) {
                Sendfile e3;
                while (AprEndpoint.this.paused) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e2) {}
                }
                while (this.sendfileCount < 1 && this.addS.size() < 1) {
                    try {
                        e3 = this;
                        synchronized (e3) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e3) {
                    }
                }
                try {
                    int errn;
                    int rv;
                    if (this.addS.size() > 0) {
                        e3 = this;
                        synchronized (e3) {
                            for (int i = this.addS.size() - 1; i >= 0; --i) {
                                SendfileData data = (SendfileData)this.addS.get(i);
                                int rv2 = Poll.add((long)this.sendfilePollset, (long)data.socket, (int)4);
                                if (rv2 == 0) {
                                    this.sendfileData.put(new Long(data.socket), data);
                                    ++this.sendfileCount;
                                    continue;
                                }
                                log.warn((Object)sm.getString("endpoint.sendfile.addfail", "" + rv2, Error.strerror((int)rv2)));
                                Socket.destroy((long)data.socket);
                            }
                            this.addS.clear();
                        }
                    }
                    if ((rv = Poll.poll((long)this.sendfilePollset, (long)AprEndpoint.this.pollTime, (long[])this.desc, (boolean)false)) > 0) {
                        for (int n = 0; n < rv; ++n) {
                            SendfileData state = (SendfileData)this.sendfileData.get(new Long(this.desc[n * 2 + 1]));
                            if ((this.desc[n * 2] & 0x20L) == 32L || (this.desc[n * 2] & 0x10L) == 16L) {
                                this.remove(state);
                                Socket.destroy((long)state.socket);
                                continue;
                            }
                            long nw = Socket.sendfilen((long)state.socket, (long)state.fd, (long)state.pos, (long)(state.end - state.pos), (int)0);
                            if (nw < 0L) {
                                this.remove(state);
                                Socket.destroy((long)state.socket);
                                continue;
                            }
                            state.pos += nw;
                            if (state.pos < state.end) continue;
                            this.remove(state);
                            if (state.keepAlive) {
                                Pool.destroy((long)state.fdpool);
                                Socket.timeoutSet((long)state.socket, (long)(AprEndpoint.this.soTimeout * 1000));
                                AprEndpoint.this.getWorkerThread().assign(state.socket, false);
                                continue;
                            }
                            Socket.destroy((long)state.socket);
                        }
                        continue;
                    }
                    if (rv >= 0 || (errn = -rv) == 120001 || errn == 120003) continue;
                    if (errn > 120000) {
                        errn -= 120000;
                    }
                    log.error((Object)sm.getString("endpoint.poll.fail", "" + errn, Error.strerror((int)errn)));
                    Sendfile sendfile = this;
                    synchronized (sendfile) {
                        this.destroy();
                        this.init();
                    }
                }
                catch (Throwable t) {
                    log.error((Object)sm.getString("endpoint.poll.error"), t);
                }
            }
        }
    }

    public static class SendfileData {
        public String fileName;
        public long fd;
        public long fdpool;
        public long start;
        public long end;
        public long socket;
        public long pos;
        public boolean keepAlive;
    }

    protected class Worker
    implements Runnable {
        protected Thread thread = null;
        protected boolean available = false;
        protected long socket = 0L;
        protected boolean options = false;

        protected Worker() {
        }

        protected synchronized void assign(long socket, boolean options) {
            while (this.available) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            this.socket = socket;
            this.options = options;
            this.available = true;
            this.notifyAll();
        }

        protected synchronized long await() {
            while (!this.available) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            long socket = this.socket;
            this.available = false;
            this.notifyAll();
            return socket;
        }

        public void run() {
            while (AprEndpoint.this.running) {
                long socket = this.await();
                if (socket == 0L) continue;
                if (this.options && !AprEndpoint.this.setSocketOptions(socket) || !AprEndpoint.this.handler.process(socket)) {
                    Socket.destroy((long)socket);
                    socket = 0L;
                }
                AprEndpoint.this.recycleWorkerThread(this);
            }
        }

        public void start() {
            this.thread = new ThreadWithAttributes(AprEndpoint.this, (Runnable)this);
            this.thread.setName(AprEndpoint.this.getName() + "-" + ++AprEndpoint.this.curThreads);
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    public class Poller
    implements Runnable {
        protected long serverPollset = 0L;
        protected long pool = 0L;
        protected long[] desc;
        protected long[] addS;
        protected int addCount = 0;
        protected int keepAliveCount = 0;

        public int getKeepAliveCount() {
            return this.keepAliveCount;
        }

        protected void init() {
            this.pool = Pool.create((long)AprEndpoint.this.serverSockPool);
            int size = AprEndpoint.this.pollerSize / AprEndpoint.this.pollerThreadCount;
            this.serverPollset = AprEndpoint.this.allocatePoller(size, this.pool, AprEndpoint.this.soTimeout);
            if (this.serverPollset == 0L && size > 1024) {
                size = 1024;
                this.serverPollset = AprEndpoint.this.allocatePoller(size, this.pool, AprEndpoint.this.soTimeout);
            }
            if (this.serverPollset == 0L) {
                size = 62;
                this.serverPollset = AprEndpoint.this.allocatePoller(size, this.pool, AprEndpoint.this.soTimeout);
            }
            this.desc = new long[size * 2];
            this.keepAliveCount = 0;
            this.addS = new long[size];
            this.addCount = 0;
        }

        protected void destroy() {
            for (int i = 0; i < this.addCount; ++i) {
                Socket.destroy((long)this.addS[i]);
            }
            int rv = Poll.pollset((long)this.serverPollset, (long[])this.desc);
            if (rv > 0) {
                for (int n = 0; n < rv; ++n) {
                    Socket.destroy((long)this.desc[n * 2 + 1]);
                }
            }
            Pool.destroy((long)this.pool);
            this.keepAliveCount = 0;
            this.addCount = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(long socket) {
            Poller poller = this;
            synchronized (poller) {
                if (this.addCount >= this.addS.length) {
                    Socket.destroy((long)socket);
                    return;
                }
                this.addS[this.addCount] = socket;
                ++this.addCount;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long maintainTime = 0L;
            while (AprEndpoint.this.running) {
                Poller e3;
                while (AprEndpoint.this.paused) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e2) {}
                }
                while (this.keepAliveCount < 1 && this.addCount < 1) {
                    maintainTime = 0L;
                    try {
                        e3 = this;
                        synchronized (e3) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e3) {
                    }
                }
                try {
                    int errn;
                    int n;
                    if (this.addCount > 0) {
                        e3 = this;
                        synchronized (e3) {
                            for (int i = this.addCount - 1; i >= 0; --i) {
                                int rv = Poll.add((long)this.serverPollset, (long)this.addS[i], (int)1);
                                if (rv == 0) {
                                    ++this.keepAliveCount;
                                    continue;
                                }
                                Socket.destroy((long)this.addS[i]);
                            }
                            this.addCount = 0;
                        }
                    }
                    maintainTime += (long)AprEndpoint.this.pollTime;
                    int rv = Poll.poll((long)this.serverPollset, (long)AprEndpoint.this.pollTime, (long[])this.desc, (boolean)true);
                    if (rv > 0) {
                        this.keepAliveCount -= rv;
                        for (n = 0; n < rv; ++n) {
                            if ((this.desc[n * 2] & 0x20L) == 32L || (this.desc[n * 2] & 0x10L) == 16L) {
                                Socket.destroy((long)this.desc[n * 2 + 1]);
                                continue;
                            }
                            AprEndpoint.this.getWorkerThread().assign(this.desc[n * 2 + 1], false);
                        }
                    } else if (rv < 0 && (errn = -rv) != 120001 && errn != 120003) {
                        if (errn > 120000) {
                            errn -= 120000;
                        }
                        log.error((Object)sm.getString("endpoint.poll.fail", "" + errn, Error.strerror((int)errn)));
                        Poller poller = this;
                        synchronized (poller) {
                            this.destroy();
                            this.init();
                            continue;
                        }
                    }
                    if (AprEndpoint.this.soTimeout <= 0 || maintainTime <= 1000000L) continue;
                    rv = Poll.maintain((long)this.serverPollset, (long[])this.desc, (boolean)true);
                    maintainTime = 0L;
                    if (rv <= 0) continue;
                    this.keepAliveCount -= rv;
                    for (n = 0; n < rv; ++n) {
                        Socket.destroy((long)this.desc[n]);
                    }
                }
                catch (Throwable t) {
                    log.error((Object)sm.getString("endpoint.poll.error"), t);
                }
            }
        }
    }

    protected class Acceptor
    implements Runnable {
        protected Acceptor() {
        }

        public void run() {
            while (AprEndpoint.this.running) {
                while (AprEndpoint.this.paused) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
                try {
                    long socket = Socket.accept((long)AprEndpoint.this.serverSock);
                    AprEndpoint.this.getWorkerThread().assign(socket, true);
                }
                catch (Throwable t) {
                    log.error((Object)sm.getString("endpoint.accept.fail"), t);
                }
            }
        }
    }
}

