/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MLAnalysisMode {
    LOCALE_ONLY{

        public boolean includesAll() {
            return false;
        }

        public boolean includesContained() {
            return false;
        }

        public boolean includesContaining() {
            return false;
        }

        public boolean includesExact() {
            return true;
        }

        public boolean includesAllLanguageMatches() {
            return false;
        }

        public boolean includesExactLanguageMatch() {
            return false;
        }

        public boolean includesAllCountryMatches() {
            return false;
        }

        public boolean includesExactCountryMatch() {
            return false;
        }
    }
    ,
    LOCALE_AND_ALL{

        public boolean includesAll() {
            return true;
        }

        public boolean includesContained() {
            return false;
        }

        public boolean includesContaining() {
            return false;
        }

        public boolean includesExact() {
            return true;
        }

        public boolean includesAllLanguageMatches() {
            return false;
        }

        public boolean includesExactLanguageMatch() {
            return false;
        }

        public boolean includesAllCountryMatches() {
            return false;
        }

        public boolean includesExactCountryMatch() {
            return false;
        }
    }
    ,
    LOCALE_AND_ALL_CONTAINING_LOCALES{

        public boolean includesAll() {
            return false;
        }

        public boolean includesContained() {
            return false;
        }

        public boolean includesContaining() {
            return true;
        }

        public boolean includesExact() {
            return true;
        }

        public boolean includesAllLanguageMatches() {
            return false;
        }

        public boolean includesExactLanguageMatch() {
            return false;
        }

        public boolean includesAllCountryMatches() {
            return false;
        }

        public boolean includesExactCountryMatch() {
            return false;
        }
    }
    ,
    LOCALE_AND_ALL_CONTAINING_LOCALES_AND_ALL{

        public boolean includesAll() {
            return true;
        }

        public boolean includesContained() {
            return false;
        }

        public boolean includesContaining() {
            return true;
        }

        public boolean includesExact() {
            return true;
        }

        public boolean includesAllLanguageMatches() {
            return false;
        }

        public boolean includesExactLanguageMatch() {
            return false;
        }

        public boolean includesAllCountryMatches() {
            return false;
        }

        public boolean includesExactCountryMatch() {
            return false;
        }
    }
    ,
    LOCALE_AND_ALL_CONTAINED_LOCALES{

        public boolean includesAll() {
            return false;
        }

        public boolean includesContained() {
            return true;
        }

        public boolean includesContaining() {
            return false;
        }

        public boolean includesExact() {
            return true;
        }

        public boolean includesAllLanguageMatches() {
            return false;
        }

        public boolean includesExactLanguageMatch() {
            return false;
        }

        public boolean includesAllCountryMatches() {
            return false;
        }

        public boolean includesExactCountryMatch() {
            return false;
        }
    }
    ,
    ALL_ONLY{

        public boolean includesAll() {
            return true;
        }

        public boolean includesContained() {
            return false;
        }

        public boolean includesContaining() {
            return false;
        }

        public boolean includesExact() {
            return false;
        }

        public boolean includesAllLanguageMatches() {
            return false;
        }

        public boolean includesExactLanguageMatch() {
            return false;
        }

        public boolean includesAllCountryMatches() {
            return false;
        }

        public boolean includesExactCountryMatch() {
            return false;
        }
    }
    ,
    ALL_LANGUAGES{

        public boolean includesAll() {
            return false;
        }

        public boolean includesContained() {
            return false;
        }

        public boolean includesContaining() {
            return false;
        }

        public boolean includesExact() {
            return false;
        }

        public boolean includesAllLanguageMatches() {
            return true;
        }

        public boolean includesExactLanguageMatch() {
            return false;
        }

        public boolean includesAllCountryMatches() {
            return false;
        }

        public boolean includesExactCountryMatch() {
            return false;
        }
    }
    ,
    ALL_LANGUAGES_AND_ALL{

        public boolean includesAll() {
            return true;
        }

        public boolean includesContained() {
            return false;
        }

        public boolean includesContaining() {
            return false;
        }

        public boolean includesExact() {
            return false;
        }

        public boolean includesAllLanguageMatches() {
            return true;
        }

        public boolean includesExactLanguageMatch() {
            return false;
        }

        public boolean includesAllCountryMatches() {
            return false;
        }

        public boolean includesExactCountryMatch() {
            return false;
        }
    }
    ,
    EXACT_LANGUAGE{

        public boolean includesAll() {
            return false;
        }

        public boolean includesContained() {
            return false;
        }

        public boolean includesContaining() {
            return false;
        }

        public boolean includesExact() {
            return false;
        }

        public boolean includesAllLanguageMatches() {
            return false;
        }

        public boolean includesExactLanguageMatch() {
            return true;
        }

        public boolean includesAllCountryMatches() {
            return false;
        }

        public boolean includesExactCountryMatch() {
            return false;
        }
    }
    ,
    EXACT_LANGUAGE_AND_ALL{

        public boolean includesAll() {
            return true;
        }

        public boolean includesContained() {
            return false;
        }

        public boolean includesContaining() {
            return false;
        }

        public boolean includesExact() {
            return false;
        }

        public boolean includesAllLanguageMatches() {
            return false;
        }

        public boolean includesExactLanguageMatch() {
            return true;
        }

        public boolean includesAllCountryMatches() {
            return false;
        }

        public boolean includesExactCountryMatch() {
            return false;
        }
    }
    ,
    EXACT_COUNRTY{

        public boolean includesAll() {
            return false;
        }

        public boolean includesContained() {
            return false;
        }

        public boolean includesContaining() {
            return false;
        }

        public boolean includesExact() {
            return false;
        }

        public boolean includesAllLanguageMatches() {
            return false;
        }

        public boolean includesExactLanguageMatch() {
            return false;
        }

        public boolean includesAllCountryMatches() {
            return false;
        }

        public boolean includesExactCountryMatch() {
            return true;
        }
    }
    ,
    EXACT_COUNTRY_AND_ALL{

        public boolean includesAll() {
            return true;
        }

        public boolean includesContained() {
            return false;
        }

        public boolean includesContaining() {
            return false;
        }

        public boolean includesExact() {
            return false;
        }

        public boolean includesAllLanguageMatches() {
            return false;
        }

        public boolean includesExactLanguageMatch() {
            return false;
        }

        public boolean includesAllCountryMatches() {
            return false;
        }

        public boolean includesExactCountryMatch() {
            return true;
        }
    }
    ,
    ALL_COUNTRIES{

        public boolean includesAll() {
            return false;
        }

        public boolean includesContained() {
            return false;
        }

        public boolean includesContaining() {
            return false;
        }

        public boolean includesExact() {
            return false;
        }

        public boolean includesAllLanguageMatches() {
            return false;
        }

        public boolean includesExactLanguageMatch() {
            return false;
        }

        public boolean includesAllCountryMatches() {
            return true;
        }

        public boolean includesExactCountryMatch() {
            return false;
        }
    }
    ,
    ALL_COUNTRIES_AND_ALL{

        public boolean includesAll() {
            return true;
        }

        public boolean includesContained() {
            return false;
        }

        public boolean includesContaining() {
            return false;
        }

        public boolean includesExact() {
            return false;
        }

        public boolean includesAllLanguageMatches() {
            return false;
        }

        public boolean includesExactLanguageMatch() {
            return false;
        }

        public boolean includesAllCountryMatches() {
            return true;
        }

        public boolean includesExactCountryMatch() {
            return false;
        }
    };


    public static MLAnalysisMode getMLAnalysisMode(String mode) {
        for (MLAnalysisMode test : MLAnalysisMode.values()) {
            if (!test.toString().equalsIgnoreCase(mode)) continue;
            return test;
        }
        throw new AlfrescoRuntimeException("Unknown ML Analysis mode " + mode);
    }

    public abstract boolean includesAll();

    public abstract boolean includesContained();

    public abstract boolean includesContaining();

    public abstract boolean includesExact();

    public abstract boolean includesAllLanguageMatches();

    public abstract boolean includesExactLanguageMatch();

    public abstract boolean includesAllCountryMatches();

    public abstract boolean includesExactCountryMatch();

    public static Set<Locale> getLocales(MLAnalysisMode mlAnalaysisMode, Locale locale, boolean withWildcards) {
        boolean v;
        HashSet<Locale> locales = new HashSet<Locale>();
        boolean l = locale.getLanguage().length() != 0;
        boolean c = locale.getCountry().length() != 0;
        boolean bl = v = locale.getVariant().length() != 0;
        if (mlAnalaysisMode.includesAll()) {
            if (withWildcards) {
                locales.add(new Locale("", "", ""));
                locales.add(new Locale("*", "", ""));
            } else {
                locales.add(new Locale("", "", ""));
            }
        }
        if (mlAnalaysisMode.includesExact()) {
            locales.add(locale);
        }
        if (mlAnalaysisMode.includesContaining()) {
            if (v) {
                Locale noVarient = new Locale(locale.getLanguage(), locale.getCountry(), "");
                locales.add(noVarient);
                Locale noCountry = new Locale(locale.getLanguage(), "", "");
                locales.add(noCountry);
            }
            if (c) {
                Locale noCountry = new Locale(locale.getLanguage(), "", "");
                locales.add(noCountry);
            }
        }
        if (mlAnalaysisMode.includesContained() && !v) {
            if (!c) {
                if (!l) {
                    if (withWildcards) {
                        locales.add(new Locale("", "", ""));
                        locales.add(new Locale("*", "", ""));
                    } else {
                        for (Locale toAdd : Locale.getAvailableLocales()) {
                            locales.add(toAdd);
                        }
                    }
                } else if (withWildcards) {
                    locales.add(new Locale(locale.getLanguage(), "", ""));
                    locales.add(new Locale(locale.getLanguage(), "*", ""));
                } else {
                    for (Locale toAdd : Locale.getAvailableLocales()) {
                        if (!locale.getLanguage().equals("") && !locale.getLanguage().equals(toAdd.getLanguage())) continue;
                        locales.add(toAdd);
                    }
                }
            } else if (withWildcards) {
                locales.add(new Locale(locale.getLanguage(), locale.getCountry(), ""));
                locales.add(new Locale(locale.getLanguage(), locale.getCountry(), "*"));
            } else {
                for (Locale toAdd : Locale.getAvailableLocales()) {
                    if (!locale.getLanguage().equals("") && !locale.getLanguage().equals(toAdd.getLanguage()) || !locale.getCountry().equals("") && !locale.getCountry().equals(toAdd.getCountry())) continue;
                    locales.add(toAdd);
                }
            }
        }
        if (mlAnalaysisMode.includesAllLanguageMatches()) {
            if (withWildcards) {
                locales.add(new Locale(locale.getLanguage(), "", ""));
                locales.add(new Locale(locale.getLanguage(), "*", ""));
            } else {
                for (Locale toAdd : Locale.getAvailableLocales()) {
                    if (!locale.getLanguage().equals("") && !locale.getLanguage().equals(toAdd.getLanguage())) continue;
                    locales.add(toAdd);
                }
            }
        }
        if (mlAnalaysisMode.includesExactLanguageMatch()) {
            if (withWildcards) {
                locales.add(new Locale(locale.getLanguage(), "", ""));
            } else {
                locales.add(new Locale(locale.getLanguage(), "", ""));
            }
        }
        if (mlAnalaysisMode.includesAllCountryMatches()) {
            if (withWildcards) {
                locales.add(new Locale(locale.getLanguage(), locale.getCountry(), ""));
                if (locale.getCountry().equals("")) {
                    locales.add(new Locale(locale.getLanguage(), "*", ""));
                } else {
                    locales.add(new Locale(locale.getLanguage(), locale.getCountry(), "*"));
                }
            } else {
                for (Locale toAdd : Locale.getAvailableLocales()) {
                    if (!locale.getLanguage().equals("") && !locale.getLanguage().equals(toAdd.getLanguage()) || !locale.getCountry().equals("") && !locale.getCountry().equals(toAdd.getCountry())) continue;
                    locales.add(toAdd);
                }
            }
        }
        if (mlAnalaysisMode.includesExactCountryMatch()) {
            if (withWildcards) {
                if (locale.getCountry().equals("")) {
                    locales.add(new Locale(locale.getLanguage(), "", ""));
                    locales.add(new Locale(locale.getLanguage(), "*", ""));
                } else {
                    locales.add(new Locale(locale.getLanguage(), locale.getCountry(), ""));
                }
            } else if (locale.getCountry().equals("")) {
                for (Locale toAdd : Locale.getAvailableLocales()) {
                    if (!locale.getLanguage().equals("") && !locale.getLanguage().equals(toAdd.getLanguage())) continue;
                    locales.add(toAdd);
                }
            } else {
                locales.add(new Locale(locale.getLanguage(), locale.getCountry(), ""));
            }
        }
        return locales;
    }
}

