/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.alfresco.repo.search.MLAnalysisMode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MLTokenDuplicator
extends Tokenizer {
    private static Log s_logger = LogFactory.getLog(MLTokenDuplicator.class);
    TokenStream source;
    Locale locale;
    Iterator<Token> it;
    HashSet<String> prefixes;

    public MLTokenDuplicator(TokenStream source, Locale locale, Reader reader, MLAnalysisMode mlAnalaysisMode) {
        super(reader);
        this.source = source;
        this.locale = locale;
        Set<Locale> locales = MLAnalysisMode.getLocales(mlAnalaysisMode, locale, false);
        this.prefixes = new HashSet(locales.size());
        for (Locale toAdd : locales) {
            String localeString = toAdd.toString();
            if (localeString.length() == 0) {
                this.prefixes.add("");
                continue;
            }
            StringBuilder builder = new StringBuilder(16);
            builder.append("{").append(localeString).append("}");
            this.prefixes.add(builder.toString());
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Locale " + locale + " using " + (Object)((Object)mlAnalaysisMode) + " is " + this.prefixes));
        }
    }

    public MLTokenDuplicator(Locale locale, MLAnalysisMode mlAnalaysisMode) {
        this(null, locale, null, mlAnalaysisMode);
    }

    public Token next() throws IOException {
        Token t = null;
        if (this.it == null) {
            this.it = this.buildIterator();
        }
        if (this.it == null) {
            return null;
        }
        if (this.it.hasNext()) {
            t = this.it.next();
            return t;
        }
        this.it = null;
        t = this.next();
        return t;
    }

    private Iterator<Token> buildIterator() throws IOException {
        Token token = this.source.next();
        return this.buildIterator(token);
    }

    public Iterator<Token> buildIterator(Token token) {
        if (token == null) {
            return null;
        }
        ArrayList<Token> tokens = new ArrayList<Token>(this.prefixes.size());
        for (String prefix : this.prefixes) {
            Token newToken = new Token(prefix + token.termText(), token.startOffset(), token.endOffset(), token.type());
            if (tokens.size() == 0) {
                newToken.setPositionIncrement(token.getPositionIncrement());
            } else {
                newToken.setPositionIncrement(0);
            }
            tokens.add(newToken);
        }
        return tokens.iterator();
    }
}

