/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository.datatype;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import junit.framework.TestCase;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.Period;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.Duration;
import org.alfresco.util.VersionNumber;
import org.springframework.extensions.surf.util.ISO8601DateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTypeConverterTest
extends TestCase {
    public DefaultTypeConverterTest() {
    }

    public DefaultTypeConverterTest(String arg0) {
        super(arg0);
    }

    public void testPrimitives() {
        DefaultTypeConverterTest.assertEquals((Object)false, (Object)DefaultTypeConverter.INSTANCE.convert(Boolean.class, (Object)false));
        DefaultTypeConverterTest.assertEquals((Object)true, (Object)DefaultTypeConverter.INSTANCE.convert(Boolean.class, (Object)true));
        DefaultTypeConverterTest.assertEquals((Object)Character.valueOf('a'), (Object)DefaultTypeConverter.INSTANCE.convert(Character.class, (Object)Character.valueOf('a')));
        DefaultTypeConverterTest.assertEquals((Object)Byte.valueOf("3"), (Object)DefaultTypeConverter.INSTANCE.convert(Byte.class, (Object)3));
        DefaultTypeConverterTest.assertEquals((Object)Short.valueOf("4"), (Object)DefaultTypeConverter.INSTANCE.convert(Short.class, (Object)4));
        DefaultTypeConverterTest.assertEquals((Object)Integer.valueOf("5"), (Object)DefaultTypeConverter.INSTANCE.convert(Integer.class, (Object)5));
        DefaultTypeConverterTest.assertEquals((Object)Long.valueOf("6"), (Object)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)6L));
        DefaultTypeConverterTest.assertEquals((Object)Float.valueOf("7.1"), (Object)DefaultTypeConverter.INSTANCE.convert(Float.class, (Object)Float.valueOf(7.1f)));
        DefaultTypeConverterTest.assertEquals((Object)Double.valueOf("123.123"), (Object)DefaultTypeConverter.INSTANCE.convert(Double.class, (Object)123.123));
    }

    public void testNoConversion() {
        DefaultTypeConverterTest.assertEquals((Object)false, (Object)DefaultTypeConverter.INSTANCE.convert(Boolean.class, (Object)false));
        DefaultTypeConverterTest.assertEquals((Object)true, (Object)DefaultTypeConverter.INSTANCE.convert(Boolean.class, (Object)true));
        DefaultTypeConverterTest.assertEquals((Object)Character.valueOf('w'), (Object)DefaultTypeConverter.INSTANCE.convert(Character.class, (Object)Character.valueOf('w')));
        DefaultTypeConverterTest.assertEquals((Object)Byte.valueOf("3"), (Object)DefaultTypeConverter.INSTANCE.convert(Byte.class, (Object)Byte.valueOf("3")));
        DefaultTypeConverterTest.assertEquals((Object)Short.valueOf("4"), (Object)DefaultTypeConverter.INSTANCE.convert(Short.class, (Object)Short.valueOf("4")));
        DefaultTypeConverterTest.assertEquals((Object)Integer.valueOf("5"), (Object)DefaultTypeConverter.INSTANCE.convert(Integer.class, (Object)Integer.valueOf("5")));
        DefaultTypeConverterTest.assertEquals((Object)Long.valueOf("6"), (Object)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)Long.valueOf("6")));
        DefaultTypeConverterTest.assertEquals((Object)Float.valueOf("7.1"), (Object)DefaultTypeConverter.INSTANCE.convert(Float.class, (Object)Float.valueOf("7.1")));
        DefaultTypeConverterTest.assertEquals((Object)Double.valueOf("123.123"), (Object)DefaultTypeConverter.INSTANCE.convert(Double.class, (Object)Double.valueOf("123.123")));
        DefaultTypeConverterTest.assertEquals((Object)Double.valueOf("123.123"), (Object)DefaultTypeConverter.INSTANCE.convert(Double.class, (Object)Double.valueOf("123.123")));
        DefaultTypeConverterTest.assertEquals((Object)new BigInteger("1234567890123456789"), (Object)DefaultTypeConverter.INSTANCE.convert(BigInteger.class, (Object)new BigInteger("1234567890123456789")));
        DefaultTypeConverterTest.assertEquals((Object)new BigDecimal("12345678901234567890.12345678901234567890"), (Object)DefaultTypeConverter.INSTANCE.convert(BigDecimal.class, (Object)new BigDecimal("12345678901234567890.12345678901234567890")));
        Date date = new Date();
        DefaultTypeConverterTest.assertEquals((Object)date, (Object)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)date));
        DefaultTypeConverterTest.assertEquals((Object)new Duration("P25D"), (Object)DefaultTypeConverter.INSTANCE.convert(Duration.class, (Object)new Duration("P25D")));
        DefaultTypeConverterTest.assertEquals((String)"woof", (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)"woof"));
    }

    public void testToString() {
        DefaultTypeConverterTest.assertEquals((String)"true", (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)new Boolean(true)));
        DefaultTypeConverterTest.assertEquals((String)"false", (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)new Boolean(false)));
        DefaultTypeConverterTest.assertEquals((String)"v", (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)Character.valueOf('v')));
        DefaultTypeConverterTest.assertEquals((String)"3", (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)Byte.valueOf("3")));
        DefaultTypeConverterTest.assertEquals((String)"4", (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)Short.valueOf("4")));
        DefaultTypeConverterTest.assertEquals((String)"5", (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)Integer.valueOf("5")));
        DefaultTypeConverterTest.assertEquals((String)"6", (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)Long.valueOf("6")));
        DefaultTypeConverterTest.assertEquals((String)"7.1", (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)Float.valueOf("7.1")));
        DefaultTypeConverterTest.assertEquals((String)"123.123", (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)Double.valueOf("123.123")));
        DefaultTypeConverterTest.assertEquals((String)"1234567890123456789", (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)new BigInteger("1234567890123456789")));
        DefaultTypeConverterTest.assertEquals((String)"12345678901234567890.12345678901234567890", (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)new BigDecimal("12345678901234567890.12345678901234567890")));
        Date date = new Date();
        DefaultTypeConverterTest.assertEquals((String)ISO8601DateFormat.format((Date)date), (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date));
        DefaultTypeConverterTest.assertEquals((String)"P0Y25D", (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)new Duration("P0Y25D")));
        DefaultTypeConverterTest.assertEquals((String)"woof", (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)"woof"));
        MLText mlText = new MLText("woof");
        mlText.addValue(Locale.SIMPLIFIED_CHINESE, "\u7f02");
        DefaultTypeConverterTest.assertEquals((String)"woof", (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)mlText));
        DefaultTypeConverterTest.assertEquals((String)"fr_FR_", (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)Locale.FRANCE));
        DefaultTypeConverterTest.assertEquals((String)"1.2.3", (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)new VersionNumber("1.2.3")));
        DefaultTypeConverterTest.assertEquals((String)"period", (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)new Period("period")));
        DefaultTypeConverterTest.assertEquals((String)"period|12", (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)new Period("period|12")));
        DefaultTypeConverterTest.assertEquals(((Object)((Object)this)).getClass(), (Object)DefaultTypeConverter.INSTANCE.convert(Class.class, (Object)((Object)((Object)this)).getClass().getName()));
    }

    public void testFromString() {
        DefaultTypeConverterTest.assertEquals((Object)true, (Object)DefaultTypeConverter.INSTANCE.convert(Boolean.class, (Object)"True"));
        DefaultTypeConverterTest.assertEquals((Object)false, (Object)DefaultTypeConverter.INSTANCE.convert(Boolean.class, (Object)"woof"));
        DefaultTypeConverterTest.assertEquals((Object)Character.valueOf('w'), (Object)DefaultTypeConverter.INSTANCE.convert(Character.class, (Object)"w"));
        DefaultTypeConverterTest.assertEquals((Object)Byte.valueOf("3"), (Object)DefaultTypeConverter.INSTANCE.convert(Byte.class, (Object)"3"));
        DefaultTypeConverterTest.assertEquals((Object)Short.valueOf("4"), (Object)DefaultTypeConverter.INSTANCE.convert(Short.class, (Object)"4"));
        DefaultTypeConverterTest.assertEquals((Object)Integer.valueOf("5"), (Object)DefaultTypeConverter.INSTANCE.convert(Integer.class, (Object)"5"));
        DefaultTypeConverterTest.assertEquals((Object)Long.valueOf("6"), (Object)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)"6"));
        DefaultTypeConverterTest.assertEquals((Object)Float.valueOf("7.1"), (Object)DefaultTypeConverter.INSTANCE.convert(Float.class, (Object)"7.1"));
        DefaultTypeConverterTest.assertEquals((Object)Double.valueOf("123.123"), (Object)DefaultTypeConverter.INSTANCE.convert(Double.class, (Object)"123.123"));
        DefaultTypeConverterTest.assertEquals((Object)new BigInteger("1234567890123456789"), (Object)DefaultTypeConverter.INSTANCE.convert(BigInteger.class, (Object)"1234567890123456789"));
        DefaultTypeConverterTest.assertEquals((Object)new BigDecimal("12345678901234567890.12345678901234567890"), (Object)DefaultTypeConverter.INSTANCE.convert(BigDecimal.class, (Object)"12345678901234567890.12345678901234567890"));
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, 2004);
        cal.set(2, 3);
        cal.set(5, 12);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        String isoDate = ISO8601DateFormat.format((Date)cal.getTime());
        DefaultTypeConverterTest.assertEquals((String)isoDate, (String)ISO8601DateFormat.format((Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)isoDate)));
        DefaultTypeConverterTest.assertEquals((Object)new Duration("P25D"), (Object)DefaultTypeConverter.INSTANCE.convert(Duration.class, (Object)"P25D"));
        DefaultTypeConverterTest.assertEquals((String)"woof", (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)"woof"));
        MLText converted = DefaultTypeConverter.INSTANCE.convert(MLText.class, (Object)"woof");
        DefaultTypeConverterTest.assertEquals((String)"woof", (String)converted.getValue(Locale.getDefault()));
        DefaultTypeConverterTest.assertEquals((Object)Locale.FRANCE, (Object)DefaultTypeConverter.INSTANCE.convert(Locale.class, (Object)"fr_FR"));
        DefaultTypeConverterTest.assertEquals((Object)Locale.FRANCE, (Object)DefaultTypeConverter.INSTANCE.convert(Locale.class, (Object)"fr_FR_"));
        DefaultTypeConverterTest.assertEquals((Object)new VersionNumber("1.2.3"), (Object)DefaultTypeConverter.INSTANCE.convert(VersionNumber.class, (Object)"1.2.3"));
        DefaultTypeConverterTest.assertEquals((Object)new Period("period"), (Object)DefaultTypeConverter.INSTANCE.convert(Period.class, (Object)"period"));
        DefaultTypeConverterTest.assertEquals((Object)new Period("period|12"), (Object)DefaultTypeConverter.INSTANCE.convert(Period.class, (Object)"period|12"));
        DefaultTypeConverterTest.assertEquals((String)((Object)((Object)this)).getClass().getName(), (String)DefaultTypeConverter.INSTANCE.convert(String.class, ((Object)((Object)this)).getClass()));
    }

    public void testPrimativeAccessors() {
        DefaultTypeConverterTest.assertEquals((boolean)false, (boolean)DefaultTypeConverter.INSTANCE.convert(Boolean.class, (Object)false));
        DefaultTypeConverterTest.assertEquals((boolean)true, (boolean)DefaultTypeConverter.INSTANCE.convert(Boolean.class, (Object)true));
        DefaultTypeConverterTest.assertEquals((char)'a', (char)DefaultTypeConverter.INSTANCE.convert(Character.class, (Object)Character.valueOf('a')).charValue());
        DefaultTypeConverterTest.assertEquals((byte)3, (byte)DefaultTypeConverter.INSTANCE.convert(Byte.class, (Object)3));
        DefaultTypeConverterTest.assertEquals((short)4, (short)DefaultTypeConverter.INSTANCE.convert(Short.class, (Object)4));
        DefaultTypeConverterTest.assertEquals((int)5, (int)DefaultTypeConverter.INSTANCE.convert(Integer.class, (Object)5));
        DefaultTypeConverterTest.assertEquals((long)6L, (long)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)6L));
        DefaultTypeConverterTest.assertEquals((Object)Float.valueOf(7.1f), (Object)Float.valueOf(DefaultTypeConverter.INSTANCE.convert(Float.class, (Object)Float.valueOf(7.1f)).floatValue()));
        DefaultTypeConverterTest.assertEquals((Object)123.123, (Object)DefaultTypeConverter.INSTANCE.convert(Double.class, (Object)123.123));
    }

    public void testInterConversions() {
        DefaultTypeConverterTest.assertEquals((Object)Byte.valueOf("1"), (Object)DefaultTypeConverter.INSTANCE.convert(Byte.class, (Object)Byte.valueOf("1")));
        DefaultTypeConverterTest.assertEquals((Object)Short.valueOf("2"), (Object)DefaultTypeConverter.INSTANCE.convert(Short.class, (Object)Byte.valueOf("2")));
        DefaultTypeConverterTest.assertEquals((Object)Integer.valueOf("3"), (Object)DefaultTypeConverter.INSTANCE.convert(Integer.class, (Object)Byte.valueOf("3")));
        DefaultTypeConverterTest.assertEquals((Object)Long.valueOf("4"), (Object)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)Byte.valueOf("4")));
        DefaultTypeConverterTest.assertEquals((Object)Float.valueOf("5"), (Object)DefaultTypeConverter.INSTANCE.convert(Float.class, (Object)Byte.valueOf("5")));
        DefaultTypeConverterTest.assertEquals((Object)Double.valueOf("6"), (Object)DefaultTypeConverter.INSTANCE.convert(Double.class, (Object)Byte.valueOf("6")));
        DefaultTypeConverterTest.assertEquals((Object)new BigInteger("7"), (Object)DefaultTypeConverter.INSTANCE.convert(BigInteger.class, (Object)Byte.valueOf("7")));
        DefaultTypeConverterTest.assertEquals((Object)new BigDecimal("8"), (Object)DefaultTypeConverter.INSTANCE.convert(BigDecimal.class, (Object)Byte.valueOf("8")));
        DefaultTypeConverterTest.assertEquals((Object)Byte.valueOf("1"), (Object)DefaultTypeConverter.INSTANCE.convert(Byte.class, (Object)Short.valueOf("1")));
        DefaultTypeConverterTest.assertEquals((Object)Short.valueOf("2"), (Object)DefaultTypeConverter.INSTANCE.convert(Short.class, (Object)Short.valueOf("2")));
        DefaultTypeConverterTest.assertEquals((Object)Integer.valueOf("3"), (Object)DefaultTypeConverter.INSTANCE.convert(Integer.class, (Object)Short.valueOf("3")));
        DefaultTypeConverterTest.assertEquals((Object)Long.valueOf("4"), (Object)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)Short.valueOf("4")));
        DefaultTypeConverterTest.assertEquals((Object)Float.valueOf("5"), (Object)DefaultTypeConverter.INSTANCE.convert(Float.class, (Object)Short.valueOf("5")));
        DefaultTypeConverterTest.assertEquals((Object)Double.valueOf("6"), (Object)DefaultTypeConverter.INSTANCE.convert(Double.class, (Object)Short.valueOf("6")));
        DefaultTypeConverterTest.assertEquals((Object)new BigInteger("7"), (Object)DefaultTypeConverter.INSTANCE.convert(BigInteger.class, (Object)Short.valueOf("7")));
        DefaultTypeConverterTest.assertEquals((Object)new BigDecimal("8"), (Object)DefaultTypeConverter.INSTANCE.convert(BigDecimal.class, (Object)Short.valueOf("8")));
        DefaultTypeConverterTest.assertEquals((Object)Byte.valueOf("1"), (Object)DefaultTypeConverter.INSTANCE.convert(Byte.class, (Object)Integer.valueOf("1")));
        DefaultTypeConverterTest.assertEquals((Object)Short.valueOf("2"), (Object)DefaultTypeConverter.INSTANCE.convert(Short.class, (Object)Integer.valueOf("2")));
        DefaultTypeConverterTest.assertEquals((Object)Integer.valueOf("3"), (Object)DefaultTypeConverter.INSTANCE.convert(Integer.class, (Object)Integer.valueOf("3")));
        DefaultTypeConverterTest.assertEquals((Object)Long.valueOf("4"), (Object)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)Integer.valueOf("4")));
        DefaultTypeConverterTest.assertEquals((Object)Float.valueOf("5"), (Object)DefaultTypeConverter.INSTANCE.convert(Float.class, (Object)Integer.valueOf("5")));
        DefaultTypeConverterTest.assertEquals((Object)Double.valueOf("6"), (Object)DefaultTypeConverter.INSTANCE.convert(Double.class, (Object)Integer.valueOf("6")));
        DefaultTypeConverterTest.assertEquals((Object)new BigInteger("7"), (Object)DefaultTypeConverter.INSTANCE.convert(BigInteger.class, (Object)Integer.valueOf("7")));
        DefaultTypeConverterTest.assertEquals((Object)new BigDecimal("8"), (Object)DefaultTypeConverter.INSTANCE.convert(BigDecimal.class, (Object)Integer.valueOf("8")));
        DefaultTypeConverterTest.assertEquals((Object)Boolean.TRUE, (Object)DefaultTypeConverter.INSTANCE.convert(Boolean.class, (Object)Long.valueOf("1")));
        DefaultTypeConverterTest.assertEquals((Object)Boolean.FALSE, (Object)DefaultTypeConverter.INSTANCE.convert(Boolean.class, (Object)Long.valueOf("0")));
        DefaultTypeConverterTest.assertEquals((Object)Byte.valueOf("1"), (Object)DefaultTypeConverter.INSTANCE.convert(Byte.class, (Object)Long.valueOf("1")));
        DefaultTypeConverterTest.assertEquals((Object)Short.valueOf("2"), (Object)DefaultTypeConverter.INSTANCE.convert(Short.class, (Object)Long.valueOf("2")));
        DefaultTypeConverterTest.assertEquals((Object)Integer.valueOf("3"), (Object)DefaultTypeConverter.INSTANCE.convert(Integer.class, (Object)Long.valueOf("3")));
        DefaultTypeConverterTest.assertEquals((Object)Long.valueOf("4"), (Object)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)Long.valueOf("4")));
        DefaultTypeConverterTest.assertEquals((Object)Float.valueOf("5"), (Object)DefaultTypeConverter.INSTANCE.convert(Float.class, (Object)Long.valueOf("5")));
        DefaultTypeConverterTest.assertEquals((Object)Double.valueOf("6"), (Object)DefaultTypeConverter.INSTANCE.convert(Double.class, (Object)Long.valueOf("6")));
        DefaultTypeConverterTest.assertEquals((Object)new BigInteger("7"), (Object)DefaultTypeConverter.INSTANCE.convert(BigInteger.class, (Object)Long.valueOf("7")));
        DefaultTypeConverterTest.assertEquals((Object)new BigDecimal("8"), (Object)DefaultTypeConverter.INSTANCE.convert(BigDecimal.class, (Object)Long.valueOf("8")));
        DefaultTypeConverterTest.assertEquals((Object)Byte.valueOf("1"), (Object)DefaultTypeConverter.INSTANCE.convert(Byte.class, (Object)Float.valueOf("1")));
        DefaultTypeConverterTest.assertEquals((Object)Short.valueOf("2"), (Object)DefaultTypeConverter.INSTANCE.convert(Short.class, (Object)Float.valueOf("2")));
        DefaultTypeConverterTest.assertEquals((Object)Integer.valueOf("3"), (Object)DefaultTypeConverter.INSTANCE.convert(Integer.class, (Object)Float.valueOf("3")));
        DefaultTypeConverterTest.assertEquals((Object)Long.valueOf("4"), (Object)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)Float.valueOf("4")));
        DefaultTypeConverterTest.assertEquals((Object)Float.valueOf("5"), (Object)DefaultTypeConverter.INSTANCE.convert(Float.class, (Object)Float.valueOf("5")));
        DefaultTypeConverterTest.assertEquals((Object)Double.valueOf("6"), (Object)DefaultTypeConverter.INSTANCE.convert(Double.class, (Object)Float.valueOf("6")));
        DefaultTypeConverterTest.assertEquals((Object)new BigInteger("7"), (Object)DefaultTypeConverter.INSTANCE.convert(BigInteger.class, (Object)Float.valueOf("7")));
        DefaultTypeConverterTest.assertEquals((Object)new BigDecimal("8"), (Object)DefaultTypeConverter.INSTANCE.convert(BigDecimal.class, (Object)Float.valueOf("8")));
        DefaultTypeConverterTest.assertEquals((Object)Byte.valueOf("1"), (Object)DefaultTypeConverter.INSTANCE.convert(Byte.class, (Object)Double.valueOf("1")));
        DefaultTypeConverterTest.assertEquals((Object)Short.valueOf("2"), (Object)DefaultTypeConverter.INSTANCE.convert(Short.class, (Object)Double.valueOf("2")));
        DefaultTypeConverterTest.assertEquals((Object)Integer.valueOf("3"), (Object)DefaultTypeConverter.INSTANCE.convert(Integer.class, (Object)Double.valueOf("3")));
        DefaultTypeConverterTest.assertEquals((Object)Long.valueOf("4"), (Object)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)Double.valueOf("4")));
        DefaultTypeConverterTest.assertEquals((Object)Float.valueOf("5"), (Object)DefaultTypeConverter.INSTANCE.convert(Float.class, (Object)Double.valueOf("5")));
        DefaultTypeConverterTest.assertEquals((Object)Double.valueOf("6"), (Object)DefaultTypeConverter.INSTANCE.convert(Double.class, (Object)Double.valueOf("6")));
        DefaultTypeConverterTest.assertEquals((Object)new BigInteger("7"), (Object)DefaultTypeConverter.INSTANCE.convert(BigInteger.class, (Object)Double.valueOf("7")));
        DefaultTypeConverterTest.assertEquals((Object)new BigDecimal("8"), (Object)DefaultTypeConverter.INSTANCE.convert(BigDecimal.class, (Object)Double.valueOf("8")));
        DefaultTypeConverterTest.assertEquals((Object)Byte.valueOf("1"), (Object)DefaultTypeConverter.INSTANCE.convert(Byte.class, (Object)new BigInteger("1")));
        DefaultTypeConverterTest.assertEquals((Object)Short.valueOf("2"), (Object)DefaultTypeConverter.INSTANCE.convert(Short.class, (Object)new BigInteger("2")));
        DefaultTypeConverterTest.assertEquals((Object)Integer.valueOf("3"), (Object)DefaultTypeConverter.INSTANCE.convert(Integer.class, (Object)new BigInteger("3")));
        DefaultTypeConverterTest.assertEquals((Object)Long.valueOf("4"), (Object)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)new BigInteger("4")));
        DefaultTypeConverterTest.assertEquals((Object)Float.valueOf("5"), (Object)DefaultTypeConverter.INSTANCE.convert(Float.class, (Object)new BigInteger("5")));
        DefaultTypeConverterTest.assertEquals((Object)Double.valueOf("6"), (Object)DefaultTypeConverter.INSTANCE.convert(Double.class, (Object)new BigInteger("6")));
        DefaultTypeConverterTest.assertEquals((Object)new BigInteger("7"), (Object)DefaultTypeConverter.INSTANCE.convert(BigInteger.class, (Object)new BigInteger("7")));
        DefaultTypeConverterTest.assertEquals((Object)new BigDecimal("8"), (Object)DefaultTypeConverter.INSTANCE.convert(BigDecimal.class, (Object)new BigInteger("8")));
        DefaultTypeConverterTest.assertEquals((Object)Byte.valueOf("1"), (Object)DefaultTypeConverter.INSTANCE.convert(Byte.class, (Object)new BigDecimal("1")));
        DefaultTypeConverterTest.assertEquals((Object)Short.valueOf("2"), (Object)DefaultTypeConverter.INSTANCE.convert(Short.class, (Object)new BigDecimal("2")));
        DefaultTypeConverterTest.assertEquals((Object)Integer.valueOf("3"), (Object)DefaultTypeConverter.INSTANCE.convert(Integer.class, (Object)new BigDecimal("3")));
        DefaultTypeConverterTest.assertEquals((Object)Long.valueOf("4"), (Object)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)new BigDecimal("4")));
        DefaultTypeConverterTest.assertEquals((Object)Float.valueOf("5"), (Object)DefaultTypeConverter.INSTANCE.convert(Float.class, (Object)new BigDecimal("5")));
        DefaultTypeConverterTest.assertEquals((Object)Double.valueOf("6"), (Object)DefaultTypeConverter.INSTANCE.convert(Double.class, (Object)new BigDecimal("6")));
        DefaultTypeConverterTest.assertEquals((Object)new BigInteger("7"), (Object)DefaultTypeConverter.INSTANCE.convert(BigInteger.class, (Object)new BigDecimal("7")));
        DefaultTypeConverterTest.assertEquals((Object)new BigDecimal("8"), (Object)DefaultTypeConverter.INSTANCE.convert(BigDecimal.class, (Object)new BigDecimal("8")));
    }

    public void testDate() {
        Date date = new Date(101L);
        DefaultTypeConverterTest.assertEquals((Object)Byte.valueOf("101"), (Object)DefaultTypeConverter.INSTANCE.convert(Byte.class, (Object)date));
        DefaultTypeConverterTest.assertEquals((Object)Short.valueOf("101"), (Object)DefaultTypeConverter.INSTANCE.convert(Short.class, (Object)date));
        DefaultTypeConverterTest.assertEquals((Object)Integer.valueOf("101"), (Object)DefaultTypeConverter.INSTANCE.convert(Integer.class, (Object)date));
        DefaultTypeConverterTest.assertEquals((Object)Long.valueOf("101"), (Object)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)date));
        DefaultTypeConverterTest.assertEquals((Object)Float.valueOf("101"), (Object)DefaultTypeConverter.INSTANCE.convert(Float.class, (Object)date));
        DefaultTypeConverterTest.assertEquals((Object)Double.valueOf("101"), (Object)DefaultTypeConverter.INSTANCE.convert(Double.class, (Object)date));
        DefaultTypeConverterTest.assertEquals((Object)new BigInteger("101"), (Object)DefaultTypeConverter.INSTANCE.convert(BigInteger.class, (Object)date));
        DefaultTypeConverterTest.assertEquals((Object)new BigDecimal("101"), (Object)DefaultTypeConverter.INSTANCE.convert(BigDecimal.class, (Object)date));
        DefaultTypeConverterTest.assertEquals((Object)date, (Object)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)101));
        DefaultTypeConverterTest.assertEquals((Object)date, (Object)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)101));
        DefaultTypeConverterTest.assertEquals((Object)date, (Object)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)101));
        DefaultTypeConverterTest.assertEquals((Object)date, (Object)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)101L));
        DefaultTypeConverterTest.assertEquals((Object)date, (Object)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)Float.valueOf(101.0f)));
        DefaultTypeConverterTest.assertEquals((Object)date, (Object)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)101.0));
        DefaultTypeConverterTest.assertEquals((Object)date, (Object)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)new BigInteger("101")));
        DefaultTypeConverterTest.assertEquals((Object)date, (Object)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)new BigDecimal("101")));
        DefaultTypeConverterTest.assertEquals((int)101, (int)DefaultTypeConverter.INSTANCE.intValue(date));
    }

    public void testMultiValue() {
        ArrayList<Object> list = this.makeList();
        DefaultTypeConverterTest.assertEquals((boolean)true, (boolean)DefaultTypeConverter.INSTANCE.isMultiValued(list));
        DefaultTypeConverterTest.assertEquals((int)14, (int)DefaultTypeConverter.INSTANCE.size(list));
        for (String stringValue : DefaultTypeConverter.INSTANCE.getCollection(String.class, list)) {
            System.out.println("Value is " + stringValue);
        }
    }

    private ArrayList<Object> makeList() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(true);
        list.add(false);
        list.add(Character.valueOf('q'));
        list.add(Byte.valueOf("1"));
        list.add(Short.valueOf("2"));
        list.add(Integer.valueOf("3"));
        list.add(Long.valueOf("4"));
        list.add(Float.valueOf("5"));
        list.add(Double.valueOf("6"));
        list.add(new BigInteger("7"));
        list.add(new BigDecimal("8"));
        list.add(new Date());
        list.add(new Duration("P5Y0M"));
        list.add("Hello mum");
        return list;
    }

    public void testSingleValuseAsMultiValue() {
        Integer integer = 43;
        DefaultTypeConverterTest.assertEquals((boolean)false, (boolean)DefaultTypeConverter.INSTANCE.isMultiValued(integer));
        DefaultTypeConverterTest.assertEquals((int)1, (int)DefaultTypeConverter.INSTANCE.size(integer));
        for (String stringValue : DefaultTypeConverter.INSTANCE.getCollection(String.class, integer)) {
            System.out.println("Value is " + stringValue);
        }
    }

    public void testNullAndEmpty() {
        DefaultTypeConverterTest.assertNull(DefaultTypeConverter.INSTANCE.convert(Boolean.class, null));
        ArrayList<Object> list = new ArrayList<Object>();
        DefaultTypeConverterTest.assertNotNull(DefaultTypeConverter.INSTANCE.convert(Boolean.class, list));
        list.add(null);
        DefaultTypeConverterTest.assertNotNull(DefaultTypeConverter.INSTANCE.convert(Boolean.class, list));
    }
}

