/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.config;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigDeployer;
import org.springframework.extensions.config.ConfigDeployment;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.ConfigImpl;
import org.springframework.extensions.config.ConfigLookupContext;
import org.springframework.extensions.config.ConfigSection;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.config.ConfigSource;
import org.springframework.extensions.config.evaluator.Evaluator;
import org.springframework.extensions.config.evaluator.ObjectTypeEvaluator;
import org.springframework.extensions.config.evaluator.StringEvaluator;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseConfigService
extends AbstractLifecycleBean
implements ConfigService {
    private static final Log logger = LogFactory.getLog(BaseConfigService.class);
    protected ConfigSource configSource;
    private ConfigImpl globalConfig;
    private Map<String, Evaluator> evaluators;
    private Map<String, List<ConfigSection>> sectionsByArea;
    private List<ConfigSection> sections;
    private boolean isInited = false;
    protected Map<String, ConfigDeployer> configDeployers = new TreeMap<String, ConfigDeployer>();

    public BaseConfigService(ConfigSource configSource) {
        if (configSource == null) {
            throw new IllegalArgumentException("The config source is mandatory");
        }
        this.configSource = configSource;
    }

    public void init() {
        this.initConfig();
        this.isInited = true;
    }

    public List<ConfigDeployment> initConfig() {
        this.putSections(new ArrayList<ConfigSection>());
        this.putSectionsByArea(new HashMap<String, List<ConfigSection>>());
        this.putEvaluators(new HashMap<String, Evaluator>());
        this.putGlobalConfig(new ConfigImpl());
        String stringCompare = "string-compare";
        this.addEvaluator(stringCompare, this.createEvaluator(stringCompare, StringEvaluator.class.getName()));
        String objectType = "object-type";
        this.addEvaluator(objectType, this.createEvaluator(objectType, ObjectTypeEvaluator.class.getName()));
        ConfigDeployment builtin = new ConfigDeployment("<Built-in evaluators>", null);
        builtin.setDeploymentStatus("OK");
        ArrayList<ConfigDeployment> builtins = new ArrayList<ConfigDeployment>();
        builtins.add(builtin);
        return builtins;
    }

    public void destroy() {
        this.removeSections();
        this.removeSectionsByArea();
        this.removeEvaluators();
        this.removeGlobalConfig();
        this.isInited = false;
    }

    @Override
    public void reset() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Resetting config service");
        }
        this.destroy();
        this.initConfig();
    }

    @Override
    public void addDeployer(ConfigDeployer configDeployer) {
        if (!this.configDeployers.containsKey(configDeployer.getSortKey())) {
            this.configDeployers.put(configDeployer.getSortKey(), configDeployer);
        }
    }

    @Override
    public Config getConfig(Object object) {
        return this.getConfig(object, new ConfigLookupContext());
    }

    @Override
    public Config getConfig(Object object, ConfigLookupContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieving configuration for '" + object + "'"));
        }
        ConfigImpl results = null;
        if (context.includeGlobalSection()) {
            results = new ConfigImpl(this.getGlobalConfigImpl());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Created initial config results using global section");
            }
        } else {
            results = new ConfigImpl();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Created initial config results ignoring the global section");
            }
        }
        if (context.getAreas().size() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Restricting search within following areas: " + context.getAreas()));
            }
            Map<String, List<ConfigSection>> sectionsByArea = this.getSectionsByArea();
            for (String area : context.getAreas()) {
                List<ConfigSection> areaSections = sectionsByArea.get(area);
                if (areaSections == null) {
                    throw new ConfigException("Requested area '" + area + "' has not been defined");
                }
                for (ConfigSection section : areaSections) {
                    this.processSection(section, object, context, results);
                }
            }
        } else {
            for (ConfigSection section : this.getSections()) {
                this.processSection(section, object, context, results);
            }
        }
        return results;
    }

    @Override
    public Config getGlobalConfig() {
        return this.getGlobalConfigImpl();
    }

    @Override
    public List<ConfigDeployment> appendConfig(ConfigSource configSource) {
        List<ConfigDeployment> configDeployments = configSource.getConfigDeployments();
        for (ConfigDeployment configDeployment : configDeployments) {
            if (configDeployment.getStream() != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Commencing parse of input stream for source: " + configDeployment.getName()));
                }
                try {
                    this.parse(configDeployment.getStream());
                    configDeployment.setDeploymentStatus("OK");
                }
                catch (Throwable t) {
                    logger.error((Object)("Input stream invalid - skipped for source: " + configDeployment.getName() + "' "), t);
                    StringWriter stringWriter = new StringWriter();
                    t.printStackTrace(new PrintWriter(stringWriter));
                    configDeployment.setDeploymentStatus("Skipped - invalid: " + stringWriter.toString());
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Completed parse of input stream for source: " + configDeployment.getName()));
                continue;
            }
            logger.debug((Object)("Input stream not available - skipped for source: " + configDeployment.getName()));
            configDeployment.setDeploymentStatus("Skipped - not available");
        }
        return configDeployments;
    }

    protected List<ConfigDeployment> parse() {
        return this.appendConfig(this.configSource);
    }

    protected abstract void parse(InputStream var1);

    protected void addConfigSection(ConfigSection section, String area) {
        if (section.isGlobal()) {
            ConfigImpl globalConfig = this.getGlobalConfigImpl();
            for (ConfigElement ce : section.getConfigElements()) {
                ConfigElement existing = globalConfig.getConfigElement(ce.getName());
                if (existing != null) {
                    if (section.isReplace()) {
                        globalConfig.putConfigElement(ce);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Replaced " + existing + " with " + ce));
                        continue;
                    }
                    ConfigElement combined = existing.combine(ce);
                    globalConfig.putConfigElement(combined);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Combined " + existing + " with " + ce + " to create " + combined));
                    continue;
                }
                globalConfig.putConfigElement(ce);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Added config elements from " + section + " to the global section"));
            }
        } else if (area != null && area.length() > 0) {
            Map<String, List<ConfigSection>> sectionsByArea = this.getSectionsByArea();
            List<ConfigSection> areaSections = sectionsByArea.get(area);
            if (areaSections == null) {
                areaSections = new ArrayList<ConfigSection>();
                sectionsByArea.put(area, areaSections);
            }
            areaSections.add(section);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Added " + section + " to the '" + area + "' area"));
            }
        } else {
            this.getSections().add(section);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Added " + section + " to the sections list"));
            }
        }
    }

    protected Evaluator getEvaluator(String name) {
        return this.getEvaluators().get(name);
    }

    protected void addEvaluator(String name, Evaluator evaluator) {
        this.getEvaluators().put(name, evaluator);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added evaluator '" + name + "': " + evaluator.getClass().getName()));
        }
    }

    protected Evaluator createEvaluator(String name, String className) {
        Evaluator evaluator = null;
        try {
            Class<?> clazz = Class.forName(className);
            evaluator = (Evaluator)clazz.newInstance();
        }
        catch (Throwable e) {
            throw new ConfigException("Could not instantiate evaluator for '" + name + "' with class: " + className, e);
        }
        return evaluator;
    }

    protected void processSection(ConfigSection section, Object object, ConfigLookupContext context, ConfigImpl results) {
        String evaluatorName = section.getEvaluator();
        Evaluator evaluator = this.getEvaluator(evaluatorName);
        if (evaluator == null) {
            throw new ConfigException("Unable to locate evaluator implementation for '" + evaluatorName + "' for " + section);
        }
        context.getAlgorithm().process(section, evaluator, object, results);
    }

    protected ConfigImpl getGlobalConfigImpl() {
        return this.globalConfig;
    }

    protected void putGlobalConfig(ConfigImpl globalConfig) {
        this.globalConfig = globalConfig;
    }

    protected void removeGlobalConfig() {
        this.globalConfig = null;
    }

    protected Map<String, Evaluator> getEvaluators() {
        return this.evaluators;
    }

    protected void putEvaluators(Map<String, Evaluator> evaluators) {
        this.evaluators = evaluators;
    }

    protected void removeEvaluators() {
        this.evaluators.clear();
        this.evaluators = null;
    }

    protected Map<String, List<ConfigSection>> getSectionsByArea() {
        return this.sectionsByArea;
    }

    protected void putSectionsByArea(Map<String, List<ConfigSection>> sectionsByArea) {
        this.sectionsByArea = sectionsByArea;
    }

    protected void removeSectionsByArea() {
        this.sectionsByArea.clear();
        this.sectionsByArea = null;
    }

    protected List<ConfigSection> getSections() {
        return this.sections;
    }

    protected void putSections(List<ConfigSection> sections) {
        this.sections = sections;
    }

    protected void removeSections() {
        this.sections.clear();
        this.sections = null;
    }

    protected void onBootstrap(ApplicationEvent event) {
        if (!this.isInited) {
            this.initConfig();
        }
    }

    protected void onShutdown(ApplicationEvent event) {
        this.destroy();
    }
}

