/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.config;

import java.util.ArrayList;
import java.util.List;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.ConfigSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigSectionImpl
implements ConfigSection {
    private String evaluator;
    private String condition;
    private boolean replace = false;
    private List<ConfigElement> configElements;

    public ConfigSectionImpl(String evaluator, String condition, boolean replace) {
        this.evaluator = evaluator;
        this.condition = condition;
        this.replace = replace;
        this.configElements = new ArrayList<ConfigElement>();
        if (this.evaluator != null && this.evaluator.length() == 0) {
            throw new ConfigException("The 'evaluator' attribute must have a value if it is present");
        }
        if (this.condition != null && this.condition.length() == 0) {
            throw new ConfigException("The 'condition' attribute must have a value if it is present");
        }
    }

    @Override
    public String getEvaluator() {
        return this.evaluator;
    }

    @Override
    public String getCondition() {
        return this.condition;
    }

    @Override
    public List<ConfigElement> getConfigElements() {
        return this.configElements;
    }

    public void addConfigElement(ConfigElement configElement) {
        this.configElements.add(configElement);
    }

    @Override
    public boolean isGlobal() {
        boolean global = false;
        if (this.evaluator == null && this.condition == null) {
            global = true;
        }
        return global;
    }

    @Override
    public boolean isReplace() {
        return this.replace;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(super.toString());
        buffer.append(" (evaluator=").append(this.evaluator);
        buffer.append(" condition=").append(this.condition);
        buffer.append(" replace=").append(this.replace).append(")");
        return buffer.toString();
    }
}

