/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.ibatis;

import com.ibatis.common.resources.Resources;
import com.ibatis.common.xml.Nodelet;
import com.ibatis.common.xml.NodeletParser;
import com.ibatis.common.xml.NodeletUtils;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.builder.xml.SqlMapClasspathEntityResolver;
import com.ibatis.sqlmap.engine.builder.xml.SqlMapParser;
import com.ibatis.sqlmap.engine.builder.xml.XmlParserState;
import com.ibatis.sqlmap.engine.config.SqlMapConfiguration;
import com.ibatis.sqlmap.engine.datasource.DataSourceFactory;
import com.ibatis.sqlmap.engine.mapping.result.ResultObjectFactory;
import com.ibatis.sqlmap.engine.transaction.TransactionConfig;
import com.ibatis.sqlmap.engine.transaction.TransactionManager;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.alfresco.util.resource.HierarchicalResourceLoader;
import org.springframework.core.io.Resource;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;

public class HierarchicalSqlMapConfigParser {
    private final HierarchicalResourceLoader resourceLoader;
    protected final NodeletParser parser = new NodeletParser();
    protected XmlParserState state = new XmlParserState();

    public HierarchicalSqlMapConfigParser(HierarchicalResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        this.parser.setValidation(true);
        this.parser.setEntityResolver((EntityResolver)new SqlMapClasspathEntityResolver());
        this.addSqlMapConfigNodelets();
        this.addGlobalPropNodelets();
        this.addSettingsNodelets();
        this.addTypeAliasNodelets();
        this.addTypeHandlerNodelets();
        this.addTransactionManagerNodelets();
        this.addSqlMapNodelets();
        this.addResultObjectFactoryNodelets();
    }

    public SqlMapClient parse(InputStream inputStream, Properties props) {
        if (props != null) {
            this.state.setGlobalProps(props);
        }
        return this.parse(inputStream);
    }

    public SqlMapClient parse(InputStream inputStream) {
        try {
            this.parser.parse(inputStream);
            return this.state.getConfig().getClient();
        }
        catch (Exception e) {
            throw new RuntimeException("Error occurred.  Cause: " + e, e);
        }
    }

    private void addSqlMapConfigNodelets() {
        this.parser.addNodelet("/sqlMapConfig/end()", new Nodelet(){

            public void process(Node node) throws Exception {
                HierarchicalSqlMapConfigParser.this.state.getConfig().finalizeSqlMapConfig();
            }
        });
    }

    private void addGlobalPropNodelets() {
        this.parser.addNodelet("/sqlMapConfig/properties", new Nodelet(){

            public void process(Node node) throws Exception {
                Properties attributes = NodeletUtils.parseAttributes((Node)node, (Properties)HierarchicalSqlMapConfigParser.this.state.getGlobalProps());
                String resource = attributes.getProperty("resource");
                String url = attributes.getProperty("url");
                HierarchicalSqlMapConfigParser.this.state.setGlobalProperties(resource, url);
            }
        });
    }

    private void addSettingsNodelets() {
        this.parser.addNodelet("/sqlMapConfig/settings", new Nodelet(){

            public void process(Node node) throws Exception {
                Properties attributes = NodeletUtils.parseAttributes((Node)node, (Properties)HierarchicalSqlMapConfigParser.this.state.getGlobalProps());
                SqlMapConfiguration config = HierarchicalSqlMapConfigParser.this.state.getConfig();
                String classInfoCacheEnabledAttr = attributes.getProperty("classInfoCacheEnabled");
                boolean classInfoCacheEnabled = classInfoCacheEnabledAttr == null || "true".equals(classInfoCacheEnabledAttr);
                config.setClassInfoCacheEnabled(classInfoCacheEnabled);
                String lazyLoadingEnabledAttr = attributes.getProperty("lazyLoadingEnabled");
                boolean lazyLoadingEnabled = lazyLoadingEnabledAttr == null || "true".equals(lazyLoadingEnabledAttr);
                config.setLazyLoadingEnabled(lazyLoadingEnabled);
                String statementCachingEnabledAttr = attributes.getProperty("statementCachingEnabled");
                boolean statementCachingEnabled = statementCachingEnabledAttr == null || "true".equals(statementCachingEnabledAttr);
                config.setStatementCachingEnabled(statementCachingEnabled);
                String cacheModelsEnabledAttr = attributes.getProperty("cacheModelsEnabled");
                boolean cacheModelsEnabled = cacheModelsEnabledAttr == null || "true".equals(cacheModelsEnabledAttr);
                config.setCacheModelsEnabled(cacheModelsEnabled);
                String enhancementEnabledAttr = attributes.getProperty("enhancementEnabled");
                boolean enhancementEnabled = enhancementEnabledAttr == null || "true".equals(enhancementEnabledAttr);
                config.setEnhancementEnabled(enhancementEnabled);
                String useColumnLabelAttr = attributes.getProperty("useColumnLabel");
                boolean useColumnLabel = useColumnLabelAttr == null || "true".equals(useColumnLabelAttr);
                config.setUseColumnLabel(useColumnLabel);
                String forceMultipleResultSetSupportAttr = attributes.getProperty("forceMultipleResultSetSupport");
                boolean forceMultipleResultSetSupport = "true".equals(forceMultipleResultSetSupportAttr);
                config.setForceMultipleResultSetSupport(forceMultipleResultSetSupport);
                String defaultTimeoutAttr = attributes.getProperty("defaultStatementTimeout");
                Integer defaultTimeout = defaultTimeoutAttr == null ? null : Integer.valueOf(defaultTimeoutAttr);
                config.setDefaultStatementTimeout(defaultTimeout);
                String useStatementNamespacesAttr = attributes.getProperty("useStatementNamespaces");
                boolean useStatementNamespaces = "true".equals(useStatementNamespacesAttr);
                HierarchicalSqlMapConfigParser.this.state.setUseStatementNamespaces(useStatementNamespaces);
            }
        });
    }

    private void addTypeAliasNodelets() {
        this.parser.addNodelet("/sqlMapConfig/typeAlias", new Nodelet(){

            public void process(Node node) throws Exception {
                Properties prop = NodeletUtils.parseAttributes((Node)node, (Properties)HierarchicalSqlMapConfigParser.this.state.getGlobalProps());
                String alias = prop.getProperty("alias");
                String type = prop.getProperty("type");
                HierarchicalSqlMapConfigParser.this.state.getConfig().getTypeHandlerFactory().putTypeAlias(alias, type);
            }
        });
    }

    private void addTypeHandlerNodelets() {
        this.parser.addNodelet("/sqlMapConfig/typeHandler", new Nodelet(){

            public void process(Node node) throws Exception {
                Properties prop = NodeletUtils.parseAttributes((Node)node, (Properties)HierarchicalSqlMapConfigParser.this.state.getGlobalProps());
                String jdbcType = prop.getProperty("jdbcType");
                String javaType = prop.getProperty("javaType");
                String callback = prop.getProperty("callback");
                javaType = HierarchicalSqlMapConfigParser.this.state.getConfig().getTypeHandlerFactory().resolveAlias(javaType);
                callback = HierarchicalSqlMapConfigParser.this.state.getConfig().getTypeHandlerFactory().resolveAlias(callback);
                HierarchicalSqlMapConfigParser.this.state.getConfig().newTypeHandler(Resources.classForName((String)javaType), jdbcType, Resources.instantiate((String)callback));
            }
        });
    }

    private void addTransactionManagerNodelets() {
        this.parser.addNodelet("/sqlMapConfig/transactionManager/property", new Nodelet(){

            public void process(Node node) throws Exception {
                Properties attributes = NodeletUtils.parseAttributes((Node)node, (Properties)HierarchicalSqlMapConfigParser.this.state.getGlobalProps());
                String name = attributes.getProperty("name");
                String value = NodeletUtils.parsePropertyTokens((String)attributes.getProperty("value"), (Properties)HierarchicalSqlMapConfigParser.this.state.getGlobalProps());
                HierarchicalSqlMapConfigParser.this.state.getTxProps().setProperty(name, value);
            }
        });
        this.parser.addNodelet("/sqlMapConfig/transactionManager/end()", new Nodelet(){

            public void process(Node node) throws Exception {
                TransactionManager txManager;
                Properties attributes = NodeletUtils.parseAttributes((Node)node, (Properties)HierarchicalSqlMapConfigParser.this.state.getGlobalProps());
                String type = attributes.getProperty("type");
                boolean commitRequired = "true".equals(attributes.getProperty("commitRequired"));
                HierarchicalSqlMapConfigParser.this.state.getConfig().getErrorContext().setActivity("configuring the transaction manager");
                type = HierarchicalSqlMapConfigParser.this.state.getConfig().getTypeHandlerFactory().resolveAlias(type);
                try {
                    HierarchicalSqlMapConfigParser.this.state.getConfig().getErrorContext().setMoreInfo("Check the transaction manager type or class.");
                    TransactionConfig config = (TransactionConfig)Resources.instantiate((String)type);
                    config.setDataSource(HierarchicalSqlMapConfigParser.this.state.getDataSource());
                    HierarchicalSqlMapConfigParser.this.state.getConfig().getErrorContext().setMoreInfo("Check the transactio nmanager properties or configuration.");
                    config.setProperties(HierarchicalSqlMapConfigParser.this.state.getTxProps());
                    config.setForceCommit(commitRequired);
                    config.setDataSource(HierarchicalSqlMapConfigParser.this.state.getDataSource());
                    HierarchicalSqlMapConfigParser.this.state.getConfig().getErrorContext().setMoreInfo(null);
                    txManager = new TransactionManager(config);
                }
                catch (Exception e) {
                    if (e instanceof SqlMapException) {
                        throw (SqlMapException)((Object)e);
                    }
                    throw new SqlMapException("Error initializing TransactionManager.  Could not instantiate TransactionConfig.  Cause: " + e, (Throwable)e);
                }
                HierarchicalSqlMapConfigParser.this.state.getConfig().setTransactionManager(txManager);
            }
        });
        this.parser.addNodelet("/sqlMapConfig/transactionManager/dataSource/property", new Nodelet(){

            public void process(Node node) throws Exception {
                Properties attributes = NodeletUtils.parseAttributes((Node)node, (Properties)HierarchicalSqlMapConfigParser.this.state.getGlobalProps());
                String name = attributes.getProperty("name");
                String value = NodeletUtils.parsePropertyTokens((String)attributes.getProperty("value"), (Properties)HierarchicalSqlMapConfigParser.this.state.getGlobalProps());
                HierarchicalSqlMapConfigParser.this.state.getDsProps().setProperty(name, value);
            }
        });
        this.parser.addNodelet("/sqlMapConfig/transactionManager/dataSource/end()", new Nodelet(){

            public void process(Node node) throws Exception {
                HierarchicalSqlMapConfigParser.this.state.getConfig().getErrorContext().setActivity("configuring the data source");
                Properties attributes = NodeletUtils.parseAttributes((Node)node, (Properties)HierarchicalSqlMapConfigParser.this.state.getGlobalProps());
                String type = attributes.getProperty("type");
                Properties props = HierarchicalSqlMapConfigParser.this.state.getDsProps();
                type = HierarchicalSqlMapConfigParser.this.state.getConfig().getTypeHandlerFactory().resolveAlias(type);
                try {
                    HierarchicalSqlMapConfigParser.this.state.getConfig().getErrorContext().setMoreInfo("Check the data source type or class.");
                    DataSourceFactory dsFactory = (DataSourceFactory)Resources.instantiate((String)type);
                    HierarchicalSqlMapConfigParser.this.state.getConfig().getErrorContext().setMoreInfo("Check the data source properties or configuration.");
                    dsFactory.initialize((Map)props);
                    HierarchicalSqlMapConfigParser.this.state.setDataSource(dsFactory.getDataSource());
                    HierarchicalSqlMapConfigParser.this.state.getConfig().getErrorContext().setMoreInfo(null);
                }
                catch (Exception e) {
                    if (e instanceof SqlMapException) {
                        throw (SqlMapException)((Object)e);
                    }
                    throw new SqlMapException("Error initializing DataSource.  Could not instantiate DataSourceFactory.  Cause: " + e, (Throwable)e);
                }
            }
        });
    }

    protected void addSqlMapNodelets() {
        this.parser.addNodelet("/sqlMapConfig/sqlMap", new Nodelet(){

            public void process(Node node) throws Exception {
                HierarchicalSqlMapConfigParser.this.state.getConfig().getErrorContext().setActivity("loading the SQL Map resource");
                Properties attributes = NodeletUtils.parseAttributes((Node)node, (Properties)HierarchicalSqlMapConfigParser.this.state.getGlobalProps());
                String resourcePath = attributes.getProperty("resource");
                String url = attributes.getProperty("url");
                InputStream inputStream = null;
                if (resourcePath != null) {
                    HierarchicalSqlMapConfigParser.this.state.getConfig().getErrorContext().setResource(resourcePath);
                    Resource resource = HierarchicalSqlMapConfigParser.this.resourceLoader.getResource(resourcePath);
                    if (resource != null && resource.exists()) {
                        inputStream = resource.getInputStream();
                    }
                } else if (url != null) {
                    HierarchicalSqlMapConfigParser.this.state.getConfig().getErrorContext().setResource(url);
                    inputStream = Resources.getUrlAsStream((String)url);
                } else {
                    throw new SqlMapException("The <sqlMap> element requires either a resource or a url attribute.");
                }
                if (inputStream == null) {
                    throw new SqlMapException("The <sqlMap> resource is missing: " + (resourcePath == null ? "" : resourcePath) + (url == null ? "" : url));
                }
                new SqlMapParser(HierarchicalSqlMapConfigParser.this.state).parse(inputStream);
            }
        });
    }

    private void addResultObjectFactoryNodelets() {
        this.parser.addNodelet("/sqlMapConfig/resultObjectFactory", new Nodelet(){

            public void process(Node node) throws Exception {
                Properties attributes = NodeletUtils.parseAttributes((Node)node, (Properties)HierarchicalSqlMapConfigParser.this.state.getGlobalProps());
                String type = attributes.getProperty("type");
                HierarchicalSqlMapConfigParser.this.state.getConfig().getErrorContext().setActivity("configuring the Result Object Factory");
                try {
                    ResultObjectFactory rof = (ResultObjectFactory)Resources.instantiate((String)type);
                    HierarchicalSqlMapConfigParser.this.state.getConfig().setResultObjectFactory(rof);
                }
                catch (Exception e) {
                    throw new SqlMapException("Error instantiating resultObjectFactory: " + type, (Throwable)e);
                }
            }
        });
        this.parser.addNodelet("/sqlMapConfig/resultObjectFactory/property", new Nodelet(){

            public void process(Node node) throws Exception {
                Properties attributes = NodeletUtils.parseAttributes((Node)node, (Properties)HierarchicalSqlMapConfigParser.this.state.getGlobalProps());
                String name = attributes.getProperty("name");
                String value = NodeletUtils.parsePropertyTokens((String)attributes.getProperty("value"), (Properties)HierarchicalSqlMapConfigParser.this.state.getGlobalProps());
                HierarchicalSqlMapConfigParser.this.state.getConfig().getDelegate().getResultObjectFactory().setProperty(name, value);
            }
        });
    }
}

