/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqualsHelper {
    private static final int BUFFER_SIZE = 1024;

    public static boolean nullSafeEquals(Object left, Object right) {
        return left == right || left != null && right != null && left.equals(right);
    }

    public static boolean nullSafeEquals(String left, String right, boolean ignoreCase) {
        if (ignoreCase) {
            return left == right || left != null && right != null && left.equalsIgnoreCase(right);
        }
        return left == right || left != null && right != null && left.equals(right);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean binaryStreamEquals(InputStream left, InputStream right) throws IOException {
        try {
            if (left == right) {
                boolean bl = true;
                return bl;
            }
            byte[] leftBuffer = new byte[1024];
            byte[] rightBuffer = new byte[1024];
            block27: while (true) {
                boolean bl;
                int rightReadCount;
                int leftReadCount;
                if ((leftReadCount = left.read(leftBuffer)) != (rightReadCount = right.read(rightBuffer))) {
                    bl = false;
                    return bl;
                }
                if (leftReadCount == -1) {
                    bl = true;
                    return bl;
                }
                int i = 0;
                while (true) {
                    if (i >= leftReadCount) continue block27;
                    if (leftBuffer[i] != rightBuffer[i]) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    ++i;
                }
                break;
            }
        }
        finally {
            try {
                left.close();
            }
            catch (Throwable e) {}
            try {
                right.close();
            }
            catch (Throwable e) {}
        }
    }

    public static String getMapDifferenceReport(Map<?, ?> actual, Map<?, ?> expected) {
        Object key;
        HashMap copyResult = new HashMap(actual);
        boolean failure = false;
        StringBuilder sb = new StringBuilder(1024);
        sb.append("\nValues that don't match the expected values: ");
        for (Map.Entry<?, ?> entry : expected.entrySet()) {
            key = entry.getKey();
            Object expectedValue = entry.getValue();
            Object resultValue = actual.get(key);
            if (!EqualsHelper.nullSafeEquals(resultValue, expectedValue)) {
                sb.append("\n").append("   Key: ").append(key).append("\n").append("      Result:   ").append(resultValue).append("\n").append("      Expected: ").append(expectedValue);
                failure = true;
            }
            copyResult.remove(key);
        }
        sb.append("\nValues that are present but should not be: ");
        for (Map.Entry<Object, Object> entry : copyResult.entrySet()) {
            key = entry.getKey();
            Object resultValue = entry.getValue();
            sb.append("\n").append("   Key: ").append(key).append("\n").append("      Result:   ").append(resultValue);
            failure = true;
        }
        if (failure) {
            return sb.toString();
        }
        return null;
    }

    public static <K, V> Map<K, MapValueComparison> getMapComparison(Map<K, V> left, Map<K, V> right) {
        HashSet<K> keys = new HashSet<K>(left.size() + right.size());
        keys.addAll(left.keySet());
        keys.addAll(right.keySet());
        HashMap diff = new HashMap(left.size() + right.size());
        for (Object key : keys) {
            boolean leftHasKey = left.containsKey(key);
            boolean rightHasKey = right.containsKey(key);
            V leftValue = left.get(key);
            V rightValue = right.get(key);
            if (leftHasKey) {
                if (!rightHasKey) {
                    diff.put(key, MapValueComparison.LEFT_ONLY);
                    continue;
                }
                if (EqualsHelper.nullSafeEquals(leftValue, rightValue)) {
                    diff.put(key, MapValueComparison.EQUAL);
                    continue;
                }
                diff.put(key, MapValueComparison.NOT_EQUAL);
                continue;
            }
            if (!rightHasKey) continue;
            if (!leftHasKey) {
                diff.put(key, MapValueComparison.RIGHT_ONLY);
                continue;
            }
            if (EqualsHelper.nullSafeEquals(leftValue, rightValue)) {
                diff.put(key, MapValueComparison.EQUAL);
                continue;
            }
            diff.put(key, MapValueComparison.NOT_EQUAL);
        }
        return diff;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MapValueComparison {
        LEFT_ONLY,
        RIGHT_ONLY,
        EQUAL,
        NOT_EQUAL;

    }
}

