/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.resource;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.util.resource.HierarchicalResourceLoader;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicalResourceLoaderTest
extends TestCase {
    private static final String RESOURCE = "classpath:resource-loader/#resource.dialect#/file.txt";

    private HierarchicalResourceLoader getLoader(Class<? extends Object> baseClazz, Class<? extends Object> clazz) throws Throwable {
        HierarchicalResourceLoader loader = new HierarchicalResourceLoader();
        loader.setDialectBaseClass(baseClazz.getName());
        loader.setDialectClass(clazz.getName());
        loader.afterPropertiesSet();
        return loader;
    }

    public void testMismatchDetection() throws Throwable {
        this.getLoader(AbstractCollection.class, TreeSet.class);
        this.getLoader(AbstractCollection.class, HashSet.class);
        this.getLoader(AbstractCollection.class, ArrayList.class);
        this.getLoader(AbstractCollection.class, AbstractCollection.class);
        try {
            this.getLoader(Collection.class, Object.class).getResource("abc");
            HierarchicalResourceLoaderTest.fail((String)"Failed to detect incompatible class hierarchy");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            this.getLoader(ArrayList.class, AbstractCollection.class).getResource("abc");
            HierarchicalResourceLoaderTest.fail((String)"Failed to detect incompatible class hierarchy");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void checkResource(Resource resource, String check) throws Throwable {
        HierarchicalResourceLoaderTest.assertNotNull((String)"Resource not found", (Object)resource);
        HierarchicalResourceLoaderTest.assertTrue((String)"Resource doesn't exist", (boolean)resource.exists());
        InputStream is = resource.getInputStream();
        StringBuilder builder = new StringBuilder(128);
        byte[] bytes = new byte[128];
        BufferedInputStream tempIs = null;
        try {
            tempIs = new BufferedInputStream(is, 128);
            int count = -2;
            while (count != -1) {
                if (count > 0) {
                    String toWrite = new String(bytes, 0, count, "UTF-8");
                    builder.append(toWrite);
                }
                count = ((InputStream)tempIs).read(bytes);
            }
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("Unable to read stream", e);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {}
        }
        String fileValue = builder.toString();
        HierarchicalResourceLoaderTest.assertEquals((String)"Incorrect file retrieved: ", (String)check, (String)fileValue);
    }

    public void testResourceLoading() throws Throwable {
        HierarchicalResourceLoader bean = this.getLoader(AbstractCollection.class, TreeSet.class);
        Resource resource = bean.getResource(RESOURCE);
        this.checkResource(resource, "java.util.TreeSet");
        bean = this.getLoader(AbstractCollection.class, AbstractSet.class);
        resource = bean.getResource(RESOURCE);
        this.checkResource(resource, "java.util.AbstractCollection");
        bean = this.getLoader(AbstractCollection.class, AbstractCollection.class);
        resource = bean.getResource(RESOURCE);
        this.checkResource(resource, "java.util.AbstractCollection");
        bean = this.getLoader(AbstractCollection.class, ArrayList.class);
        resource = bean.getResource(RESOURCE);
        this.checkResource(resource, "java.util.AbstractList");
        bean = this.getLoader(AbstractCollection.class, AbstractList.class);
        resource = bean.getResource(RESOURCE);
        this.checkResource(resource, "java.util.AbstractList");
    }
}

