/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.dictionary.CompiledModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryListener;
import org.alfresco.repo.dictionary.M2AnonymousTypeDefinition;
import org.alfresco.repo.dictionary.M2ClassDefinition;
import org.alfresco.repo.dictionary.M2ConstraintDefinition;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2ModelDiff;
import org.alfresco.repo.dictionary.M2Namespace;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.NamespaceDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryDAOImpl
implements DictionaryDAO {
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Lock readLock = this.lock.readLock();
    private Lock writeLock = this.lock.writeLock();
    private NamespaceDAO namespaceDAO;
    private TenantService tenantService;
    private SimpleCache<String, DictionaryRegistry> dictionaryRegistryCache;
    private ThreadLocal<DictionaryRegistry> dictionaryRegistryThreadLocal = new ThreadLocal();
    private ThreadLocal<DictionaryRegistry> defaultDictionaryRegistryThreadLocal = new ThreadLocal();
    private List<DictionaryListener> dictionaryListeners = new ArrayList<DictionaryListener>();
    private static Log logger = LogFactory.getLog(DictionaryDAO.class);

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setDictionaryRegistryCache(SimpleCache<String, DictionaryRegistry> dictionaryRegistryCache) {
        this.dictionaryRegistryCache = dictionaryRegistryCache;
    }

    public DictionaryDAOImpl(NamespaceDAO namespaceDAO) {
        this.namespaceDAO = namespaceDAO;
        this.namespaceDAO.registerDictionary(this);
    }

    @Override
    public void register(DictionaryListener dictionaryListener) {
        if (!this.dictionaryListeners.contains(dictionaryListener)) {
            this.dictionaryListeners.add(dictionaryListener);
        }
    }

    @Override
    public void init() {
        this.initDictionary(this.tenantService.getCurrentUserDomain());
    }

    @Override
    public void destroy() {
        String tenantDomain = this.tenantService.getCurrentUserDomain();
        this.removeDictionaryRegistry(tenantDomain);
        this.namespaceDAO.destroy();
        for (DictionaryListener dictionaryDeployer : this.dictionaryListeners) {
            dictionaryDeployer.afterDictionaryDestroy();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Dictionary destroyed");
        }
    }

    @Override
    public void reset() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Resetting dictionary ...");
        }
        this.destroy();
        this.init();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"... resetting dictionary completed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DictionaryRegistry initDictionary(final String tenantDomain) {
        long startTime = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Init Dictionary: [" + Thread.currentThread() + "] " + (tenantDomain.equals("") ? "" : " (Tenant: " + tenantDomain + ")")));
        }
        try {
            DictionaryRegistry dictionaryRegistry;
            this.writeLock.lock();
            try {
                dictionaryRegistry = AuthenticationUtil.runAs(new AuthenticationUtil.RunAsWork<DictionaryRegistry>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public DictionaryRegistry doWork() {
                        try {
                            DictionaryRegistry dictionaryRegistry = DictionaryDAOImpl.this.initDictionaryRegistry(tenantDomain);
                            if (dictionaryRegistry == null) {
                                throw new AlfrescoRuntimeException("Failed to init dictionaryRegistry " + tenantDomain);
                            }
                            DictionaryDAOImpl.this.dictionaryRegistryCache.put(tenantDomain, dictionaryRegistry);
                            DictionaryRegistry dictionaryRegistry2 = dictionaryRegistry;
                            return dictionaryRegistry2;
                        }
                        finally {
                            if (DictionaryDAOImpl.this.dictionaryRegistryCache.get(tenantDomain) != null) {
                                DictionaryDAOImpl.this.removeDataDictionaryLocal(tenantDomain);
                            }
                        }
                    }
                }, this.tenantService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenantDomain));
            }
            catch (Throwable throwable) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Init Dictionary: model count = " + (this.getModels() != null ? this.getModels().size() : 0) + " in " + (System.currentTimeMillis() - startTime) + " msecs [" + Thread.currentThread() + "] " + (tenantDomain.equals("") ? "" : " (Tenant: " + tenantDomain + ")")));
                }
                throw throwable;
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Init Dictionary: model count = " + (this.getModels() != null ? this.getModels().size() : 0) + " in " + (System.currentTimeMillis() - startTime) + " msecs [" + Thread.currentThread() + "] " + (tenantDomain.equals("") ? "" : " (Tenant: " + tenantDomain + ")")));
            }
            return dictionaryRegistry;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private DictionaryRegistry initDictionaryRegistry(String tenantDomain) {
        DictionaryRegistry dictionaryRegistry = this.createDataDictionaryLocal(tenantDomain);
        dictionaryRegistry.setCompiledModels(new HashMap<QName, CompiledModel>());
        dictionaryRegistry.setUriToModels(new HashMap<String, List<CompiledModel>>());
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Empty dictionary initialised: " + dictionaryRegistry + " - " + this.defaultDictionaryRegistryThreadLocal + " [" + Thread.currentThread() + "]"));
        }
        this.namespaceDAO.init();
        for (DictionaryListener dictionaryDeployer : this.dictionaryListeners) {
            dictionaryDeployer.onDictionaryInit();
        }
        for (DictionaryListener dictionaryListener : this.dictionaryListeners) {
            dictionaryListener.afterDictionaryInit();
        }
        this.namespaceDAO.afterDictionaryInit();
        return dictionaryRegistry;
    }

    @Override
    public QName putModel(M2Model model) {
        String tenantDomain = this.tenantService.getCurrentUserDomain();
        CompiledModel compiledModel = model.compile(this, this.namespaceDAO);
        QName modelName = compiledModel.getModelDefinition().getName();
        CompiledModel previousVersion = this.getCompiledModels(tenantDomain).get(modelName);
        if (previousVersion != null) {
            for (M2Namespace namespace : previousVersion.getM2Model().getNamespaces()) {
                this.namespaceDAO.removePrefix(namespace.getPrefix());
                this.namespaceDAO.removeURI(namespace.getUri());
                this.unmapUriToModel(namespace.getUri(), previousVersion, tenantDomain);
            }
            for (M2Namespace importNamespace : previousVersion.getM2Model().getImports()) {
                this.unmapUriToModel(importNamespace.getUri(), previousVersion, tenantDomain);
            }
        }
        for (M2Namespace namespace : model.getNamespaces()) {
            this.namespaceDAO.addURI(namespace.getUri());
            this.namespaceDAO.addPrefix(namespace.getPrefix(), namespace.getUri());
            this.mapUriToModel(namespace.getUri(), compiledModel, tenantDomain);
        }
        for (M2Namespace importNamespace : model.getImports()) {
            this.mapUriToModel(importNamespace.getUri(), compiledModel, tenantDomain);
        }
        this.getCompiledModels(tenantDomain).put(modelName, compiledModel);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Registered model: " + modelName.toPrefixString(this.namespaceDAO)));
            for (M2Namespace namespace : model.getNamespaces()) {
                logger.trace((Object)("Registered namespace: '" + namespace.getUri() + "' (prefix '" + namespace.getPrefix() + "')"));
            }
        }
        return modelName;
    }

    @Override
    public void removeModel(QName modelName) {
        String tenantDomain = this.tenantService.getCurrentUserDomain();
        CompiledModel compiledModel = this.getCompiledModels(tenantDomain).get(modelName);
        if (compiledModel != null) {
            M2Model model = compiledModel.getM2Model();
            for (M2Namespace namespace : model.getNamespaces()) {
                this.namespaceDAO.removePrefix(namespace.getPrefix());
                this.namespaceDAO.removeURI(namespace.getUri());
                this.unmapUriToModel(namespace.getUri(), compiledModel, tenantDomain);
            }
            this.getCompiledModels(tenantDomain).remove(modelName);
        }
    }

    private void mapUriToModel(String uri, CompiledModel model, String tenantDomain) {
        List<CompiledModel> models = this.getUriToModels(tenantDomain).get(uri);
        if (models == null) {
            models = new ArrayList<CompiledModel>();
            this.getUriToModels(tenantDomain).put(uri, models);
        }
        if (!models.contains(model)) {
            models.add(model);
        }
    }

    private void unmapUriToModel(String uri, CompiledModel model, String tenantDomain) {
        List<CompiledModel> models = this.getUriToModels(tenantDomain).get(uri);
        if (models != null) {
            models.remove(model);
        }
    }

    private List<CompiledModel> getModelsForUri(String uri) {
        String tenantDomain = this.tenantService.getCurrentUserDomain();
        if (!tenantDomain.equals("")) {
            List<CompiledModel> tenantModels;
            List<CompiledModel> models = this.getUriToModels("").get(uri);
            ArrayList<CompiledModel> filteredModels = new ArrayList<CompiledModel>();
            if (models != null) {
                filteredModels.addAll(models);
            }
            if ((tenantModels = this.getUriToModels(tenantDomain).get(uri)) != null) {
                if (models != null) {
                    for (CompiledModel tenantModel : tenantModels) {
                        for (CompiledModel model : models) {
                            if (!tenantModel.getM2Model().getName().equals(model.getM2Model().getName())) continue;
                            filteredModels.remove(model);
                        }
                    }
                }
                filteredModels.addAll(tenantModels);
                models = filteredModels;
            }
            if (models == null) {
                models = Collections.emptyList();
            }
            return models;
        }
        List<CompiledModel> models = this.getUriToModels("").get(uri);
        if (models == null) {
            models = Collections.emptyList();
        }
        return models;
    }

    CompiledModel getCompiledModel(QName modelName) {
        CompiledModel model;
        String tenantDomain = this.tenantService.getCurrentUserDomain();
        if (!tenantDomain.equals("") && (model = this.getCompiledModels(tenantDomain).get(modelName)) != null) {
            return model;
        }
        model = this.getCompiledModels("").get(modelName);
        if (model == null) {
            throw new DictionaryException("d_dictionary.model.err.no_model", modelName);
        }
        return model;
    }

    @Override
    public DataTypeDefinition getDataType(QName typeName) {
        if (typeName != null) {
            List<CompiledModel> models = this.getModelsForUri(typeName.getNamespaceURI());
            for (CompiledModel model : models) {
                DataTypeDefinition dataType = model.getDataType(typeName);
                if (dataType == null) continue;
                return dataType;
            }
        }
        return null;
    }

    @Override
    public DataTypeDefinition getDataType(Class javaClass) {
        String tenantDomain = this.tenantService.getCurrentUserDomain();
        if (!tenantDomain.equals("")) {
            DataTypeDefinition dataTypeDef;
            for (CompiledModel model : this.getCompiledModels(tenantDomain).values()) {
                dataTypeDef = model.getDataType(javaClass);
                if (dataTypeDef == null) continue;
                return dataTypeDef;
            }
            for (CompiledModel model : this.getCompiledModels("").values()) {
                dataTypeDef = model.getDataType(javaClass);
                if (dataTypeDef == null) continue;
                return dataTypeDef;
            }
            return null;
        }
        for (CompiledModel model : this.getCompiledModels("").values()) {
            DataTypeDefinition dataTypeDef = model.getDataType(javaClass);
            if (dataTypeDef == null) continue;
            return dataTypeDef;
        }
        return null;
    }

    @Override
    public Collection<DataTypeDefinition> getDataTypes(QName modelName) {
        CompiledModel model = this.getCompiledModel(modelName);
        return model.getDataTypes();
    }

    @Override
    public TypeDefinition getType(QName typeName) {
        if (typeName != null) {
            List<CompiledModel> models = this.getModelsForUri(typeName.getNamespaceURI());
            for (CompiledModel model : models) {
                TypeDefinition type = model.getType(typeName);
                if (type == null) continue;
                return type;
            }
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Type not found: " + typeName));
            }
        }
        return null;
    }

    @Override
    public Collection<QName> getSubTypes(QName superType, boolean follow) {
        HashMap<QName, QName> allTypesAndParents = new HashMap<QName, QName>();
        for (CompiledModel model : this.getCompiledModels().values()) {
            for (TypeDefinition type : model.getTypes()) {
                allTypesAndParents.put(type.getName(), type.getParentName());
            }
        }
        HashSet<QName> subTypes = new HashSet<QName>();
        for (QName type : allTypesAndParents.keySet()) {
            if (follow) {
                QName current = type;
                while (current != null && !current.equals(superType)) {
                    current = (QName)allTypesAndParents.get(current);
                }
                if (current == null) continue;
                subTypes.add(type);
                continue;
            }
            QName typesSuperType = (QName)allTypesAndParents.get(type);
            if (typesSuperType == null || !typesSuperType.equals(superType)) continue;
            subTypes.add(type);
        }
        return subTypes;
    }

    @Override
    public AspectDefinition getAspect(QName aspectName) {
        if (aspectName != null) {
            List<CompiledModel> models = this.getModelsForUri(aspectName.getNamespaceURI());
            for (CompiledModel model : models) {
                AspectDefinition aspect = model.getAspect(aspectName);
                if (aspect == null) continue;
                return aspect;
            }
        }
        return null;
    }

    @Override
    public Collection<QName> getSubAspects(QName superAspect, boolean follow) {
        HashMap<QName, QName> allAspectsAndParents = new HashMap<QName, QName>();
        for (CompiledModel model : this.getCompiledModels().values()) {
            for (AspectDefinition aspect : model.getAspects()) {
                allAspectsAndParents.put(aspect.getName(), aspect.getParentName());
            }
        }
        HashSet<QName> subAspects = new HashSet<QName>();
        for (QName aspect : allAspectsAndParents.keySet()) {
            if (follow) {
                QName current = aspect;
                while (current != null && !current.equals(superAspect)) {
                    current = (QName)allAspectsAndParents.get(current);
                }
                if (current == null) continue;
                subAspects.add(aspect);
                continue;
            }
            if (!((QName)allAspectsAndParents.get(aspect)).equals(superAspect)) continue;
            subAspects.add(aspect);
        }
        return subAspects;
    }

    @Override
    public ClassDefinition getClass(QName className) {
        List<CompiledModel> models = this.getModelsForUri(className.getNamespaceURI());
        for (CompiledModel model : models) {
            ClassDefinition classDef = model.getClass(className);
            if (classDef == null) continue;
            return classDef;
        }
        return null;
    }

    @Override
    public PropertyDefinition getProperty(QName propertyName) {
        List<CompiledModel> models = this.getModelsForUri(propertyName.getNamespaceURI());
        for (CompiledModel model : models) {
            PropertyDefinition propDef = model.getProperty(propertyName);
            if (propDef == null) continue;
            return propDef;
        }
        return null;
    }

    @Override
    public ConstraintDefinition getConstraint(QName constraintQName) {
        List<CompiledModel> models = this.getModelsForUri(constraintQName.getNamespaceURI());
        for (CompiledModel model : models) {
            ConstraintDefinition constraintDef = model.getConstraint(constraintQName);
            if (constraintDef == null) continue;
            return constraintDef;
        }
        return null;
    }

    @Override
    public AssociationDefinition getAssociation(QName assocName) {
        List<CompiledModel> models = this.getModelsForUri(assocName.getNamespaceURI());
        for (CompiledModel model : models) {
            AssociationDefinition assocDef = model.getAssociation(assocName);
            if (assocDef == null) continue;
            return assocDef;
        }
        return null;
    }

    @Override
    public Collection<AssociationDefinition> getAssociations(QName modelName) {
        CompiledModel model = this.getCompiledModel(modelName);
        return model.getAssociations();
    }

    @Override
    public Collection<QName> getModels() {
        return this.getCompiledModels().keySet();
    }

    @Override
    public boolean isModelInherited(QName modelName) {
        CompiledModel model;
        String tenantDomain = this.tenantService.getCurrentUserDomain();
        if (!tenantDomain.equals("") && (model = this.getCompiledModels(tenantDomain).get(modelName)) != null) {
            return false;
        }
        model = this.getCompiledModels("").get(modelName);
        if (model == null) {
            throw new DictionaryException("d_dictionary.model.err.no_model", modelName);
        }
        return !tenantDomain.equals("");
    }

    private Map<QName, CompiledModel> getCompiledModels() {
        String tenantDomain = this.tenantService.getCurrentUserDomain();
        if (!tenantDomain.equals("")) {
            HashMap<QName, CompiledModel> filteredModels = new HashMap<QName, CompiledModel>();
            Map<QName, CompiledModel> tenantModels = this.getCompiledModels(tenantDomain);
            Map<QName, CompiledModel> nontenantModels = this.getCompiledModels("");
            filteredModels.putAll(nontenantModels);
            block0: for (QName tenantModel : tenantModels.keySet()) {
                for (QName nontenantModel : nontenantModels.keySet()) {
                    if (!tenantModel.equals(nontenantModel)) continue;
                    filteredModels.remove(nontenantModel);
                    continue block0;
                }
            }
            filteredModels.putAll(tenantModels);
            return filteredModels;
        }
        return this.getCompiledModels("");
    }

    @Override
    public ModelDefinition getModel(QName name) {
        CompiledModel model = this.getCompiledModel(name);
        return model.getModelDefinition();
    }

    @Override
    public Collection<TypeDefinition> getTypes(QName modelName) {
        CompiledModel model = this.getCompiledModel(modelName);
        return model.getTypes();
    }

    @Override
    public Collection<AspectDefinition> getAspects(QName modelName) {
        CompiledModel model = this.getCompiledModel(modelName);
        return model.getAspects();
    }

    @Override
    public TypeDefinition getAnonymousType(QName type, Collection<QName> aspects) {
        TypeDefinition typeDef = this.getType(type);
        if (typeDef == null) {
            throw new DictionaryException("d_dictionary.model.err.type_not_found", type);
        }
        ArrayList<AspectDefinition> aspectDefs = new ArrayList<AspectDefinition>();
        if (aspects != null) {
            for (QName aspect : aspects) {
                AspectDefinition aspectDef = this.getAspect(aspect);
                if (aspectDef == null) {
                    throw new DictionaryException("d_dictionary.model.err.aspect_not_found", aspect);
                }
                aspectDefs.add(aspectDef);
            }
        }
        return new M2AnonymousTypeDefinition(typeDef, aspectDefs);
    }

    @Override
    public Collection<PropertyDefinition> getProperties(QName modelName) {
        CompiledModel model = this.getCompiledModel(modelName);
        return model.getProperties();
    }

    @Override
    public Collection<PropertyDefinition> getProperties(QName modelName, QName dataType) {
        HashSet<PropertyDefinition> properties = new HashSet<PropertyDefinition>();
        Collection<PropertyDefinition> props = this.getProperties(modelName);
        for (PropertyDefinition prop : props) {
            if (dataType != null && !prop.getDataType().getName().equals(dataType)) continue;
            properties.add(prop);
        }
        return properties;
    }

    @Override
    public Collection<NamespaceDefinition> getNamespaces(QName modelName) {
        CompiledModel model = this.getCompiledModel(modelName);
        ModelDefinition modelDef = model.getModelDefinition();
        return modelDef.getNamespaces();
    }

    @Override
    public Collection<ConstraintDefinition> getConstraints(QName modelName) {
        return this.getConstraints(modelName, false);
    }

    @Override
    public Collection<ConstraintDefinition> getConstraints(QName modelName, boolean referenceableDefsOnly) {
        CompiledModel model = this.getCompiledModel(modelName);
        if (referenceableDefsOnly) {
            return this.getReferenceableConstraintDefs(model);
        }
        return model.getConstraints();
    }

    private Collection<ConstraintDefinition> getReferenceableConstraintDefs(CompiledModel model) {
        Collection<ConstraintDefinition> conDefs = model.getConstraints();
        Collection<PropertyDefinition> propDefs = model.getProperties();
        for (PropertyDefinition propDef : propDefs) {
            for (ConstraintDefinition conDef : propDef.getConstraints()) {
                conDefs.remove(conDef);
            }
        }
        return conDefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DictionaryRegistry getDictionaryRegistry(String tenantDomain) {
        DictionaryRegistry dictionaryRegistry = null;
        dictionaryRegistry = this.getDictionaryRegistryLocal(tenantDomain);
        if (dictionaryRegistry != null) {
            return dictionaryRegistry;
        }
        try {
            this.readLock.lock();
            dictionaryRegistry = this.dictionaryRegistryCache.get(tenantDomain);
            if (dictionaryRegistry != null) {
                DictionaryRegistry dictionaryRegistry2 = dictionaryRegistry;
                return dictionaryRegistry2;
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("getDictionaryRegistry: not in cache (or threadlocal) - re-init [" + Thread.currentThread().getId() + "]" + (tenantDomain.equals("") ? "" : " (Tenant: " + tenantDomain + ")")));
        }
        if ((dictionaryRegistry = this.initDictionary(tenantDomain)) == null) {
            throw new AlfrescoRuntimeException("Failed to get dictionaryRegistry " + tenantDomain);
        }
        return dictionaryRegistry;
    }

    private DictionaryRegistry createDataDictionaryLocal(String tenantDomain) {
        DictionaryRegistry dictionaryRegistry = this.getDictionaryRegistryLocal(tenantDomain);
        if (dictionaryRegistry == null) {
            dictionaryRegistry = new DictionaryRegistry(tenantDomain);
            if (tenantDomain.equals("")) {
                this.defaultDictionaryRegistryThreadLocal.set(dictionaryRegistry);
            } else {
                this.dictionaryRegistryThreadLocal.set(dictionaryRegistry);
            }
        }
        return dictionaryRegistry;
    }

    private DictionaryRegistry getDictionaryRegistryLocal(String tenantDomain) {
        DictionaryRegistry dictionaryRegistry = null;
        dictionaryRegistry = tenantDomain.equals("") ? this.defaultDictionaryRegistryThreadLocal.get() : this.dictionaryRegistryThreadLocal.get();
        if (dictionaryRegistry != null && tenantDomain.equals(dictionaryRegistry.getTenantDomain())) {
            return dictionaryRegistry;
        }
        return null;
    }

    private void removeDataDictionaryLocal(String tenantDomain) {
        if (tenantDomain.equals("")) {
            this.defaultDictionaryRegistryThreadLocal.set(null);
        } else {
            this.dictionaryRegistryThreadLocal.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDictionaryRegistry(String tenantDomain) {
        try {
            this.writeLock.lock();
            if (this.dictionaryRegistryCache.get(tenantDomain) != null) {
                this.dictionaryRegistryCache.remove(tenantDomain);
            }
            this.removeDataDictionaryLocal(tenantDomain);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Map<QName, CompiledModel> getCompiledModels(String tenantDomain) {
        return this.getDictionaryRegistry(tenantDomain).getCompiledModels();
    }

    private Map<String, List<CompiledModel>> getUriToModels(String tenantDomain) {
        return this.getDictionaryRegistry(tenantDomain).getUriToModels();
    }

    @Override
    public List<M2ModelDiff> diffModel(M2Model model) {
        CompiledModel compiledModel = model.compile(this, this.namespaceDAO);
        QName modelName = compiledModel.getModelDefinition().getName();
        CompiledModel previousVersion = null;
        try {
            previousVersion = this.getCompiledModel(modelName);
        }
        catch (DictionaryException e) {
            // empty catch block
        }
        if (previousVersion == null) {
            return new ArrayList<M2ModelDiff>(0);
        }
        return this.diffModel(previousVersion, compiledModel);
    }

    List<M2ModelDiff> diffModel(CompiledModel previousVersion, CompiledModel model) {
        ArrayList<M2ModelDiff> M2ModelDiffs;
        block17: {
            block16: {
                M2ModelDiffs = new ArrayList<M2ModelDiff>();
                if (previousVersion == null) break block16;
                Collection<TypeDefinition> previousTypes = previousVersion.getTypes();
                Collection<AspectDefinition> previousAspects = previousVersion.getAspects();
                Collection<ConstraintDefinition> previousConDefs = this.getReferenceableConstraintDefs(previousVersion);
                if (model == null) {
                    for (TypeDefinition previousType : previousTypes) {
                        M2ModelDiffs.add(new M2ModelDiff(previousType.getName(), "TYPE", "deleted"));
                    }
                    for (AspectDefinition previousAspect : previousAspects) {
                        M2ModelDiffs.add(new M2ModelDiff(previousAspect.getName(), "ASPECT", "deleted"));
                    }
                    for (ConstraintDefinition previousConDef : previousConDefs) {
                        M2ModelDiffs.add(new M2ModelDiff(previousConDef.getName(), "TYPE_CONSTRAINT", "deleted"));
                    }
                } else {
                    Collection<TypeDefinition> types = model.getTypes();
                    Collection<AspectDefinition> aspects = model.getAspects();
                    Collection<ConstraintDefinition> conDefs = this.getReferenceableConstraintDefs(model);
                    if (previousTypes.size() != 0) {
                        M2ModelDiffs.addAll(M2ClassDefinition.diffClassLists(new ArrayList<ClassDefinition>(previousTypes), new ArrayList<ClassDefinition>(types), "TYPE"));
                    } else {
                        for (TypeDefinition type : types) {
                            M2ModelDiffs.add(new M2ModelDiff(type.getName(), "TYPE", "created"));
                        }
                    }
                    if (previousAspects.size() != 0) {
                        M2ModelDiffs.addAll(M2ClassDefinition.diffClassLists(new ArrayList<ClassDefinition>(previousAspects), new ArrayList<ClassDefinition>(aspects), "ASPECT"));
                    } else {
                        for (AspectDefinition aspect : aspects) {
                            M2ModelDiffs.add(new M2ModelDiff(aspect.getName(), "ASPECT", "created"));
                        }
                    }
                    if (previousConDefs.size() != 0) {
                        M2ModelDiffs.addAll(M2ConstraintDefinition.diffConstraintLists(new ArrayList<ConstraintDefinition>(previousConDefs), new ArrayList<ConstraintDefinition>(conDefs)));
                    } else {
                        for (ConstraintDefinition conDef : conDefs) {
                            M2ModelDiffs.add(new M2ModelDiff(conDef.getName(), "TYPE_CONSTRAINT", "created"));
                        }
                    }
                }
                break block17;
            }
            if (model == null) break block17;
            Collection<TypeDefinition> types = model.getTypes();
            Collection<AspectDefinition> aspects = model.getAspects();
            for (TypeDefinition type : types) {
                M2ModelDiffs.add(new M2ModelDiff(type.getName(), "TYPE", "created"));
            }
            for (AspectDefinition aspect : aspects) {
                M2ModelDiffs.add(new M2ModelDiff(aspect.getName(), "ASPECT", "created"));
            }
        }
        return M2ModelDiffs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DictionaryRegistry {
        private Map<String, List<CompiledModel>> uriToModels = new HashMap<String, List<CompiledModel>>(0);
        private Map<QName, CompiledModel> compiledModels = new HashMap<QName, CompiledModel>(0);
        private String tenantDomain;

        public DictionaryRegistry(String tenantDomain) {
            this.tenantDomain = tenantDomain;
        }

        public String getTenantDomain() {
            return this.tenantDomain;
        }

        public Map<String, List<CompiledModel>> getUriToModels() {
            return this.uriToModels;
        }

        public void setUriToModels(Map<String, List<CompiledModel>> uriToModels) {
            this.uriToModels = uriToModels;
        }

        public Map<QName, CompiledModel> getCompiledModels() {
            return this.compiledModels;
        }

        public void setCompiledModels(Map<QName, CompiledModel> compiledModels) {
            this.compiledModels = compiledModels;
        }
    }
}

