/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.repo.cache.MemoryCache;
import org.alfresco.repo.dictionary.DictionaryBootstrap;
import org.alfresco.repo.dictionary.DictionaryComponent;
import org.alfresco.repo.dictionary.DictionaryDAOImpl;
import org.alfresco.repo.dictionary.NamespaceDAOImpl;
import org.alfresco.repo.dictionary.constraint.RegexConstraint;
import org.alfresco.repo.dictionary.constraint.RegisteredConstraint;
import org.alfresco.repo.dictionary.constraint.StringLengthConstraint;
import org.alfresco.repo.tenant.SingleTServiceImpl;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ChildAssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.Constraint;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.surf.util.I18NUtil;

public class DictionaryDAOTest
extends TestCase {
    public static final String TEST_RESOURCE_MESSAGES = "alfresco/messages/dictionary-messages";
    private static final String TEST_URL = "http://www.alfresco.org/test/dictionarydaotest/1.0";
    private static final String TEST_MODEL = "org/alfresco/repo/dictionary/dictionarydaotest_model.xml";
    private static final String TEST_BUNDLE = "org/alfresco/repo/dictionary/dictionarydaotest_model";
    private DictionaryService service;

    public void setUp() {
        I18NUtil.registerResourceBundle((String)TEST_RESOURCE_MESSAGES);
        SingleTServiceImpl tenantService = new SingleTServiceImpl();
        NamespaceDAOImpl namespaceDAO = new NamespaceDAOImpl();
        namespaceDAO.setTenantService(tenantService);
        this.initNamespaceCaches(namespaceDAO);
        DictionaryDAOImpl dictionaryDAO = new DictionaryDAOImpl(namespaceDAO);
        dictionaryDAO.setTenantService(tenantService);
        this.initDictionaryCaches(dictionaryDAO);
        DictionaryBootstrap bootstrap = new DictionaryBootstrap();
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add("alfresco/model/dictionaryModel.xml");
        bootstrapModels.add(TEST_MODEL);
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(TEST_BUNDLE);
        bootstrap.setModels(bootstrapModels);
        bootstrap.setLabels(labels);
        bootstrap.setDictionaryDAO(dictionaryDAO);
        bootstrap.setTenantService(tenantService);
        bootstrap.bootstrap();
        DictionaryComponent component = new DictionaryComponent();
        component.setDictionaryDAO(dictionaryDAO);
        this.service = component;
    }

    private void initDictionaryCaches(DictionaryDAOImpl dictionaryDAO) {
        dictionaryDAO.setDictionaryRegistryCache(new MemoryCache<String, DictionaryDAOImpl.DictionaryRegistry>());
    }

    private void initNamespaceCaches(NamespaceDAOImpl namespaceDAO) {
        namespaceDAO.setNamespaceRegistryCache(new MemoryCache<String, NamespaceDAOImpl.NamespaceRegistry>());
    }

    public void testBootstrap() {
        SingleTServiceImpl tenantService = new SingleTServiceImpl();
        NamespaceDAOImpl namespaceDAO = new NamespaceDAOImpl();
        namespaceDAO.setTenantService(tenantService);
        this.initNamespaceCaches(namespaceDAO);
        DictionaryDAOImpl dictionaryDAO = new DictionaryDAOImpl(namespaceDAO);
        dictionaryDAO.setTenantService(tenantService);
        this.initDictionaryCaches(dictionaryDAO);
        DictionaryBootstrap bootstrap = new DictionaryBootstrap();
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add("alfresco/model/dictionaryModel.xml");
        bootstrap.setModels(bootstrapModels);
        bootstrap.setDictionaryDAO(dictionaryDAO);
        bootstrap.setTenantService(tenantService);
        bootstrap.bootstrap();
    }

    public void testLabels() {
        QName model = QName.createQName(TEST_URL, "dictionarydaotest");
        ModelDefinition modelDef = this.service.getModel(model);
        DictionaryDAOTest.assertEquals((String)"Model Description", (String)modelDef.getDescription());
        QName type = QName.createQName(TEST_URL, "base");
        TypeDefinition typeDef = this.service.getType(type);
        DictionaryDAOTest.assertEquals((String)"Base Title", (String)typeDef.getTitle());
        DictionaryDAOTest.assertEquals((String)"Base Description", (String)typeDef.getDescription());
        QName prop = QName.createQName(TEST_URL, "prop1");
        PropertyDefinition propDef = this.service.getProperty(prop);
        DictionaryDAOTest.assertEquals((String)"Prop1 Title", (String)propDef.getTitle());
        DictionaryDAOTest.assertEquals((String)"Prop1 Description", (String)propDef.getDescription());
        QName assoc = QName.createQName(TEST_URL, "assoc1");
        AssociationDefinition assocDef = this.service.getAssociation(assoc);
        DictionaryDAOTest.assertEquals((String)"Assoc1 Title", (String)assocDef.getTitle());
        DictionaryDAOTest.assertEquals((String)"Assoc1 Description", (String)assocDef.getDescription());
        QName datatype = QName.createQName(TEST_URL, "datatype");
        DataTypeDefinition datatypeDef = this.service.getDataType(datatype);
        DictionaryDAOTest.assertEquals((String)"Datatype Analyser", (String)datatypeDef.getAnalyserClassName());
    }

    public void testConstraints() {
        QName model = QName.createQName(TEST_URL, "dictionarydaotest");
        Collection<ConstraintDefinition> modelConstraints = this.service.getConstraints(model);
        DictionaryDAOTest.assertEquals((int)15, (int)modelConstraints.size());
        QName conRegExp1QName = QName.createQName(TEST_URL, "regex1");
        boolean found1 = false;
        QName conStrLen1QName = QName.createQName(TEST_URL, "stringLength1");
        boolean found2 = false;
        for (ConstraintDefinition constraintDef : modelConstraints) {
            if (constraintDef.getName().equals(conRegExp1QName)) {
                DictionaryDAOTest.assertEquals((String)"Regex1 title", (String)constraintDef.getTitle());
                DictionaryDAOTest.assertEquals((String)"Regex1 description", (String)constraintDef.getDescription());
                found1 = true;
            }
            if (!constraintDef.getName().equals(conStrLen1QName)) continue;
            DictionaryDAOTest.assertNull((Object)constraintDef.getTitle());
            DictionaryDAOTest.assertNull((Object)constraintDef.getDescription());
            found2 = true;
        }
        DictionaryDAOTest.assertTrue((boolean)found1);
        DictionaryDAOTest.assertTrue((boolean)found2);
        QName propNoConstraintsQName = QName.createQName(TEST_URL, "fileprop");
        PropertyDefinition propNoConstraintsDef = this.service.getProperty(propNoConstraintsQName);
        DictionaryDAOTest.assertNotNull((String)"Property without constraints returned null list", propNoConstraintsDef.getConstraints());
        QName prop1QName = QName.createQName(TEST_URL, "prop1");
        PropertyDefinition propDef = this.service.getProperty(prop1QName);
        List<ConstraintDefinition> constraints = propDef.getConstraints();
        DictionaryDAOTest.assertNotNull((String)"Null constraints list", constraints);
        DictionaryDAOTest.assertEquals((String)"Incorrect number of constraints", (int)3, (int)constraints.size());
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(constraints.get(0).getConstraint() instanceof RegexConstraint));
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(constraints.get(1).getConstraint() instanceof StringLengthConstraint));
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(constraints.get(2).getConstraint() instanceof RegisteredConstraint));
        ConstraintDefinition constraintDef = constraints.get(0);
        DictionaryDAOTest.assertTrue((String)"Constraint anonymous name incorrect", (boolean)constraintDef.getName().getLocalName().startsWith("prop1_anon"));
        DictionaryDAOTest.assertTrue((String)"Constraint title incorrect", (boolean)constraintDef.getTitle().equals("Regex1 title"));
        DictionaryDAOTest.assertTrue((String)"Constraint description incorrect", (boolean)constraintDef.getDescription().equals("Regex1 description"));
        constraintDef = constraints.get(1);
        DictionaryDAOTest.assertTrue((String)"Constraint anonymous name incorrect", (boolean)constraintDef.getName().getLocalName().startsWith("prop1_anon"));
        DictionaryDAOTest.assertTrue((String)"Constraint title incorrect", (boolean)constraintDef.getTitle().equals("Prop1 Strlen1 title"));
        DictionaryDAOTest.assertTrue((String)"Constraint description incorrect", (boolean)constraintDef.getDescription().equals("Prop1 Strlen1 description"));
        Constraint constraint = constraintDef.getConstraint();
        DictionaryDAOTest.assertNotNull((String)"Reference constraint has no implementation", (Object)constraint);
    }

    public void testConstraintsOverrideInheritance() {
        QName baseQName = QName.createQName(TEST_URL, "base");
        QName fileQName = QName.createQName(TEST_URL, "file");
        QName folderQName = QName.createQName(TEST_URL, "folder");
        QName prop1QName = QName.createQName(TEST_URL, "prop1");
        PropertyDefinition prop1Def = this.service.getProperty(baseQName, prop1QName);
        DictionaryDAOTest.assertNotNull((Object)prop1Def);
        List<ConstraintDefinition> prop1Constraints = prop1Def.getConstraints();
        DictionaryDAOTest.assertEquals((String)"Incorrect number of constraints", (int)3, (int)prop1Constraints.size());
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(prop1Constraints.get(0).getConstraint() instanceof RegexConstraint));
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(prop1Constraints.get(1).getConstraint() instanceof StringLengthConstraint));
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(prop1Constraints.get(2).getConstraint() instanceof RegisteredConstraint));
        prop1Def = this.service.getProperty(folderQName, prop1QName);
        DictionaryDAOTest.assertNotNull((Object)prop1Def);
        prop1Constraints = prop1Def.getConstraints();
        DictionaryDAOTest.assertEquals((String)"Incorrect number of constraints", (int)3, (int)prop1Constraints.size());
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(prop1Constraints.get(0).getConstraint() instanceof RegexConstraint));
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(prop1Constraints.get(1).getConstraint() instanceof StringLengthConstraint));
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(prop1Constraints.get(2).getConstraint() instanceof RegisteredConstraint));
        prop1Def = this.service.getProperty(fileQName, prop1QName);
        DictionaryDAOTest.assertNotNull((Object)prop1Def);
        prop1Constraints = prop1Def.getConstraints();
        DictionaryDAOTest.assertEquals((String)"Incorrect number of constraints", (int)3, (int)prop1Constraints.size());
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(prop1Constraints.get(0).getConstraint() instanceof StringLengthConstraint));
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(prop1Constraints.get(1).getConstraint() instanceof RegexConstraint));
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(prop1Constraints.get(2).getConstraint() instanceof RegisteredConstraint));
    }

    public void testArchive() {
        QName testFileQName = QName.createQName(TEST_URL, "file");
        ClassDefinition fileClassDef = this.service.getClass(testFileQName);
        DictionaryDAOTest.assertTrue((String)"File type should have the archive flag", (boolean)fileClassDef.getArchive());
        QName testFileDerivedQName = QName.createQName(TEST_URL, "file-derived");
        ClassDefinition fileDerivedClassDef = this.service.getClass(testFileDerivedQName);
        DictionaryDAOTest.assertTrue((String)"Direct derived File type should have the archive flag", (boolean)fileDerivedClassDef.getArchive());
        QName testFileDerivedNoArchiveQName = QName.createQName(TEST_URL, "file-derived-no-archive");
        ClassDefinition fileDerivedNoArchiveClassDef = this.service.getClass(testFileDerivedNoArchiveQName);
        DictionaryDAOTest.assertFalse((String)"Derived File with archive override type should NOT have the archive flag", (boolean)fileDerivedNoArchiveClassDef.getArchive());
        QName testFolderQName = QName.createQName(TEST_URL, "folder");
        ClassDefinition folderClassDef = this.service.getClass(testFolderQName);
        DictionaryDAOTest.assertNull((String)"Folder type should not have the archive flag", (Object)folderClassDef.getArchive());
    }

    public void testMandatoryEnforced() {
        QName testEnforcedQName = QName.createQName(TEST_URL, "enforced");
        ClassDefinition testEnforcedClassDef = this.service.getClass(testEnforcedQName);
        Map<QName, PropertyDefinition> testEnforcedPropertyDefs = testEnforcedClassDef.getProperties();
        PropertyDefinition propertyDef = null;
        QName testMandatoryEnforcedQName = QName.createQName(TEST_URL, "mandatory-enforced");
        propertyDef = testEnforcedPropertyDefs.get(testMandatoryEnforcedQName);
        DictionaryDAOTest.assertNotNull((String)("Property not found: " + testMandatoryEnforcedQName), (Object)propertyDef);
        DictionaryDAOTest.assertTrue((String)("Expected property to be mandatory: " + testMandatoryEnforcedQName), (boolean)propertyDef.isMandatory());
        DictionaryDAOTest.assertTrue((String)("Expected property to be mandatory-enforced: " + testMandatoryEnforcedQName), (boolean)propertyDef.isMandatoryEnforced());
        QName testMandatoryNotEnforcedQName = QName.createQName(TEST_URL, "mandatory-not-enforced");
        propertyDef = testEnforcedPropertyDefs.get(testMandatoryNotEnforcedQName);
        DictionaryDAOTest.assertNotNull((String)("Property not found: " + testMandatoryNotEnforcedQName), (Object)propertyDef);
        DictionaryDAOTest.assertTrue((String)("Expected property to be mandatory: " + testMandatoryNotEnforcedQName), (boolean)propertyDef.isMandatory());
        DictionaryDAOTest.assertFalse((String)("Expected property to be mandatory-not-enforced: " + testMandatoryNotEnforcedQName), (boolean)propertyDef.isMandatoryEnforced());
        QName testMandatoryDefaultEnforcedQName = QName.createQName(TEST_URL, "mandatory-default-enforced");
        propertyDef = testEnforcedPropertyDefs.get(testMandatoryDefaultEnforcedQName);
        DictionaryDAOTest.assertNotNull((String)("Property not found: " + testMandatoryDefaultEnforcedQName), (Object)propertyDef);
        DictionaryDAOTest.assertTrue((String)("Expected property to be mandatory: " + testMandatoryDefaultEnforcedQName), (boolean)propertyDef.isMandatory());
        DictionaryDAOTest.assertFalse((String)("Expected property to be mandatory-not-enforced: " + testMandatoryDefaultEnforcedQName), (boolean)propertyDef.isMandatoryEnforced());
    }

    public void testSubClassOf() {
        QName invalid = QName.createQName(TEST_URL, "invalid");
        QName base = QName.createQName(TEST_URL, "base");
        QName file = QName.createQName(TEST_URL, "file");
        QName folder = QName.createQName(TEST_URL, "folder");
        QName referenceable = QName.createQName(TEST_URL, "referenceable");
        boolean testI1 = this.service.isSubClass(invalid, referenceable);
        DictionaryDAOTest.assertFalse((boolean)testI1);
        boolean testI2 = this.service.isSubClass(referenceable, invalid);
        DictionaryDAOTest.assertFalse((boolean)testI2);
        boolean testI3 = this.service.isSubClass(invalid, invalid);
        DictionaryDAOTest.assertFalse((boolean)testI3);
        boolean test1 = this.service.isSubClass(file, referenceable);
        DictionaryDAOTest.assertFalse((boolean)test1);
        boolean test2 = this.service.isSubClass(file, folder);
        DictionaryDAOTest.assertFalse((boolean)test2);
        boolean test3 = this.service.isSubClass(file, file);
        DictionaryDAOTest.assertTrue((boolean)test3);
        boolean test4 = this.service.isSubClass(folder, base);
        DictionaryDAOTest.assertTrue((boolean)test4);
        boolean test5 = this.service.isSubClass(base, folder);
        DictionaryDAOTest.assertFalse((boolean)test5);
    }

    public void testPropertyOverride() {
        TypeDefinition type1 = this.service.getType(QName.createQName(TEST_URL, "overridetype1"));
        Map<QName, PropertyDefinition> props1 = type1.getProperties();
        PropertyDefinition prop1 = props1.get(QName.createQName(TEST_URL, "propoverride"));
        String def1 = prop1.getDefaultValue();
        DictionaryDAOTest.assertEquals((String)"one", (String)def1);
        TypeDefinition type2 = this.service.getType(QName.createQName(TEST_URL, "overridetype2"));
        Map<QName, PropertyDefinition> props2 = type2.getProperties();
        PropertyDefinition prop2 = props2.get(QName.createQName(TEST_URL, "propoverride"));
        String def2 = prop2.getDefaultValue();
        DictionaryDAOTest.assertEquals((String)"two", (String)def2);
        TypeDefinition type3 = this.service.getType(QName.createQName(TEST_URL, "overridetype3"));
        Map<QName, PropertyDefinition> props3 = type3.getProperties();
        PropertyDefinition prop3 = props3.get(QName.createQName(TEST_URL, "propoverride"));
        String def3 = prop3.getDefaultValue();
        DictionaryDAOTest.assertEquals((String)"three", (String)def3);
    }

    public void testChildAssocPropagate() {
        AssociationDefinition assocDef = this.service.getAssociation(QName.createQName(TEST_URL, "childassoc1"));
        DictionaryDAOTest.assertNotNull((String)"No such child association found", (Object)assocDef);
        DictionaryDAOTest.assertTrue((String)"Expected a child association", (boolean)(assocDef instanceof ChildAssociationDefinition));
        ChildAssociationDefinition childAssocDef = (ChildAssociationDefinition)assocDef;
        DictionaryDAOTest.assertFalse((String)"Expected 'false' for default timestamp propagation", (boolean)childAssocDef.getPropagateTimestamps());
        assocDef = this.service.getAssociation(QName.createQName(TEST_URL, "childassocPropagate"));
        DictionaryDAOTest.assertNotNull((String)"No such child association found", (Object)assocDef);
        DictionaryDAOTest.assertTrue((String)"Expected a child association", (boolean)(assocDef instanceof ChildAssociationDefinition));
        childAssocDef = (ChildAssociationDefinition)assocDef;
        DictionaryDAOTest.assertTrue((String)"Expected 'true' for timestamp propagation", (boolean)childAssocDef.getPropagateTimestamps());
    }
}

