/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository.datatype;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeConverter {
    private Map<Class, Map<Class, Converter>> conversions = new HashMap<Class, Map<Class, Converter>>();

    public final Object convert(DataTypeDefinition propertyType, Object value) {
        ParameterCheck.mandatory((String)"Property type definition", (Object)propertyType);
        Class<?> javaClass = null;
        String javaClassName = propertyType.getJavaClassName();
        try {
            javaClass = Class.forName(javaClassName);
        }
        catch (ClassNotFoundException e) {
            throw new DictionaryException("Java class " + javaClassName + " of property type " + propertyType.getName() + " is invalid", e);
        }
        return this.convert(javaClass, value);
    }

    public final <T> T convert(Class<T> c, Object value) {
        if (value == null) {
            return null;
        }
        if (c.isPrimitive()) {
            throw new TypeConversionException("Can not convert direct to primitive type " + c.getName());
        }
        if (c.isInstance(value)) {
            return c.cast(value);
        }
        Converter converter = this.getConverter(value, c);
        if (converter == null) {
            throw new TypeConversionException("There is no conversion registered for the value: \n   value class: " + value.getClass().getName() + "\n" + "   to class: " + c.getName() + "\n" + "   value: " + value.toString());
        }
        return converter.convert(value);
    }

    public final Collection convert(DataTypeDefinition propertyType, Object[] values) {
        if (values == null) {
            return this.convert(propertyType, (Collection)null);
        }
        ArrayList<Object> c = new ArrayList<Object>();
        c.ensureCapacity(values.length);
        for (Object v : values) {
            c.add(v);
        }
        return this.convert(propertyType, c);
    }

    public final Collection convert(DataTypeDefinition propertyType, Collection values) {
        ParameterCheck.mandatory((String)"Property type definition", (Object)propertyType);
        Class<?> javaClass = null;
        String javaClassName = propertyType.getJavaClassName();
        try {
            javaClass = Class.forName(javaClassName);
        }
        catch (ClassNotFoundException e) {
            throw new DictionaryException("Java class " + javaClassName + " of property type " + propertyType.getName() + " is invalid", e);
        }
        return this.convert(javaClass, values);
    }

    public final <T> Collection<T> convert(Class<T> c, Collection values) {
        if (values == null) {
            return null;
        }
        ArrayList<T> converted = new ArrayList<T>(values.size());
        for (Object value : values) {
            converted.add(this.convert(c, value));
        }
        return converted;
    }

    public final boolean booleanValue(Object value) {
        return this.convert(Boolean.class, value);
    }

    public final char charValue(Object value) {
        return this.convert(Character.class, value).charValue();
    }

    public final byte byteValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        return this.convert(Byte.class, value);
    }

    public final short shortValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        return this.convert(Short.class, value);
    }

    public final int intValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return this.convert(Integer.class, value);
    }

    public final long longValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return this.convert(Long.class, value);
    }

    public final float floatValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        return this.convert(Float.class, value).floatValue();
    }

    public final double doubleValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return this.convert(Double.class, value);
    }

    public final boolean isMultiValued(Object value) {
        return value instanceof Collection;
    }

    public final int size(Object value) {
        if (value instanceof Collection) {
            return ((Collection)value).size();
        }
        return 1;
    }

    private final Collection createCollection(Object value) {
        ArrayList<Object> coll;
        if (this.isMultiValued(value)) {
            coll = (ArrayList<Object>)value;
        } else {
            ArrayList<Object> list = new ArrayList<Object>(1);
            list.add(value);
            coll = list;
        }
        return coll;
    }

    public final <T> Collection<T> getCollection(Class<T> c, Object value) {
        Collection coll = this.createCollection(value);
        return this.convert(c, coll);
    }

    public final <F, T> void addConverter(Class<F> source, Class<T> destination, Converter<F, T> converter) {
        Map<Class, Converter> map = this.conversions.get(source);
        if (map == null) {
            map = new HashMap<Class, Converter>();
            this.conversions.put(source, map);
        }
        map.put(destination, converter);
    }

    public final <F, I, T> Converter<F, T> addDynamicTwoStageConverter(Class<F> source, Class<I> intermediate, Class<T> destination) {
        DynamicTwoStageConverter<F, I, T> converter = new DynamicTwoStageConverter<F, I, T>(source, intermediate, destination);
        this.addConverter(source, destination, converter);
        return converter;
    }

    public final <T> Converter getConverter(Object value, Class<T> dest) {
        Converter converter = null;
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        converter = this.getConverter(valueClass, dest);
        if (converter != null) {
            return converter;
        }
        do {
            Class<?>[] ifClasses;
            for (Class<?> ifClass : ifClasses = valueClass.getInterfaces()) {
                converter = this.getConverter(ifClass, dest);
                if (converter == null) continue;
                return converter;
            }
        } while ((valueClass = valueClass.getSuperclass()) != null);
        return null;
    }

    public <F, T> Converter getConverter(Class<F> source, Class<T> dest) {
        TwoStageConverter converter = null;
        Class<F> clazz = source;
        do {
            Map<Class, Converter> map;
            if ((map = this.conversions.get(clazz)) == null || (converter = map.get(dest)) != null) continue;
            Converter first = map.get(Number.class);
            Converter second = null;
            if (first != null && (map = this.conversions.get(Number.class)) != null) {
                second = map.get(dest);
            }
            if (second == null) continue;
            converter = new TwoStageConverter(first, second);
        } while (converter == null && (clazz = clazz.getSuperclass()) != null);
        return converter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DynamicTwoStageConverter<F, I, T>
    implements Converter<F, T> {
        Class<F> from;
        Class<I> intermediate;
        Class<T> to;

        DynamicTwoStageConverter(Class<F> from, Class<I> intermediate, Class<T> to) {
            this.from = from;
            this.intermediate = intermediate;
            this.to = to;
        }

        public Class<F> getFrom() {
            return this.from;
        }

        public Class<I> getIntermediate() {
            return this.intermediate;
        }

        public Class<T> getTo() {
            return this.to;
        }

        @Override
        public T convert(F source) {
            Converter iConverter = TypeConverter.this.getConverter(this.from, this.intermediate);
            Converter tConverter = TypeConverter.this.getConverter(this.intermediate, this.to);
            if (iConverter == null || tConverter == null) {
                throw new TypeConversionException("Cannot convert from " + this.from.getName() + " to " + this.to.getName());
            }
            Object iValue = iConverter.convert(source);
            Object tValue = tConverter.convert(iValue);
            return tValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TwoStageConverter<F, I, T>
    implements Converter<F, T> {
        Converter first;
        Converter second;

        TwoStageConverter(Converter first, Converter second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public T convert(F source) {
            return this.second.convert(this.first.convert(source));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Converter<F, T> {
        public T convert(F var1);
    }
}

