/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.impl.querymodel.QueryOptions;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.PermissionEvaluationMode;
import org.alfresco.service.cmr.search.QueryParameterDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchParameters {
    private static int DEFAULT_LIMIT = 500;
    public static final SortDefinition SORT_IN_DOCUMENT_ORDER_ASCENDING = new SortDefinition(SortDefinition.SortType.DOCUMENT, null, true);
    public static final SortDefinition SORT_IN_DOCUMENT_ORDER_DESCENDING = new SortDefinition(SortDefinition.SortType.DOCUMENT, null, false);
    public static final SortDefinition SORT_IN_SCORE_ORDER_ASCENDING = new SortDefinition(SortDefinition.SortType.SCORE, null, false);
    public static final SortDefinition SORT_IN_SCORE_ORDER_DESCENDING = new SortDefinition(SortDefinition.SortType.SCORE, null, true);
    public static final Operator OR = Operator.OR;
    public static final Operator AND = Operator.AND;
    private String language;
    private String query;
    private ArrayList<StoreRef> stores = new ArrayList(1);
    private ArrayList<QueryParameterDefinition> queryParameterDefinitions = new ArrayList(1);
    private boolean excludeDataInTheCurrentTransaction = false;
    private ArrayList<SortDefinition> sortDefinitions = new ArrayList(1);
    private ArrayList<Locale> locales = new ArrayList();
    private MLAnalysisMode mlAnalaysisMode = null;
    private LimitBy limitBy = LimitBy.UNLIMITED;
    private PermissionEvaluationMode permissionEvaluation = PermissionEvaluationMode.EAGER;
    private int limit = DEFAULT_LIMIT;
    private HashSet<String> allAttributes = new HashSet();
    private HashSet<String> textAttributes = new HashSet();
    private int maxItems = -1;
    private int skipCount = 0;
    private Operator defaultFTSOperator = Operator.OR;
    private Operator defaultFTSFieldOperator = Operator.OR;
    private Map<String, String> queryTemplates = new HashMap<String, String>();
    private String namespace = "http://www.alfresco.org/model/content/1.0";
    private int maxPermissionChecks = -1;
    private long maxPermissionCheckTimeMillis = -1L;
    private String defaultFieldName = "TEXT";

    public SearchParameters() {
    }

    public SearchParameters(QueryOptions options) {
        this.setSkipCount(options.getSkipCount());
        this.setMaxPermissionChecks(options.getMaxPermissionChecks());
        this.setMaxPermissionCheckTimeMillis(options.getMaxPermissionCheckTimeMillis());
        if (options.getMaxItems() >= 0) {
            this.setLimitBy(LimitBy.FINAL_SIZE);
            this.setLimit(options.getMaxItems());
            this.setMaxItems(options.getMaxItems());
        } else {
            this.setLimitBy(LimitBy.UNLIMITED);
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public String getQuery() {
        return this.query;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void addStore(StoreRef store) {
        if (this.stores.size() != 0) {
            throw new IllegalStateException("At the moment, there can only be one store set for the search");
        }
        this.stores.add(store);
    }

    public void addQueryParameterDefinition(QueryParameterDefinition queryParameterDefinition) {
        this.queryParameterDefinitions.add(queryParameterDefinition);
    }

    public void excludeDataInTheCurrentTransaction(boolean excludeDataInTheCurrentTransaction) {
        this.excludeDataInTheCurrentTransaction = excludeDataInTheCurrentTransaction;
    }

    public void addSort(String field, boolean ascending) {
        this.addSort(new SortDefinition(SortDefinition.SortType.FIELD, field, ascending));
    }

    public void addSort(SortDefinition sortDefinition) {
        this.sortDefinitions.add(sortDefinition);
    }

    public boolean excludeDataInTheCurrentTransaction() {
        return this.excludeDataInTheCurrentTransaction;
    }

    public ArrayList<QueryParameterDefinition> getQueryParameterDefinitions() {
        return this.queryParameterDefinitions;
    }

    public ArrayList<SortDefinition> getSortDefinitions() {
        return this.sortDefinitions;
    }

    public ArrayList<StoreRef> getStores() {
        return this.stores;
    }

    public void setDefaultOperator(Operator defaultOperator) {
        this.defaultFTSOperator = defaultOperator;
        this.defaultFTSFieldOperator = defaultOperator;
    }

    public Operator getDefaultOperator() {
        return this.getDefaultFTSOperator();
    }

    public LimitBy getLimitBy() {
        return this.limitBy;
    }

    public void setLimitBy(LimitBy limitBy) {
        this.limitBy = limitBy;
    }

    public PermissionEvaluationMode getPermissionEvaluation() {
        return this.permissionEvaluation;
    }

    public void setPermissionEvaluation(PermissionEvaluationMode permissionEvaluation) {
        this.permissionEvaluation = permissionEvaluation;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public MLAnalysisMode getMlAnalaysisMode() {
        return this.mlAnalaysisMode;
    }

    public void setMlAnalaysisMode(MLAnalysisMode mlAnalaysisMode) {
        this.mlAnalaysisMode = mlAnalaysisMode;
    }

    public void addLocale(Locale locale) {
        this.locales.add(locale);
    }

    public List<Locale> getLocales() {
        return Collections.unmodifiableList(this.locales);
    }

    public void addTextAttribute(String attribute) {
        this.textAttributes.add(attribute);
    }

    public Set<String> getTextAttributes() {
        return Collections.unmodifiableSet(this.textAttributes);
    }

    public void addAllAttribute(String attribute) {
        this.allAttributes.add(attribute);
    }

    public Set<String> getAllAttributes() {
        return Collections.unmodifiableSet(this.allAttributes);
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(int maxItems) {
        this.maxItems = maxItems;
    }

    public int getSkipCount() {
        return this.skipCount;
    }

    public void setSkipCount(int skipCount) {
        this.skipCount = skipCount;
    }

    public Operator getDefaultFTSOperator() {
        return this.defaultFTSOperator;
    }

    public void setDefaultFTSOperator(Operator defaultFTSOperator) {
        this.defaultFTSOperator = defaultFTSOperator;
    }

    public Operator getDefaultFTSFieldOperator() {
        return this.defaultFTSFieldOperator;
    }

    public void setDefaultFTSFieldConnective(Operator defaultFTSFieldOperator) {
        this.defaultFTSFieldOperator = defaultFTSFieldOperator;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Map<String, String> getQueryTemplates() {
        return this.queryTemplates;
    }

    public String addQueryTemplate(String name, String template) {
        return this.queryTemplates.put(name, template);
    }

    public long getMaxPermissionCheckTimeMillis() {
        return this.maxPermissionCheckTimeMillis;
    }

    public void setMaxPermissionCheckTimeMillis(long maxPermissionCheckTimeMillis) {
        this.maxPermissionCheckTimeMillis = maxPermissionCheckTimeMillis;
    }

    public int getMaxPermissionChecks() {
        return this.maxPermissionChecks;
    }

    public void setMaxPermissionChecks(int maxPermissionChecks) {
        this.maxPermissionChecks = maxPermissionChecks;
    }

    public String getDefaultFieldName() {
        return this.defaultFieldName;
    }

    public void setDefaultFieldName(String defaultFieldName) {
        this.defaultFieldName = defaultFieldName;
    }

    public String toString() {
        return "SearchParameters [allAttributes=" + this.allAttributes + ", defaultFTSFieldOperator=" + (Object)((Object)this.defaultFTSFieldOperator) + ", defaultFTSOperator=" + (Object)((Object)this.defaultFTSOperator) + ", defaultFieldName=" + this.defaultFieldName + ", excludeDataInTheCurrentTransaction=" + this.excludeDataInTheCurrentTransaction + ", language=" + this.language + ", limit=" + this.limit + ", limitBy=" + (Object)((Object)this.limitBy) + ", locales=" + this.locales + ", maxItems=" + this.maxItems + ", maxPermissionCheckTimeMillis=" + this.maxPermissionCheckTimeMillis + ", maxPermissionChecks=" + this.maxPermissionChecks + ", mlAnalaysisMode=" + (Object)((Object)this.mlAnalaysisMode) + ", namespace=" + this.namespace + ", permissionEvaluation=" + (Object)((Object)this.permissionEvaluation) + ", query=" + this.query + ", queryParameterDefinitions=" + this.queryParameterDefinitions + ", queryTemplates=" + this.queryTemplates + ", skipCount=" + this.skipCount + ", sortDefinitions=" + this.sortDefinitions + ", stores=" + this.stores + ", textAttributes=" + this.textAttributes + "]";
    }

    public static class SortDefinition {
        SortType sortType;
        String field;
        boolean ascending;

        SortDefinition(SortType sortType, String field, boolean ascending) {
            this.sortType = sortType;
            this.field = field;
            this.ascending = ascending;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public String getField() {
            return this.field;
        }

        public SortType getSortType() {
            return this.sortType;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum SortType {
            FIELD,
            DOCUMENT,
            SCORE;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        OR,
        AND;

    }
}

