/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.Arrays;
import org.alfresco.util.LazyClassPathXmlApplicationContext;
import org.alfresco.util.NoAutoStartClassPathXmlApplicationContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public abstract class BaseApplicationContextHelper {
    private static ClassPathXmlApplicationContext instance;
    private static String[] usedConfiguration;
    private static boolean useLazyLoading;
    private static boolean noAutoStart;

    public static synchronized ApplicationContext getApplicationContext(String[] configLocations) {
        if (configLocations == null) {
            throw new IllegalArgumentException("configLocations argument is mandatory.");
        }
        if (usedConfiguration != null && Arrays.deepEquals(configLocations, usedConfiguration)) {
            return instance;
        }
        BaseApplicationContextHelper.closeApplicationContext();
        instance = useLazyLoading || noAutoStart ? new VariableFeatureClassPathXmlApplicationContext(configLocations) : new ClassPathXmlApplicationContext(configLocations);
        usedConfiguration = configLocations;
        return instance;
    }

    public static synchronized void closeApplicationContext() {
        if (instance == null) {
            return;
        }
        instance.close();
        instance = null;
        usedConfiguration = null;
    }

    public static void setUseLazyLoading(boolean lazyLoading) {
        useLazyLoading = lazyLoading;
    }

    public static boolean isUsingLazyLoading() {
        return useLazyLoading;
    }

    public static void setNoAutoStart(boolean noAutoStart) {
        BaseApplicationContextHelper.noAutoStart = noAutoStart;
    }

    public static boolean isNoAutoStart() {
        return noAutoStart;
    }

    static {
        useLazyLoading = false;
        noAutoStart = false;
    }

    protected static class VariableFeatureClassPathXmlApplicationContext
    extends ClassPathXmlApplicationContext {
        protected VariableFeatureClassPathXmlApplicationContext(String[] configLocations) throws BeansException {
            super(configLocations);
        }

        protected void initBeanDefinitionReader(XmlBeanDefinitionReader reader) {
            super.initBeanDefinitionReader(reader);
            if (useLazyLoading) {
                LazyClassPathXmlApplicationContext.postInitBeanDefinitionReader(reader);
            }
            if (noAutoStart) {
                NoAutoStartClassPathXmlApplicationContext.postInitBeanDefinitionReader(reader);
            }
        }
    }
}

