/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.alfresco;

import java.util.Enumeration;
import org.alfresco.filesys.AlfrescoConfigSection;
import org.alfresco.filesys.alfresco.AlfrescoClientInfo;
import org.alfresco.filesys.repo.ContentContext;
import org.alfresco.filesys.repo.ContentDiskDriver;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.auth.InvalidUserException;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.server.config.ServerConfigurationAccessor;
import org.alfresco.jlan.server.core.DeviceInterface;
import org.alfresco.jlan.server.core.ShareMapper;
import org.alfresco.jlan.server.core.ShareType;
import org.alfresco.jlan.server.core.SharedDevice;
import org.alfresco.jlan.server.core.SharedDeviceList;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskInterface;
import org.alfresco.jlan.server.filesys.DiskSharedDevice;
import org.alfresco.jlan.server.filesys.FilesystemsConfigSection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.ConfigElement;

public class HomeShareMapper
implements ShareMapper {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.smb.protocol");
    public static final String HOME_FOLDER_SHARE = "HOME";
    private ServerConfigurationAccessor m_config;
    private DiskInterface m_repoDiskInterface;
    private String m_homeShareName = "HOME";
    private boolean m_debug;

    public void setConfig(ServerConfiguration config) {
        this.m_config = config;
    }

    public void setRepoDiskInterface(DiskInterface diskInterface) {
        this.m_repoDiskInterface = diskInterface;
    }

    public void setHomeShareName(String shareName) {
        this.m_homeShareName = shareName;
    }

    public void setDebug(boolean m_debug) {
        this.m_debug = m_debug;
    }

    public void initializeMapper(ServerConfiguration config, ConfigElement params) throws InvalidConfigurationException {
        this.setConfig(config);
        this.setRepoDiskInterface(((AlfrescoConfigSection)this.m_config.getConfigSection("Alfresco")).getRepoDiskInterface());
        String homeName = params.getAttribute("name");
        if (homeName != null && homeName.length() > 0) {
            this.setHomeShareName(homeName);
        }
        if (params != null && params.getChild("debug") != null) {
            this.setDebug(true);
        }
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public final String getHomeFolderName() {
        return this.m_homeShareName;
    }

    public SharedDeviceList getShareList(String host, SrvSession sess, boolean allShares) {
        AlfrescoClientInfo client;
        if (sess != null && sess.hasClientInformation() && !sess.hasDynamicShares() && sess.getClientInformation() instanceof AlfrescoClientInfo && (client = (AlfrescoClientInfo)sess.getClientInformation()).hasHomeFolder()) {
            DiskSharedDevice homeShare = this.createHomeDiskShare(client);
            sess.addDynamicShare((SharedDevice)homeShare);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Added " + this.getHomeFolderName() + " share to list of shares for " + client.getUserName()));
            }
        }
        SharedDeviceList shrList = new SharedDeviceList(this.getFilesystemsConfigSection().getShares());
        if (sess != null && sess.hasDynamicShares()) {
            shrList.addShares(sess.getDynamicShareList());
        }
        if (!allShares) {
            shrList.removeUnavailableShares();
        }
        return shrList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SharedDevice findShare(String tohost, String name, int typ, SrvSession sess, boolean create) throws Exception {
        SharedDevice share = null;
        if ((typ == 0 || typ == -1) && name.equalsIgnoreCase(this.getHomeFolderName()) && sess.getClientInformation() != null && sess.getClientInformation() instanceof AlfrescoClientInfo) {
            AlfrescoClientInfo client = (AlfrescoClientInfo)sess.getClientInformation();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Map share " + name + ", type=" + ShareType.TypeAsString((int)typ) + ", client=" + (Object)((Object)client)));
            }
            if (client == null) throw new InvalidUserException("No home directory");
            if (!client.hasHomeFolder()) throw new InvalidUserException("No home directory");
            if (sess.hasDynamicShares()) {
                share = sess.getDynamicShareList().findShare(name, typ, false);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("  Reusing existing dynamic share for " + name));
                }
            }
            if (share == null && create) {
                DiskSharedDevice diskShare = this.createHomeDiskShare(client);
                sess.addDynamicShare((SharedDevice)diskShare);
                share = diskShare;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("  Mapped share " + name + " to " + client.getHomeFolder()));
                }
            }
        } else {
            FilesystemsConfigSection filesystemsConfigSection = this.getFilesystemsConfigSection();
            share = filesystemsConfigSection.getShares().findShare(name, typ, false);
            if (share == null) {
                share = filesystemsConfigSection.getShares().findShare(name, typ, true);
            }
        }
        if (share == null) return share;
        if (share.getContext() == null) return share;
        if (share.getContext().isAvailable()) return share;
        return null;
    }

    public void deleteShares(SrvSession sess) {
        if (!sess.hasDynamicShares()) {
            return;
        }
        SharedDeviceList shares = sess.getDynamicShareList();
        Enumeration enm = shares.enumerateShares();
        while (enm.hasMoreElements()) {
            SharedDevice shr = (SharedDevice)enm.nextElement();
            shr.getContext().CloseContext();
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Deleted dynamic share " + shr));
        }
        shares.removeAllShares();
    }

    public void closeMapper() {
    }

    private final DiskSharedDevice createHomeDiskShare(AlfrescoClientInfo client) {
        ContentDiskDriver diskDrv = (ContentDiskDriver)this.getRepoDiskInterface();
        ContentContext diskCtx = new ContentContext(this.getHomeFolderName(), "", "", client.getHomeFolder());
        diskCtx.enableStateCache(true);
        return new DiskSharedDevice(this.getHomeFolderName(), (DeviceInterface)diskDrv, (DiskDeviceContext)diskCtx, 8);
    }

    protected DiskInterface getRepoDiskInterface() {
        return this.m_repoDiskInterface;
    }

    protected FilesystemsConfigSection getFilesystemsConfigSection() {
        return (FilesystemsConfigSection)this.m_config.getConfigSection("Filesystems");
    }
}

