/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.auth.ftp;

import javax.transaction.UserTransaction;
import org.alfresco.filesys.AlfrescoConfigSection;
import org.alfresco.jlan.ftp.FTPAuthenticator;
import org.alfresco.jlan.ftp.FTPSrvSession;
import org.alfresco.jlan.server.auth.ClientInfo;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.server.config.ServerConfigurationAccessor;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.ntlm.NLTMAuthenticator;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.extensions.config.ConfigElement;

public abstract class FTPAuthenticatorBase
implements FTPAuthenticator,
ActivateableBean,
DisposableBean {
    protected static final Log logger = LogFactory.getLog((String)"org.alfresco.ftp.protocol.auth");
    protected ServerConfigurationAccessor serverConfiguration;
    private AuthenticationComponent authenticationComponent;
    private AuthenticationService authenticationService;
    private TransactionService transactionService;
    private AuthorityService authorityService;
    private boolean active = true;

    public void setConfig(ServerConfigurationAccessor config) {
        this.serverConfiguration = config;
    }

    public void setAuthenticationComponent(AuthenticationComponent authenticationComponent) {
        this.authenticationComponent = authenticationComponent;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void initialize(ServerConfiguration config, ConfigElement params) throws InvalidConfigurationException {
        this.setConfig((ServerConfigurationAccessor)config);
        AlfrescoConfigSection alfrescoConfig = (AlfrescoConfigSection)config.getConfigSection("Alfresco");
        this.setAuthenticationComponent(alfrescoConfig.getAuthenticationComponent());
        this.setAuthenticationService(alfrescoConfig.getAuthenticationService());
        this.setTransactionService(alfrescoConfig.getTransactionService());
        this.setAuthorityService(alfrescoConfig.getAuthorityService());
        this.initialize();
    }

    public void initialize() throws InvalidConfigurationException {
        if (this.serverConfiguration == null) {
            throw new InvalidConfigurationException("server configuration accessor property not set");
        }
    }

    public abstract boolean authenticateUser(ClientInfo var1, FTPSrvSession var2);

    public void closeAuthenticator() {
    }

    protected final AuthenticationComponent getAuthenticationComponent() {
        return this.authenticationComponent;
    }

    protected final NLTMAuthenticator getNTLMAuthenticator() {
        if (!(this.authenticationComponent instanceof NLTMAuthenticator)) {
            throw new IllegalStateException("Attempt to use non SSO-enabled authentication component for SSO");
        }
        return (NLTMAuthenticator)this.authenticationComponent;
    }

    protected final AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    protected final TransactionService getTransactionService() {
        return this.transactionService;
    }

    protected final AuthorityService getAuthorityService() {
        return this.authorityService;
    }

    protected final void checkForAdminUserName(ClientInfo cInfo) {
        UserTransaction tx = this.getTransactionService().getUserTransaction();
        try {
            tx.begin();
            if (cInfo.getLogonType() == 0 && this.getAuthorityService().isAdminAuthority(cInfo.getUserName())) {
                cInfo.setLogonType(3);
            }
            tx.commit();
        }
        catch (Throwable ex) {
            try {
                tx.rollback();
            }
            catch (Throwable ex2) {
                logger.error((Object)"Failed to rollback transaction", ex2);
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException("Error during execution of transaction.", ex);
        }
    }

    protected final UserTransaction createTransaction() {
        TransactionService txService = this.getTransactionService();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using " + (txService.isReadOnly() ? "ReadOnly" : "Write") + " transaction"));
        }
        return txService.getUserTransaction(txService.isReadOnly());
    }

    public void destroy() {
        this.closeAuthenticator();
    }
}

