/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.avm;

import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.SearchContext;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;

public class AVMSingleFileSearchContext
extends SearchContext {
    private AVMNodeDescriptor m_fileDetails;
    private boolean m_endOfSearch;
    private String m_relativePath;
    private boolean m_readOnly;

    public AVMSingleFileSearchContext(AVMNodeDescriptor fileDetails, String relPath, boolean readOnly) {
        this.m_fileDetails = fileDetails;
        this.m_relativePath = relPath;
        this.m_readOnly = readOnly;
    }

    public boolean hasMoreFiles() {
        return !this.m_endOfSearch;
    }

    public boolean nextFileInfo(FileInfo info) {
        if (this.m_endOfSearch) {
            return false;
        }
        info.setFileName(this.m_fileDetails.getName());
        if (this.m_fileDetails.isFile()) {
            info.setFileSize(this.m_fileDetails.getLength());
            info.setAllocationSize(this.m_fileDetails.getLength() + 512L & 0xFFFFFFFFFFFFFE00L);
        } else {
            info.setFileSize(0L);
        }
        info.setAccessDateTime(this.m_fileDetails.getAccessDate());
        info.setCreationDateTime(this.m_fileDetails.getCreateDate());
        info.setModifyDateTime(this.m_fileDetails.getModDate());
        int attr = 0;
        if (this.m_fileDetails.isDirectory()) {
            attr += 16;
        }
        if (this.m_fileDetails.getName().startsWith(".") || this.m_fileDetails.getName().equalsIgnoreCase("Desktop.ini") || this.m_fileDetails.getName().equalsIgnoreCase("Thumbs.db")) {
            attr += 2;
        }
        if (this.m_readOnly) {
            ++attr;
        }
        info.setFileAttributes(attr);
        info.setFileId(this.m_relativePath.hashCode());
        this.m_endOfSearch = true;
        return true;
    }

    public String nextFileName() {
        if (this.m_endOfSearch) {
            return null;
        }
        this.m_endOfSearch = true;
        return this.m_fileDetails.getName();
    }

    public int numberOfEntries() {
        return 1;
    }

    public int getResumeId() {
        return 1;
    }

    public boolean restartAt(int resumeId) {
        if (resumeId != 1) {
            return false;
        }
        this.m_endOfSearch = false;
        return true;
    }

    public boolean restartAt(FileInfo info) {
        return true;
    }
}

