/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.exporter;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.alfresco.jcr.dictionary.JCRNamespace;
import org.alfresco.jcr.dictionary.PropertyDefinitionImpl;
import org.alfresco.jcr.item.NodeImpl;
import org.alfresco.jcr.item.property.JCRMixinTypesProperty;
import org.alfresco.jcr.item.property.JCRPrimaryTypeProperty;
import org.alfresco.jcr.item.property.JCRUUIDProperty;
import org.alfresco.jcr.session.SessionImpl;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.view.Exporter;
import org.alfresco.service.cmr.view.ExporterContext;
import org.alfresco.service.cmr.view.ExporterException;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.surf.util.Base64;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class JCRSystemXMLExporter
implements Exporter {
    public static final String NODE_LOCALNAME = "node";
    public static final String NAME_LOCALNAME = "name";
    public static final String PROPERTY_LOCALNAME = "property";
    public static final String TYPE_LOCALNAME = "type";
    public static final String VALUE_LOCALNAME = "value";
    public static final QName NODE_QNAME = QName.createQName((String)JCRNamespace.SV_URI, (String)"node");
    public static final QName NAME_QNAME = QName.createQName((String)JCRNamespace.SV_URI, (String)"name");
    public static final QName PROPERTY_QNAME = QName.createQName((String)JCRNamespace.SV_URI, (String)"property");
    public static final QName TYPE_QNAME = QName.createQName((String)JCRNamespace.SV_URI, (String)"type");
    public static final QName VALUE_QNAME = QName.createQName((String)JCRNamespace.SV_URI, (String)"value");
    private SessionImpl session;
    private ContentHandler contentHandler;
    private static final AttributesImpl EMPTY_ATTRIBUTES = new AttributesImpl();

    public JCRSystemXMLExporter(SessionImpl session, ContentHandler contentHandler) {
        this.session = session;
        this.contentHandler = contentHandler;
    }

    public void start(ExporterContext exportNodeRef) {
        try {
            this.contentHandler.startDocument();
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process export start event", e);
        }
    }

    public void startNamespace(String prefix, String uri) {
        try {
            this.contentHandler.startPrefixMapping(prefix, uri);
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process start namespace event - prefix " + prefix + " uri " + uri, e);
        }
    }

    public void endNamespace(String prefix) {
        try {
            this.contentHandler.endPrefixMapping(prefix);
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process end namespace event - prefix " + prefix, e);
        }
    }

    public void startNode(NodeRef nodeRef) {
        try {
            String childName;
            NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
            NodeRef rootNode = nodeService.getRootNode(nodeRef.getStoreRef());
            if (rootNode.equals((Object)nodeRef)) {
                childName = "jcr:root";
            } else {
                Path path = nodeService.getPath(nodeRef);
                childName = path.last().getElementString();
            }
            QName childQName = QName.createQName((String)childName);
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute(NAME_QNAME.getNamespaceURI(), NAME_LOCALNAME, this.toPrefixString(NAME_QNAME), null, this.toPrefixString(childQName));
            this.contentHandler.startElement(NODE_QNAME.getNamespaceURI(), NODE_LOCALNAME, this.toPrefixString(NODE_QNAME), attrs);
            NodeImpl nodeImpl = new NodeImpl(this.session, nodeRef);
            JCRPrimaryTypeProperty primaryType = new JCRPrimaryTypeProperty(nodeImpl);
            this.startProperty(nodeRef, JCRPrimaryTypeProperty.PROPERTY_NAME);
            this.value(nodeRef, JCRPrimaryTypeProperty.PROPERTY_NAME, primaryType.getValue().getString(), -1);
            this.endProperty(nodeRef, JCRPrimaryTypeProperty.PROPERTY_NAME);
            JCRMixinTypesProperty mixinTypes = new JCRMixinTypesProperty(nodeImpl);
            this.startProperty(nodeRef, JCRMixinTypesProperty.PROPERTY_NAME);
            Value[] mixinValues = mixinTypes.getValues();
            for (int i = 0; i < mixinValues.length; ++i) {
                this.value(nodeRef, JCRMixinTypesProperty.PROPERTY_NAME, mixinValues[i].getString(), i);
            }
            this.endProperty(nodeRef, JCRMixinTypesProperty.PROPERTY_NAME);
            this.startProperty(nodeRef, JCRUUIDProperty.PROPERTY_NAME);
            this.value(nodeRef, JCRUUIDProperty.PROPERTY_NAME, nodeRef.getId(), -1);
            this.endProperty(nodeRef, JCRUUIDProperty.PROPERTY_NAME);
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process start node event - node ref " + nodeRef.toString(), e);
        }
        catch (RepositoryException e) {
            throw new ExporterException("Failed to process start node event - node ref " + nodeRef.toString(), e);
        }
    }

    public void endNode(NodeRef nodeRef) {
        try {
            this.contentHandler.endElement(NODE_QNAME.getNamespaceURI(), NODE_LOCALNAME, this.toPrefixString(NODE_QNAME));
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process end node event - node ref " + nodeRef.toString(), e);
        }
    }

    public void startAspects(NodeRef nodeRef) {
    }

    public void endAspects(NodeRef nodeRef) {
    }

    public void startAspect(NodeRef nodeRef, QName aspect) {
    }

    public void endAspect(NodeRef nodeRef, QName aspect) {
    }

    public void startACL(NodeRef nodeRef) {
    }

    public void permission(NodeRef nodeRef, AccessPermission permission) {
    }

    public void endACL(NodeRef nodeRef) {
    }

    public void startProperties(NodeRef nodeRef) {
    }

    public void endProperties(NodeRef nodeRef) {
    }

    public void startProperty(NodeRef nodeRef, QName property) {
        try {
            DictionaryService dictionaryService = this.session.getRepositoryImpl().getServiceRegistry().getDictionaryService();
            PropertyDefinition propDef = dictionaryService.getProperty(property);
            PropertyDefinitionImpl propDefImpl = new PropertyDefinitionImpl(this.session.getTypeManager(), propDef);
            String datatype = PropertyType.nameFromValue((int)propDefImpl.getRequiredType());
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute(NAME_QNAME.getNamespaceURI(), NAME_LOCALNAME, this.toPrefixString(NAME_QNAME), null, this.toPrefixString(property));
            attrs.addAttribute(TYPE_QNAME.getNamespaceURI(), TYPE_LOCALNAME, this.toPrefixString(TYPE_QNAME), null, datatype);
            this.contentHandler.startElement(PROPERTY_QNAME.getNamespaceURI(), PROPERTY_LOCALNAME, this.toPrefixString(PROPERTY_QNAME), attrs);
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process start property event - nodeRef " + nodeRef + "; property " + this.toPrefixString(property), e);
        }
    }

    public void endProperty(NodeRef nodeRef, QName property) {
        try {
            this.contentHandler.endElement(PROPERTY_QNAME.getNamespaceURI(), PROPERTY_LOCALNAME, this.toPrefixString(PROPERTY_QNAME));
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process end property event - nodeRef " + nodeRef + "; property " + this.toPrefixString(property), e);
        }
    }

    public void startValueCollection(NodeRef nodeRef, QName property) {
    }

    public void endValueCollection(NodeRef nodeRef, QName property) {
    }

    public void value(NodeRef nodeRef, QName property, Object value, int index) {
        try {
            this.contentHandler.startElement(VALUE_QNAME.getNamespaceURI(), VALUE_LOCALNAME, this.toPrefixString(VALUE_QNAME), EMPTY_ATTRIBUTES);
            String strValue = this.session.getTypeConverter().convert(String.class, value);
            this.contentHandler.characters(strValue.toCharArray(), 0, strValue.length());
            this.contentHandler.endElement(VALUE_QNAME.getNamespaceURI(), VALUE_LOCALNAME, this.toPrefixString(VALUE_QNAME));
        }
        catch (RepositoryException e) {
            throw new ExporterException("Failed to process value event - nodeRef " + nodeRef + "; property " + this.toPrefixString(property) + "; value " + value, e);
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process value event - nodeRef " + nodeRef + "; property " + this.toPrefixString(property) + "; value " + value, e);
        }
    }

    public void content(NodeRef nodeRef, QName property, InputStream content, ContentData contentData, int index) {
        try {
            this.contentHandler.startElement(VALUE_QNAME.getNamespaceURI(), VALUE_LOCALNAME, this.toPrefixString(VALUE_QNAME), EMPTY_ATTRIBUTES);
            if (content != null) {
                int read;
                Base64.InputStream base64content = new Base64.InputStream(content, 9);
                byte[] buffer = new byte[9216];
                while ((read = base64content.read(buffer, 0, buffer.length)) > 0) {
                    String characters = new String(buffer, 0, read);
                    this.contentHandler.characters(characters.toCharArray(), 0, characters.length());
                }
            }
            this.contentHandler.endElement(VALUE_QNAME.getNamespaceURI(), VALUE_LOCALNAME, this.toPrefixString(VALUE_QNAME));
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process content event - nodeRef " + nodeRef + "; property " + this.toPrefixString(property));
        }
        catch (IOException e) {
            throw new ExporterException("Failed to process content event - nodeRef " + nodeRef + "; property " + this.toPrefixString(property));
        }
    }

    public void startAssoc(NodeRef nodeRef, QName assoc) {
    }

    public void endAssoc(NodeRef nodeRef, QName assoc) {
    }

    public void startAssocs(NodeRef nodeRef) {
    }

    public void endAssocs(NodeRef nodeRef) {
    }

    public void startReference(NodeRef nodeRef, QName childName) {
    }

    public void endReference(NodeRef nodeRef) {
    }

    public void endValueMLText(NodeRef nodeRef) {
    }

    public void startValueMLText(NodeRef nodeRef, Locale locale) {
    }

    public void warning(String warning) {
    }

    public void end() {
        try {
            this.contentHandler.endDocument();
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process end export event", e);
        }
    }

    private String toPrefixString(QName qname) {
        return qname.toPrefixString(this.session.getNamespaceResolver());
    }
}

