/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action;

import java.util.List;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.ActionImplTest;
import org.alfresco.repo.action.CompositeActionImpl;
import org.alfresco.service.cmr.action.Action;

public class CompositeActionImplTest
extends ActionImplTest {
    private static final String ACTION1_ID = "action1Id";
    private static final String ACTION2_ID = "action2Id";
    private static final String ACTION3_ID = "action3Id";
    private static final String ACTION1_NAME = "actionName1";
    private static final String ACTION2_NAME = "actionName1";
    private static final String ACTION3_NAME = "actionName3";

    public void testActions() {
        ActionImpl action1 = new ActionImpl(null, ACTION1_ID, "actionName1", null);
        ActionImpl action2 = new ActionImpl(null, ACTION2_ID, "actionName1", null);
        ActionImpl action3 = new ActionImpl(null, ACTION3_ID, ACTION3_NAME, null);
        CompositeActionImpl compositeAction = new CompositeActionImpl(null, "id");
        CompositeActionImplTest.assertFalse((boolean)compositeAction.hasActions());
        List noActions = compositeAction.getActions();
        CompositeActionImplTest.assertNotNull(noActions);
        CompositeActionImplTest.assertEquals((int)0, (int)noActions.size());
        compositeAction.addAction(action1);
        compositeAction.addAction(action2);
        compositeAction.addAction(action3);
        CompositeActionImplTest.assertTrue((boolean)compositeAction.hasActions());
        List actions = compositeAction.getActions();
        CompositeActionImplTest.assertNotNull(actions);
        CompositeActionImplTest.assertEquals((int)3, (int)actions.size());
        int counter = 0;
        for (Action action : actions) {
            if (counter == 0) {
                CompositeActionImplTest.assertEquals((Object)action1, (Object)action);
            } else if (counter == 1) {
                CompositeActionImplTest.assertEquals((Object)action2, (Object)action);
            } else if (counter == 2) {
                CompositeActionImplTest.assertEquals((Object)action3, (Object)action);
            }
            ++counter;
        }
        CompositeActionImplTest.assertEquals((Object)action1, compositeAction.getAction(0));
        CompositeActionImplTest.assertEquals((Object)action2, compositeAction.getAction(1));
        CompositeActionImplTest.assertEquals((Object)action3, compositeAction.getAction(2));
        compositeAction.removeAction(action3);
        CompositeActionImplTest.assertEquals((int)2, (int)compositeAction.getActions().size());
        compositeAction.setAction(1, action3);
        CompositeActionImplTest.assertEquals((Object)action1, compositeAction.getAction(0));
        CompositeActionImplTest.assertEquals((Object)action3, compositeAction.getAction(1));
        CompositeActionImplTest.assertEquals((int)0, (int)compositeAction.indexOfAction(action1));
        CompositeActionImplTest.assertEquals((int)1, (int)compositeAction.indexOfAction(action3));
        compositeAction.addAction(1, action2);
        CompositeActionImplTest.assertEquals((int)3, (int)compositeAction.getActions().size());
        CompositeActionImplTest.assertEquals((Object)action1, compositeAction.getAction(0));
        CompositeActionImplTest.assertEquals((Object)action2, compositeAction.getAction(1));
        CompositeActionImplTest.assertEquals((Object)action3, compositeAction.getAction(2));
        compositeAction.removeAllActions();
        CompositeActionImplTest.assertFalse((boolean)compositeAction.hasActions());
        CompositeActionImplTest.assertEquals((int)0, (int)compositeAction.getActions().size());
    }
}

