/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.feed.cleanup;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.alfresco.repo.domain.activities.ActivityFeedDAO;
import org.alfresco.repo.domain.activities.ActivityFeedEntity;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.VmShutdownListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionException;

public class FeedCleaner {
    private static Log logger = LogFactory.getLog(FeedCleaner.class);
    private static VmShutdownListener vmShutdownListener = new VmShutdownListener(FeedCleaner.class.getName());
    private int maxAgeMins = 0;
    private int maxFeedSize = -1;
    private ActivityFeedDAO feedDAO;
    private SiteService siteService;

    public void setFeedDAO(ActivityFeedDAO feedDAO) {
        this.feedDAO = feedDAO;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setMaxAgeMins(int mins) {
        this.maxAgeMins = mins;
    }

    public void setMaxFeedSize(int size) {
        this.maxFeedSize = size;
    }

    private void checkProperties() {
        PropertyCheck.mandatory((Object)this, (String)"feedDAO", (Object)this.feedDAO);
        if (this.maxAgeMins <= 0 && this.maxFeedSize <= 0) {
            logger.warn((Object)"Neither maxAgeMins or maxFeedSize set - feeds will not be cleaned");
        }
    }

    public int execute() throws JobExecutionException {
        int maxSizeDeletedCount;
        int maxAgeDeletedCount;
        block17: {
            this.checkProperties();
            maxAgeDeletedCount = 0;
            maxSizeDeletedCount = 0;
            try {
                if (this.maxAgeMins > 0) {
                    long nowTimeOffset = new Date().getTime();
                    long keepTimeOffset = nowTimeOffset - (long)this.maxAgeMins * 60000L;
                    Date keepDate = new Date(keepTimeOffset);
                    maxAgeDeletedCount = this.feedDAO.deleteFeedEntries(keepDate);
                    if (maxAgeDeletedCount > 0) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Cleaned " + maxAgeDeletedCount + " entries (upto " + keepDate + ", max age " + this.maxAgeMins + " mins)"));
                        }
                    } else if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Cleaned " + maxAgeDeletedCount + " entries (upto " + keepDate + ", max age " + this.maxAgeMins + " mins)"));
                    }
                }
                if (this.maxFeedSize > 0) {
                    List<ActivityFeedEntity> feeds = this.feedDAO.selectFeedsToClean(this.maxFeedSize);
                    int feedCount = 0;
                    for (ActivityFeedEntity feed : feeds) {
                        List<ActivityFeedEntity> feedToClean;
                        String siteId = feed.getSiteNetwork();
                        final String feedUserId = feed.getFeedUserId();
                        String format = feed.getActivitySummaryFormat();
                        int feedUserSiteCount = 0;
                        if (feedUserId == null || feedUserId.length() == 0) {
                            feedToClean = this.feedDAO.selectSiteFeedEntries(siteId, format);
                        } else {
                            feedToClean = this.feedDAO.selectUserFeedEntries(feedUserId, format, null, false, false);
                            if (this.siteService != null) {
                                feedUserSiteCount = (Integer)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Integer>(){

                                    public Integer doWork() throws Exception {
                                        return FeedCleaner.this.siteService.listSites(feedUserId).size();
                                    }
                                }, (String)"System");
                            }
                        }
                        if ((feedUserSiteCount != 0 || feedToClean.size() <= this.maxFeedSize) && feedToClean.size() <= this.maxFeedSize * feedUserSiteCount) continue;
                        Date oldestFeedEntry = feedToClean.get(this.maxFeedSize - 1).getPostDate();
                        int deletedCount = 0;
                        deletedCount = feedUserId == null || feedUserId.length() == 0 ? this.feedDAO.deleteSiteFeedEntries(siteId, format, oldestFeedEntry) : this.feedDAO.deleteUserFeedEntries(feedUserId, format, oldestFeedEntry);
                        if (deletedCount <= 0) continue;
                        maxSizeDeletedCount += deletedCount;
                        ++feedCount;
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace((Object)("Cleaned " + deletedCount + " entries for [" + feed.getSiteNetwork() + ", " + feed.getFeedUserId() + ", " + feed.getActivitySummaryFormat() + "] (upto " + oldestFeedEntry + ")"));
                    }
                    if (maxSizeDeletedCount > 0) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Cleaned " + maxSizeDeletedCount + " entries across " + feedCount + " feeds (max feed size " + this.maxFeedSize + " entries)"));
                        }
                    } else if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Cleaned " + maxSizeDeletedCount + " entries across " + feedCount + " feeds (max feed size " + this.maxFeedSize + " entries)"));
                    }
                }
            }
            catch (SQLException e) {
                logger.error((Object)"Exception during cleanup of feeds", (Throwable)e);
                throw new JobExecutionException((Throwable)e);
            }
            catch (Throwable e) {
                if (vmShutdownListener.isVmShuttingDown()) break block17;
                logger.error((Object)"Exception during cleanup of feeds", e);
            }
        }
        return maxAgeDeletedCount + maxSizeDeletedCount;
    }
}

