/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.invitation.Invitation;
import org.alfresco.service.cmr.invitation.InvitationService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskQuery;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class InvitationMigrationPatch
extends AbstractPatch {
    private WorkflowService workflowService;
    private InvitationService invitationService;
    private static final String MSG_SUCCESS = "patch.invitationMigration.result";
    private static final String MSG_NO_INVITES = "patch.invitationMigration.no_invites";
    private static final Log logger = LogFactory.getLog(InvitationMigrationPatch.class);

    protected String applyInternal() throws Exception {
        WorkflowDefinition def = this.workflowService.getDefinitionByName("jbpm$wf:invite");
        if (def != null) {
            List<WorkflowInstance> currentInstances = this.workflowService.getActiveWorkflows(def.getId());
            int count = 0;
            for (WorkflowInstance oldInstance : currentInstances) {
                String oldWorkflowId = oldInstance.id;
                this.convertOldInvite(oldWorkflowId);
                this.workflowService.cancelWorkflow(oldWorkflowId);
                ++count;
            }
            String msg = I18NUtil.getMessage((String)MSG_SUCCESS, (Object[])new Object[]{count});
            return msg;
        }
        logger.debug((Object)"no invites to cancel");
        String msg = I18NUtil.getMessage((String)MSG_NO_INVITES);
        return msg;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public WorkflowService getWorkflowService() {
        return this.workflowService;
    }

    public void setInvitationService(InvitationService invitationService) {
        this.invitationService = invitationService;
    }

    public InvitationService getInvitationService() {
        return this.invitationService;
    }

    private void convertOldInvite(String oldWorkflowId) {
        WorkflowTaskQuery query = new WorkflowTaskQuery();
        query.setProcessId(oldWorkflowId);
        query.setProcessName(OldInviteModel.WF_PROCESS_INVITE);
        query.setTaskName(OldInviteModel.WF_INVITE_TASK_INVITE_TO_SITE);
        List<WorkflowTask> inviteStartTasks = this.workflowService.queryTasks(query);
        if (inviteStartTasks.size() >= 1) {
            WorkflowTask oldTask = inviteStartTasks.get(0);
            Map<QName, Serializable> workflowProps = oldTask.properties;
            final String inviteeUserName = (String)((Object)workflowProps.get(OldInviteModel.WF_PROP_INVITEE_USER_NAME));
            String inviterUserName = (String)((Object)workflowProps.get(OldInviteModel.WF_PROP_INVITER_USER_NAME));
            final String resourceName = (String)((Object)workflowProps.get(OldInviteModel.WF_PROP_SITE_SHORT_NAME));
            final String roleName = (String)((Object)workflowProps.get(OldInviteModel.WF_PROP_INVITEE_SITE_ROLE));
            final String serverPath = (String)((Object)workflowProps.get(OldInviteModel.WF_PROP_SERVER_PATH));
            final String acceptUrl = (String)((Object)workflowProps.get(OldInviteModel.WF_PROP_ACCEPT_URL));
            final String rejectUrl = (String)((Object)workflowProps.get(OldInviteModel.WF_PROP_REJECT_URL));
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    InvitationMigrationPatch.this.invitationService.inviteNominated(inviteeUserName, Invitation.ResourceType.WEB_SITE, resourceName, roleName, serverPath, acceptUrl, rejectUrl);
                    return null;
                }
            }, (String)inviterUserName);
        }
    }

    private static class OldInviteModel {
        public static final QName WF_PROCESS_INVITE = QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"invite");
        public static final String WORKFLOW_DEFINITION_NAME = "jbpm$wf:invite";
        public static final QName WF_INVITE_TASK_INVITE_TO_SITE = QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"inviteToSiteTask");
        public static final QName WF_INVITE_TASK_INVITE_PENDING = QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"invitePendingTask");
        public static final QName WF_TASK_ACCEPT_INVITE = QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"acceptInviteTask");
        public static final QName WF_TASK_REJECT_INVITE = QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"rejectInviteTask");
        public static final String WF_TRANSITION_SEND_INVITE = "sendInvite";
        public static final String WF_TRANSITION_ACCEPT = "accept";
        public static final String WF_TRANSITION_REJECT = "reject";
        public static final String WF_TRANSITION_CANCEL = "cancel";
        public static final String WF_TRANSITION_ACCEPT_INVITE_END = "end";
        public static final String WF_TRANSITION_REJECT_INVITE_END = "end";
        public static final QName WF_PROP_SERVER_PATH = QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"serverPath");
        public static final QName WF_PROP_ACCEPT_URL = QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"acceptUrl");
        public static final QName WF_PROP_REJECT_URL = QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"rejectUrl");
        public static final QName WF_PROP_INVITE_TICKET = QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"inviteTicket");
        public static final QName WF_PROP_INVITER_USER_NAME = QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"inviterUserName");
        public static final QName WF_PROP_INVITEE_USER_NAME = QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"inviteeUserName");
        public static final QName WF_PROP_INVITEE_FIRSTNAME = QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"inviteeFirstName");
        public static final QName WF_PROP_INVITEE_LASTNAME = QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"inviteeLastName");
        public static final QName WF_PROP_SITE_SHORT_NAME = QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"siteShortName");
        public static final QName WF_PROP_INVITEE_SITE_ROLE = QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"inviteeSiteRole");
        public static final QName WF_PROP_SENT_INVITE_DATE = QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"sentInviteDate");
        public static final QName WF_PROP_INVITEE_GEN_PASSWORD = QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"inviteeGenPassword");

        private OldInviteModel() {
        }
    }
}

