/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import com.ibatis.sqlmap.client.event.RowHandler;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.avm.locking.AVMLockingServiceImpl;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.service.cmr.attributes.AttributeService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class MigrateAttrAVMLocksPatch
extends AbstractPatch {
    private Log logger = LogFactory.getLog(this.getClass());
    private static final String MSG_SUCCESS = "patch.migrateAttrAVMLocks.result";
    private AttributeService attributeService;
    private PatchDAO patchDAO;

    public void setAttributeService(AttributeService attributeService) {
        this.attributeService = attributeService;
    }

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    protected String applyInternal() throws Exception {
        long startTime = System.currentTimeMillis();
        AVMLockRowHandler handler = new AVMLockRowHandler();
        this.patchDAO.migrateOldAttrAVMLocks(handler);
        if (handler.total > 0) {
            this.logger.info((Object)("Processed " + handler.total + " AVM Lock attrs in " + (System.currentTimeMillis() - startTime) / 1000L + " secs"));
        }
        String msg = I18NUtil.getMessage((String)MSG_SUCCESS, (Object[])new Object[]{handler.total});
        return msg;
    }

    private class AVMLockRowHandler
    implements RowHandler {
        private int total = 0;

        private AVMLockRowHandler() {
        }

        public void handleRow(Object valueObject) {
            Map result = (Map)valueObject;
            String wpStoreId = (String)result.get("wpStoreId");
            String path = (String)result.get("relPath");
            String avmStore = (String)result.get("avmStore");
            String lockOwner = (String)result.get("owner1");
            String relPath = AVMLockingServiceImpl.normalizePath(path);
            HashMap<String, String> lockData = new HashMap<String, String>(2);
            lockData.put("lock-owner", lockOwner);
            lockData.put("avm-store-name", avmStore);
            if (!MigrateAttrAVMLocksPatch.this.attributeService.exists(new Serializable[]{".avm_locks", wpStoreId, relPath})) {
                MigrateAttrAVMLocksPatch.this.attributeService.createAttribute(lockData, new Serializable[]{".avm_locks", wpStoreId, relPath});
                if (MigrateAttrAVMLocksPatch.this.logger.isTraceEnabled()) {
                    MigrateAttrAVMLocksPatch.this.logger.trace((Object)("Set AVM Lock attr [wpStoreId=" + wpStoreId + ", relPath=" + relPath + ", lockOwner=" + lockOwner + ", avmStore=" + avmStore + "]"));
                }
                ++this.total;
            } else {
                MigrateAttrAVMLocksPatch.this.logger.warn((Object)("'" + path + "' path has duplicates in normalized form. AVM lock unique attribute creation has been skipped"));
            }
            if (MigrateAttrAVMLocksPatch.this.logger.isDebugEnabled() && (this.total == 0 || this.total % 1000 == 0)) {
                MigrateAttrAVMLocksPatch.this.logger.debug((Object)("   Handled " + this.total + " AVM Lock attributes"));
            }
        }
    }
}

