/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class PersonUsagePatch
extends AbstractPatch {
    private static Log logger = LogFactory.getLog(PersonUsagePatch.class);
    private static final String MSG_SUCCESS1 = "patch.personUsagePatch.result1";
    private static final String MSG_SUCCESS2 = "patch.personUsagePatch.result2";
    private PatchDAO patchDAO;
    private StoreRef personStoreRef;
    private TenantService tenantService;

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    public void setPersonStoreUrl(String storeUrl) {
        this.personStoreRef = new StoreRef(storeUrl);
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    protected String applyInternal() throws Exception {
        logger.info((Object)"Checking for people with missing 'cm:sizeCurrent' property ...");
        int count = this.addPersonSizeCurrentProperty();
        String msg = null;
        if (count > 0) {
            logger.info((Object)("... missing 'cm:sizeCurrent' property added to " + count + " people"));
            msg = I18NUtil.getMessage((String)MSG_SUCCESS1, (Object[])new Object[]{count});
        } else {
            logger.info((Object)"... no people were missing the 'cm:sizeCurrent' property");
            msg = I18NUtil.getMessage((String)MSG_SUCCESS2);
        }
        return msg;
    }

    private int addPersonSizeCurrentProperty() {
        CountQueryCallback userHandler = new CountQueryCallback();
        this.patchDAO.getUsersWithoutUsageProp(this.tenantService.getName(this.personStoreRef), userHandler);
        return userHandler.getCount();
    }

    private class CountQueryCallback
    implements PatchDAO.StringHandler {
        private int count = 0;

        public void handle(String uuid) {
            PersonUsagePatch.this.nodeService.setProperty(new NodeRef(PersonUsagePatch.this.personStoreRef, uuid), ContentModel.PROP_SIZE_CURRENT, null);
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }
}

