/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.service.cmr.admin.PatchException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.springframework.context.MessageSource;
import org.springframework.extensions.surf.util.I18NUtil;

public class WCMFoldersPatch
extends AbstractPatch {
    private static final String MSG_WEBPROJECTS_EXISTS = "patch.wcmFolders.webprojects.result.exists";
    private static final String MSG_WEBPROJECTS_CREATED = "patch.wcmFolders.webprojects.result.created";
    private static final String MSG_WEBFORMS_EXISTS = "patch.wcmFolders.webforms.result.exists";
    private static final String MSG_WEBFORMS_CREATED = "patch.wcmFolders.webforms.result.created";
    private static final String PROPERTY_COMPANY_HOME_CHILDNAME = "spaces.company_home.childname";
    private static final String PROPERTY_DICTIONARY_CHILDNAME = "spaces.dictionary.childname";
    public static final String PROPERTY_WEBPROJECTS_FOLDER_CHILDNAME = "spaces.wcm.childname";
    private static final String MSG_WEBPROJECTS_FOLDER_NAME = "spaces.wcm.name";
    private static final String MSG_WEBPROJECTS_FOLDER_DESCRIPTION = "spaces.wcm.description";
    public static final String PROPERTY_WEBFORMS_FOLDER_CHILDNAME = "spaces.wcm_content_forms.childname";
    private static final String MSG_WEBFORMS_FOLDER_NAME = "spaces.wcm_content_forms.name";
    private static final String MSG_WEBFORMS_FOLDER_DESCRIPTION = "spaces.wcm_content_forms.description";
    private static final String PROPERTY_ICON = "space-icon-default";
    private ImporterBootstrap importerBootstrap;
    private MessageSource messageSource;
    protected NodeRef companyHomeNodeRef;
    protected NodeRef dictionaryNodeRef;
    protected Properties configuration;
    protected NodeRef wcmProjectsFolderNodeRef;
    protected NodeRef wcmFormsFolderNodeRef;

    public void setImporterBootstrap(ImporterBootstrap importerBootstrap) {
        this.importerBootstrap = importerBootstrap;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    protected void checkCommonProperties() throws Exception {
        if (this.importerBootstrap == null) {
            throw new PatchException("'importerBootstrap' property has not been set");
        }
        if (this.namespaceService == null) {
            throw new PatchException("'namespaceService' property has not been set");
        }
        if (this.searchService == null) {
            throw new PatchException("'searchService' property has not been set");
        }
        if (this.nodeService == null) {
            throw new PatchException("'nodeService' property has not been set");
        }
    }

    protected void setUp() throws Exception {
        StoreRef storeRef = this.importerBootstrap.getStoreRef();
        if (storeRef == null) {
            throw new PatchException("Bootstrap store has not been set");
        }
        NodeRef storeRootNodeRef = this.nodeService.getRootNode(storeRef);
        this.configuration = this.importerBootstrap.getConfiguration();
        String companyHomeChildName = this.configuration.getProperty(PROPERTY_COMPANY_HOME_CHILDNAME);
        if (companyHomeChildName == null || companyHomeChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.company_home.childname' is not present");
        }
        String dictionaryChildName = this.configuration.getProperty(PROPERTY_DICTIONARY_CHILDNAME);
        if (dictionaryChildName == null || dictionaryChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.dictionary.childname' is not present");
        }
        String wcmProjectsChildName = this.configuration.getProperty(PROPERTY_WEBPROJECTS_FOLDER_CHILDNAME);
        if (wcmProjectsChildName == null || wcmProjectsChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.wcm.childname' is not present");
        }
        String wcmFormsChildName = this.configuration.getProperty(PROPERTY_WEBFORMS_FOLDER_CHILDNAME);
        if (wcmFormsChildName == null || wcmFormsChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.wcm_content_forms.childname' is not present");
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append("/").append(companyHomeChildName);
        String xpath = sb.toString();
        List nodeRefs = this.searchService.selectNodes(storeRootNodeRef, xpath, null, (NamespacePrefixResolver)this.namespaceService, false);
        if (nodeRefs.size() == 0) {
            throw new PatchException("XPath didn't return any results: \n   root: " + storeRootNodeRef + "\n" + "   xpath: " + xpath);
        }
        if (nodeRefs.size() > 1) {
            throw new PatchException("XPath returned too many results: \n   root: " + storeRootNodeRef + "\n" + "   xpath: " + xpath + "\n" + "   results: " + nodeRefs);
        }
        this.companyHomeNodeRef = (NodeRef)nodeRefs.get(0);
        sb.append("/").append(dictionaryChildName);
        xpath = sb.toString();
        nodeRefs = this.searchService.selectNodes(storeRootNodeRef, xpath, null, (NamespacePrefixResolver)this.namespaceService, false);
        if (nodeRefs.size() == 0) {
            throw new PatchException("XPath didn't return any results: \n   root: " + storeRootNodeRef + "\n" + "   xpath: " + xpath);
        }
        if (nodeRefs.size() > 1) {
            throw new PatchException("XPath returned too many results: \n   root: " + storeRootNodeRef + "\n" + "   xpath: " + xpath + "\n" + "   results: " + nodeRefs);
        }
        this.dictionaryNodeRef = (NodeRef)nodeRefs.get(0);
        xpath = wcmProjectsChildName;
        nodeRefs = this.searchService.selectNodes(this.companyHomeNodeRef, xpath, null, (NamespacePrefixResolver)this.namespaceService, false);
        if (nodeRefs.size() > 1) {
            throw new PatchException("XPath returned too many results: \n   company home node: " + this.companyHomeNodeRef + "\n" + "   xpath: " + xpath + "\n" + "   results: " + nodeRefs);
        }
        this.wcmProjectsFolderNodeRef = nodeRefs.size() == 0 ? null : (NodeRef)nodeRefs.get(0);
        xpath = wcmFormsChildName;
        nodeRefs = this.searchService.selectNodes(this.dictionaryNodeRef, xpath, null, (NamespacePrefixResolver)this.namespaceService, false);
        if (nodeRefs.size() > 1) {
            throw new PatchException("XPath returned too many results: \n   dictionary node: " + this.dictionaryNodeRef + "\n" + "   xpath: " + xpath + "\n" + "   results: " + nodeRefs);
        }
        this.wcmFormsFolderNodeRef = nodeRefs.size() == 0 ? null : (NodeRef)nodeRefs.get(0);
    }

    protected String applyInternal() throws Exception {
        this.checkCommonProperties();
        if (this.messageSource == null) {
            throw new PatchException("'messageSource' property has not been set");
        }
        this.setUp();
        String msg = null;
        if (this.wcmProjectsFolderNodeRef == null) {
            this.createWebProjectsFolder();
            msg = I18NUtil.getMessage((String)MSG_WEBPROJECTS_CREATED, (Object[])new Object[]{this.wcmProjectsFolderNodeRef});
        } else {
            msg = I18NUtil.getMessage((String)MSG_WEBPROJECTS_EXISTS, (Object[])new Object[]{this.wcmProjectsFolderNodeRef});
        }
        if (this.wcmFormsFolderNodeRef == null) {
            this.createWebFormsFolder();
            msg = msg + "\r\n" + I18NUtil.getMessage((String)MSG_WEBFORMS_CREATED, (Object[])new Object[]{this.wcmProjectsFolderNodeRef});
        } else {
            msg = msg + "\r\n" + I18NUtil.getMessage((String)MSG_WEBFORMS_EXISTS, (Object[])new Object[]{this.wcmProjectsFolderNodeRef});
        }
        return msg;
    }

    private void createWebProjectsFolder() {
        String wcmProjectsChildName = this.configuration.getProperty(PROPERTY_WEBPROJECTS_FOLDER_CHILDNAME);
        if (wcmProjectsChildName == null) {
            throw new PatchException("Bootstrap property 'spaces.wcm.childname' is not present");
        }
        String name = this.messageSource.getMessage(MSG_WEBPROJECTS_FOLDER_NAME, null, I18NUtil.getLocale());
        if (name == null || name.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.wcm.name' is not present");
        }
        String description = this.messageSource.getMessage(MSG_WEBPROJECTS_FOLDER_DESCRIPTION, null, I18NUtil.getLocale());
        if (description == null || description.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.wcm.description' is not present");
        }
        HashMap<QName, String> properties = new HashMap<QName, String>(7);
        properties.put(ContentModel.PROP_NAME, name);
        properties.put(ContentModel.PROP_TITLE, name);
        properties.put(ContentModel.PROP_DESCRIPTION, description);
        properties.put(ApplicationModel.PROP_ICON, PROPERTY_ICON);
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.companyHomeNodeRef, ContentModel.ASSOC_CONTAINS, QName.resolveToQName((NamespacePrefixResolver)this.namespaceService, (String)wcmProjectsChildName), ContentModel.TYPE_FOLDER, properties);
        this.wcmProjectsFolderNodeRef = childAssocRef.getChildRef();
        this.nodeService.addAspect(this.wcmProjectsFolderNodeRef, ApplicationModel.ASPECT_UIFACETS, null);
    }

    private void createWebFormsFolder() {
        String wcmFormsChildName = this.configuration.getProperty(PROPERTY_WEBFORMS_FOLDER_CHILDNAME);
        if (wcmFormsChildName == null) {
            throw new PatchException("Bootstrap property 'spaces.wcm_content_forms.childname' is not present");
        }
        String name = this.messageSource.getMessage(MSG_WEBFORMS_FOLDER_NAME, null, I18NUtil.getLocale());
        if (name == null || name.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.wcm_content_forms.name' is not present");
        }
        String description = this.messageSource.getMessage(MSG_WEBFORMS_FOLDER_DESCRIPTION, null, I18NUtil.getLocale());
        if (description == null || description.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.wcm_content_forms.description' is not present");
        }
        HashMap<QName, String> properties = new HashMap<QName, String>(7);
        properties.put(ContentModel.PROP_NAME, name);
        properties.put(ContentModel.PROP_TITLE, name);
        properties.put(ContentModel.PROP_DESCRIPTION, description);
        properties.put(ApplicationModel.PROP_ICON, PROPERTY_ICON);
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.dictionaryNodeRef, ContentModel.ASSOC_CONTAINS, QName.resolveToQName((NamespacePrefixResolver)this.namespaceService, (String)wcmFormsChildName), ContentModel.TYPE_FOLDER, properties);
        this.wcmFormsFolderNodeRef = childAssocRef.getChildRef();
        this.nodeService.addAspect(this.wcmFormsFolderNodeRef, ApplicationModel.ASPECT_UIFACETS, null);
    }
}

