/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.avm.AVMTestSuite;
import org.alfresco.repo.avm.util.RemoteBulkLoader;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMNotFoundException;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.cmr.avm.VersionDescriptor;
import org.alfresco.service.cmr.avmsync.AVMDifference;
import org.alfresco.service.cmr.avmsync.AVMSyncException;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.remote.AVMRemote;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.NameMatcher;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

public class AVMServiceLocalTest
extends TestCase {
    private static Log logger = LogFactory.getLog(AVMServiceLocalTest.class);
    protected static ApplicationContext fContext;
    protected static AVMRemote fService;
    protected static AVMSyncService fSyncService;
    protected static NameMatcher excluder;

    protected void setUp() throws Exception {
        if (fContext == null) {
            fContext = AVMTestSuite.getContext();
            fService = (AVMRemote)fContext.getBean("avmRemote");
            fSyncService = (AVMSyncService)fContext.getBean("AVMSyncService");
            excluder = (NameMatcher)fContext.getBean("globalPathExcluder");
            AuthenticationService authService = (AuthenticationService)fContext.getBean("AuthenticationService");
            authService.authenticate(AuthenticationUtil.getAdminUserName(), "admin".toCharArray());
        }
        if (fService.getStore("main") == null) {
            fService.createStore("main");
        }
        if (fService.getStore("layer") == null) {
            fService.createStore("layer");
        }
    }

    protected void tearDown() throws Exception {
        fService.purgeStore("main");
        fService.purgeStore("layer");
    }

    public void testSetup() throws Exception {
        this.setUp();
    }

    public void testGetAPath() throws Exception {
        try {
            try {
                fService.createStore("test2932");
                fService.createDirectory("test2932:/", "a");
                fService.createFile("test2932:/a", "foo.txt").close();
                AVMNodeDescriptor found = fService.lookup(-1, "test2932:/a/foo.txt");
                Pair<Integer, String> path = fService.getAPath(found);
                AVMServiceLocalTest.assertEquals((String)((String)path.getSecond()), (String)"test2932:/a/foo.txt");
                this.explorePaths("test2932:/");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            Object var4_4 = null;
            fService.purgeStore("test2932");
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            fService.purgeStore("test2932");
            throw throwable;
        }
    }

    public void testSimple() throws Throwable {
        try {
            List<AVMStoreDescriptor> stores = fService.getStores();
            for (AVMStoreDescriptor store : stores) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)store);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    protected void explorePaths(String path) throws Exception {
        SortedMap<String, AVMNodeDescriptor> listing = fService.getDirectoryListing(-1, path);
        for (Map.Entry entry : listing.entrySet()) {
            Pair<Integer, String> childPath = fService.getAPath((AVMNodeDescriptor)entry.getValue());
            if (logger.isDebugEnabled()) {
                logger.debug(childPath);
            }
            if (!((AVMNodeDescriptor)entry.getValue()).isDirectory()) continue;
            this.explorePaths(((AVMNodeDescriptor)entry.getValue()).getPath());
        }
    }

    public void testReadWrite() throws Throwable {
        try {
            try {
                fService.createStore("test2933");
                fService.createDirectory("test2933:/", "a");
                OutputStream out = fService.createFile("test2933:/a", "foo.txt");
                byte[] buff = "This is a plain old text file.\n".getBytes();
                out.write(buff);
                buff = "It contains text.\n".getBytes();
                out.write(buff);
                out.close();
                InputStream in = fService.getFileInputStream(-1, "test2933:/a/foo.txt");
                buff = new byte[1024];
                AVMServiceLocalTest.assertEquals((int)49, (int)in.read(buff));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)new String(buff));
                }
                AVMServiceLocalTest.assertEquals((int)-1, (int)in.read(buff));
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw e;
            }
            Object var5_5 = null;
            fService.purgeStore("test2933");
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            fService.purgeStore("test2933");
            throw throwable;
        }
    }

    public void testRead() throws Throwable {
        try {
            try {
                fService.createStore("froo");
                byte[] buff = new byte[64];
                for (int i = 0; i < 64; ++i) {
                    buff[i] = (byte)i;
                }
                OutputStream out = fService.createFile("froo:/", "foo.dat");
                out.write(buff, 32, 32);
                out.close();
                InputStream in = fService.getFileInputStream(-1, "froo:/foo.dat");
                buff = new byte[1024];
                AVMServiceLocalTest.assertEquals((int)32, (int)in.read(buff));
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw e;
            }
            Object var5_6 = null;
            fService.purgeStore("froo");
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            fService.purgeStore("froo");
            throw throwable;
        }
    }

    public void testErrorState() throws Throwable {
        try {
            AVMServiceLocalTest.assertNull((Object)fService.lookup(-1, "main:/fizz/fazz"));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testSimpleUpdateBR() throws Throwable {
        try {
            try {
                fService.createStore("froo");
                fService.createDirectory("froo:/", "a");
                fService.createFile("froo:/a", "foo").close();
                fService.createStore("broo");
                fService.createBranch(-1, "froo:/a", "broo:/", "a");
                List<AVMDifference> diffs = fSyncService.compare(-1, "froo:/a", -1, "broo:/a", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
                fService.createFile("froo:/a", "bar").close();
                diffs = fSyncService.compare(-1, "froo:/a", -1, "broo:/a", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[froo:/a/bar[-1] > broo:/a/bar[-1]]", (String)diffs.toString());
                fSyncService.update(diffs, null, false, false, false, false, "flippy", "Stuff");
                diffs = fSyncService.compare(-1, "froo:/a", -1, "broo:/a", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            Object var3_3 = null;
            fService.purgeStore("broo");
            fService.purgeStore("froo");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            fService.purgeStore("broo");
            fService.purgeStore("froo");
            throw throwable;
        }
    }

    public void testSimpleUpdateLD1() throws Throwable {
        try {
            List<AVMDifference> diffs = fSyncService.compare(-1, "main:/", -1, "main:/", null);
            AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
            diffs = fSyncService.compare(-1, "layer:/", -1, "main:/", null);
            AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
            fService.createFile("main:/", "f-a").close();
            diffs = fSyncService.compare(-1, "layer:/", -1, "main:/", null);
            AVMServiceLocalTest.assertEquals((String)"[layer:/f-a[-1] < main:/f-a[-1]]", (String)diffs.toString());
            AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
            fService.createLayeredDirectory("main:/", "layer:/", "layer");
            diffs = fSyncService.compare(-1, "layer:/layer", -1, "main:/", null);
            AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
            fService.createFile("main:/", "f-b").close();
            diffs = fSyncService.compare(-1, "layer:/layer", -1, "main:/", null);
            AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
            fService.getFileOutputStream("layer:/layer/f-b").close();
            diffs = fSyncService.compare(-1, "layer:/layer", -1, "main:/", null);
            AVMServiceLocalTest.assertEquals((String)"[layer:/layer/f-b[-1] > main:/f-b[-1]]", (String)diffs.toString());
            AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
            fSyncService.update(diffs, null, false, false, false, false, null, null);
            diffs = fSyncService.compare(-1, "layer:/layer", -1, "main:/", null);
            AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
    }

    public void testSimpleUpdateLD2() throws Throwable {
        try {
            fService.createDirectory("main:/", "base");
            fService.createDirectory("main:/base", "d-a");
            fService.createFile("main:/base/d-a", "f-aa").close();
            List<AVMDifference> diffs = fSyncService.compare(-1, "layer:/", -1, "main:/", null);
            AVMServiceLocalTest.assertEquals((String)"[layer:/base[-1] < main:/base[-1]]", (String)diffs.toString());
            AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
            fService.createLayeredDirectory("main:/base", "layer:/", "layer-to-base");
            diffs = fSyncService.compare(-1, "layer:/layer-to-base", -1, "main:/base", null);
            AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
            fService.getFileOutputStream("main:/base/d-a/f-aa").close();
            diffs = fSyncService.compare(-1, "layer:/layer-to-base", -1, "main:/base", null);
            AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
            fService.getFileOutputStream("layer:/layer-to-base/d-a/f-aa").close();
            diffs = fSyncService.compare(-1, "layer:/layer-to-base", -1, "main:/base", null);
            AVMServiceLocalTest.assertEquals((String)"[layer:/layer-to-base/d-a/f-aa[-1] > main:/base/d-a/f-aa[-1]]", (String)diffs.toString());
            AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
            fSyncService.update(diffs, null, false, false, false, false, null, null);
            diffs = fSyncService.compare(-1, "layer:/layer-to-base", -1, "main:/base", null);
            AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
    }

    public void testSimpleUpdateLD3() throws Throwable {
        try {
            fService.createDirectory("main:/", "base");
            fService.createLayeredDirectory("main:/base", "layer:/", "layer-to-base");
            List<AVMDifference> diffs = fSyncService.compare(-1, "layer:/layer-to-base", -1, "main:/base", null);
            AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
            fService.createDirectory("layer:/layer-to-base", "d-a");
            fService.createFile("layer:/layer-to-base/d-a", "f-aa").close();
            diffs = fSyncService.compare(-1, "layer:/layer-to-base", -1, "main:/base", null);
            AVMServiceLocalTest.assertEquals((String)"[layer:/layer-to-base/d-a[-1] > main:/base/d-a[-1]]", (String)diffs.toString());
            AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
            fSyncService.update(diffs, null, false, false, false, false, null, null);
            diffs = fSyncService.compare(-1, "layer:/layer-to-base", -1, "main:/base", null);
            AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
    }

    public void testSimpleUpdateLD4() throws Exception {
        try {
            try {
                fService.createLayeredDirectory("main:/", "layer:/", "layer");
                fService.createDirectory("layer:/layer", "b");
                fService.createFile("layer:/layer/b", "foo").close();
                List<AVMDifference> diffs = fSyncService.compare(-1, "layer:/layer", -1, "main:/", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[layer:/layer/b[-1] > main:/b[-1]]", (String)diffs.toString());
                fService.createSnapshot("layer", null, null);
                fSyncService.update(diffs, null, false, false, false, false, null, null);
                fService.createSnapshot("main", null, null);
                diffs = fSyncService.compare(-1, "layer:/layer", -1, "main:/", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
                fSyncService.flatten("layer:/layer", "main:/");
                fService.createStore("layer2");
                fService.createLayeredDirectory("layer:/layer", "layer2:/", "layer");
                fService.createDirectory("layer2:/layer/", "c");
                fService.createFile("layer2:/layer/c", "foo").close();
                fService.createSnapshot("layer2", null, null);
                diffs = fSyncService.compare(-1, "layer2:/layer", -1, "layer:/layer", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[layer2:/layer/c[-1] > layer:/layer/c[-1]]", (String)diffs.toString());
                fSyncService.update(diffs, null, false, false, false, false, null, null);
                diffs = fSyncService.compare(-1, "layer2:/layer", -1, "layer:/layer", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
                fSyncService.flatten("layer2:/layer", "layer:/layer");
                diffs = fSyncService.compare(-1, "layer:/layer", -1, "main:/", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[layer:/layer/c[-1] > main:/c[-1]]", (String)diffs.toString());
                this.recursiveList("main");
                this.recursiveList("layer");
                this.recursiveList("layer2");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw e;
            }
            Object var3_3 = null;
            fService.purgeStore("layer2");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            fService.purgeStore("layer2");
            throw throwable;
        }
    }

    public void testSimpleUpdateLD5() throws Exception {
        try {
            logger.debug((Object)"start: testSimpleUpdateLD5");
            logger.debug((Object)"created 2 stores: main, layer");
            this.recursiveList("main");
            this.recursiveList("layer");
            fService.createLayeredDirectory("main:/", "layer:/", "layer");
            logger.debug((Object)"created layered dir: layer:/layer -> main:/");
            this.recursiveList("main");
            this.recursiveList("layer");
            fService.createDirectory("layer:/layer", "b");
            logger.debug((Object)"created dir in layer: layer:/layer/b");
            this.recursiveList("main");
            this.recursiveList("layer");
            List<AVMDifference> diffs = fSyncService.compare(-1, "layer:/layer", -1, "main:/", null);
            AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
            AVMServiceLocalTest.assertEquals((String)"[layer:/layer/b[-1] > main:/b[-1]]", (String)diffs.toString());
            fSyncService.update(diffs, null, false, false, false, false, null, null);
            logger.debug((Object)"updated: created directory: main:/b");
            this.recursiveList("main");
            this.recursiveList("layer");
            diffs = fSyncService.compare(-1, "layer:/layer", -1, "main:/", null);
            AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
            fSyncService.flatten("layer:/layer", "main:/");
            logger.debug((Object)"flattened: created directory: main:/b");
            this.recursiveList("main");
            this.recursiveList("layer");
            fService.createFile("layer:/layer/b", "foo").close();
            logger.debug((Object)"created file: layer:/layer/b/foo");
            this.recursiveList("main");
            this.recursiveList("layer");
            fService.createFile("layer:/layer/b", "bar").close();
            logger.debug((Object)"created file: layer:/layer/b/bar");
            this.recursiveList("main");
            this.recursiveList("layer");
            diffs = fSyncService.compare(-1, "layer:/layer", -1, "main:/", null);
            AVMServiceLocalTest.assertEquals((int)2, (int)diffs.size());
            AVMServiceLocalTest.assertEquals((String)"[layer:/layer/b/bar[-1] > main:/b/bar[-1], layer:/layer/b/foo[-1] > main:/b/foo[-1]]", (String)diffs.toString());
            ArrayList<AVMDifference> selected = new ArrayList<AVMDifference>(1);
            selected.add(diffs.get(1));
            AVMServiceLocalTest.assertEquals((String)"[layer:/layer/b/foo[-1] > main:/b/foo[-1]]", (String)((Object)selected).toString());
            fSyncService.update(selected, null, false, false, false, false, null, null);
            logger.debug((Object)"updated: created file: main:/b/foo");
            this.recursiveList("main");
            this.recursiveList("layer");
            diffs = fSyncService.compare(-1, "layer:/layer", -1, "main:/", null);
            AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
            AVMServiceLocalTest.assertEquals((String)"[layer:/layer/b/bar[-1] > main:/b/bar[-1]]", (String)diffs.toString());
            fSyncService.flatten("layer:/layer", "main:/");
            logger.debug((Object)"flattened: created file: main:/b/foo");
            this.recursiveList("main");
            this.recursiveList("layer");
            fService.removeNode("layer:/layer", "b");
            logger.debug((Object)"removed dir in layer: layer:/layer/b");
            this.recursiveList("main");
            this.recursiveList("layer");
            fService.createSnapshot("layer", null, null);
            logger.debug((Object)"snapshot: layer");
            this.recursiveList("main");
            this.recursiveList("layer");
            diffs = fSyncService.compare(-1, "layer:/layer", -1, "main:/", null);
            AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
            AVMServiceLocalTest.assertEquals((String)"[layer:/layer/b[-1] > main:/b[-1]]", (String)diffs.toString());
            fSyncService.update(diffs, null, false, false, false, false, null, null);
            logger.debug((Object)"updated: deleted dir: main:/b");
            this.recursiveList("main");
            this.recursiveList("layer");
            diffs = fSyncService.compare(-1, "layer:/layer", -1, "main:/", null);
            AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
            fSyncService.flatten("layer:/layer", "main:/");
            logger.debug((Object)"flattened: deleted dir: main:/b");
            this.recursiveList("main");
            this.recursiveList("layer");
            logger.debug((Object)"finish: testSimpleUpdateLD5");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testSimpleUpdateLD6() throws Exception {
        try {
            try {
                logger.debug((Object)"created 2 stores: main, layer");
                fService.createDirectory("main:/", "a");
                fService.createDirectory("main:/a", "b");
                logger.debug((Object)"created dirs: main:/a, main:/a/b");
                fService.createLayeredDirectory("main:/", "layer:/", "layer");
                logger.debug((Object)"created layered dir: layer:/layer -> main:/");
                List<AVMDifference> diffs = fSyncService.compare(-1, "layer:/layer", -1, "main:/", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
                fService.createDirectory("layer:/layer/a", "xyz");
                fService.createFile("layer:/layer/a/xyz", "index.html").close();
                logger.debug((Object)"created: layer:/layer/a/xyz, layer:/layer/a/xyz/index.html");
                diffs = fSyncService.compare(-1, "layer:/layer", -1, "main:/", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[layer:/layer/a/xyz[-1] > main:/a/xyz[-1]]", (String)diffs.toString());
                fService.createStore("main--workflow1");
                logger.debug((Object)"created store: main--workflow1");
                fService.createLayeredDirectory("main:/a", "main--workflow1:/", "a");
                logger.debug((Object)"created layered dir: main--workflow1:/a -> main:/a");
                diffs = fSyncService.compare(-1, "main--workflow1:/a", -1, "main:/a", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
                diffs = new ArrayList<AVMDifference>(1);
                diffs.add(new AVMDifference(-1, "layer:/layer/a/xyz/index.html", -1, "main--workflow1:/a/xyz/index.html", 0));
                diffs.add(new AVMDifference(-1, "layer:/layer/a/xyz", -1, "main--workflow1:/a/xyz", 0));
                fSyncService.update(diffs, null, false, false, false, false, "one", "one");
                logger.debug((Object)"updated: added: main--workflow1:/a/xyz,  main--workflow1:/a/xyz/index.html");
                diffs = fSyncService.compare(-1, "layer:/layer/a", -1, "main:/a", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[layer:/layer/a/xyz[-1] > main:/a/xyz[-1]]", (String)diffs.toString());
                diffs = fSyncService.compare(-1, "main--workflow1:/a", -1, "main:/a", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[main--workflow1:/a/xyz[-1] > main:/a/xyz[-1]]", (String)diffs.toString());
                fSyncService.update(diffs, null, false, false, true, true, "two", "two");
                fSyncService.flatten("main--workflow1:/a", "main:/a");
                logger.debug((Object)"updated & flattened");
                diffs = fSyncService.compare(-1, "main--workflow1:/a", -1, "main:/a", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
                diffs = fSyncService.compare(-1, "main--workflow1:/a", -1, "layer:/layer/a", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
                this.recursiveList("main");
                this.recursiveList("layer");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw e;
            }
            Object var3_3 = null;
            if (fService.getStore("main--workflow1") != null) {
                fService.purgeStore("main--workflow1");
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (fService.getStore("main--workflow1") != null) {
                fService.purgeStore("main--workflow1");
            }
            throw throwable;
        }
    }

    public void testDeleteLD1() throws Exception {
        try {
            logger.debug((Object)"created 2 stores: main, layer");
            fService.createDirectory("main:/", "a");
            OutputStream o = fService.createFile("main:/a", "foo");
            PrintStream out = new PrintStream(o);
            out.println("I am main:/a/foo");
            out.close();
            logger.debug((Object)"created file in main: main:/a/foo");
            fService.createLayeredDirectory("main:/a", "layer:/", "a");
            logger.debug((Object)"created layered dir: layer:/a -> main:/a");
            BufferedReader reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "layer:/a/foo")));
            String line = reader.readLine();
            reader.close();
            AVMServiceLocalTest.assertEquals((String)"I am main:/a/foo", (String)line);
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/a/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceLocalTest.assertEquals((String)"I am main:/a/foo", (String)line);
            out = new PrintStream(fService.getFileOutputStream("layer:/a/foo"));
            out.println("I am layer:/a/foo");
            out.close();
            logger.debug((Object)"update file in layer: layer:/a/foo");
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "layer:/a/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceLocalTest.assertEquals((String)"I am layer:/a/foo", (String)line);
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/a/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceLocalTest.assertEquals((String)"I am main:/a/foo", (String)line);
            List<AVMDifference> diffs = fSyncService.compare(-1, "layer:/a", -1, "main:/a", null);
            AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
            AVMServiceLocalTest.assertEquals((String)"[layer:/a/foo[-1] > main:/a/foo[-1]]", (String)diffs.toString());
            fSyncService.update(diffs, null, false, false, false, false, null, null);
            diffs = fSyncService.compare(-1, "layer:/a", -1, "main:/a", null);
            AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
            fSyncService.flatten("layer:/a", "main:/a");
            logger.debug((Object)"updated & flattened: updated file: main:/a/foo");
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "layer:/a/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceLocalTest.assertEquals((String)"I am layer:/a/foo", (String)line);
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/a/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceLocalTest.assertEquals((String)"I am layer:/a/foo", (String)line);
            fService.removeNode("main:/", "a");
            fService.createSnapshot("main", null, null);
            logger.debug((Object)"remove directory in main & snapshot: main:/a");
            AVMServiceLocalTest.assertNotNull((Object)fService.lookup(-1, "layer:/a"));
            AVMServiceLocalTest.assertNull((Object)fService.lookup(-1, "layer:/a/foo"));
            try {
                fService.getFileInputStream(-1, "layer:/a/foo");
                AVMServiceLocalTest.fail();
            }
            catch (AVMNotFoundException nfe) {
                // empty catch block
            }
            try {
                fService.getFileOutputStream("layer:/a/foo");
                AVMServiceLocalTest.fail();
            }
            catch (AVMNotFoundException nfe) {
                // empty catch block
            }
            this.recursiveList("main");
            this.recursiveList("layer");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testDeleteLD2() throws Exception {
        try {
            logger.debug((Object)"created 2 stores: main, layer");
            fService.createDirectory("main:/", "a");
            OutputStream o = fService.createFile("main:/a", "foo");
            PrintStream out = new PrintStream(o);
            out.println("I am main:/a/foo");
            out.close();
            logger.debug((Object)"created file in main: main:/a/foo");
            fService.createLayeredDirectory("main:/a", "layer:/", "a");
            logger.debug((Object)"created layered dir: layer:/a -> main:/a");
            BufferedReader reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "layer:/a/foo")));
            String line = reader.readLine();
            reader.close();
            AVMServiceLocalTest.assertEquals((String)"I am main:/a/foo", (String)line);
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/a/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceLocalTest.assertEquals((String)"I am main:/a/foo", (String)line);
            out = new PrintStream(fService.getFileOutputStream("layer:/a/foo"));
            out.println("I am layer:/a/foo");
            out.close();
            logger.debug((Object)"update file in layer: layer:/a/foo");
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "layer:/a/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceLocalTest.assertEquals((String)"I am layer:/a/foo", (String)line);
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/a/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceLocalTest.assertEquals((String)"I am main:/a/foo", (String)line);
            fService.removeNode("main:/", "a");
            logger.debug((Object)"remove directory in main: main:/a");
            fService.createSnapshot("main", null, null);
            logger.debug((Object)"snapshot: main:/a");
            AVMServiceLocalTest.assertNull((Object)fService.lookup(-1, "main:/a"));
            AVMServiceLocalTest.assertNull((Object)fService.lookup(-1, "main:/a/foo"));
            try {
                fService.getFileInputStream(-1, "main:/a/foo");
                AVMServiceLocalTest.fail();
            }
            catch (AVMNotFoundException nfe) {
                // empty catch block
            }
            AVMServiceLocalTest.assertNotNull((Object)fService.lookup(-1, "layer:/a"));
            AVMServiceLocalTest.assertNotNull((Object)fService.lookup(-1, "layer:/a/foo"));
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "layer:/a/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceLocalTest.assertEquals((String)"I am layer:/a/foo", (String)line);
            out = new PrintStream(fService.getFileOutputStream("layer:/a/foo"));
            out.println("I am layer:/a/foo V2");
            out.close();
            List<AVMDifference> diffs = fSyncService.compare(-1, "layer:/a", -1, "main:/a", null);
            AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
            AVMServiceLocalTest.assertEquals((String)"[layer:/a[-1] > main:/a[-1]]", (String)diffs.toString());
            fSyncService.update(diffs, null, false, false, false, false, null, null);
            diffs = fSyncService.compare(-1, "layer:/a", -1, "main:/a", null);
            AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
            logger.debug((Object)"updated: updated dir & file: main:/a/foo");
            fSyncService.flatten("layer:/a", "main:/a");
            logger.debug((Object)"flattened: layer:/a -> main:/a");
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "layer:/a/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceLocalTest.assertEquals((String)"I am layer:/a/foo V2", (String)line);
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/a/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceLocalTest.assertEquals((String)"I am layer:/a/foo V2", (String)line);
            this.recursiveList("main");
            this.recursiveList("layer");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testDeleteLD3() throws Exception {
        try {
            try {
                fService.createStore("mainB");
                fService.createStore("mainB--layer");
                fService.createDirectory("mainB:/", "a");
                fService.createSnapshot("mainB", null, null);
                SortedMap<String, AVMNodeDescriptor> directoryListing = fService.getDirectoryListing(-1, "mainB:/a");
                AVMServiceLocalTest.assertTrue((boolean)directoryListing.isEmpty());
                fService.createLayeredDirectory("mainB:/a", "mainB--layer:/", "a");
                fService.createFile("mainB--layer:/a", "testfile.txt");
                fService.createDirectory("mainB--layer:/a", "testfolder");
                fService.createSnapshot("mainB--layer", null, null);
                List<AVMDifference> diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)2, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[mainB--layer:/a/testfile.txt[-1] > mainB:/a/testfile.txt[-1], mainB--layer:/a/testfolder[-1] > mainB:/a/testfolder[-1]]", (String)diffs.toString());
                fService.removeNode("mainB--layer:/a", "testfile.txt");
                fService.createSnapshot("mainB--layer", null, null);
                diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[mainB--layer:/a/testfolder[-1] > mainB:/a/testfolder[-1]]", (String)diffs.toString());
                fService.removeNode("mainB--layer:/a", "testfolder");
                fService.createSnapshot("mainB--layer", null, null);
                diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
                directoryListing = fService.getDirectoryListing(-1, "mainB--layer:/a");
                AVMServiceLocalTest.assertTrue((boolean)directoryListing.isEmpty());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            Object var4_4 = null;
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
            throw throwable;
        }
    }

    public void testDeleteLD4() throws Exception {
        try {
            try {
                logger.debug((Object)"created 2 stores: main, layer");
                fService.createDirectory("main:/", "a");
                fService.createLayeredDirectory("main:/a", "layer:/", "a");
                logger.debug((Object)"created layered dir: layer:/a -> main:/a");
                List<AVMDifference> diffs = fSyncService.compare(-1, "layer:/a", -1, "main:/a", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
                fService.createStore("layer2");
                logger.debug((Object)"created store: layer2");
                fService.createLayeredDirectory("layer:/a", "layer2:/", "a");
                logger.debug((Object)"created layered dir: layer2:/a -> layer:/a");
                OutputStream o = fService.createFile("layer2:/a", "foo");
                PrintStream out = new PrintStream(o);
                out.println("I am layer2:/a/foo");
                out.close();
                diffs = fSyncService.compare(-1, "layer2:/a", -1, "layer:/a", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[layer2:/a/foo[-1] > layer:/a/foo[-1]]", (String)diffs.toString());
                fSyncService.update(diffs, null, false, false, false, false, null, null);
                diffs = fSyncService.compare(-1, "layer2:/a", -1, "layer:/a", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
                diffs = fSyncService.compare(-1, "layer:/a", -1, "main:/a", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[layer:/a/foo[-1] > main:/a/foo[-1]]", (String)diffs.toString());
                fService.removeNode("layer:/a", "foo");
                logger.debug((Object)"remove file in layer: layer:/a/foo");
                diffs = fSyncService.compare(-1, "layer:/a", -1, "main:/a", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw e;
            }
            Object var5_5 = null;
            if (fService.getStore("layer2") != null) {
                fService.purgeStore("layer2");
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (fService.getStore("layer2") != null) {
                fService.purgeStore("layer2");
            }
            throw throwable;
        }
    }

    public void testBulkUpdateLD() throws Exception {
        String LOAD_DIR = "source/java/org/alfresco/repo/avm/actions";
        String[] split = LOAD_DIR.split("/");
        String DIR = split[split.length - 1];
        try {
            try {
                RemoteBulkLoader loader = new RemoteBulkLoader();
                loader.setAvmRemoteService(fService);
                fService.createLayeredDirectory("main:/", "layer:/", "layer");
                loader.recursiveLoad(LOAD_DIR, "layer:/layer");
                List<AVMDifference> diffs = fSyncService.compare(-1, "layer:/layer", -1, "main:/", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)("[layer:/layer/" + DIR + "[-1] > main:/" + DIR + "[-1]]"), (String)diffs.toString());
                fService.createSnapshot("layer", null, null);
                fSyncService.update(diffs, null, false, false, false, false, null, null);
                fService.createSnapshot("main", null, null);
                diffs = fSyncService.compare(-1, "layer:/layer", -1, "main:/", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
                fSyncService.flatten("layer:/layer", "main:/");
                this.recursiveList("layer");
                this.recursiveList("main");
                fService.createStore("layer2");
                fService.createLayeredDirectory("layer:/layer", "layer2:/", "layer");
                loader.recursiveLoad(LOAD_DIR, "layer2:/layer/" + DIR);
                fService.createSnapshot("layer2", null, null);
                diffs = fSyncService.compare(-1, "layer2:/layer", -1, "layer:/layer", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)("[layer2:/layer/" + DIR + "/" + DIR + "[-1] > layer:/layer/" + DIR + "/" + DIR + "[-1]]"), (String)diffs.toString());
                fSyncService.update(diffs, null, false, false, false, false, null, null);
                diffs = fSyncService.compare(-1, "layer2:/layer", -1, "layer:/layer", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
                fSyncService.flatten("layer2:/layer", "layer:/layer");
                diffs = fSyncService.compare(-1, "layer:/layer", -1, "main:/", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)("[layer:/layer/" + DIR + "/" + DIR + "[-1] > main:/" + DIR + "/" + DIR + "[-1]]"), (String)diffs.toString());
                this.recursiveList("layer2");
                this.recursiveList("layer");
                this.recursiveList("main");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw e;
            }
            Object var7_7 = null;
            if (fService.getStore("layer2") != null) {
                fService.purgeStore("layer2");
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (fService.getStore("layer2") != null) {
                fService.purgeStore("layer2");
            }
            throw throwable;
        }
    }

    public void testFlatten() throws Exception {
        try {
            this.setupBasicTree();
            fService.createLayeredDirectory("main:/a", "main:/", "layer");
            fService.createSnapshot("main", null, null);
            this.recursiveList("main");
            fService.createFile("main:/layer/b", "fig").close();
            fService.getFileOutputStream("main:/layer/b/c/foo").close();
            fService.createSnapshot("main", null, null);
            this.recursiveList("main");
            List<AVMDifference> diffs = fSyncService.compare(-1, "main:/layer", -1, "main:/a", null);
            AVMServiceLocalTest.assertEquals((int)2, (int)diffs.size());
            AVMServiceLocalTest.assertEquals((String)"[main:/layer/b/c/foo[-1] > main:/a/b/c/foo[-1], main:/layer/b/fig[-1] > main:/a/b/fig[-1]]", (String)diffs.toString());
            fSyncService.update(diffs, null, false, false, false, false, null, null);
            this.recursiveList("main");
            fSyncService.flatten("main:/layer", "main:/a");
            this.recursiveList("main");
            diffs = fSyncService.compare(-1, "main:/layer", -1, "main:/a", null);
            AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testPartialFlatten() throws Exception {
        try {
            this.setupBasicTree();
            fService.createLayeredDirectory("main:/a", "layer:/", "a");
            fService.getFileOutputStream("layer:/a/b/c/foo").close();
            fService.createFile("layer:/a/b", "bing").close();
            List<AVMDifference> diffs = new ArrayList<AVMDifference>();
            diffs.add(new AVMDifference(-1, "layer:/a/b/c/foo", -1, "main:/a/b/c/foo", 0));
            fSyncService.update(diffs, null, false, false, false, false, null, null);
            fSyncService.flatten("layer:/a", "main:/a");
            AVMNodeDescriptor b = fService.lookup(-1, "layer:/a/b");
            AVMServiceLocalTest.assertTrue((boolean)b.isLayeredDirectory());
            AVMNodeDescriptor c = fService.lookup(-1, "layer:/a/b/c");
            AVMServiceLocalTest.assertTrue((boolean)c.isPlainDirectory());
            diffs = fSyncService.compare(-1, "layer:/a", -1, "main:/a", null);
            AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
            AVMServiceLocalTest.assertEquals((String)"[layer:/a/b/bing[-1] > main:/a/b/bing[-1]]", (String)diffs.toString());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testResetLayer() throws Exception {
        try {
            this.setupBasicTree();
            fService.createLayeredDirectory("main:/a", "main:/", "layer");
            fService.createFile("main:/layer", "figs").close();
            AVMServiceLocalTest.assertFalse((boolean)this.recursiveContents("main:/a", -1, true).equals(this.recursiveContents("main:/layer", -1, true)));
            this.recursiveList("main");
            fSyncService.resetLayer("main:/layer");
            AVMServiceLocalTest.assertEquals((String)this.recursiveContents("main:/a", -1, true), (String)this.recursiveContents("main:/layer", -1, true));
            this.recursiveList("main");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testUpdate() throws Exception {
        try {
            this.setupBasicTree();
            fService.createBranch(-1, "main:/a", "main:/", "abranch");
            fService.createFile("main:/abranch", "monkey").close();
            fService.createFile("main:/abranch", "#foo").close();
            fService.createFile("main:/abranch", "figs.tmp").close();
            fService.getFileOutputStream("main:/abranch/b/c/foo").close();
            this.recursiveList("main");
            List<AVMDifference> cmp = fSyncService.compare(-1, "main:/abranch", -1, "main:/a", excluder);
            AVMServiceLocalTest.assertEquals((int)2, (int)cmp.size());
            AVMServiceLocalTest.assertEquals((String)"[main:/abranch/b/c/foo[-1] > main:/a/b/c/foo[-1], main:/abranch/monkey[-1] > main:/a/monkey[-1]]", (String)cmp.toString());
            ArrayList<AVMDifference> diffs = new ArrayList<AVMDifference>();
            diffs.add(new AVMDifference(-1, "main:/abranch/monkey", -1, "main:/a/monkey", 0));
            diffs.add(new AVMDifference(-1, "main:/abranch/b/c/foo", -1, "main:/a/b/c/foo", 0));
            fSyncService.update(diffs, null, false, false, false, false, null, null);
            fService.createSnapshot("main", null, null);
            this.recursiveList("main");
            AVMServiceLocalTest.assertEquals((long)fService.lookup(-1, "main:/abranch/monkey").getId(), (long)fService.lookup(-1, "main:/a/monkey").getId());
            AVMServiceLocalTest.assertEquals((long)fService.lookup(-1, "main:/abranch/b/c/foo").getId(), (long)fService.lookup(-1, "main:/a/b/c/foo").getId());
            fService.removeNode("main:/abranch", "monkey");
            this.recursiveList("main");
            cmp = fSyncService.compare(-1, "main:/abranch", -1, "main:/a", excluder);
            AVMServiceLocalTest.assertEquals((int)1, (int)cmp.size());
            AVMServiceLocalTest.assertEquals((String)"[main:/abranch/monkey[-1] > main:/a/monkey[-1]]", (String)cmp.toString());
            diffs.clear();
            diffs.add(new AVMDifference(-1, "main:/abranch/monkey", -1, "main:/a/monkey", 0));
            fSyncService.update(diffs, null, false, false, false, false, null, null);
            AVMServiceLocalTest.assertEquals((int)0, (int)fSyncService.compare(-1, "main:/abranch", -1, "main:/a", excluder).size());
            fService.createSnapshot("main", null, null);
            this.recursiveList("main");
            AVMServiceLocalTest.assertEquals((long)fService.lookup(-1, "main:/abranch/monkey", true).getId(), (long)fService.lookup(-1, "main:/a/monkey", true).getId());
            fService.createFile("main:/abranch", "monkey").close();
            cmp = fSyncService.compare(-1, "main:/abranch", -1, "main:/a", excluder);
            AVMServiceLocalTest.assertEquals((int)1, (int)cmp.size());
            AVMServiceLocalTest.assertEquals((String)"[main:/abranch/monkey[-1] > main:/a/monkey[-1]]", (String)cmp.toString());
            diffs.clear();
            diffs.add(new AVMDifference(-1, "main:/a/monkey", -1, "main:/abranch/monkey", 0));
            try {
                fSyncService.update(diffs, null, false, false, false, false, null, null);
                AVMServiceLocalTest.fail();
            }
            catch (AVMSyncException se) {
                // empty catch block
            }
            this.recursiveList("main");
            diffs.clear();
            diffs.add(new AVMDifference(-1, "main:/a/monkey", -1, "main:/abranch/monkey", 0));
            fSyncService.update(diffs, null, false, false, false, true, null, null);
            AVMServiceLocalTest.assertEquals((int)0, (int)fSyncService.compare(-1, "main:/abranch", -1, "main:/a", excluder).size());
            fService.createSnapshot("main", null, null);
            this.recursiveList("main");
            AVMServiceLocalTest.assertEquals((long)fService.lookup(-1, "main:/a/monkey", true).getId(), (long)fService.lookup(-1, "main:/abranch/monkey", true).getId());
            fService.purgeStore("main");
            fService.createStore("main");
            this.setupBasicTree();
            fService.createLayeredDirectory("main:/a", "main:/", "layer");
            fService.createFile("main:/layer", "monkey").close();
            fService.getFileOutputStream("main:/layer/b/c/foo").close();
            cmp = fSyncService.compare(-1, "main:/layer", -1, "main:/a", excluder);
            AVMServiceLocalTest.assertEquals((int)2, (int)cmp.size());
            AVMServiceLocalTest.assertEquals((String)"[main:/layer/b/c/foo[-1] > main:/a/b/c/foo[-1], main:/layer/monkey[-1] > main:/a/monkey[-1]]", (String)cmp.toString());
            this.recursiveList("main");
            diffs.clear();
            diffs.add(new AVMDifference(-1, "main:/layer/monkey", -1, "main:/a/monkey", 0));
            diffs.add(new AVMDifference(-1, "main:/layer/b/c/foo", -1, "main:/a/b/c/foo", 0));
            fSyncService.update(diffs, null, false, false, false, false, null, null);
            AVMServiceLocalTest.assertEquals((int)0, (int)fSyncService.compare(-1, "main:/layer", -1, "main:/a", excluder).size());
            fService.createSnapshot("main", null, null);
            this.recursiveList("main");
            AVMServiceLocalTest.assertEquals((long)fService.lookup(-1, "main:/layer/monkey").getId(), (long)fService.lookup(-1, "main:/a/monkey").getId());
            AVMServiceLocalTest.assertEquals((long)fService.lookup(-1, "main:/layer/b/c/foo").getId(), (long)fService.lookup(-1, "main:/a/b/c/foo").getId());
            fService.removeNode("main:/layer", "monkey");
            this.recursiveList("main");
            cmp = fSyncService.compare(-1, "main:/layer", -1, "main:/a", excluder);
            AVMServiceLocalTest.assertEquals((int)1, (int)cmp.size());
            AVMServiceLocalTest.assertEquals((String)"[main:/layer/monkey[-1] > main:/a/monkey[-1]]", (String)cmp.toString());
            diffs.clear();
            diffs.add(new AVMDifference(-1, "main:/layer/monkey", -1, "main:/a/monkey", 0));
            fSyncService.update(diffs, null, false, false, false, false, null, null);
            AVMServiceLocalTest.assertEquals((int)0, (int)fSyncService.compare(-1, "main:/layer", -1, "main:/a", excluder).size());
            fService.createSnapshot("main", null, null);
            this.recursiveList("main");
            AVMServiceLocalTest.assertEquals((long)fService.lookup(-1, "main:/layer/monkey", true).getId(), (long)fService.lookup(-1, "main:/a/monkey", true).getId());
            fService.createFile("main:/layer", "monkey").close();
            cmp = fSyncService.compare(-1, "main:/layer", -1, "main:/a", excluder);
            AVMServiceLocalTest.assertEquals((int)1, (int)cmp.size());
            AVMServiceLocalTest.assertEquals((String)"[main:/layer/monkey[-1] > main:/a/monkey[-1]]", (String)cmp.toString());
            diffs.clear();
            diffs.add(new AVMDifference(-1, "main:/a/monkey", -1, "main:/layer/monkey", 0));
            try {
                fSyncService.update(diffs, null, false, false, false, false, null, null);
                AVMServiceLocalTest.fail();
            }
            catch (AVMSyncException aVMSyncException) {
                // empty catch block
            }
            this.recursiveList("main");
            diffs.clear();
            diffs.add(new AVMDifference(-1, "main:/a/monkey", -1, "main:/layer/monkey", 0));
            fSyncService.update(diffs, null, false, false, false, true, null, null);
            AVMServiceLocalTest.assertEquals((int)0, (int)fSyncService.compare(-1, "main:/layer", -1, "main:/a", excluder).size());
            fService.createSnapshot("main", null, null);
            this.recursiveList("main");
            AVMServiceLocalTest.assertEquals((long)fService.lookup(-1, "main:/a/monkey", true).getId(), (long)fService.lookup(-1, "main:/layer/monkey", true).getId());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testUpdateSnapshot() throws Exception {
        try {
            try {
                this.setupBasicTree();
                fService.createStore("branch");
                fService.createBranch(-1, "main:/", "branch:/", "branch");
                fService.createFile("branch:/branch/a/b", "fing").close();
                fService.getFileOutputStream("branch:/branch/a/b/c/foo").close();
                fService.removeNode("branch:/branch/a/b/c", "bar");
                List<AVMDifference> diffs = fSyncService.compare(-1, "branch:/branch", -1, "main:/", null);
                AVMServiceLocalTest.assertEquals((int)3, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[branch:/branch/a/b/c/bar[-1] > main:/a/b/c/bar[-1], branch:/branch/a/b/c/foo[-1] > main:/a/b/c/foo[-1], branch:/branch/a/b/fing[-1] > main:/a/b/fing[-1]]", (String)diffs.toString());
                fSyncService.update(diffs, null, false, false, false, false, null, null);
                diffs = fSyncService.compare(-1, "branch:/branch", -1, "main:/", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
                fService.getFileOutputStream("branch:/branch/a/b/fing").close();
                AVMServiceLocalTest.assertTrue((fService.lookup(-1, "branch:/branch/a/b/fing").getId() != fService.lookup(-1, "main:/a/b/fing").getId() ? 1 : 0) != 0);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw e;
            }
            Object var3_3 = null;
            fService.purgeStore("branch");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            fService.purgeStore("branch");
            throw throwable;
        }
    }

    public void testNoodleUpdate() throws Exception {
        try {
            try {
                this.setupBasicTree();
                fService.createStore("staging");
                List<AVMDifference> diffs = fSyncService.compare(-1, "main:/", -1, "staging:/", null);
                AVMServiceLocalTest.assertEquals((int)2, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[main:/a[-1] > staging:/a[-1], main:/d[-1] > staging:/d[-1]]", (String)diffs.toString());
                ArrayList<AVMDifference> noodle = new ArrayList<AVMDifference>();
                noodle.add(new AVMDifference(-1, "main:/a/b/c/foo", -1, "staging:/a/b/c/foo", 0));
                noodle.add(new AVMDifference(-1, "main:/d", -1, "staging:/d", 0));
                fSyncService.update(noodle, null, false, false, false, false, null, null);
                diffs = fSyncService.compare(-1, "main:/", -1, "staging:/", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[main:/a/b/c/bar[-1] > staging:/a/b/c/bar[-1]]", (String)diffs.toString());
                AVMServiceLocalTest.assertEquals((String)"main:/a/b/c/bar", (String)diffs.get(0).getSourcePath());
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw e;
            }
            Object var4_4 = null;
            fService.purgeStore("staging");
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            fService.purgeStore("staging");
            throw throwable;
        }
    }

    public void testRename1() throws Exception {
        try {
            this.setupBasicTree();
            fService.createLayeredDirectory("main:/a", "layer:/", "a");
            fService.rename("layer:/a/b", "c", "layer:/a/b", "z");
            this.recursiveContents("layer:/");
            List<AVMDifference> diffs = fSyncService.compare(-1, "layer:/a", -1, "main:/a", null);
            AVMServiceLocalTest.assertEquals((int)2, (int)diffs.size());
            AVMServiceLocalTest.assertEquals((String)"[layer:/a/b/c[-1] > main:/a/b/c[-1], layer:/a/b/z[-1] > main:/a/b/z[-1]]", (String)diffs.toString());
            fSyncService.update(diffs, null, false, false, false, false, null, null);
            this.recursiveContents("layer:/");
            this.recursiveContents("main:/");
            fSyncService.flatten("layer:/a", "main:/a");
            this.recursiveContents("layer:/");
            this.recursiveContents("main:/");
            fService.createFile("layer:/a/b/z", "fudge").close();
            fService.rename("layer:/a/b", "z", "layer:/a/b", "y");
            this.recursiveContents("layer:/");
            diffs = fSyncService.compare(-1, "layer:/a", -1, "main:/a", null);
            AVMServiceLocalTest.assertEquals((int)2, (int)diffs.size());
            AVMServiceLocalTest.assertEquals((String)"[layer:/a/b/y[-1] > main:/a/b/y[-1], layer:/a/b/z[-1] > main:/a/b/z[-1]]", (String)diffs.toString());
            fSyncService.update(diffs, null, false, false, false, false, null, null);
            this.recursiveContents("layer:/");
            this.recursiveContents("main:/");
            fSyncService.flatten("layer:/a", "main:/a");
            this.recursiveContents("layer:/");
            this.recursiveContents("main:/");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void testRename2() throws Exception {
        String fileLower = "foo";
        String fileUpper = "FOO";
        try {
            logger.debug((Object)"created 2 stores: main, layer");
            fService.createDirectory("main:/", "a");
            fService.createFile("main:/a", fileLower);
            logger.debug((Object)("created: main:/a/" + fileLower));
            AVMNodeDescriptor desc = fService.lookup(-1, "main:/a/" + fileLower);
            AVMServiceLocalTest.assertNotNull((Object)desc);
            AVMServiceLocalTest.assertEquals((String)("main:/a/" + fileLower), (String)desc.getPath());
            fService.createLayeredDirectory("main:/a", "layer:/", "a");
            logger.debug((Object)("created: layer:/a/" + fileLower + " -> main:/a/" + fileLower));
            AVMServiceLocalTest.assertNotNull((Object)fService.lookup(-1, "layer:/a/" + fileLower));
            List<AVMDifference> diffs = fSyncService.compare(-1, "layer:/a", -1, "main:/a", null);
            AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
            fService.rename("layer:/a/", fileLower, "layer:/a", fileUpper);
            logger.debug((Object)("rename: layer:/a/" + fileLower + " -> layer:/a/" + fileUpper));
            diffs = fSyncService.compare(-1, "layer:/a", -1, "main:/a", null);
            AVMServiceLocalTest.assertEquals((String)("[layer:/a/" + fileUpper + "[-1] > main:/a/" + fileUpper + "[-1]]"), (String)diffs.toString());
            fSyncService.update(diffs, null, false, false, false, false, null, null);
            logger.debug((Object)("update: layer:/a/" + fileUpper + " -> main:/a/" + fileUpper));
            diffs = fSyncService.compare(-1, "layer:/a", -1, "main:/a", null);
            AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
            fSyncService.flatten("layer:/a", "main:/a");
            logger.debug((Object)"flatten: layer:/a -> main:/a");
            desc = fService.lookup(-1, "main:/a/" + fileLower);
            AVMServiceLocalTest.assertNotNull((Object)desc);
            AVMServiceLocalTest.assertEquals((String)("main:/a/" + fileUpper), (String)desc.getPath());
            desc = fService.lookup(-1, "main:/a/" + fileUpper);
            AVMServiceLocalTest.assertNotNull((Object)desc);
            AVMServiceLocalTest.assertEquals((String)("main:/a/" + fileUpper), (String)desc.getPath());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void testRename3() throws Exception {
        try {
            logger.debug((Object)"created 2 stores: main, layer");
            fService.createDirectory("main:/", "a");
            fService.createDirectory("main:/a", "b");
            fService.createDirectory("main:/a/b", "c");
            logger.debug((Object)"created: main:/a/b/c");
            fService.createLayeredDirectory("main:/a", "layer:/", "a");
            logger.debug((Object)"created: layer:/a -> main:/a");
            List<AVMDifference> diffs = fSyncService.compare(-1, "layer:/a", -1, "main:/a", null);
            AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
            AVMNodeDescriptor desc = fService.lookup(-1, "main:/a/b");
            AVMServiceLocalTest.assertNotNull((Object)desc);
            AVMServiceLocalTest.assertEquals((String)"main:/a/b", (String)desc.getPath());
            desc = fService.lookup(-1, "main:/a/B");
            AVMServiceLocalTest.assertNotNull((Object)desc);
            AVMServiceLocalTest.assertEquals((String)"main:/a/b", (String)desc.getPath());
            desc = fService.lookup(-1, "layer:/a/b");
            AVMServiceLocalTest.assertNotNull((Object)desc);
            AVMServiceLocalTest.assertEquals((String)"layer:/a/b", (String)desc.getPath());
            fService.rename("layer:/a/", "b", "layer:/a", "B");
            logger.debug((Object)"rename: layer:/a/b -> layer:/a/B");
            desc = fService.lookup(-1, "main:/a/b");
            AVMServiceLocalTest.assertNotNull((Object)desc);
            AVMServiceLocalTest.assertEquals((String)"main:/a/b", (String)desc.getPath());
            desc = fService.lookup(-1, "layer:/a/B");
            AVMServiceLocalTest.assertNotNull((Object)desc);
            AVMServiceLocalTest.assertEquals((String)"layer:/a/B", (String)desc.getPath());
            desc = fService.lookup(-1, "layer:/a/b");
            AVMServiceLocalTest.assertNotNull((Object)desc);
            AVMServiceLocalTest.assertEquals((String)"layer:/a/B", (String)desc.getPath());
            diffs = fSyncService.compare(-1, "layer:/a", -1, "main:/a", null);
            AVMServiceLocalTest.assertEquals((String)"[layer:/a/B[-1] > main:/a/B[-1]]", (String)diffs.toString());
            fSyncService.update(diffs, null, false, false, false, false, null, null);
            logger.debug((Object)"update: layer:/a/B -> main:/a/B");
            diffs = fSyncService.compare(-1, "layer:/a", -1, "main:/a", null);
            AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
            fSyncService.flatten("layer:/a", "main:/a");
            logger.debug((Object)"flatten: layer:/a -> main:/a");
            desc = fService.lookup(-1, "main:/a/b");
            AVMServiceLocalTest.assertNotNull((Object)desc);
            AVMServiceLocalTest.assertEquals((String)"main:/a/B", (String)desc.getPath());
            desc = fService.lookup(-1, "main:/a/B");
            AVMServiceLocalTest.assertNotNull((Object)desc);
            AVMServiceLocalTest.assertEquals((String)"main:/a/B", (String)desc.getPath());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void testUpdateFileTitleAndDescription() throws Exception {
        try {
            fService.createLayeredDirectory("main:/", "layer:/", "layer");
            fService.createDirectory("layer:/layer", "b");
            fService.createFile("layer:/layer/b", "foo").close();
            List<AVMDifference> diffs = fSyncService.compare(-1, "layer:/layer", -1, "main:/", null);
            AVMServiceLocalTest.assertEquals((String)"[layer:/layer/b[-1] > main:/b[-1]]", (String)diffs.toString());
            fService.createSnapshot("layer", null, null);
            fSyncService.update(diffs, null, false, false, false, false, null, null);
            fService.createSnapshot("main", null, null);
            diffs = fSyncService.compare(-1, "layer:/layer", -1, "main:/", null);
            AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
            fSyncService.flatten("layer:/layer", "main:/");
            AVMServiceLocalTest.assertEquals((int)0, (int)fService.getNodeProperties(-1, "main:/b/foo").size());
            AVMServiceLocalTest.assertEquals((int)0, (int)fService.getNodeProperties(-1, "layer:/layer/b/foo").size());
            HashMap<QName, PropertyValue> properties = new HashMap<QName, PropertyValue>();
            properties.put(ContentModel.PROP_TITLE, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)"foo title")));
            properties.put(ContentModel.PROP_DESCRIPTION, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)"foo descrip")));
            fService.setNodeProperties("layer:/layer/b/foo", properties);
            diffs = fSyncService.compare(-1, "layer:/layer", -1, "main:/", null);
            AVMServiceLocalTest.assertEquals((String)"[layer:/layer/b/foo[-1] > main:/b/foo[-1]]", (String)diffs.toString());
            fService.createSnapshot("layer", null, null);
            fSyncService.update(diffs, null, false, false, false, false, null, null);
            fService.createSnapshot("main", null, null);
            diffs = fSyncService.compare(-1, "layer:/layer", -1, "main:/", null);
            AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
            fSyncService.flatten("layer:/layer", "main:/");
            AVMServiceLocalTest.assertEquals((int)2, (int)fService.getNodeProperties(-1, "main:/b/foo").size());
            AVMServiceLocalTest.assertEquals((String)"foo title", (String)fService.getNodeProperty(-1, "main:/b/foo", ContentModel.PROP_TITLE).getStringValue());
            AVMServiceLocalTest.assertEquals((String)"foo descrip", (String)fService.getNodeProperty(-1, "main:/b/foo", ContentModel.PROP_DESCRIPTION).getStringValue());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testUpdateDirectoryTitleAndDescription() throws Exception {
        try {
            fService.createLayeredDirectory("main:/", "layer:/", "layer");
            fService.createDirectory("layer:/layer", "b");
            fService.createFile("layer:/layer/b", "foo").close();
            List<AVMDifference> diffs = fSyncService.compare(-1, "layer:/layer", -1, "main:/", null);
            AVMServiceLocalTest.assertEquals((String)"[layer:/layer/b[-1] > main:/b[-1]]", (String)diffs.toString());
            fService.createSnapshot("layer", null, null);
            fSyncService.update(diffs, null, false, false, false, false, null, null);
            fService.createSnapshot("main", null, null);
            diffs = fSyncService.compare(-1, "layer:/layer", -1, "main:/", null);
            AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
            fSyncService.flatten("layer:/layer", "main:/");
            AVMServiceLocalTest.assertEquals((int)0, (int)fService.getNodeProperties(-1, "main:/b").size());
            AVMServiceLocalTest.assertEquals((int)0, (int)fService.getNodeProperties(-1, "layer:/layer/b").size());
            HashMap<QName, PropertyValue> properties = new HashMap<QName, PropertyValue>();
            properties.put(ContentModel.PROP_TITLE, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)"b title")));
            properties.put(ContentModel.PROP_DESCRIPTION, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)"b descrip")));
            fService.setNodeProperties("layer:/layer/b", properties);
            AVMServiceLocalTest.assertEquals((int)0, (int)fService.getNodeProperties(-1, "main:/b").size());
            AVMServiceLocalTest.assertEquals((int)2, (int)fService.getNodeProperties(-1, "layer:/layer/b").size());
            diffs = fSyncService.compare(-1, "layer:/layer", -1, "main:/", null);
            AVMServiceLocalTest.assertEquals((String)"[layer:/layer/b[-1] > main:/b[-1]]", (String)diffs.toString());
            fService.createSnapshot("layer", null, null);
            fSyncService.update(diffs, null, false, false, false, false, null, null);
            fService.createSnapshot("main", null, null);
            AVMServiceLocalTest.assertEquals((int)2, (int)fService.getNodeProperties(-1, "main:/b").size());
            AVMServiceLocalTest.assertEquals((int)2, (int)fService.getNodeProperties(-1, "layer:/layer/b").size());
            diffs = fSyncService.compare(-1, "layer:/layer", -1, "main:/", null);
            AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
            fSyncService.flatten("layer:/layer", "main:/");
            AVMServiceLocalTest.assertEquals((int)2, (int)fService.getNodeProperties(-1, "main:/b").size());
            AVMServiceLocalTest.assertEquals((int)2, (int)fService.getNodeProperties(-1, "layer:/layer/b").size());
            AVMServiceLocalTest.assertEquals((String)"b title", (String)fService.getNodeProperty(-1, "main:/b", ContentModel.PROP_TITLE).getStringValue());
            AVMServiceLocalTest.assertEquals((String)"b descrip", (String)fService.getNodeProperty(-1, "main:/b", ContentModel.PROP_DESCRIPTION).getStringValue());
            fService.setNodeProperty("layer:/layer/b", ContentModel.PROP_TITLE, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)"b title2")));
            fService.setNodeProperty("layer:/layer/b", ContentModel.PROP_DESCRIPTION, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)"b descrip2")));
            diffs = fSyncService.compare(-1, "layer:/layer", -1, "main:/", null);
            AVMServiceLocalTest.assertEquals((String)"[layer:/layer/b[-1] > main:/b[-1]]", (String)diffs.toString());
            fService.createSnapshot("layer", null, null);
            fSyncService.update(diffs, null, false, false, false, false, null, null);
            fService.createSnapshot("main", null, null);
            diffs = fSyncService.compare(-1, "layer:/layer", -1, "main:/", null);
            AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
            fSyncService.flatten("layer:/layer", "main:/");
            AVMServiceLocalTest.assertEquals((int)2, (int)fService.getNodeProperties(-1, "main:/b").size());
            AVMServiceLocalTest.assertEquals((int)2, (int)fService.getNodeProperties(-1, "layer:/layer/b").size());
            AVMServiceLocalTest.assertEquals((String)"b title2", (String)fService.getNodeProperty(-1, "main:/b", ContentModel.PROP_TITLE).getStringValue());
            AVMServiceLocalTest.assertEquals((String)"b descrip2", (String)fService.getNodeProperty(-1, "main:/b", ContentModel.PROP_DESCRIPTION).getStringValue());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testSimpleUpdateLF1() throws Exception {
        try {
            List<VersionDescriptor> snapshots = fService.getStoreVersions("main");
            AVMServiceLocalTest.assertEquals((int)1, (int)snapshots.size());
            AVMServiceLocalTest.assertEquals((int)0, (int)snapshots.get(0).getVersionID());
            snapshots = fService.getStoreVersions("layer");
            AVMServiceLocalTest.assertEquals((int)1, (int)snapshots.size());
            AVMServiceLocalTest.assertEquals((int)0, (int)snapshots.get(0).getVersionID());
            fService.createDirectory("main:/", "a");
            fService.createDirectory("layer:/", "a");
            logger.debug((Object)"created 2 plain dirs: main:/a, layer:/a");
            fService.createFile("main:/a", "foo");
            AVMServiceLocalTest.assertEquals((int)1, (int)fService.lookup(-1, "main:/a/foo").getVersionID());
            PrintStream out = new PrintStream(fService.getFileOutputStream("main:/a/foo"));
            out.println("I am main:/a/foo");
            out.close();
            AVMNodeDescriptor node = fService.lookup(-1, "main:/a/foo");
            AVMServiceLocalTest.assertEquals((int)1, (int)node.getVersionID());
            List<AVMNodeDescriptor> history = fService.getHistory(node, -1);
            AVMServiceLocalTest.assertEquals((int)0, (int)history.size());
            fService.createSnapshot("main", null, null);
            snapshots = fService.getStoreVersions("main");
            AVMServiceLocalTest.assertEquals((int)2, (int)snapshots.size());
            AVMServiceLocalTest.assertEquals((int)1, (int)snapshots.get(snapshots.size() - 1).getVersionID());
            snapshots = fService.getStoreVersions("layer");
            AVMServiceLocalTest.assertEquals((int)1, (int)snapshots.size());
            AVMServiceLocalTest.assertEquals((int)0, (int)snapshots.get(0).getVersionID());
            AVMServiceLocalTest.assertEquals((int)1, (int)fService.lookup(-1, "main:/a/foo").getVersionID());
            AVMServiceLocalTest.assertEquals((int)1, (int)fService.lookup(1, "main:/a/foo").getVersionID());
            logger.debug((Object)"created plain file: main:/a/foo");
            fService.createLayeredFile("main:/a/foo", "layer:/a", "foo");
            AVMServiceLocalTest.assertEquals((int)1, (int)fService.lookup(-1, "layer:/a/foo").getVersionID());
            BufferedReader reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "layer:/a/foo")));
            String line = reader.readLine();
            reader.close();
            AVMServiceLocalTest.assertEquals((String)"I am main:/a/foo", (String)line);
            node = fService.lookup(-1, "layer:/a/foo");
            AVMServiceLocalTest.assertEquals((int)1, (int)node.getVersionID());
            history = fService.getHistory(node, -1);
            AVMServiceLocalTest.assertEquals((int)0, (int)history.size());
            fService.createSnapshot("layer", null, null);
            snapshots = fService.getStoreVersions("main");
            AVMServiceLocalTest.assertEquals((int)2, (int)snapshots.size());
            AVMServiceLocalTest.assertEquals((int)1, (int)snapshots.get(snapshots.size() - 1).getVersionID());
            snapshots = fService.getStoreVersions("layer");
            AVMServiceLocalTest.assertEquals((int)2, (int)snapshots.size());
            AVMServiceLocalTest.assertEquals((int)1, (int)snapshots.get(snapshots.size() - 1).getVersionID());
            AVMServiceLocalTest.assertEquals((int)1, (int)fService.lookup(-1, "layer:/a/foo").getVersionID());
            AVMServiceLocalTest.assertEquals((int)1, (int)fService.lookup(1, "layer:/a/foo").getVersionID());
            List<AVMDifference> diffs = fSyncService.compare(-1, "layer:/a", -1, "main:/a", null);
            AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "layer:/a/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceLocalTest.assertEquals((String)"I am main:/a/foo", (String)line);
            logger.debug((Object)"created layered file: layer:/a/foo -> main:/a/foo");
            out = new PrintStream(fService.getFileOutputStream("layer:/a/foo"));
            out.println("I am layer:/a/foo");
            out.close();
            logger.debug((Object)"modified file: layer:/a/foo");
            AVMServiceLocalTest.assertEquals((int)2, (int)fService.lookup(-1, "layer:/a/foo").getVersionID());
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/a/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceLocalTest.assertEquals((String)"I am main:/a/foo", (String)line);
            diffs = fSyncService.compare(-1, "layer:/a", -1, "main:/a", null);
            AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
            AVMServiceLocalTest.assertEquals((String)"[layer:/a/foo[-1] > main:/a/foo[-1]]", (String)diffs.toString());
            fSyncService.update(diffs, null, false, false, false, false, "one", "one");
            snapshots = fService.getStoreVersions("main");
            AVMServiceLocalTest.assertEquals((int)3, (int)snapshots.size());
            AVMServiceLocalTest.assertEquals((int)2, (int)snapshots.get(snapshots.size() - 1).getVersionID());
            snapshots = fService.getStoreVersions("layer");
            AVMServiceLocalTest.assertEquals((int)3, (int)snapshots.size());
            AVMServiceLocalTest.assertEquals((int)2, (int)snapshots.get(snapshots.size() - 1).getVersionID());
            node = fService.lookup(-1, "layer:/a/foo");
            AVMServiceLocalTest.assertEquals((int)2, (int)node.getVersionID());
            history = fService.getHistory(node, -1);
            AVMServiceLocalTest.assertEquals((int)1, (int)history.size());
            AVMServiceLocalTest.assertEquals((int)1, (int)history.get(0).getVersionID());
            AVMServiceLocalTest.assertEquals((int)1, (int)fService.lookup(1, "layer:/a/foo").getVersionID());
            AVMServiceLocalTest.assertEquals((int)2, (int)fService.lookup(2, "layer:/a/foo").getVersionID());
            logger.debug((Object)"submitted/updated file: layer:/a/foo -> main:/a/foo");
            fSyncService.flatten("layer:/a", "main:/a");
            logger.debug((Object)"flatten dir: layer:/a -> main:/a");
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "layer:/a/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceLocalTest.assertEquals((String)"I am layer:/a/foo", (String)line);
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/a/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceLocalTest.assertEquals((String)"I am layer:/a/foo", (String)line);
            snapshots = fService.getStoreVersions("main");
            AVMServiceLocalTest.assertEquals((int)3, (int)snapshots.size());
            AVMServiceLocalTest.assertEquals((int)2, (int)snapshots.get(snapshots.size() - 1).getVersionID());
            snapshots = fService.getStoreVersions("layer");
            AVMServiceLocalTest.assertEquals((int)3, (int)snapshots.size());
            AVMServiceLocalTest.assertEquals((int)2, (int)snapshots.get(snapshots.size() - 1).getVersionID());
            this.recursiveList("main");
            this.recursiveList("layer");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testSimpleUpdateLF2() throws Exception {
        try {
            try {
                fService.createStore("mainA");
                fService.createStore("mainB");
                fService.createStore("mainB--layer");
                List<VersionDescriptor> snapshots = fService.getStoreVersions("mainA");
                AVMServiceLocalTest.assertEquals((int)1, (int)snapshots.size());
                AVMServiceLocalTest.assertEquals((int)0, (int)snapshots.get(0).getVersionID());
                snapshots = fService.getStoreVersions("mainB");
                AVMServiceLocalTest.assertEquals((int)1, (int)snapshots.size());
                AVMServiceLocalTest.assertEquals((int)0, (int)snapshots.get(0).getVersionID());
                snapshots = fService.getStoreVersions("mainB--layer");
                AVMServiceLocalTest.assertEquals((int)1, (int)snapshots.size());
                AVMServiceLocalTest.assertEquals((int)0, (int)snapshots.get(0).getVersionID());
                logger.debug((Object)"created 3 stores: mainA, mainB, mainB-layer");
                fService.createDirectory("mainA:/", "a");
                fService.createDirectory("mainB:/", "a");
                logger.debug((Object)"created 2 plain dirs: mainA:/a, mainB:/a");
                fService.createLayeredDirectory("mainB:/a", "mainB--layer:/", "a");
                logger.debug((Object)"created layered dir: mainB--layer:/a -> mainB:/a");
                fService.createFile("mainA:/a", "foo");
                AVMServiceLocalTest.assertEquals((int)1, (int)fService.lookup(-1, "mainA:/a/foo").getVersionID());
                AVMServiceLocalTest.assertNull((Object)fService.lookup(-1, "mainB:/a/foo"));
                AVMServiceLocalTest.assertNull((Object)fService.lookup(-1, "mainB--layer:/a/foo"));
                PrintStream out = new PrintStream(fService.getFileOutputStream("mainA:/a/foo"));
                out.println("I am mainA:/a/foo");
                out.close();
                logger.debug((Object)"created plain file: mainA:/a/foo");
                fService.createSnapshot("mainA", null, null);
                AVMServiceLocalTest.assertEquals((int)1, (int)fService.lookup(-1, "mainA:/a/foo").getVersionID());
                AVMServiceLocalTest.assertNull((Object)fService.lookup(-1, "mainB:/a/foo"));
                AVMServiceLocalTest.assertNull((Object)fService.lookup(-1, "mainB--layer:/a/foo"));
                snapshots = fService.getStoreVersions("mainA");
                AVMServiceLocalTest.assertEquals((int)2, (int)snapshots.size());
                AVMServiceLocalTest.assertEquals((int)1, (int)snapshots.get(snapshots.size() - 1).getVersionID());
                logger.debug((Object)"created snapshot: mainA");
                fService.createLayeredFile("mainA:/a/foo", "mainB:/a", "foo");
                AVMServiceLocalTest.assertEquals((int)1, (int)fService.lookup(-1, "mainA:/a/foo").getVersionID());
                AVMServiceLocalTest.assertEquals((int)1, (int)fService.lookup(-1, "mainB:/a/foo").getVersionID());
                AVMServiceLocalTest.assertEquals((int)1, (int)fService.lookup(-1, "mainB--layer:/a/foo").getVersionID());
                BufferedReader reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB--layer:/a/foo")));
                String line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/foo", (String)line);
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB:/a/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/foo", (String)line);
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainA:/a/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/foo", (String)line);
                logger.debug((Object)"created layered file: mainB:/a/foo -> mainA:/a/foo");
                out = new PrintStream(fService.getFileOutputStream("mainB--layer:/a/foo"));
                out.println("I am mainB--layer:/a/foo");
                out.close();
                AVMServiceLocalTest.assertEquals((int)1, (int)fService.lookup(-1, "mainA:/a/foo").getVersionID());
                AVMServiceLocalTest.assertEquals((int)1, (int)fService.lookup(-1, "mainB:/a/foo").getVersionID());
                AVMServiceLocalTest.assertEquals((int)2, (int)fService.lookup(-1, "mainB--layer:/a/foo").getVersionID());
                logger.debug((Object)"modified file: mainB--layer:/a/foo");
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB--layer:/a/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainB--layer:/a/foo", (String)line);
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB:/a/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/foo", (String)line);
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainA:/a/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/foo", (String)line);
                List<AVMDifference> diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[mainB--layer:/a/foo[-1] > mainB:/a/foo[-1]]", (String)diffs.toString());
                fSyncService.update(diffs, null, false, false, false, false, "one", "one");
                fSyncService.flatten("mainB--layer:/a", "mainB:/a");
                AVMServiceLocalTest.assertEquals((int)1, (int)fService.lookup(-1, "mainA:/a/foo").getVersionID());
                AVMServiceLocalTest.assertEquals((int)2, (int)fService.lookup(-1, "mainB:/a/foo").getVersionID());
                AVMServiceLocalTest.assertEquals((int)2, (int)fService.lookup(-1, "mainB--layer:/a/foo").getVersionID());
                snapshots = fService.getStoreVersions("mainB--layer");
                AVMServiceLocalTest.assertEquals((int)2, (int)snapshots.size());
                AVMServiceLocalTest.assertEquals((int)1, (int)snapshots.get(snapshots.size() - 1).getVersionID());
                snapshots = fService.getStoreVersions("mainB");
                AVMServiceLocalTest.assertEquals((int)3, (int)snapshots.size());
                AVMServiceLocalTest.assertEquals((int)2, (int)snapshots.get(snapshots.size() - 1).getVersionID());
                logger.debug((Object)"submit/update file: mainB--layer:/a/foo -> mainB:/a/foo");
                fSyncService.flatten("mainB--layer:/a", "mainB:/a");
                logger.debug((Object)"flatten dir: mainB--layer:/a/foo -> mainB:/a/foo");
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB--layer:/a/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainB--layer:/a/foo", (String)line);
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB:/a/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainB--layer:/a/foo", (String)line);
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainA:/a/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/foo", (String)line);
                this.recursiveList("mainA");
                this.recursiveList("mainB");
                this.recursiveList("mainB--layer");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw e;
            }
            Object var7_7 = null;
            fService.purgeStore("mainA");
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            fService.purgeStore("mainA");
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
            throw throwable;
        }
    }

    public void testSimpleUpdateLF3() throws Exception {
        try {
            try {
                fService.createStore("mainA");
                fService.createStore("mainB");
                fService.createStore("mainB--layer");
                List<VersionDescriptor> snapshots = fService.getStoreVersions("mainA");
                AVMServiceLocalTest.assertEquals((int)1, (int)snapshots.size());
                AVMServiceLocalTest.assertEquals((int)0, (int)snapshots.get(0).getVersionID());
                snapshots = fService.getStoreVersions("mainB");
                AVMServiceLocalTest.assertEquals((int)1, (int)snapshots.size());
                AVMServiceLocalTest.assertEquals((int)0, (int)snapshots.get(0).getVersionID());
                snapshots = fService.getStoreVersions("mainB--layer");
                AVMServiceLocalTest.assertEquals((int)1, (int)snapshots.size());
                AVMServiceLocalTest.assertEquals((int)0, (int)snapshots.get(0).getVersionID());
                logger.debug((Object)"created 3 stores: mainA, mainB, mainB-layer");
                fService.createDirectory("mainA:/", "a");
                fService.createDirectory("mainB:/", "a");
                logger.debug((Object)"created 2 plain dirs: mainA:/a, mainB:/a");
                fService.createLayeredDirectory("mainB:/a", "mainB--layer:/", "a");
                logger.debug((Object)"created layered dir: mainB--layer:/a -> mainB:/a");
                fService.createFile("mainA:/a", "foo");
                AVMServiceLocalTest.assertEquals((int)1, (int)fService.lookup(-1, "mainA:/a/foo").getVersionID());
                AVMServiceLocalTest.assertNull((Object)fService.lookup(-1, "mainB:/a/foo"));
                AVMServiceLocalTest.assertNull((Object)fService.lookup(-1, "mainB--layer:/a/foo"));
                PrintStream out = new PrintStream(fService.getFileOutputStream("mainA:/a/foo"));
                out.println("I am mainA:/a/foo");
                out.close();
                logger.debug((Object)"created plain file: mainA:/a/foo");
                fService.createSnapshot("mainA", null, null);
                AVMServiceLocalTest.assertEquals((int)1, (int)fService.lookup(-1, "mainA:/a/foo").getVersionID());
                AVMServiceLocalTest.assertNull((Object)fService.lookup(-1, "mainB:/a/foo"));
                AVMServiceLocalTest.assertNull((Object)fService.lookup(-1, "mainB--layer:/a/foo"));
                snapshots = fService.getStoreVersions("mainA");
                AVMServiceLocalTest.assertEquals((int)2, (int)snapshots.size());
                AVMServiceLocalTest.assertEquals((int)1, (int)snapshots.get(snapshots.size() - 1).getVersionID());
                logger.debug((Object)"created snapshot: mainA");
                fService.createLayeredFile("mainA:/a/foo", "mainB:/a", "foo");
                AVMServiceLocalTest.assertEquals((int)1, (int)fService.lookup(-1, "mainA:/a/foo").getVersionID());
                AVMServiceLocalTest.assertEquals((int)1, (int)fService.lookup(-1, "mainB:/a/foo").getVersionID());
                AVMNodeDescriptor foo = fService.lookup(-1, "mainB--layer:/a/foo");
                AVMServiceLocalTest.assertEquals((int)1, (int)foo.getVersionID());
                AVMServiceLocalTest.assertTrue((boolean)foo.isLayeredFile());
                BufferedReader reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB--layer:/a/foo")));
                String line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/foo", (String)line);
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB:/a/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/foo", (String)line);
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainA:/a/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/foo", (String)line);
                logger.debug((Object)"created layered file: mainB:/a/foo -> mainA:/a/foo");
                fService.createDirectory("mainB--layer:/a", "b");
                AVMServiceLocalTest.assertEquals((int)1, (int)fService.lookup(-1, "mainA:/a/foo").getVersionID());
                AVMServiceLocalTest.assertEquals((int)1, (int)fService.lookup(-1, "mainB:/a/foo").getVersionID());
                AVMServiceLocalTest.assertEquals((int)1, (int)fService.lookup(-1, "mainB--layer:/a/b").getVersionID());
                foo = fService.lookup(-1, "mainB--layer:/a/foo");
                AVMServiceLocalTest.assertEquals((int)1, (int)foo.getVersionID());
                AVMServiceLocalTest.assertTrue((boolean)foo.isLayeredFile());
                logger.debug((Object)"created dir: mainB--layer:/a/b");
                List<AVMDifference> diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                foo = fService.lookup(-1, "mainB--layer:/a/foo");
                AVMServiceLocalTest.assertTrue((boolean)foo.isLayeredFile());
                AVMServiceLocalTest.assertEquals((String)"[mainB--layer:/a/b[-1] > mainB:/a/b[-1]]", (String)diffs.toString());
                fSyncService.update(diffs, null, false, false, false, false, "one", "one");
                foo = fService.lookup(-1, "mainB--layer:/a/foo");
                AVMServiceLocalTest.assertTrue((boolean)foo.isLayeredFile());
                fSyncService.flatten("mainB--layer:/a", "mainB:/a");
                foo = fService.lookup(-1, "mainB--layer:/a/foo");
                AVMServiceLocalTest.assertTrue((boolean)foo.isLayeredFile());
                AVMServiceLocalTest.assertEquals((int)1, (int)fService.lookup(-1, "mainA:/a/foo").getVersionID());
                AVMServiceLocalTest.assertEquals((int)2, (int)fService.lookup(-1, "mainB:/a/foo").getVersionID());
                AVMServiceLocalTest.assertEquals((int)2, (int)fService.lookup(-1, "mainB--layer:/a/foo").getVersionID());
                snapshots = fService.getStoreVersions("mainB--layer");
                AVMServiceLocalTest.assertEquals((int)2, (int)snapshots.size());
                AVMServiceLocalTest.assertEquals((int)1, (int)snapshots.get(snapshots.size() - 1).getVersionID());
                snapshots = fService.getStoreVersions("mainB");
                AVMServiceLocalTest.assertEquals((int)3, (int)snapshots.size());
                AVMServiceLocalTest.assertEquals((int)2, (int)snapshots.get(snapshots.size() - 1).getVersionID());
                logger.debug((Object)"submitted dir: mainB--layer:/a/b -> mainB:/a/b");
                foo = fService.lookup(-1, "mainB--layer:/a/foo");
                AVMServiceLocalTest.assertEquals((int)2, (int)foo.getVersionID());
                AVMServiceLocalTest.assertTrue((boolean)foo.isLayeredFile());
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainA:/a/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/foo", (String)line);
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB:/a/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/foo", (String)line);
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB--layer:/a/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/foo", (String)line);
                this.recursiveList("mainA");
                this.recursiveList("mainB");
                this.recursiveList("mainB--layer");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw e;
            }
            Object var8_8 = null;
            fService.purgeStore("mainA");
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            fService.purgeStore("mainA");
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
            throw throwable;
        }
    }

    public void testLayeredFolder1() throws Exception {
        try {
            try {
                fService.createStore("mainA");
                fService.createStore("mainB");
                fService.createDirectory("mainA:/", "a");
                fService.createDirectory("mainA:/a", "b");
                fService.createDirectory("mainB:/", "a");
                fService.createStore("mainB--layer");
                fService.createLayeredDirectory("mainB:/a", "mainB--layer:/", "a");
                fService.createFile("mainA:/a/b", "foo");
                PrintStream out = new PrintStream(fService.getFileOutputStream("mainA:/a/b/foo"));
                out.println("I am mainA:/a/b/foo");
                out.close();
                logger.debug((Object)"created file: mainA:/a/b/foo");
                fService.createLayeredDirectory("mainA:/a/b", "mainB:/a", "b");
                fService.createSnapshot("mainA", null, null);
                fService.createSnapshot("mainB", null, null);
                AVMServiceLocalTest.assertTrue((boolean)fService.lookup(-1, "mainB--layer:/a/b").isLayeredDirectory());
                logger.debug((Object)"created layered directory: mainB:/a/b -> mainA:/a/b");
                fService.createDirectory("mainB--layer:/a", "c");
                fService.createSnapshot("mainB--layer", null, null);
                logger.debug((Object)"created dir: mainB--layer:/a/c");
                List<AVMDifference> diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[mainB--layer:/a/c[-1] > mainB:/a/c[-1]]", (String)diffs.toString());
                fSyncService.update(diffs, null, false, false, false, false, "one", "one");
                fSyncService.flatten("mainB--layer:/a", "mainB:/a");
                logger.debug((Object)"updated: created dir: mainB:/a/c");
                AVMServiceLocalTest.assertTrue((boolean)fService.lookup(-1, "mainB--layer:/a/b").isLayeredDirectory());
                fService.createDirectory("mainB--layer:/a/b", "c");
                AVMServiceLocalTest.assertTrue((boolean)fService.lookup(-1, "mainB--layer:/a/b").isLayeredDirectory());
                fService.createSnapshot("mainB--layer", null, null);
                logger.debug((Object)"created dir: mainB--layer:/a/b/c");
                diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[mainB--layer:/a/b/c[-1] > mainB:/a/b/c[-1]]", (String)diffs.toString());
                fSyncService.update(diffs, null, false, false, false, false, "one", "one");
                fSyncService.flatten("mainB--layer:/a", "mainB:/a");
                logger.debug((Object)"updated: created dir: mainB:/a/b/c");
                AVMServiceLocalTest.assertTrue((boolean)fService.lookup(-1, "mainB--layer:/a/b").isLayeredDirectory());
                this.recursiveList("mainA");
                this.recursiveList("mainB");
                this.recursiveList("mainB--layer");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw e;
            }
            Object var4_4 = null;
            fService.purgeStore("mainA");
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            fService.purgeStore("mainA");
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
            throw throwable;
        }
    }

    public void testLayeredFolder2() throws Exception {
        try {
            try {
                fService.createStore("mainA");
                fService.createStore("mainB");
                fService.createDirectory("mainA:/", "a");
                fService.createDirectory("mainA:/a", "b");
                fService.createDirectory("mainB:/", "a");
                fService.createStore("mainB--layer");
                List<VersionDescriptor> snapshots = fService.getStoreVersions("mainA");
                AVMServiceLocalTest.assertEquals((int)1, (int)snapshots.size());
                AVMServiceLocalTest.assertEquals((int)0, (int)snapshots.get(0).getVersionID());
                snapshots = fService.getStoreVersions("mainB");
                AVMServiceLocalTest.assertEquals((int)1, (int)snapshots.size());
                AVMServiceLocalTest.assertEquals((int)0, (int)snapshots.get(0).getVersionID());
                snapshots = fService.getStoreVersions("mainB--layer");
                AVMServiceLocalTest.assertEquals((int)1, (int)snapshots.size());
                AVMServiceLocalTest.assertEquals((int)0, (int)snapshots.get(0).getVersionID());
                fService.createLayeredDirectory("mainB:/a", "mainB--layer:/", "a");
                fService.createFile("mainA:/a/b", "foo");
                PrintStream out = new PrintStream(fService.getFileOutputStream("mainA:/a/b/foo"));
                out.println("I am mainA:/a/b/foo");
                out.close();
                logger.debug((Object)"created file: mainA:/a/b/foo");
                fService.createLayeredDirectory("mainA:/a/b", "mainB:/a", "b");
                logger.debug((Object)"created layered directory: mainB:/a/b -> mainA:/a/b");
                fService.createFile("mainB--layer:/a/b", "bar");
                out = new PrintStream(fService.getFileOutputStream("mainB--layer:/a/b/bar"));
                out.println("I am mainB--layer:/a/b/bar");
                out.close();
                logger.debug((Object)"created file: mainB--layer:/a/b/bar");
                List<AVMDifference> diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[mainB--layer:/a/b/bar[-1] > mainB:/a/b/bar[-1]]", (String)diffs.toString());
                snapshots = fService.getStoreVersions("mainB");
                AVMServiceLocalTest.assertEquals((int)1, (int)snapshots.size());
                fSyncService.update(diffs, null, false, false, false, false, "one", "one");
                snapshots = fService.getStoreVersions("mainB");
                AVMServiceLocalTest.assertEquals((int)3, (int)snapshots.size());
                fSyncService.flatten("mainB--layer:/a", "mainB:/a");
                logger.debug((Object)"updated: created file: mainB:/a/b/bar");
                snapshots = fService.getStoreVersions("mainB");
                AVMServiceLocalTest.assertEquals((int)3, (int)snapshots.size());
                AVMServiceLocalTest.assertEquals((int)2, (int)snapshots.get(snapshots.size() - 1).getVersionID());
                fService.createFile("mainA:/a/b", "baz");
                out = new PrintStream(fService.getFileOutputStream("mainA:/a/b/baz"));
                out.println("I am mainA:/a/b/baz");
                out.close();
                logger.debug((Object)"created file: mainA:/a/b/baz");
                fService.createSnapshot("mainB", "two", "two");
                logger.debug((Object)"snapshot: mainB");
                snapshots = fService.getStoreVersions("mainB");
                AVMServiceLocalTest.assertEquals((int)4, (int)snapshots.size());
                AVMServiceLocalTest.assertEquals((int)3, (int)snapshots.get(snapshots.size() - 1).getVersionID());
                diffs = fSyncService.compare(2, "mainB:/a", 3, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[mainB:/a/b/baz[2] < mainB:/a/b/baz[3]]", (String)diffs.toString());
                logger.debug((Object)"list mainB [2]");
                this.recursiveList("mainB", 2);
                logger.debug((Object)"list mainB [3]");
                this.recursiveList("mainB", 3);
                this.recursiveList("mainA");
                this.recursiveList("mainB");
                this.recursiveList("mainB--layer");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw e;
            }
            Object var5_5 = null;
            fService.purgeStore("mainA");
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            fService.purgeStore("mainA");
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
            throw throwable;
        }
    }

    public void testLayeredFolder3() throws Exception {
        try {
            try {
                fService.createStore("mainA");
                fService.createStore("mainB");
                fService.createStore("mainB--layer");
                logger.debug((Object)"created stores: mainA, mainB and mainB--layer");
                fService.createDirectory("mainA:/", "a");
                fService.createDirectory("mainA:/a", "b");
                fService.createDirectory("mainB:/", "a");
                logger.debug((Object)"created directories: mainA:/a/b and mainB:/a");
                fService.createLayeredDirectory("mainB:/a", "mainB--layer:/", "a");
                logger.debug((Object)"created layered directory: mainB--layer:/a -> mainB:/a");
                fService.createLayeredDirectory("mainA:/a/b", "mainB:/a", "b");
                logger.debug((Object)"created layered directory: mainB:/a/b -> mainA:/a/b");
                fService.createDirectory("mainB--layer:/a/b", "c");
                logger.debug((Object)"created directory: mainB--layer:/a/b/c");
                fService.createFile("mainB--layer:/a/b/c", "foo");
                PrintStream out = new PrintStream(fService.getFileOutputStream("mainB--layer:/a/b/c/foo"));
                out.println("I am mainB--layer:/a/b/c/foo");
                out.close();
                logger.debug((Object)"created file: mainB--layer:/a/b/c/foo");
                List<AVMDifference> diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[mainB--layer:/a/b/c[-1] > mainB:/a/b/c[-1]]", (String)diffs.toString());
                fSyncService.update(diffs, null, false, false, false, false, "one", "one");
                logger.debug((Object)"updated: mainB--layer:/a/b/c (including 'foo') to mainB:/a/b/c");
                diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
                diffs = fSyncService.compare(-1, "mainB:/a", -1, "mainA:/a", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[mainB:/a/b/c[-1] > mainA:/a/b/c[-1]]", (String)diffs.toString());
                fSyncService.flatten("mainB--layer:/a", "mainB:/a");
                logger.debug((Object)"flattened: mainB--layer:/a to mainB:/a");
                diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
                diffs = fSyncService.compare(-1, "mainB:/a", -1, "mainA:/a", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[mainB:/a/b/c[-1] > mainA:/a/b/c[-1]]", (String)diffs.toString());
                out = new PrintStream(fService.getFileOutputStream("mainB--layer:/a/b/c/foo"));
                out.println("I am mainB--layer:/a/b/c/foo V2");
                out.close();
                logger.debug((Object)"updated file: mainB--layer:/a/b/c/foo");
                diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[mainB--layer:/a/b/c/foo[-1] > mainB:/a/b/c/foo[-1]]", (String)diffs.toString());
                logger.debug((Object)"updated: mainB:/a/b/c/foo");
                diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[mainB--layer:/a/b/c/foo[-1] > mainB:/a/b/c/foo[-1]]", (String)diffs.toString());
                fSyncService.update(diffs, null, false, false, false, false, "two", "two");
                logger.debug((Object)"updated: mainB--layer:/a/b/c/foo to mainB:/a/b/c/foo");
                fSyncService.flatten("mainB--layer:/a", "mainB:/a");
                logger.debug((Object)"flattened: mainB--layer:/a to mainB:/a");
                diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
                this.recursiveList("mainA");
                this.recursiveList("mainB");
                this.recursiveList("mainB--layer");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw e;
            }
            Object var4_4 = null;
            fService.purgeStore("mainA");
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            fService.purgeStore("mainA");
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
            throw throwable;
        }
    }

    public void testLayeredFolder4() throws Exception {
        try {
            try {
                logger.debug((Object)"start: testLayeredFolder4");
                fService.createStore("mainA");
                fService.createStore("mainB");
                fService.createStore("mainB--layer");
                logger.debug((Object)"created stores: mainA, mainB and mainB--layer");
                this.recursiveList("mainA");
                this.recursiveList("mainB");
                this.recursiveList("mainB--layer");
                fService.createDirectory("mainA:/", "a");
                fService.createDirectory("mainA:/a", "b");
                fService.createDirectory("mainA:/a/b", "c");
                fService.createDirectory("mainB:/", "a");
                logger.debug((Object)"created directories: mainA:/a/b/c and mainB:/a");
                this.recursiveList("mainA");
                this.recursiveList("mainB");
                this.recursiveList("mainB--layer");
                fService.createLayeredDirectory("mainB:/a", "mainB--layer:/", "a");
                logger.debug((Object)"created layered directory: mainB--layer:/a -> mainB:/a");
                this.recursiveList("mainA");
                this.recursiveList("mainB");
                this.recursiveList("mainB--layer");
                fService.createLayeredDirectory("mainA:/a/b", "mainB:/a", "b");
                logger.debug((Object)"created layered directory: mainB:/a/b -> mainA:/a/b");
                this.recursiveList("mainA");
                this.recursiveList("mainB");
                this.recursiveList("mainB--layer");
                fService.createDirectory("mainB--layer:/a/b/c", "d");
                logger.debug((Object)"created directory: mainB--layer:/a/b/c/d");
                this.recursiveList("mainA");
                this.recursiveList("mainB");
                this.recursiveList("mainB--layer");
                List<AVMDifference> diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[mainB--layer:/a/b/c/d[-1] > mainB:/a/b/c/d[-1]]", (String)diffs.toString());
                fSyncService.update(diffs, null, false, false, false, false, "one", "one");
                logger.debug((Object)"updated: mainB--layer:/a/b/c/d to mainB:/a/b/c/d");
                this.recursiveList("mainA");
                this.recursiveList("mainB");
                this.recursiveList("mainB--layer");
                fSyncService.flatten("mainB--layer:/a", "mainB:/a");
                logger.debug((Object)"flattened: mainB--layer:/a to mainB:/a");
                this.recursiveList("mainA");
                this.recursiveList("mainB");
                this.recursiveList("mainB--layer");
                fService.createFile("mainB--layer:/a/b/c/d", "foo");
                PrintStream out = new PrintStream(fService.getFileOutputStream("mainB--layer:/a/b/c/d/foo"));
                out.println("I am mainB--layer:/a/b/c/d/foo");
                out.close();
                logger.debug((Object)"created file: mainB--layer:/a/b/c/foo");
                this.recursiveList("mainA");
                this.recursiveList("mainB");
                this.recursiveList("mainB--layer");
                fService.createStore("mainB--workflow1");
                logger.debug((Object)"created store: mainB--workflow1");
                this.recursiveList("mainA");
                this.recursiveList("mainB");
                this.recursiveList("mainB--layer");
                this.recursiveList("mainB--workflow1");
                fService.createLayeredDirectory("mainB:/a", "mainB--workflow1:/", "a");
                logger.debug((Object)"created layered dir: mainB--workflow1:/a -> mainB:/a");
                this.recursiveList("mainA");
                this.recursiveList("mainB");
                this.recursiveList("mainB--layer");
                this.recursiveList("mainB--workflow1");
                diffs = fSyncService.compare(-1, "mainB--workflow1:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
                diffs = new ArrayList<AVMDifference>(1);
                diffs.add(new AVMDifference(-1, "mainB--layer:/a/b/c/d/foo", -1, "mainB--workflow1:/a/b/c/d/foo", 0));
                AVMServiceLocalTest.assertNotNull((Object)fService.lookup(-1, "mainB--workflow1:/a/b/c/d"));
                fSyncService.update(diffs, null, false, false, false, false, null, null);
                logger.debug((Object)"updated: added file: mainB--workflow1:/a/b/c/d/foo");
                this.recursiveList("mainA");
                this.recursiveList("mainB");
                this.recursiveList("mainB--layer");
                this.recursiveList("mainB--workflow1");
                diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((String)"[mainB--layer:/a/b/c/d/foo[-1] > mainB:/a/b/c/d/foo[-1]]", (String)diffs.toString());
                diffs = fSyncService.compare(-1, "mainB--workflow1:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((String)"[mainB--workflow1:/a/b/c/d/foo[-1] > mainB:/a/b/c/d/foo[-1]]", (String)diffs.toString());
                fSyncService.update(diffs, null, false, false, true, true, "two", "two");
                logger.debug((Object)"updated: added file: mainB:/a/b/c/d/foo");
                this.recursiveList("mainA");
                this.recursiveList("mainB");
                this.recursiveList("mainB--layer");
                this.recursiveList("mainB--workflow1");
                fSyncService.flatten("mainB--workflow1:/a", "mainB:/a");
                logger.debug((Object)"flattened: added file: mainB:/a/b/c/d/foo");
                this.recursiveList("mainA");
                this.recursiveList("mainB");
                this.recursiveList("mainB--layer");
                this.recursiveList("mainB--workflow1");
                diffs = fSyncService.compare(-1, "mainB--workflow1:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
                diffs = fSyncService.compare(-1, "mainB--workflow1:/a", -1, "mainB--layer:/a", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
                logger.debug((Object)"finish: testLayeredFolder4");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw e;
            }
            Object var4_4 = null;
            fService.purgeStore("mainA");
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
            if (fService.getStore("mainB--workflow1") != null) {
                fService.purgeStore("mainB--workflow1");
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            fService.purgeStore("mainA");
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
            if (fService.getStore("mainB--workflow1") != null) {
                fService.purgeStore("mainB--workflow1");
            }
            throw throwable;
        }
    }

    public void testLayeredFolderDelete1() throws Exception {
        try {
            try {
                fService.createStore("mainA");
                fService.createStore("mainB");
                fService.createDirectory("mainA:/", "a");
                fService.createDirectory("mainA:/a", "b");
                fService.createDirectory("mainB:/", "a");
                fService.createStore("mainB--layer");
                fService.createLayeredDirectory("mainB:/a", "mainB--layer:/", "a");
                fService.createFile("mainA:/a/b", "foo");
                PrintStream out = new PrintStream(fService.getFileOutputStream("mainA:/a/b/foo"));
                out.println("I am mainA:/a/b/foo");
                out.close();
                logger.debug((Object)"created file: mainA:/a/b/foo");
                fService.createLayeredDirectory("mainA:/a/b", "mainB:/a", "b");
                fService.createSnapshot("mainA", null, null);
                fService.createSnapshot("mainB", null, null);
                logger.debug((Object)"created layered directory: mainB:/a/b -> mainA:/a/b");
                BufferedReader reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB--layer:/a/b/foo")));
                String line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/b/foo", (String)line);
                out = new PrintStream(fService.getFileOutputStream("mainB--layer:/a/b/foo"));
                out.println("I am mainB--layer:/a/b/foo");
                out.close();
                fService.createSnapshot("mainB--layer", null, null);
                logger.debug((Object)"updated file: mainB--layer:/a/b/foo");
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainA:/a/b/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/b/foo", (String)line);
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB:/a/b/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/b/foo", (String)line);
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB--layer:/a/b/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainB--layer:/a/b/foo", (String)line);
                List<AVMDifference> diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[mainB--layer:/a/b/foo[-1] > mainB:/a/b/foo[-1]]", (String)diffs.toString());
                fSyncService.update(diffs, null, false, false, false, false, "one", "one");
                fSyncService.flatten("mainB--layer:/a", "mainB:/a");
                logger.debug((Object)"updated: created file: mainB:/a/b/foo");
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB:/a/b/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainB--layer:/a/b/foo", (String)line);
                fService.removeNode("mainA:/a/b", "foo");
                fService.createSnapshot("mainA", null, null);
                logger.debug((Object)"removed file & snapshot: mainA:/a/b/foo");
                fService.removeNode("mainB--layer:/a/b", "foo");
                fService.createSnapshot("mainB--layer", null, null);
                diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[mainB--layer:/a/b/foo[-1] > mainB:/a/b/foo[-1]]", (String)diffs.toString());
                fSyncService.update(diffs, null, false, false, false, false, "one", "one");
                fSyncService.flatten("mainB--layer:/a", "mainB:/a");
                fService.createSnapshot("mainB", null, null);
                logger.debug((Object)"updated: removed file: mainB:/a/b/foo");
                this.recursiveList("mainA");
                this.recursiveList("mainB");
                this.recursiveList("mainB--layer");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw e;
            }
            Object var6_6 = null;
            fService.purgeStore("mainA");
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            fService.purgeStore("mainA");
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
            throw throwable;
        }
    }

    public void testLayeredFolderDelete2() throws Exception {
        try {
            try {
                fService.createStore("mainA");
                fService.createStore("mainB");
                fService.createDirectory("mainA:/", "a");
                fService.createDirectory("mainA:/a", "b");
                fService.createDirectory("mainB:/", "a");
                fService.createStore("mainB--layer");
                fService.createLayeredDirectory("mainB:/a", "mainB--layer:/", "a");
                fService.createFile("mainA:/a/b", "foo");
                PrintStream out = new PrintStream(fService.getFileOutputStream("mainA:/a/b/foo"));
                out.println("I am mainA:/a/b/foo");
                out.close();
                logger.debug((Object)"created file: mainA:/a/b/foo");
                fService.createLayeredDirectory("mainA:/a/b", "mainB:/a", "b");
                fService.createSnapshot("mainA", null, null);
                fService.createSnapshot("mainB", null, null);
                logger.debug((Object)"created layered directory: mainB:/a/b -> mainA:/a/b");
                BufferedReader reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB--layer:/a/b/foo")));
                String line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/b/foo", (String)line);
                out = new PrintStream(fService.getFileOutputStream("mainB--layer:/a/b/foo"));
                out.println("I am mainB--layer:/a/b/foo");
                out.close();
                fService.createSnapshot("mainB--layer", null, null);
                logger.debug((Object)"updated file: mainB--layer:/a/b/foo");
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainA:/a/b/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/b/foo", (String)line);
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB:/a/b/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/b/foo", (String)line);
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB--layer:/a/b/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainB--layer:/a/b/foo", (String)line);
                List<AVMDifference> diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[mainB--layer:/a/b/foo[-1] > mainB:/a/b/foo[-1]]", (String)diffs.toString());
                fSyncService.update(diffs, null, false, false, false, false, "one", "one");
                fSyncService.flatten("mainB--layer:/a", "mainB:/a");
                logger.debug((Object)"updated: created file: mainB:/a/b/foo");
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB:/a/b/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainB--layer:/a/b/foo", (String)line);
                fService.removeNode("mainA:/a", "b");
                fService.createSnapshot("mainA", null, null);
                logger.debug((Object)"removed folder & snapshot: mainA:/a/b");
                fService.removeNode("mainB--layer:/a/b", "foo");
                fService.createSnapshot("mainB--layer", null, null);
                logger.debug((Object)"removed file & snapshot: mainB--layer:/a/b/foo");
                diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[mainB--layer:/a/b/foo[-1] > mainB:/a/b/foo[-1]]", (String)diffs.toString());
                fSyncService.update(diffs, null, false, false, false, false, "one", "one");
                fSyncService.flatten("mainB--layer:/a", "mainB:/a");
                logger.debug((Object)"updated & flattened: removed file: mainB:/a/b/foo");
                this.recursiveList("mainA");
                this.recursiveList("mainB");
                this.recursiveList("mainB--layer");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw e;
            }
            Object var6_6 = null;
            fService.purgeStore("mainA");
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            fService.purgeStore("mainA");
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
            throw throwable;
        }
    }

    public void testLayeredFolderDelete3() throws Exception {
        try {
            try {
                fService.createStore("mainA");
                fService.createStore("mainB");
                fService.createDirectory("mainA:/", "a");
                fService.createDirectory("mainA:/a", "b");
                fService.createDirectory("mainB:/", "a");
                fService.createStore("mainB--layer");
                fService.createLayeredDirectory("mainB:/a", "mainB--layer:/", "a");
                fService.createFile("mainA:/a/b", "foo");
                PrintStream out = new PrintStream(fService.getFileOutputStream("mainA:/a/b/foo"));
                out.println("I am mainA:/a/b/foo");
                out.close();
                logger.debug((Object)"created file: mainA:/a/b/foo");
                fService.createLayeredDirectory("mainA:/a/b", "mainB:/a", "b");
                fService.createSnapshot("mainA", null, null);
                fService.createSnapshot("mainB", null, null);
                logger.debug((Object)"created layered directory: mainB:/a/b -> mainA:/a/b");
                BufferedReader reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB--layer:/a/b/foo")));
                String line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/b/foo", (String)line);
                out = new PrintStream(fService.getFileOutputStream("mainB--layer:/a/b/foo"));
                out.println("I am mainB--layer:/a/b/foo");
                out.close();
                logger.debug((Object)"updated file: mainB--layer:/a/b/foo");
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainA:/a/b/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/b/foo", (String)line);
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB:/a/b/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/b/foo", (String)line);
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB--layer:/a/b/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainB--layer:/a/b/foo", (String)line);
                List<AVMDifference> diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[mainB--layer:/a/b/foo[-1] > mainB:/a/b/foo[-1]]", (String)diffs.toString());
                fSyncService.update(diffs, null, false, false, false, false, "one", "one");
                fSyncService.flatten("mainB--layer:/a", "mainB:/a");
                logger.debug((Object)"updated: created file: mainB:/a/b/foo");
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB:/a/b/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainB--layer:/a/b/foo", (String)line);
                fService.removeNode("mainA:/a", "b");
                fService.createSnapshot("mainA", null, null);
                logger.debug((Object)"removed folder & snapshot: mainA:/a/b");
                fService.createFile("mainB--layer:/a/b", "bar");
                out = new PrintStream(fService.getFileOutputStream("mainB--layer:/a/b/bar"));
                out.println("I am mainB--layer:/a/b/bar");
                out.close();
                logger.debug((Object)"created file: mainB--layer:/a/b/bar");
                diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[mainB--layer:/a/b/bar[-1] > mainB:/a/b/bar[-1]]", (String)diffs.toString());
                fSyncService.update(diffs, null, false, false, false, false, "two", "two");
                fSyncService.flatten("mainB--layer:/a", "mainB:/a");
                logger.debug((Object)"updated & flattened: created file: mainB:/a/b/bar");
                this.recursiveList("mainA");
                this.recursiveList("mainB");
                this.recursiveList("mainB--layer");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw e;
            }
            Object var6_6 = null;
            fService.purgeStore("mainA");
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            fService.purgeStore("mainA");
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
            throw throwable;
        }
    }

    public void testLayeredFolderDelete4() throws Exception {
        try {
            try {
                fService.createStore("mainA");
                fService.createStore("mainB");
                fService.createDirectory("mainA:/", "a");
                fService.createDirectory("mainA:/a", "b");
                fService.createDirectory("mainB:/", "a");
                fService.createStore("mainB--layer");
                fService.createLayeredDirectory("mainB:/a", "mainB--layer:/", "a");
                fService.createFile("mainA:/a/b", "foo");
                PrintStream out = new PrintStream(fService.getFileOutputStream("mainA:/a/b/foo"));
                out.println("I am mainA:/a/b/foo");
                out.close();
                logger.debug((Object)"created file: mainA:/a/b/foo");
                fService.createLayeredDirectory("mainA:/a/b", "mainB:/a", "b");
                fService.createSnapshot("mainA", null, null);
                fService.createSnapshot("mainB", null, null);
                logger.debug((Object)"created layered directory: mainB:/a/b -> mainA:/a/b");
                BufferedReader reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB--layer:/a/b/foo")));
                String line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/b/foo", (String)line);
                out = new PrintStream(fService.getFileOutputStream("mainB--layer:/a/b/foo"));
                out.println("I am mainB--layer:/a/b/foo");
                out.close();
                logger.debug((Object)"updated file: mainB--layer:/a/b/foo");
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainA:/a/b/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/b/foo", (String)line);
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB:/a/b/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/b/foo", (String)line);
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB--layer:/a/b/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainB--layer:/a/b/foo", (String)line);
                List<AVMDifference> diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[mainB--layer:/a/b/foo[-1] > mainB:/a/b/foo[-1]]", (String)diffs.toString());
                fSyncService.update(diffs, null, false, false, false, false, "one", "one");
                fSyncService.flatten("mainB--layer:/a", "mainB:/a");
                logger.debug((Object)"updated & flattened: updated file: mainB:/a/b/foo");
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB:/a/b/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainB--layer:/a/b/foo", (String)line);
                fService.removeNode("mainA:/a", "b");
                fService.createSnapshot("mainA", null, null);
                logger.debug((Object)"removed folder & snapshot: mainA:/a/b");
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB--layer:/a/b/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainB--layer:/a/b/foo", (String)line);
                out = new PrintStream(fService.getFileOutputStream("mainB--layer:/a/b/foo"));
                out.println("I am mainB--layer:/a/b/foo V2");
                out.close();
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB--layer:/a/b/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainB--layer:/a/b/foo V2", (String)line);
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB:/a/b/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainB--layer:/a/b/foo", (String)line);
                logger.debug((Object)"updated file: mainB--layer:/a/b/foo");
                diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[mainB--layer:/a/b/foo[-1] > mainB:/a/b/foo[-1]]", (String)diffs.toString());
                fSyncService.update(diffs, null, false, false, false, false, "two", "two");
                fSyncService.flatten("mainB--layer:/a", "mainB:/a");
                logger.debug((Object)"updated & flattened: updated file: mainB:/a/b/foo");
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB:/a/b/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainB--layer:/a/b/foo V2", (String)line);
                this.recursiveList("mainA");
                this.recursiveList("mainB");
                this.recursiveList("mainB--layer");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw e;
            }
            Object var6_6 = null;
            fService.purgeStore("mainA");
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            fService.purgeStore("mainA");
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
            throw throwable;
        }
    }

    public void testLayeredFileDeleteFile1() throws Exception {
        try {
            try {
                fService.createStore("mainA");
                fService.createStore("mainB");
                fService.createStore("mainB--layer");
                logger.debug((Object)"created 3 stores: mainA, mainB, mainB--layer");
                fService.createDirectory("mainA:/", "a");
                fService.createDirectory("mainB:/", "a");
                logger.debug((Object)"created 2 plain dirs: mainA:/a and mainB:/a");
                fService.createLayeredDirectory("mainB:/a", "mainB--layer:/", "a");
                logger.debug((Object)"created layered dir: mainB--layer:/a -> mainB:/a");
                fService.createFile("mainA:/a", "foo");
                PrintStream out = new PrintStream(fService.getFileOutputStream("mainA:/a/foo"));
                out.println("I am mainA:/a/foo");
                out.close();
                logger.debug((Object)"created file: mainA:/a/foo");
                fService.createLayeredFile("mainA:/a/foo", "mainB:/a", "foo");
                logger.debug((Object)"created layered file: mainB:/a/foo -> mainA:/a/foo");
                fService.createSnapshot("mainA", null, null);
                fService.createSnapshot("mainB", null, null);
                logger.debug((Object)"created 2 snapshots: mainA and mainB");
                BufferedReader reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB--layer:/a/foo")));
                String line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/foo", (String)line);
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB:/a/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/foo", (String)line);
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainA:/a/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/foo", (String)line);
                List<AVMDifference> diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
                fService.removeNode("mainB--layer:/a", "foo");
                fService.createSnapshot("mainB--layer", null, null);
                logger.debug((Object)"removed file & snapshot: mainB--layer:/a/foo");
                diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((String)"[mainB--layer:/a/foo[-1] > mainB:/a/foo[-1]]", (String)diffs.toString());
                fSyncService.update(diffs, null, false, false, false, false, "one", "one");
                fSyncService.flatten("mainB--layer:/a", "mainB:/a");
                logger.debug((Object)"updated & flattened: removed file: mainB:/a/foo");
                this.recursiveList("mainA");
                this.recursiveList("mainB");
                this.recursiveList("mainB--layer");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw e;
            }
            Object var6_6 = null;
            fService.purgeStore("mainA");
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            fService.purgeStore("mainA");
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
            throw throwable;
        }
    }

    public void testLayeredFileDeleteFile2() throws Exception {
        try {
            try {
                fService.createStore("mainA");
                fService.createStore("mainB");
                fService.createStore("mainB--layer");
                logger.debug((Object)"created 3 stores: mainA, mainB, mainB--layer");
                fService.createDirectory("mainA:/", "a");
                fService.createDirectory("mainB:/", "a");
                logger.debug((Object)"created 2 plain dirs: mainA:/a and mainB:/a");
                fService.createLayeredDirectory("mainB:/a", "mainB--layer:/", "a");
                logger.debug((Object)"created layered dir: mainB--layer:/a -> mainB:/a");
                fService.createFile("mainA:/a", "foo");
                PrintStream out = new PrintStream(fService.getFileOutputStream("mainA:/a/foo"));
                out.println("I am mainA:/a/foo");
                out.close();
                logger.debug((Object)"created file: mainA:/a/foo");
                fService.createLayeredFile("mainA:/a/foo", "mainB:/a", "foo");
                logger.debug((Object)"created layered file: mainB:/a/foo -> mainA:/a/foo");
                fService.createSnapshot("mainA", null, null);
                fService.createSnapshot("mainB", null, null);
                logger.debug((Object)"created 2 snapshots: mainA and mainB");
                BufferedReader reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB--layer:/a/foo")));
                String line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/foo", (String)line);
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB:/a/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/foo", (String)line);
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainA:/a/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/foo", (String)line);
                List<AVMDifference> diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
                fService.removeNode("mainA:/a", "foo");
                fService.createSnapshot("mainA", null, null);
                logger.debug((Object)"removed file & snapshot: mainA:/a/foo");
                try {
                    fService.getFileInputStream(-1, "mainA:/a/foo");
                    AVMServiceLocalTest.fail((String)"Unexpected");
                }
                catch (AVMNotFoundException nfe) {
                    // empty catch block
                }
                try {
                    fService.getFileInputStream(-1, "mainB:/a/foo");
                    AVMServiceLocalTest.fail((String)"Unexpected");
                }
                catch (AVMNotFoundException nfe) {
                    // empty catch block
                }
                try {
                    fService.getFileInputStream(-1, "mainB--layer:/a/foo");
                    AVMServiceLocalTest.fail((String)"Unexpected");
                }
                catch (AVMNotFoundException nfe) {
                    // empty catch block
                }
                fService.removeNode("mainB--layer:/a", "foo");
                fService.createSnapshot("mainB--layer", null, null);
                logger.debug((Object)"removed file & snapshot: mainB--layer:/a/foo");
                diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((String)"[mainB--layer:/a/foo[-1] > mainB:/a/foo[-1]]", (String)diffs.toString());
                fSyncService.update(diffs, null, false, false, false, false, "one", "one");
                fSyncService.flatten("mainB--layer:/a", "mainB:/a");
                logger.debug((Object)"updated & flattened: removed file: mainB:/a/foo");
                this.recursiveList("mainA");
                this.recursiveList("mainB");
                this.recursiveList("mainB--layer");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw e;
            }
            Object var7_9 = null;
            fService.purgeStore("mainA");
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            fService.purgeStore("mainA");
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
            throw throwable;
        }
    }

    public void testLayeredFileDeleteFile3() throws Exception {
        try {
            try {
                fService.createStore("mainB");
                fService.createStore("mainB--layer");
                logger.debug((Object)"created 2 stores: mainB, mainB--layer");
                fService.createDirectory("mainB:/", "a");
                logger.debug((Object)"created plain dir: mainB:/a");
                fService.createLayeredDirectory("mainB:/a", "mainB--layer:/", "a");
                logger.debug((Object)"created layered dir: mainB--layer:/a -> mainB:/a");
                fService.createLayeredFile("mainA:/a/foo", "mainB:/a", "foo");
                logger.debug((Object)"created layered file: mainB:/a/foo -> mainA:/a/foo");
                List<AVMDifference> diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
                fService.createFile("mainB--layer:/a", "bar");
                logger.debug((Object)"created file: mainB--layer:/a/bar");
                diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((String)"[mainB--layer:/a/bar[-1] > mainB:/a/bar[-1]]", (String)diffs.toString());
                fSyncService.update(diffs, null, false, false, false, false, "one", "one");
                logger.debug((Object)"updated: created file: mainB:/a/bar");
                fSyncService.flatten("mainB--layer:/a", "mainB:/a");
                logger.debug((Object)"flattened: created file: mainB:/a/bar");
                fService.removeNode("mainB--layer:/a", "foo");
                fService.createSnapshot("mainB--layer", null, null);
                logger.debug((Object)"removed file & snapshot: mainB--layer:/a/foo");
                diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((String)"[mainB--layer:/a/foo[-1] > mainB:/a/foo[-1]]", (String)diffs.toString());
                fService.createStore("mainB--workflow1");
                logger.debug((Object)"created store: mainB--workflow1");
                this.recursiveList("mainB--workflow1");
                fService.createLayeredDirectory("mainB:/a", "mainB--workflow1:/", "a");
                logger.debug((Object)"created layered dir: mainB--workflow1:/a -> mainB:/a");
                this.recursiveList("mainB");
                this.recursiveList("mainB--layer");
                this.recursiveList("mainB--workflow1");
                diffs = fSyncService.compare(-1, "mainB--workflow1:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
                diffs = new ArrayList<AVMDifference>(1);
                diffs.add(new AVMDifference(-1, "mainB--layer:/a/foo", -1, "mainB--workflow1:/a/foo", 0));
                fSyncService.update(diffs, null, false, false, false, false, null, null);
                logger.debug((Object)"updated: removed file: mainB--workflow1:/a/foo");
                this.recursiveList("mainB");
                this.recursiveList("mainB--layer");
                this.recursiveList("mainB--workflow1");
                diffs = fSyncService.compare(-1, "mainB--workflow1:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((String)"[mainB--workflow1:/a/foo[-1] > mainB:/a/foo[-1]]", (String)diffs.toString());
                fSyncService.update(diffs, null, false, false, true, true, "one", "one");
                fSyncService.flatten("mainB--workflow1:/a", "mainB:/a");
                logger.debug((Object)"updated & flattened: removed file: mainB:/a/foo");
                diffs = fSyncService.compare(-1, "mainB--workflow1:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
                diffs = fSyncService.compare(-1, "mainB--workflow1:/a", -1, "mainB--layer:/a", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
                fSyncService.update(diffs, null, true, true, false, false, null, null);
                fSyncService.flatten("mainB--layer:/a", "mainB--workflow1:/a");
                this.recursiveList("mainB");
                this.recursiveList("mainB--layer");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw e;
            }
            Object var3_3 = null;
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
            if (fService.getStore("mainB--workflow1") != null) {
                fService.purgeStore("mainB--workflow1");
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
            if (fService.getStore("mainB--workflow1") != null) {
                fService.purgeStore("mainB--workflow1");
            }
            throw throwable;
        }
    }

    public void testLayeredFileDeleteFile4() throws Exception {
        try {
            try {
                fService.createStore("mainA");
                fService.createStore("mainB");
                fService.createStore("mainB--layer");
                logger.debug((Object)"created 3 stores: mainA, mainB, mainB--layer");
                fService.createDirectory("mainA:/", "a");
                fService.createDirectory("mainB:/", "a");
                logger.debug((Object)"created 2 plain dirs: mainA:/a and mainB:/a");
                fService.createSnapshot("mainA", null, null);
                fService.createSnapshot("mainB", null, null);
                logger.debug((Object)"created 2 snapshots: mainA and mainB");
                fService.createLayeredDirectory("mainB:/a", "mainB--layer:/", "a");
                logger.debug((Object)"created layered dir: mainB--layer:/a -> mainB:/a");
                fService.createDirectory("mainA:/a", "b");
                fService.createDirectory("mainB:/a", "b");
                logger.debug((Object)"created directories: mainA:/a/b &  mainB:/a/b");
                fService.createFile("mainA:/a/b", "foo");
                PrintStream out = new PrintStream(fService.getFileOutputStream("mainA:/a/b/foo"));
                out.println("I am mainA:/a/b/foo");
                out.close();
                logger.debug((Object)"created file: mainA:/a/b/foo");
                fService.createLayeredFile("mainA:/a/b/foo", "mainB:/a/b", "foo");
                logger.debug((Object)"created layered file: mainB:/a/b/foo -> mainA:/a/b/foo");
                BufferedReader reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB--layer:/a/b/foo")));
                String line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/b/foo", (String)line);
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB:/a/b/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/b/foo", (String)line);
                reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainA:/a/b/foo")));
                line = reader.readLine();
                reader.close();
                AVMServiceLocalTest.assertEquals((String)"I am mainA:/a/b/foo", (String)line);
                List<AVMDifference> diffs = fSyncService.compare(-1, "mainB--layer:/a/b", -1, "mainB:/a/b", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
                fService.createFile("mainB--layer:/a/b", "bar");
                logger.debug((Object)"created file: mainB--layer:/a/b/bar");
                diffs = fSyncService.compare(-1, "mainB--layer:/a/b", -1, "mainB:/a/b", null);
                AVMServiceLocalTest.assertEquals((String)"[mainB--layer:/a/b/bar[-1] > mainB:/a/b/bar[-1]]", (String)diffs.toString());
                fSyncService.update(diffs, null, false, false, false, false, "one", "one");
                fSyncService.flatten("mainB--layer:/a/b", "mainB:/a/b");
                logger.debug((Object)"updated & flattened: created file: mainB:/a/b/bar");
                fService.removeNode("mainB--layer:/a/b", "foo");
                fService.createSnapshot("mainB--layer", null, null);
                logger.debug((Object)"removed file & snapshot: mainB--layer:/a/b/foo");
                diffs = fSyncService.compare(-1, "mainB--layer:/a/b", -1, "mainB:/a/b", null);
                AVMServiceLocalTest.assertEquals((String)"[mainB--layer:/a/b/foo[-1] > mainB:/a/b/foo[-1]]", (String)diffs.toString());
                fService.createStore("mainB--workflow1");
                fService.createLayeredDirectory("mainB:/a", "mainB--workflow1:/", "a");
                logger.debug((Object)"created layered dir: mainB--workflow1:/a -> mainB:/a");
                this.recursiveList("mainA");
                this.recursiveList("mainB");
                this.recursiveList("mainB--layer");
                this.recursiveList("mainB--workflow1");
                diffs = fSyncService.compare(-1, "mainB--workflow1:/a/b", -1, "mainB:/a/b", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
                diffs = new ArrayList<AVMDifference>(1);
                diffs.add(new AVMDifference(-1, "mainB--layer:/a/b/foo", -1, "mainB--workflow1:/a/b/foo", 0));
                fSyncService.update(diffs, null, false, false, false, false, null, null);
                logger.debug((Object)"updated: removed file: mainB--workflow1:/a/b/foo");
                this.recursiveList("mainA");
                this.recursiveList("mainB");
                this.recursiveList("mainB--layer");
                this.recursiveList("mainB--workflow1");
                diffs = fSyncService.compare(-1, "mainB--workflow1:/a/b", -1, "mainB:/a/b", null);
                AVMServiceLocalTest.assertEquals((String)"[mainB--workflow1:/a/b/foo[-1] > mainB:/a/b/foo[-1]]", (String)diffs.toString());
                fSyncService.update(diffs, null, false, false, true, true, "one", "one");
                fSyncService.flatten("mainB--workflow1:/a/b", "mainB:/a/b");
                logger.debug((Object)"updated & flattened: removed file: mainB:/a/b/foo");
                diffs = fSyncService.compare(-1, "mainB--workflow1:/a/b", -1, "mainB:/a/b", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
                diffs = fSyncService.compare(-1, "mainB--workflow1:/a/b", -1, "mainB--layer:/a/b", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
                fSyncService.update(diffs, null, true, true, false, false, null, null);
                fSyncService.flatten("mainB--layer:/a/b", "mainB--workflow1:/a/b");
                this.recursiveList("mainA");
                this.recursiveList("mainB");
                this.recursiveList("mainB--layer");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw e;
            }
            Object var6_6 = null;
            fService.purgeStore("mainA");
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
            if (fService.getStore("mainB--workflow1") != null) {
                fService.purgeStore("mainB--workflow1");
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            fService.purgeStore("mainA");
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
            if (fService.getStore("mainB--workflow1") != null) {
                fService.purgeStore("mainB--workflow1");
            }
            throw throwable;
        }
    }

    public void testDeleteLD5() throws Exception {
        try {
            try {
                fService.createStore("mainB");
                fService.createStore("mainB--layer");
                fService.createDirectory("mainB:/", "a");
                fService.createSnapshot("mainB", null, null);
                SortedMap<String, AVMNodeDescriptor> directoryListing = fService.getDirectoryListing(-1, "mainB:/a");
                AVMServiceLocalTest.assertTrue((boolean)directoryListing.isEmpty());
                fService.createLayeredDirectory("mainB:/a", "mainB--layer:/", "a");
                fService.createFile("mainB--layer:/a", "testfile.txt");
                fService.createDirectory("mainB--layer:/a", "testfolder");
                fService.createSnapshot("mainB--layer", null, null);
                List<AVMDifference> diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)2, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[mainB--layer:/a/testfile.txt[-1] > mainB:/a/testfile.txt[-1], mainB--layer:/a/testfolder[-1] > mainB:/a/testfolder[-1]]", (String)diffs.toString());
                fService.removeNode("mainB--layer:/a", "testfile.txt");
                fService.createSnapshot("mainB--layer", null, null);
                diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)1, (int)diffs.size());
                AVMServiceLocalTest.assertEquals((String)"[mainB--layer:/a/testfolder[-1] > mainB:/a/testfolder[-1]]", (String)diffs.toString());
                fService.removeNode("mainB--layer:/a", "testfolder");
                fService.createSnapshot("mainB--layer", null, null);
                diffs = fSyncService.compare(-1, "mainB--layer:/a", -1, "mainB:/a", null);
                AVMServiceLocalTest.assertEquals((int)0, (int)diffs.size());
                directoryListing = fService.getDirectoryListing(-1, "mainB--layer:/a");
                AVMServiceLocalTest.assertTrue((boolean)directoryListing.isEmpty());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            Object var4_4 = null;
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
            throw throwable;
        }
    }

    public void testDeleteLD6() throws Exception {
        try {
            try {
                fService.createStore("mainB");
                fService.createStore("mainB--layer");
                fService.createDirectory("mainB:/", "a");
                fService.createSnapshot("mainB", null, null);
                SortedMap<String, AVMNodeDescriptor> directoryListing = fService.getDirectoryListing(-1, "mainB:/a");
                AVMServiceLocalTest.assertTrue((boolean)directoryListing.isEmpty());
                fService.createLayeredDirectory("mainB:/a", "mainB--layer:/", "a");
                this.performDeletion(100);
                fSyncService.resetLayer("mainB--layer:/a");
                this.performDeletion(500);
                fSyncService.resetLayer("mainB--layer:/a");
                this.performDeletion(500);
                fSyncService.resetLayer("mainB--layer:/a");
                this.performDeletion(1000);
                fSyncService.resetLayer("mainB--layer:/a");
                this.performDeletion(2000);
                fSyncService.resetLayer("mainB--layer:/a");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            Object var3_3 = null;
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
            throw throwable;
        }
    }

    private void performDeletion(int objectsAmount) {
        String timestamp = String.valueOf(System.currentTimeMillis());
        for (int i = 0; i < objectsAmount; ++i) {
            String commonPart = "-" + timestamp + "-" + i;
            fService.createFile("mainB--layer:/a", "testfile" + commonPart + ".txt");
            fService.createDirectory("mainB--layer:/a", "testfolder" + commonPart);
        }
        fService.createSnapshot("mainB--layer", null, null);
        List<AVMDifference> compare = fSyncService.compare(-1, "mainB:/a", -1, "mainB--layer:/a", null);
        AVMServiceLocalTest.assertEquals((int)(2 * objectsAmount), (int)compare.size());
        long time = System.currentTimeMillis();
        for (int i = 0; i < objectsAmount; ++i) {
            String commonPart = "-" + timestamp + "-" + i;
            fService.removeNode("mainB--layer:/a", "testfile" + commonPart + ".txt");
            fService.removeNode("mainB--layer:/a", "testfolder" + commonPart);
        }
        fService.createSnapshot("mainB--layer", null, null);
        logger.info((Object)("Time spent on deletion of " + compare.size() + " objects is " + (System.currentTimeMillis() - time)));
        SortedMap<String, AVMNodeDescriptor> directoryListing = fService.getDirectoryListing(-1, "mainB--layer:/a");
        AVMServiceLocalTest.assertTrue((boolean)directoryListing.isEmpty());
    }

    protected void recursiveContents(String path) {
        String contentsStr = this.recursiveContents(path, -1, true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)contentsStr);
        }
    }

    protected String recursiveContents(String path, int version, boolean followLinks) {
        String val = this.recursiveList(path, version, 0, followLinks);
        return val.substring(val.indexOf(10));
    }

    protected void recursiveList(String store) {
        this.recursiveList(store, -1);
    }

    protected void recursiveList(String store, int version) {
        String list = this.recursiveList(store, version, true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\n\n" + store + ":" + "\n" + list + "\n"));
        }
    }

    protected String recursiveList(String repoName, int version, boolean followLinks) {
        return this.recursiveList(repoName + ":/", version, 0, followLinks);
    }

    protected String recursiveList(String path, int version, int indent, boolean followLinks) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            builder.append(' ');
        }
        builder.append(path.substring(path.lastIndexOf(47) + 1));
        builder.append(' ');
        AVMNodeDescriptor desc = fService.lookup(version, path, true);
        builder.append(desc.toString());
        List<AVMNodeDescriptor> ancs = fService.getHistory(desc, -1);
        for (AVMNodeDescriptor anc : ancs) {
            builder.append("--->").append(anc.toString());
        }
        builder.append('\n');
        if (desc.getType() == 2 || desc.getType() == 3 && followLinks) {
            String basename = path.endsWith("/") ? path : path + "/";
            SortedMap<String, AVMNodeDescriptor> listing = fService.getDirectoryListing(version, path);
            for (String name : listing.keySet()) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)name);
                }
                builder.append(this.recursiveList(basename + name, version, indent + 2, followLinks));
            }
            List<String> deletedList = fService.getDeleted(version, path);
            for (String name : deletedList) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)name);
                }
                builder.append(this.recursiveList(basename + name, version, indent + 2, followLinks));
            }
        }
        return builder.toString();
    }

    protected void setupBasicTree() throws IOException {
        fService.createDirectory("main:/", "a");
        fService.createDirectory("main:/a", "b");
        fService.createDirectory("main:/a/b", "c");
        fService.createDirectory("main:/", "d");
        fService.createDirectory("main:/d", "e");
        fService.createDirectory("main:/d/e", "f");
        OutputStream out = fService.createFile("main:/a/b/c", "foo");
        byte[] buff = "I am main:/a/b/c/foo".getBytes();
        out.write(buff);
        out.close();
        out = fService.createFile("main:/a/b/c", "bar");
        buff = "I am main:/a/b/c/bar".getBytes();
        out.write(buff);
        out.close();
        fService.createSnapshot("main", null, null);
    }
}

