/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Properties;
import net.sf.ehcache.CacheManager;
import org.alfresco.error.AlfrescoRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.hibernate.cache.EhCache;
import org.hibernate.cache.EhCacheProvider;
import org.hibernate.cache.Timestamper;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.util.ResourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalEhCacheManagerFactoryBean
implements FactoryBean<CacheManager>,
CacheProvider {
    public static final String CUSTOM_CONFIGURATION_FILE = "classpath:alfresco/extension/ehcache-custom.xml";
    public static final String DEFAULT_CONFIGURATION_FILE = "classpath:alfresco/ehcache-default.xml";
    private static Log logger;
    private static boolean initialized;
    private static CacheManager cacheManager;
    private static EhCacheProvider hibernateEhCacheProvider;

    private static synchronized void initCacheManager() {
        if (initialized) {
            return;
        }
        try {
            boolean defaultLocation = false;
            try {
                URL configUrl = ResourceUtils.getURL((String)CUSTOM_CONFIGURATION_FILE);
                cacheManager = CacheManager.create((URL)configUrl);
            }
            catch (FileNotFoundException e) {
                URL configUrl = ResourceUtils.getURL((String)DEFAULT_CONFIGURATION_FILE);
                if (configUrl == null) {
                    throw new AlfrescoRuntimeException("Missing default cache config: classpath:alfresco/ehcache-default.xml");
                }
                cacheManager = new CacheManager(configUrl);
                defaultLocation = true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created EHCache CacheManager instance: \n   configuration: " + (defaultLocation ? DEFAULT_CONFIGURATION_FILE : CUSTOM_CONFIGURATION_FILE)));
            }
            initialized = true;
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("EHCache configuration failed", e);
        }
    }

    public static CacheManager getInstance() {
        if (!initialized) {
            InternalEhCacheManagerFactoryBean.initCacheManager();
        }
        return cacheManager;
    }

    public Cache buildCache(String regionName, Properties properties) throws CacheException {
        CacheManager manager = InternalEhCacheManagerFactoryBean.getInstance();
        try {
            net.sf.ehcache.Cache cache = manager.getCache(regionName);
            if (cache == null) {
                logger.info((Object)("Using default cache configuration: " + regionName));
                manager.addCache(regionName);
                cache = manager.getCache(regionName);
                logger.debug((Object)("Started EHCache region: " + regionName));
            }
            return new EhCache(cache);
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return false;
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public void start(Properties properties) throws CacheException {
        InternalEhCacheManagerFactoryBean.initCacheManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (Thread.currentThread().getName().contains("Finalizer")) {
            return;
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (logger.isDebugEnabled()) {
                String[] caches;
                for (String regionName : caches = InternalEhCacheManagerFactoryBean.getInstance().getCacheNames()) {
                    logger.debug((Object)("Stopped EHCache region: " + regionName));
                }
            }
            if (initialized) {
                InternalEhCacheManagerFactoryBean.getInstance().shutdown();
                initialized = false;
            }
        }
    }

    public CacheManager getObject() throws Exception {
        return InternalEhCacheManagerFactoryBean.getInstance();
    }

    public Class<CacheManager> getObjectType() {
        return CacheManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    static {
        System.setProperty("net.sf.ehcache.use.classic.lru", "true");
        logger = LogFactory.getLog(InternalEhCacheManagerFactoryBean.class);
        hibernateEhCacheProvider = new EhCacheProvider();
    }
}

