/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.config.xml;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.transaction.UserTransaction;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantDeployer;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.config.ConfigDeployment;
import org.springframework.extensions.config.ConfigImpl;
import org.springframework.extensions.config.ConfigSection;
import org.springframework.extensions.config.ConfigSource;
import org.springframework.extensions.config.evaluator.Evaluator;
import org.springframework.extensions.config.xml.XMLConfigService;
import org.springframework.extensions.config.xml.elementreader.ConfigElementReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepoXMLConfigService
extends XMLConfigService
implements TenantDeployer {
    private static final Log logger = LogFactory.getLog(RepoXMLConfigService.class);
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Lock readLock = this.lock.readLock();
    private Lock writeLock = this.lock.writeLock();
    private TransactionService transactionService;
    private AuthenticationContext authenticationContext;
    private TenantAdminService tenantAdminService;
    private SimpleCache<String, ConfigData> configDataCache;
    private ThreadLocal<ConfigData> configDataThreadLocal = new ThreadLocal();

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setAuthenticationContext(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void setTenantAdminService(TenantAdminService tenantAdminService) {
        this.tenantAdminService = tenantAdminService;
    }

    public void setConfigDataCache(SimpleCache<String, ConfigData> configDataCache) {
        this.configDataCache = configDataCache;
    }

    public RepoXMLConfigService(ConfigSource configSource) {
        super(configSource);
    }

    public List<ConfigDeployment> initConfig() {
        return this.resetRepoConfig().getConfigDeployments();
    }

    private ConfigData initRepoConfig(String tenantDomain) {
        ConfigData configData = null;
        String currentUser = this.authenticationContext.getCurrentUserName();
        if (currentUser == null) {
            this.authenticationContext.setSystemUserAsCurrentUser();
        }
        UserTransaction userTransaction = this.transactionService.getUserTransaction();
        try {
            try {
                userTransaction.begin();
                List configDeployments = super.initConfig();
                configData = this.getConfigDataLocal(tenantDomain);
                if (configData != null) {
                    configData.setConfigDeployments(configDeployments);
                }
                userTransaction.commit();
                logger.info((Object)"Config initialised");
            }
            catch (Throwable e) {
                try {
                    userTransaction.rollback();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw new AlfrescoRuntimeException("Failed to initialise config service", e);
            }
            Object var8_7 = null;
            if (currentUser == null) {
                this.authenticationContext.clearCurrentSecurityContext();
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (currentUser == null) {
                this.authenticationContext.clearCurrentSecurityContext();
            }
            throw throwable;
        }
        return configData;
    }

    public void destroy() {
        super.destroy();
        logger.info((Object)"Config destroyed");
    }

    public void reset() {
        this.resetRepoConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigData resetRepoConfig() {
        Object v1;
        ConfigData configData;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Resetting repo config service");
        }
        String tenantDomain = this.getTenantDomain();
        try {
            this.destroy();
            ConfigData configData2 = this.getConfigDataLocal(tenantDomain);
            if (configData2 == null) {
                configData2 = new ConfigData(tenantDomain);
                this.configDataThreadLocal.set(configData2);
            }
            if ((configData2 = this.initRepoConfig(tenantDomain)) == null) {
                throw new AlfrescoRuntimeException("Failed to reset configData " + tenantDomain);
            }
            try {
                this.writeLock.lock();
                this.configDataCache.put((Serializable)((Object)tenantDomain), (Object)configData2);
                Object var4_3 = null;
                this.writeLock.unlock();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.writeLock.unlock();
                throw throwable;
            }
            configData = configData2;
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object v0;
            Object var6_8 = null;
            try {
                this.readLock.lock();
                if (this.configDataCache.get((Serializable)((Object)tenantDomain)) != null) {
                    this.configDataThreadLocal.set(null);
                }
                v0 = null;
            }
            catch (Throwable throwable2) {
                v0 = null;
            }
            Object var8_12 = v0;
            this.readLock.unlock();
            throw throwable;
        }
        try {
            this.readLock.lock();
            if (this.configDataCache.get((Serializable)((Object)tenantDomain)) != null) {
                this.configDataThreadLocal.set(null);
            }
            v1 = null;
        }
        catch (Throwable throwable) {
            v1 = null;
        }
        Object var8_11 = v1;
        this.readLock.unlock();
        return configData;
    }

    protected void onBootstrap(ApplicationEvent event) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() {
                RepoXMLConfigService.this.initConfig();
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        if (this.tenantAdminService != null && this.tenantAdminService.isEnabled()) {
            this.tenantAdminService.deployTenants(this, logger);
            this.tenantAdminService.register(this);
        }
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    public void onEnableTenant() {
        this.initConfig();
    }

    public void onDisableTenant() {
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigData getConfigData() {
        ConfigData configData;
        String tenantDomain;
        block5: {
            tenantDomain = this.getTenantDomain();
            configData = this.getConfigDataLocal(tenantDomain);
            if (configData != null) {
                return configData;
            }
            try {
                this.readLock.lock();
                configData = (ConfigData)this.configDataCache.get((Serializable)((Object)tenantDomain));
                if (configData == null) break block5;
                ConfigData configData2 = configData;
                Object var5_4 = null;
                this.readLock.unlock();
                return configData2;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
        Object var5_5 = null;
        this.readLock.unlock();
        configData = this.resetRepoConfig();
        if (configData == null) {
            throw new AlfrescoRuntimeException("Failed to get configData " + tenantDomain);
        }
        return configData;
    }

    private ConfigData getConfigDataLocal(String tenantDomain) {
        ConfigData configData = this.configDataThreadLocal.get();
        if (configData != null && tenantDomain.equals(configData.getTenantDomain())) {
            return configData;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConfigData() {
        try {
            this.writeLock.lock();
            String tenantDomain = this.getTenantDomain();
            if (this.configDataCache.get((Serializable)((Object)tenantDomain)) != null) {
                this.configDataCache.remove((Serializable)((Object)tenantDomain));
            }
            Object var3_2 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    protected ConfigImpl getGlobalConfigImpl() {
        return this.getConfigData().getGlobalConfig();
    }

    protected void putGlobalConfig(ConfigImpl globalConfig) {
        this.getConfigData().setGlobalConfig(globalConfig);
    }

    protected void removeGlobalConfig() {
        this.removeConfigData();
    }

    protected Map<String, Evaluator> getEvaluators() {
        return this.getConfigData().getEvaluators();
    }

    protected void putEvaluators(Map<String, Evaluator> evaluators) {
        this.getConfigData().setEvaluators(evaluators);
    }

    protected void removeEvaluators() {
        this.removeConfigData();
    }

    protected Map<String, List<ConfigSection>> getSectionsByArea() {
        return this.getConfigData().getSectionsByArea();
    }

    protected void putSectionsByArea(Map<String, List<ConfigSection>> sectionsByArea) {
        this.getConfigData().setSectionsByArea(sectionsByArea);
    }

    protected void removeSectionsByArea() {
        this.removeConfigData();
    }

    protected List<ConfigSection> getSections() {
        return this.getConfigData().getSections();
    }

    protected void putSections(List<ConfigSection> sections) {
        this.getConfigData().setSections(sections);
    }

    protected void removeSections() {
        this.removeConfigData();
    }

    protected Map<String, ConfigElementReader> getElementReaders() {
        return this.getConfigData().getElementReaders();
    }

    protected void putElementReaders(Map<String, ConfigElementReader> elementReaders) {
        this.getConfigData().setElementReaders(elementReaders);
    }

    protected void removeElementReaders() {
        this.removeConfigData();
    }

    private String getTenantDomain() {
        return this.tenantAdminService.getCurrentUserDomain();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConfigData {
        private ConfigImpl globalConfig;
        private Map<String, Evaluator> evaluators;
        private Map<String, List<ConfigSection>> sectionsByArea;
        private List<ConfigSection> sections;
        private Map<String, ConfigElementReader> elementReaders;
        private List<ConfigDeployment> configDeployments;
        private String tenantDomain;

        public ConfigData(String tenantDomain) {
            this.tenantDomain = tenantDomain;
        }

        public String getTenantDomain() {
            return this.tenantDomain;
        }

        public ConfigImpl getGlobalConfig() {
            return this.globalConfig;
        }

        public void setGlobalConfig(ConfigImpl globalConfig) {
            this.globalConfig = globalConfig;
        }

        public Map<String, Evaluator> getEvaluators() {
            return this.evaluators;
        }

        public void setEvaluators(Map<String, Evaluator> evaluators) {
            this.evaluators = evaluators;
        }

        public Map<String, List<ConfigSection>> getSectionsByArea() {
            return this.sectionsByArea;
        }

        public void setSectionsByArea(Map<String, List<ConfigSection>> sectionsByArea) {
            this.sectionsByArea = sectionsByArea;
        }

        public List<ConfigSection> getSections() {
            return this.sections;
        }

        public void setSections(List<ConfigSection> sections) {
            this.sections = sections;
        }

        public Map<String, ConfigElementReader> getElementReaders() {
            return this.elementReaders;
        }

        public void setElementReaders(Map<String, ConfigElementReader> elementReaders) {
            this.elementReaders = elementReaders;
        }

        public List<ConfigDeployment> getConfigDeployments() {
            return this.configDeployments;
        }

        public void setConfigDeployments(List<ConfigDeployment> configDeployments) {
            this.configDeployments = configDeployments;
        }
    }
}

