/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.alfresco.repo.content.metadata.AbstractMappingMetadataExtracter;
import org.alfresco.service.cmr.repository.ContentReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlMetadataExtracter
extends AbstractMappingMetadataExtracter {
    private static final String KEY_AUTHOR = "author";
    private static final String KEY_TITLE = "title";
    private static final String KEY_DESCRIPTION = "description";
    public static final Set<String> MIMETYPES = new HashSet<String>(5);

    public HtmlMetadataExtracter() {
        super(MIMETYPES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map<String, Serializable> extractRaw(ContentReader reader) throws Throwable {
        InputStream cis;
        Map<String, Serializable> rawProperties;
        block8: {
            InputStreamReader r;
            block9: {
                rawProperties = this.newRawMap();
                HTMLEditorKit.ParserCallback callback = new HTMLEditorKit.ParserCallback(){
                    StringBuffer title = null;
                    boolean inHead = false;

                    public void handleText(char[] data, int pos) {
                        if (this.title != null) {
                            this.title.append(data);
                        }
                    }

                    public void handleComment(char[] data, int pos) {
                    }

                    public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                        if (HTML.Tag.HEAD.equals(t)) {
                            this.inHead = true;
                        } else if (HTML.Tag.TITLE.equals(t) && this.inHead) {
                            this.title = new StringBuffer();
                        } else {
                            this.handleSimpleTag(t, a, pos);
                        }
                    }

                    public void handleEndTag(HTML.Tag t, int pos) {
                        if (HTML.Tag.HEAD.equals(t)) {
                            this.inHead = false;
                        } else if (HTML.Tag.TITLE.equals(t) && this.title != null) {
                            HtmlMetadataExtracter.this.putRawValue(HtmlMetadataExtracter.KEY_TITLE, (Serializable)((Object)this.title.toString()), rawProperties);
                            this.title = null;
                        }
                    }

                    public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                        if (HTML.Tag.META.equals(t)) {
                            Object nameO = a.getAttribute(HTML.Attribute.NAME);
                            Object valueO = a.getAttribute(HTML.Attribute.CONTENT);
                            if (nameO == null || valueO == null) {
                                return;
                            }
                            String name = nameO.toString();
                            if (name.equalsIgnoreCase("creator") || name.equalsIgnoreCase(HtmlMetadataExtracter.KEY_AUTHOR) || name.equalsIgnoreCase("dc.creator")) {
                                HtmlMetadataExtracter.this.putRawValue(HtmlMetadataExtracter.KEY_AUTHOR, (Serializable)((Object)valueO.toString()), rawProperties);
                            } else if (name.equalsIgnoreCase(HtmlMetadataExtracter.KEY_DESCRIPTION) || name.equalsIgnoreCase("dc.description")) {
                                HtmlMetadataExtracter.this.putRawValue(HtmlMetadataExtracter.KEY_DESCRIPTION, (Serializable)((Object)valueO.toString()), rawProperties);
                            }
                        }
                    }

                    public void handleError(String errorMsg, int pos) {
                    }
                };
                String charsetGuess = "UTF-8";
                int tries = 0;
                while (tries < 3) {
                    Object var11_11;
                    rawProperties.clear();
                    r = null;
                    cis = null;
                    try {
                        try {
                            cis = reader.getContentInputStream();
                            r = new InputStreamReader(cis);
                            ParserDelegator parser = new ParserDelegator();
                            ((HTMLEditorKit.Parser)parser).parse(r, callback, tries > 0);
                            var11_11 = null;
                            if (r == null) break block8;
                            break block9;
                        }
                        catch (ChangedCharSetException ccse) {
                            ++tries;
                            charsetGuess = ccse.getCharSetSpec();
                            int begin = charsetGuess.indexOf("charset=");
                            if (begin > 0) {
                                charsetGuess = charsetGuess.substring(begin + 8, charsetGuess.length());
                            }
                            reader = reader.getReader();
                            var11_11 = null;
                            if (r != null) {
                                ((Reader)r).close();
                            }
                            if (cis == null) continue;
                            cis.close();
                        }
                    }
                    catch (Throwable throwable) {
                        var11_11 = null;
                        if (r != null) {
                            ((Reader)r).close();
                        }
                        if (cis == null) throw throwable;
                        cis.close();
                        throw throwable;
                    }
                }
                return rawProperties;
            }
            ((Reader)r).close();
        }
        if (cis == null) return rawProperties;
        cis.close();
        return rawProperties;
    }

    static {
        MIMETYPES.add("text/html");
        MIMETYPES.add("application/xhtml+xml");
    }
}

