/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import org.alfresco.repo.content.transform.AbstractContentTransformer2;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlparser.beans.StringBean;

public class HtmlParserContentTransformer
extends AbstractContentTransformer2 {
    private static final Log logger = LogFactory.getLog(HtmlParserContentTransformer.class);

    public boolean isTransformable(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return "text/html".equals(sourceMimetype) && "text/plain".equals(targetMimetype);
    }

    public void transformInternal(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
        File htmlFile = TempFileProvider.createTempFile((String)"HtmlParserContentTransformer_", (String)".html");
        reader.getContent(htmlFile);
        StringBean extractor = new StringBean();
        extractor.setCollapse(false);
        extractor.setLinks(false);
        extractor.setReplaceNonBreakingSpaces(false);
        extractor.setURL(htmlFile.getAbsolutePath());
        String text = extractor.getStrings();
        writer.putContent(text);
    }
}

