/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import junit.framework.Assert;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryModelType;
import org.alfresco.repo.dictionary.DictionaryRepositoryBootstrap;
import org.alfresco.repo.dictionary.RepositoryLocation;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.PropertyMap;

public class DictionaryModelTypeTest
extends BaseAlfrescoSpringTest {
    private static final QName TEST_MODEL_ONE = QName.createQName((String)"{http://www.alfresco.org/test/testmodel1/1.0}testModelOne");
    private static final QName TEST_MODEL_TWO = QName.createQName((String)"{http://www.alfresco.org/test/testmodel2/1.0}testModelTwo");
    public static final String MODEL_ONE_XML = "<model name='test1:testModelOne' xmlns='http://www.alfresco.org/model/dictionary/1.0'>   <description>Test model one</description>   <author>Alfresco</author>   <published>2005-05-30</published>   <version>1.0</version>   <imports>      <import uri='http://www.alfresco.org/model/dictionary/1.0' prefix='d'/>      <import uri='http://www.alfresco.org/model/content/1.0' prefix='cm'/>   </imports>   <namespaces>      <namespace uri='http://www.alfresco.org/test/testmodel1/1.0' prefix='test1'/>   </namespaces>   <types>      <type name='test1:base'>        <title>Base</title>        <description>The Base Type</description>        <parent>cm:content</parent>        <properties>           <property name='test1:prop1'>              <type>d:text</type>           </property>        </properties>      </type>   </types></model>";
    public static final String MODEL_ONE_MODIFIED_XML = "<model name='test1:testModelOne' xmlns='http://www.alfresco.org/model/dictionary/1.0'>   <description>Test model one (updated)</description>   <author>Alfresco</author>   <published>2005-05-30</published>   <version>1.1</version>   <imports>      <import uri='http://www.alfresco.org/model/dictionary/1.0' prefix='d'/>      <import uri='http://www.alfresco.org/model/content/1.0' prefix='cm'/>   </imports>   <namespaces>      <namespace uri='http://www.alfresco.org/test/testmodel1/1.0' prefix='test1'/>   </namespaces>   <types>      <type name='test1:base'>        <title>Base</title>        <description>The Base Type</description>        <parent>cm:content</parent>        <properties>           <property name='test1:prop1'>              <type>d:text</type>           </property>           <property name='test1:prop2'>              <type>d:boolean</type>           </property>        </properties>      </type>   </types></model>";
    public static final String MODEL_ONE_MODIFIED2_XML = "<model name='test1:testModelOne' xmlns='http://www.alfresco.org/model/dictionary/1.0'>   <description>Test model one (updated 2)</description>   <author>Alfresco</author>   <published>2005-05-30</published>   <version>1.2</version>   <imports>      <import uri='http://www.alfresco.org/model/dictionary/1.0' prefix='d'/>      <import uri='http://www.alfresco.org/model/content/1.0' prefix='cm'/>   </imports>   <namespaces>      <namespace uri='http://www.alfresco.org/test/testmodel1/1.0' prefix='test1'/>   </namespaces>   <types>      <type name='test1:base'>        <title>Base</title>        <description>The Base Type</description>        <parent>cm:content</parent>        <properties>           <property name='test1:prop1'>              <type>d:text</type>           </property>           <property name='test1:prop99'>              <type>d:text</type>           </property>        </properties>      </type>   </types></model>";
    public static final String MODEL_TWO_XML = "<model name='test2:testModelTwo' xmlns='http://www.alfresco.org/model/dictionary/1.0'>   <description>Test model two</description>   <author>Alfresco</author>   <published>2010-01-13</published>   <version>1.0</version>   <imports>      <import uri='http://www.alfresco.org/model/dictionary/1.0' prefix='d'/>      <import uri='http://www.alfresco.org/model/content/1.0' prefix='cm'/>   </imports>   <namespaces>      <namespace uri='http://www.alfresco.org/test/testmodel2/1.0' prefix='test2'/>   </namespaces>   <constraints>      <constraint name='test2:con1' type='LIST'>         <parameter name='allowedValues'>            <list>               <value>alfresco</value>               <value>file</value>            </list>         </parameter>      </constraint>   </constraints>   <types>      <type name='test2:base'>        <title>Base</title>        <description>The Base Type</description>        <parent>cm:content</parent>        <properties>           <property name='test2:prop2'>              <type>d:text</type>              <constraints>                 <constraint ref='test2:con1'/>              </constraints>           </property>        </properties>      </type>   </types></model>";
    public static final String MODEL_TWO_INVALID_XML = "<model name='test2:testModelTwo' xmlns='http://www.alfresco.org/model/dictionary/1.0'>   <description>Test model two</description>   <author>Alfresco</author>   <published>2010-01-14</published>   <version>1.1</version>   <imports>      <import uri='http://www.alfresco.org/model/dictionary/1.0' prefix='d'/>      <import uri='http://www.alfresco.org/model/content/1.0' prefix='cm'/>   </imports>   <namespaces>      <namespace uri='http://www.alfresco.org/test/testmodel2/1.0' prefix='test2'/>   </namespaces>   <types>      <type name='test2:base'>        <title>Base</title>        <description>The Base Type</description>        <parent>cm:content</parent>        <properties>           <property name='test2:prop2'>              <type>d:text</type>              <constraints>                 <constraint ref='test2:con1'/>              </constraints>           </property>        </properties>      </type>   </types></model>";
    public static final String MODEL_TWO_MODIFIED_XML = "<model name='test2:testModelTwo' xmlns='http://www.alfresco.org/model/dictionary/1.0'>   <description>Test model two - modified</description>   <author>Alfresco - modified</author>   <published>2010-01-14</published>   <version>1.1</version>   <imports>      <import uri='http://www.alfresco.org/model/dictionary/1.0' prefix='d'/>      <import uri='http://www.alfresco.org/model/content/1.0' prefix='cm'/>   </imports>   <namespaces>      <namespace uri='http://www.alfresco.org/test/testmodel2/1.0' prefix='test2'/>   </namespaces>   <types>      <type name='test2:base'>        <title>Base</title>        <description>The Base Type</description>        <parent>cm:content</parent>        <properties>           <property name='test2:prop2'>              <type>d:text</type>           </property>        </properties>      </type>   </types></model>";
    private DictionaryService dictionaryService;
    private NamespaceService namespaceService;
    private CheckOutCheckInService cociService;
    private DictionaryDAO dictionaryDAO;

    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.dictionaryService = (DictionaryService)this.applicationContext.getBean("dictionaryService");
        this.namespaceService = (NamespaceService)this.applicationContext.getBean("namespaceService");
        this.cociService = (CheckOutCheckInService)this.applicationContext.getBean("checkOutCheckInService");
        this.dictionaryDAO = (DictionaryDAO)this.applicationContext.getBean("dictionaryDAO");
        this.nodeService = (NodeService)this.applicationContext.getBean("NodeService");
        TenantAdminService tenantAdminService = (TenantAdminService)this.applicationContext.getBean("tenantAdminService");
        MessageService messageService = (MessageService)this.applicationContext.getBean("messageService");
        ArrayList<String> storeUrlsToValidate = new ArrayList<String>(1);
        storeUrlsToValidate.add(this.storeRef.toString());
        DictionaryModelType dictionaryModelType = (DictionaryModelType)this.applicationContext.getBean("dictionaryModelType");
        dictionaryModelType.setStoreUrls(storeUrlsToValidate);
        DictionaryRepositoryBootstrap bootstrap = new DictionaryRepositoryBootstrap();
        bootstrap.setContentService(this.contentService);
        bootstrap.setDictionaryDAO(this.dictionaryDAO);
        bootstrap.setTransactionService(this.transactionService);
        bootstrap.setTenantAdminService(tenantAdminService);
        bootstrap.setNodeService(this.nodeService);
        bootstrap.setNamespaceService(this.namespaceService);
        bootstrap.setMessageService(messageService);
        RepositoryLocation location = new RepositoryLocation();
        location.setStoreProtocol(this.storeRef.getProtocol());
        location.setStoreId(this.storeRef.getIdentifier());
        location.setQueryLanguage("path");
        ArrayList<RepositoryLocation> locations = new ArrayList<RepositoryLocation>();
        locations.add(location);
        bootstrap.setRepositoryModelsLocations(locations);
        bootstrap.register();
    }

    public void testCreateAndUpdateDictionaryModelNodeContent() {
        try {
            this.dictionaryService.getModel(TEST_MODEL_ONE);
            DictionaryModelTypeTest.fail((String)"This model has not yet been loaded into the dictionary service");
        }
        catch (DictionaryException exception) {
            // empty catch block
        }
        String uri = this.namespaceService.getNamespaceURI("test1");
        DictionaryModelTypeTest.assertNull((Object)uri);
        PropertyMap properties = new PropertyMap(1);
        properties.put(ContentModel.PROP_MODEL_ACTIVE, true);
        final NodeRef modelNode = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org", (String)"dictionaryModels"), ContentModel.TYPE_DICTIONARY_MODEL, (Map)properties).getChildRef();
        DictionaryModelTypeTest.assertNotNull((Object)modelNode);
        ContentWriter contentWriter = this.contentService.getWriter(modelNode, ContentModel.PROP_CONTENT, true);
        contentWriter.setEncoding("UTF-8");
        contentWriter.setMimetype("text/xml");
        contentWriter.putContent(MODEL_ONE_XML);
        this.setComplete();
        this.endTransaction();
        final NodeRef workingCopy = this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Exception {
                String uri = DictionaryModelTypeTest.this.namespaceService.getNamespaceURI("test1");
                Assert.assertNotNull((Object)uri);
                Assert.assertEquals((Object)QName.createQName((String)"{http://www.alfresco.org/test/testmodel1/1.0}testModelOne"), (Object)DictionaryModelTypeTest.this.nodeService.getProperty(modelNode, ContentModel.PROP_MODEL_NAME));
                Assert.assertEquals((Object)"Test model one", (Object)DictionaryModelTypeTest.this.nodeService.getProperty(modelNode, ContentModel.PROP_MODEL_DESCRIPTION));
                Assert.assertEquals((Object)"Alfresco", (Object)DictionaryModelTypeTest.this.nodeService.getProperty(modelNode, ContentModel.PROP_MODEL_AUTHOR));
                Assert.assertEquals((Object)"1.0", (Object)DictionaryModelTypeTest.this.nodeService.getProperty(modelNode, ContentModel.PROP_MODEL_VERSION));
                ModelDefinition modelDefinition2 = DictionaryModelTypeTest.this.dictionaryService.getModel(TEST_MODEL_ONE);
                Assert.assertNotNull((Object)modelDefinition2);
                Assert.assertEquals((String)"Test model one", (String)modelDefinition2.getDescription());
                String uri2 = DictionaryModelTypeTest.this.namespaceService.getNamespaceURI("test1");
                Assert.assertEquals((String)uri2, (String)"http://www.alfresco.org/test/testmodel1/1.0");
                NodeRef workingCopy = DictionaryModelTypeTest.this.cociService.checkout(modelNode);
                ContentWriter contentWriter2 = DictionaryModelTypeTest.this.contentService.getWriter(workingCopy, ContentModel.PROP_CONTENT, true);
                contentWriter2.putContent(DictionaryModelTypeTest.MODEL_ONE_MODIFIED_XML);
                return workingCopy;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                Assert.assertEquals((Object)"1.0", (Object)DictionaryModelTypeTest.this.nodeService.getProperty(workingCopy, ContentModel.PROP_MODEL_VERSION));
                DictionaryModelTypeTest.this.cociService.checkin(workingCopy, null);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                Assert.assertEquals((Object)"1.1", (Object)DictionaryModelTypeTest.this.nodeService.getProperty(modelNode, ContentModel.PROP_MODEL_VERSION));
                return null;
            }
        });
        final NodeRef node1 = this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Exception {
                NodeRef node = DictionaryModelTypeTest.this.nodeService.createNode(DictionaryModelTypeTest.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"node1"), QName.createQName((String)"http://www.alfresco.org/test/testmodel1/1.0", (String)"base"), null).getChildRef();
                Assert.assertNotNull((Object)node);
                return node;
            }
        });
        try {
            this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                @Override
                public Object execute() throws Exception {
                    DictionaryModelTypeTest.this.nodeService.deleteNode(modelNode);
                    return null;
                }
            });
            DictionaryModelTypeTest.fail((String)"Unexpected - should not be able to delete model");
        }
        catch (AlfrescoRuntimeException are) {
            // empty catch block
        }
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                DictionaryModelTypeTest.this.nodeService.deleteNode(node1);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                DictionaryModelTypeTest.this.nodeService.deleteNode(modelNode);
                return null;
            }
        });
    }

    public void testUpdateDictionaryModelPropertyDelete() {
        try {
            this.dictionaryService.getModel(TEST_MODEL_ONE);
            DictionaryModelTypeTest.fail((String)"This model has not yet been loaded into the dictionary service");
        }
        catch (DictionaryException exception) {
            // empty catch block
        }
        String uri = this.namespaceService.getNamespaceURI("test1");
        DictionaryModelTypeTest.assertNull((Object)uri);
        PropertyMap properties = new PropertyMap(1);
        properties.put(ContentModel.PROP_MODEL_ACTIVE, true);
        final NodeRef modelNode = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org", (String)"dictionaryModels"), ContentModel.TYPE_DICTIONARY_MODEL, (Map)properties).getChildRef();
        DictionaryModelTypeTest.assertNotNull((Object)modelNode);
        ContentWriter contentWriter = this.contentService.getWriter(modelNode, ContentModel.PROP_CONTENT, true);
        contentWriter.setEncoding("UTF-8");
        contentWriter.setMimetype("text/xml");
        contentWriter.putContent(MODEL_ONE_MODIFIED_XML);
        this.setComplete();
        this.endTransaction();
        final NodeRef node1 = this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Exception {
                String uri = DictionaryModelTypeTest.this.namespaceService.getNamespaceURI("test1");
                Assert.assertNotNull((Object)uri);
                PropertyMap properties = new PropertyMap(1);
                properties.put(QName.createQName((String)"http://www.alfresco.org/test/testmodel1/1.0", (String)"prop2"), "false");
                NodeRef node = DictionaryModelTypeTest.this.nodeService.createNode(DictionaryModelTypeTest.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org", (String)"node1"), QName.createQName((String)"http://www.alfresco.org/test/testmodel1/1.0", (String)"base"), (Map)properties).getChildRef();
                Assert.assertNotNull((Object)node);
                return node;
            }
        });
        final NodeRef workingCopy = this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Exception {
                NodeRef workingCopy = DictionaryModelTypeTest.this.cociService.checkout(modelNode);
                ContentWriter contentWriter2 = DictionaryModelTypeTest.this.contentService.getWriter(workingCopy, ContentModel.PROP_CONTENT, true);
                contentWriter2.putContent(DictionaryModelTypeTest.MODEL_ONE_MODIFIED2_XML);
                return workingCopy;
            }
        });
        try {
            this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                @Override
                public Object execute() throws Exception {
                    Assert.assertEquals((Object)"1.1", (Object)DictionaryModelTypeTest.this.nodeService.getProperty(workingCopy, ContentModel.PROP_MODEL_VERSION));
                    DictionaryModelTypeTest.this.cociService.checkin(workingCopy, null);
                    return null;
                }
            });
            DictionaryModelTypeTest.fail((String)"Unexpected - should not be able to update model");
        }
        catch (AlfrescoRuntimeException are) {
            // empty catch block
        }
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                DictionaryModelTypeTest.this.nodeService.deleteNode(node1);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                Assert.assertEquals((Object)"1.1", (Object)DictionaryModelTypeTest.this.nodeService.getProperty(workingCopy, ContentModel.PROP_MODEL_VERSION));
                DictionaryModelTypeTest.this.cociService.checkin(workingCopy, null);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                Assert.assertEquals((Object)"1.2", (Object)DictionaryModelTypeTest.this.nodeService.getProperty(modelNode, ContentModel.PROP_MODEL_VERSION));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                DictionaryModelTypeTest.this.nodeService.deleteNode(modelNode);
                return null;
            }
        });
    }

    public void testUpdateDictionaryModelConstraintDelete() {
        try {
            this.dictionaryService.getModel(TEST_MODEL_TWO);
            DictionaryModelTypeTest.fail((String)"This model has not yet been loaded into the dictionary service");
        }
        catch (DictionaryException exception) {
            // empty catch block
        }
        String uri = this.namespaceService.getNamespaceURI("test2");
        DictionaryModelTypeTest.assertNull((Object)uri);
        PropertyMap properties = new PropertyMap(1);
        properties.put(ContentModel.PROP_MODEL_ACTIVE, true);
        final NodeRef modelNode = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org", (String)"dictionaryModels"), ContentModel.TYPE_DICTIONARY_MODEL, (Map)properties).getChildRef();
        DictionaryModelTypeTest.assertNotNull((Object)modelNode);
        ContentWriter contentWriter = this.contentService.getWriter(modelNode, ContentModel.PROP_CONTENT, true);
        contentWriter.setEncoding("UTF-8");
        contentWriter.setMimetype("text/xml");
        contentWriter.putContent(MODEL_TWO_XML);
        this.setComplete();
        this.endTransaction();
        final NodeRef workingCopy = this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Exception {
                String uri = DictionaryModelTypeTest.this.namespaceService.getNamespaceURI("test2");
                Assert.assertNotNull((Object)uri);
                Collection constraints = DictionaryModelTypeTest.this.dictionaryService.getConstraints(TEST_MODEL_TWO, true);
                Assert.assertEquals((int)1, (int)constraints.size());
                Assert.assertEquals((String)"test2:con1", (String)((ConstraintDefinition)constraints.iterator().next()).getName().getPrefixString());
                NodeRef workingCopy = DictionaryModelTypeTest.this.cociService.checkout(modelNode);
                ContentWriter contentWriter2 = DictionaryModelTypeTest.this.contentService.getWriter(workingCopy, ContentModel.PROP_CONTENT, true);
                contentWriter2.putContent(DictionaryModelTypeTest.MODEL_TWO_INVALID_XML);
                return workingCopy;
            }
        });
        try {
            this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                @Override
                public Object execute() throws Exception {
                    Assert.assertEquals((Object)"1.0", (Object)DictionaryModelTypeTest.this.nodeService.getProperty(workingCopy, ContentModel.PROP_MODEL_VERSION));
                    DictionaryModelTypeTest.this.cociService.checkin(workingCopy, null);
                    return null;
                }
            });
            DictionaryModelTypeTest.fail((String)"Unexpected - should not be able to update model");
        }
        catch (AlfrescoRuntimeException are) {
            DictionaryModelTypeTest.assertTrue((boolean)are.getMessage().contains("Failed to validate constraint delete"));
        }
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                Assert.assertEquals((Object)"1.0", (Object)DictionaryModelTypeTest.this.nodeService.getProperty(modelNode, ContentModel.PROP_MODEL_VERSION));
                ContentWriter contentWriter2 = DictionaryModelTypeTest.this.contentService.getWriter(workingCopy, ContentModel.PROP_CONTENT, true);
                contentWriter2.putContent(DictionaryModelTypeTest.MODEL_TWO_MODIFIED_XML);
                DictionaryModelTypeTest.this.cociService.checkin(workingCopy, null);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                Collection constraints = DictionaryModelTypeTest.this.dictionaryService.getConstraints(TEST_MODEL_TWO, true);
                Assert.assertEquals((int)0, (int)constraints.size());
                Assert.assertEquals((Object)"1.1", (Object)DictionaryModelTypeTest.this.nodeService.getProperty(modelNode, ContentModel.PROP_MODEL_VERSION));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                DictionaryModelTypeTest.this.nodeService.deleteNode(modelNode);
                return null;
            }
        });
    }

    public void testIsActiveFlagAndDelete() {
        try {
            this.dictionaryService.getModel(TEST_MODEL_ONE);
            DictionaryModelTypeTest.fail((String)"This model has not yet been loaded into the dictionary service");
        }
        catch (DictionaryException exception) {
            // empty catch block
        }
        PropertyMap properties = new PropertyMap(1);
        final NodeRef modelNode = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org", (String)"dictionaryModels"), ContentModel.TYPE_DICTIONARY_MODEL, (Map)properties).getChildRef();
        DictionaryModelTypeTest.assertNotNull((Object)modelNode);
        ContentWriter contentWriter = this.contentService.getWriter(modelNode, ContentModel.PROP_CONTENT, true);
        contentWriter.setEncoding("UTF-8");
        contentWriter.setMimetype("text/xml");
        contentWriter.putContent(MODEL_ONE_XML);
        this.setComplete();
        this.endTransaction();
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                try {
                    DictionaryModelTypeTest.this.dictionaryService.getModel(TEST_MODEL_ONE);
                    Assert.fail((String)"This model has not yet been loaded into the dictionary service");
                }
                catch (DictionaryException dictionaryException) {
                    // empty catch block
                }
                DictionaryModelTypeTest.this.nodeService.setProperty(modelNode, ContentModel.PROP_MODEL_ACTIVE, (Serializable)Boolean.valueOf(true));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                Assert.assertNotNull((Object)DictionaryModelTypeTest.this.dictionaryService.getModel(TEST_MODEL_ONE));
                DictionaryModelTypeTest.this.nodeService.setProperty(modelNode, ContentModel.PROP_MODEL_ACTIVE, (Serializable)Boolean.valueOf(false));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                try {
                    DictionaryModelTypeTest.this.dictionaryService.getModel(TEST_MODEL_ONE);
                    Assert.fail((String)"This model has not yet been loaded into the dictionary service");
                }
                catch (DictionaryException dictionaryException) {
                    // empty catch block
                }
                DictionaryModelTypeTest.this.nodeService.setProperty(modelNode, ContentModel.PROP_MODEL_ACTIVE, (Serializable)Boolean.valueOf(true));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                Assert.assertNotNull((Object)DictionaryModelTypeTest.this.dictionaryService.getModel(TEST_MODEL_ONE));
                DictionaryModelTypeTest.this.nodeService.deleteNode(modelNode);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                try {
                    DictionaryModelTypeTest.this.dictionaryService.getModel(TEST_MODEL_ONE);
                    Assert.fail((String)"This model has not yet been loaded into the dictionary service");
                }
                catch (DictionaryException dictionaryException) {
                    // empty catch block
                }
                return null;
            }
        });
    }
}

