/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.EhCacheAdapter;
import org.alfresco.repo.dictionary.DictionaryBootstrap;
import org.alfresco.repo.dictionary.DictionaryComponent;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryDAOImpl;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Property;
import org.alfresco.repo.dictionary.M2Type;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.repo.dictionary.NamespaceDAOImpl;
import org.alfresco.repo.dictionary.constraint.ConstraintRegistry;
import org.alfresco.repo.dictionary.constraint.RegexConstraint;
import org.alfresco.repo.dictionary.constraint.RegisteredConstraint;
import org.alfresco.repo.dictionary.constraint.StringLengthConstraint;
import org.alfresco.repo.dictionary.constraint.UserNameConstraint;
import org.alfresco.repo.tenant.SingleTServiceImpl;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ChildAssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.Constraint;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.surf.util.I18NUtil;

public class RepoDictionaryDAOTest
extends TestCase {
    public static final String TEST_RESOURCE_MESSAGES = "alfresco/messages/dictionary-messages";
    private static final String TEST_URL = "http://www.alfresco.org/test/dictionarydaotest/1.0";
    private static final String TEST_MODEL = "org/alfresco/repo/dictionary/dictionarydaotest_model.xml";
    private static final String TEST_BUNDLE = "org/alfresco/repo/dictionary/dictionarydaotest_model";
    private DictionaryService service;

    public void setUp() {
        ConstraintRegistry constraintRegistry = ConstraintRegistry.getInstance();
        UserNameConstraint constraintReg1 = new UserNameConstraint();
        constraintReg1.setShortName("cm:reg1");
        constraintReg1.setRegistry(constraintRegistry);
        constraintReg1.initialize();
        UserNameConstraint constraintReg2 = new UserNameConstraint();
        constraintReg2.setShortName("cm:reg2");
        constraintReg2.setRegistry(constraintRegistry);
        constraintReg2.initialize();
        I18NUtil.registerResourceBundle((String)TEST_RESOURCE_MESSAGES);
        SingleTServiceImpl tenantService = new SingleTServiceImpl();
        NamespaceDAOImpl namespaceDAO = new NamespaceDAOImpl();
        namespaceDAO.setTenantService((TenantService)tenantService);
        this.initNamespaceCaches(namespaceDAO);
        DictionaryDAOImpl dictionaryDAO = new DictionaryDAOImpl((NamespaceDAO)namespaceDAO);
        dictionaryDAO.setTenantService((TenantService)tenantService);
        this.initDictionaryCaches(dictionaryDAO);
        DictionaryBootstrap bootstrap = new DictionaryBootstrap();
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add("alfresco/model/dictionaryModel.xml");
        bootstrapModels.add(TEST_MODEL);
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(TEST_BUNDLE);
        bootstrap.setModels(bootstrapModels);
        bootstrap.setLabels(labels);
        bootstrap.setDictionaryDAO((DictionaryDAO)dictionaryDAO);
        bootstrap.setTenantService((TenantService)tenantService);
        bootstrap.bootstrap();
        DictionaryComponent component = new DictionaryComponent();
        component.setDictionaryDAO((DictionaryDAO)dictionaryDAO);
        this.service = component;
    }

    private void initDictionaryCaches(DictionaryDAOImpl dictionaryDAO) {
        CacheManager cacheManager = new CacheManager();
        Cache dictionaryEhCache = new Cache("dictionaryCache", 50, false, true, 0L, 0L);
        cacheManager.addCache(dictionaryEhCache);
        EhCacheAdapter dictionaryCache = new EhCacheAdapter();
        dictionaryCache.setCache(dictionaryEhCache);
        dictionaryDAO.setDictionaryRegistryCache(dictionaryCache);
    }

    private void initNamespaceCaches(NamespaceDAOImpl namespaceDAO) {
        CacheManager cacheManager = new CacheManager();
        Cache namespaceEhCache = new Cache("namespaceCache", 50, false, true, 0L, 0L);
        cacheManager.addCache(namespaceEhCache);
        EhCacheAdapter namespaceCache = new EhCacheAdapter();
        namespaceCache.setCache(namespaceEhCache);
        namespaceDAO.setNamespaceRegistryCache(namespaceCache);
    }

    public void testBootstrap() {
        SingleTServiceImpl tenantService = new SingleTServiceImpl();
        NamespaceDAOImpl namespaceDAO = new NamespaceDAOImpl();
        namespaceDAO.setTenantService((TenantService)tenantService);
        this.initNamespaceCaches(namespaceDAO);
        DictionaryDAOImpl dictionaryDAO = new DictionaryDAOImpl((NamespaceDAO)namespaceDAO);
        dictionaryDAO.setTenantService((TenantService)tenantService);
        this.initDictionaryCaches(dictionaryDAO);
        DictionaryBootstrap bootstrap = new DictionaryBootstrap();
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add("alfresco/model/dictionaryModel.xml");
        bootstrapModels.add("alfresco/model/systemModel.xml");
        bootstrapModels.add("alfresco/model/contentModel.xml");
        bootstrapModels.add("alfresco/model/wcmModel.xml");
        bootstrapModels.add("alfresco/model/applicationModel.xml");
        bootstrapModels.add("org/alfresco/repo/security/authentication/userModel.xml");
        bootstrapModels.add("org/alfresco/repo/action/actionModel.xml");
        bootstrapModels.add("org/alfresco/repo/rule/ruleModel.xml");
        bootstrapModels.add("org/alfresco/repo/version/version_model.xml");
        bootstrap.setModels(bootstrapModels);
        bootstrap.setDictionaryDAO((DictionaryDAO)dictionaryDAO);
        bootstrap.setTenantService((TenantService)tenantService);
        bootstrap.bootstrap();
    }

    public void testLabels() {
        QName model = QName.createQName((String)TEST_URL, (String)"dictionarydaotest");
        ModelDefinition modelDef = this.service.getModel(model);
        RepoDictionaryDAOTest.assertEquals((String)"Model Description", (String)modelDef.getDescription());
        QName type = QName.createQName((String)TEST_URL, (String)"base");
        TypeDefinition typeDef = this.service.getType(type);
        RepoDictionaryDAOTest.assertEquals((String)"Base Title", (String)typeDef.getTitle());
        RepoDictionaryDAOTest.assertEquals((String)"Base Description", (String)typeDef.getDescription());
        QName prop = QName.createQName((String)TEST_URL, (String)"prop1");
        PropertyDefinition propDef = this.service.getProperty(prop);
        RepoDictionaryDAOTest.assertEquals((String)"Prop1 Title", (String)propDef.getTitle());
        RepoDictionaryDAOTest.assertEquals((String)"Prop1 Description", (String)propDef.getDescription());
        QName assoc = QName.createQName((String)TEST_URL, (String)"assoc1");
        AssociationDefinition assocDef = this.service.getAssociation(assoc);
        RepoDictionaryDAOTest.assertEquals((String)"Assoc1 Title", (String)assocDef.getTitle());
        RepoDictionaryDAOTest.assertEquals((String)"Assoc1 Description", (String)assocDef.getDescription());
        QName datatype = QName.createQName((String)TEST_URL, (String)"datatype");
        DataTypeDefinition datatypeDef = this.service.getDataType(datatype);
        RepoDictionaryDAOTest.assertEquals((String)"Datatype Analyser", (String)datatypeDef.getAnalyserClassName());
    }

    public void testConstraints() {
        RepoDictionaryDAOTest.assertNotNull((String)"Constraint reg1 not registered", (Object)ConstraintRegistry.getInstance().getConstraint("cm:reg1"));
        RepoDictionaryDAOTest.assertNotNull((String)"Constraint reg2 not registered", (Object)ConstraintRegistry.getInstance().getConstraint("cm:reg2"));
        QName model = QName.createQName((String)TEST_URL, (String)"dictionarydaotest");
        Collection modelConstraints = this.service.getConstraints(model);
        RepoDictionaryDAOTest.assertEquals((int)15, (int)modelConstraints.size());
        QName conRegExp1QName = QName.createQName((String)TEST_URL, (String)"regex1");
        boolean found1 = false;
        QName conStrLen1QName = QName.createQName((String)TEST_URL, (String)"stringLength1");
        boolean found2 = false;
        for (ConstraintDefinition constraintDef : modelConstraints) {
            if (constraintDef.getName().equals((Object)conRegExp1QName)) {
                RepoDictionaryDAOTest.assertEquals((String)"Regex1 title", (String)constraintDef.getTitle());
                RepoDictionaryDAOTest.assertEquals((String)"Regex1 description", (String)constraintDef.getDescription());
                found1 = true;
            }
            if (!constraintDef.getName().equals((Object)conStrLen1QName)) continue;
            RepoDictionaryDAOTest.assertNull((Object)constraintDef.getTitle());
            RepoDictionaryDAOTest.assertNull((Object)constraintDef.getDescription());
            found2 = true;
        }
        RepoDictionaryDAOTest.assertTrue((boolean)found1);
        RepoDictionaryDAOTest.assertTrue((boolean)found2);
        QName propNoConstraintsQName = QName.createQName((String)TEST_URL, (String)"fileprop");
        PropertyDefinition propNoConstraintsDef = this.service.getProperty(propNoConstraintsQName);
        RepoDictionaryDAOTest.assertNotNull((String)"Property without constraints returned null list", (Object)propNoConstraintsDef.getConstraints());
        QName prop1QName = QName.createQName((String)TEST_URL, (String)"prop1");
        PropertyDefinition propDef = this.service.getProperty(prop1QName);
        List constraints = propDef.getConstraints();
        RepoDictionaryDAOTest.assertNotNull((String)"Null constraints list", (Object)constraints);
        RepoDictionaryDAOTest.assertEquals((String)"Incorrect number of constraints", (int)3, (int)constraints.size());
        RepoDictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(((ConstraintDefinition)constraints.get(0)).getConstraint() instanceof RegexConstraint));
        RepoDictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(((ConstraintDefinition)constraints.get(1)).getConstraint() instanceof StringLengthConstraint));
        RepoDictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(((ConstraintDefinition)constraints.get(2)).getConstraint() instanceof RegisteredConstraint));
        ConstraintDefinition constraintDef = (ConstraintDefinition)constraints.get(0);
        RepoDictionaryDAOTest.assertTrue((String)"Constraint anonymous name incorrect", (boolean)constraintDef.getName().getLocalName().startsWith("prop1_anon"));
        RepoDictionaryDAOTest.assertTrue((String)"Constraint title incorrect", (boolean)constraintDef.getTitle().equals("Regex1 title"));
        RepoDictionaryDAOTest.assertTrue((String)"Constraint description incorrect", (boolean)constraintDef.getDescription().equals("Regex1 description"));
        constraintDef = (ConstraintDefinition)constraints.get(1);
        RepoDictionaryDAOTest.assertTrue((String)"Constraint anonymous name incorrect", (boolean)constraintDef.getName().getLocalName().startsWith("prop1_anon"));
        RepoDictionaryDAOTest.assertTrue((String)"Constraint title incorrect", (boolean)constraintDef.getTitle().equals("Prop1 Strlen1 title"));
        RepoDictionaryDAOTest.assertTrue((String)"Constraint description incorrect", (boolean)constraintDef.getDescription().equals("Prop1 Strlen1 description"));
        Constraint constraint = constraintDef.getConstraint();
        RepoDictionaryDAOTest.assertNotNull((String)"Reference constraint has no implementation", (Object)constraint);
    }

    public void testConstraintsOverrideInheritance() {
        QName baseQName = QName.createQName((String)TEST_URL, (String)"base");
        QName fileQName = QName.createQName((String)TEST_URL, (String)"file");
        QName folderQName = QName.createQName((String)TEST_URL, (String)"folder");
        QName prop1QName = QName.createQName((String)TEST_URL, (String)"prop1");
        PropertyDefinition prop1Def = this.service.getProperty(baseQName, prop1QName);
        RepoDictionaryDAOTest.assertNotNull((Object)prop1Def);
        List prop1Constraints = prop1Def.getConstraints();
        RepoDictionaryDAOTest.assertEquals((String)"Incorrect number of constraints", (int)3, (int)prop1Constraints.size());
        RepoDictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(((ConstraintDefinition)prop1Constraints.get(0)).getConstraint() instanceof RegexConstraint));
        RepoDictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(((ConstraintDefinition)prop1Constraints.get(1)).getConstraint() instanceof StringLengthConstraint));
        RepoDictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(((ConstraintDefinition)prop1Constraints.get(2)).getConstraint() instanceof RegisteredConstraint));
        prop1Def = this.service.getProperty(folderQName, prop1QName);
        RepoDictionaryDAOTest.assertNotNull((Object)prop1Def);
        prop1Constraints = prop1Def.getConstraints();
        RepoDictionaryDAOTest.assertEquals((String)"Incorrect number of constraints", (int)3, (int)prop1Constraints.size());
        RepoDictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(((ConstraintDefinition)prop1Constraints.get(0)).getConstraint() instanceof RegexConstraint));
        RepoDictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(((ConstraintDefinition)prop1Constraints.get(1)).getConstraint() instanceof StringLengthConstraint));
        RepoDictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(((ConstraintDefinition)prop1Constraints.get(2)).getConstraint() instanceof RegisteredConstraint));
        prop1Def = this.service.getProperty(fileQName, prop1QName);
        RepoDictionaryDAOTest.assertNotNull((Object)prop1Def);
        prop1Constraints = prop1Def.getConstraints();
        RepoDictionaryDAOTest.assertEquals((String)"Incorrect number of constraints", (int)3, (int)prop1Constraints.size());
        RepoDictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(((ConstraintDefinition)prop1Constraints.get(0)).getConstraint() instanceof StringLengthConstraint));
        RepoDictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(((ConstraintDefinition)prop1Constraints.get(1)).getConstraint() instanceof RegexConstraint));
        RepoDictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(((ConstraintDefinition)prop1Constraints.get(2)).getConstraint() instanceof RegisteredConstraint));
    }

    public void testArchive() {
        QName testFileQName = QName.createQName((String)TEST_URL, (String)"file");
        ClassDefinition fileClassDef = this.service.getClass(testFileQName);
        RepoDictionaryDAOTest.assertTrue((String)"File type should have the archive flag", (boolean)fileClassDef.getArchive());
        QName testFileDerivedQName = QName.createQName((String)TEST_URL, (String)"file-derived");
        ClassDefinition fileDerivedClassDef = this.service.getClass(testFileDerivedQName);
        RepoDictionaryDAOTest.assertTrue((String)"Direct derived File type should have the archive flag", (boolean)fileDerivedClassDef.getArchive());
        QName testFileDerivedNoArchiveQName = QName.createQName((String)TEST_URL, (String)"file-derived-no-archive");
        ClassDefinition fileDerivedNoArchiveClassDef = this.service.getClass(testFileDerivedNoArchiveQName);
        RepoDictionaryDAOTest.assertFalse((String)"Derived File with archive override type should NOT have the archive flag", (boolean)fileDerivedNoArchiveClassDef.getArchive());
        QName testFolderQName = QName.createQName((String)TEST_URL, (String)"folder");
        ClassDefinition folderClassDef = this.service.getClass(testFolderQName);
        RepoDictionaryDAOTest.assertNull((String)"Folder type should not have the archive flag", (Object)folderClassDef.getArchive());
    }

    public void testMandatoryEnforced() {
        QName testEnforcedQName = QName.createQName((String)TEST_URL, (String)"enforced");
        ClassDefinition testEnforcedClassDef = this.service.getClass(testEnforcedQName);
        Map testEnforcedPropertyDefs = testEnforcedClassDef.getProperties();
        PropertyDefinition propertyDef = null;
        QName testMandatoryEnforcedQName = QName.createQName((String)TEST_URL, (String)"mandatory-enforced");
        propertyDef = (PropertyDefinition)testEnforcedPropertyDefs.get(testMandatoryEnforcedQName);
        RepoDictionaryDAOTest.assertNotNull((String)("Property not found: " + testMandatoryEnforcedQName), (Object)propertyDef);
        RepoDictionaryDAOTest.assertTrue((String)("Expected property to be mandatory: " + testMandatoryEnforcedQName), (boolean)propertyDef.isMandatory());
        RepoDictionaryDAOTest.assertTrue((String)("Expected property to be mandatory-enforced: " + testMandatoryEnforcedQName), (boolean)propertyDef.isMandatoryEnforced());
        QName testMandatoryNotEnforcedQName = QName.createQName((String)TEST_URL, (String)"mandatory-not-enforced");
        propertyDef = (PropertyDefinition)testEnforcedPropertyDefs.get(testMandatoryNotEnforcedQName);
        RepoDictionaryDAOTest.assertNotNull((String)("Property not found: " + testMandatoryNotEnforcedQName), (Object)propertyDef);
        RepoDictionaryDAOTest.assertTrue((String)("Expected property to be mandatory: " + testMandatoryNotEnforcedQName), (boolean)propertyDef.isMandatory());
        RepoDictionaryDAOTest.assertFalse((String)("Expected property to be mandatory-not-enforced: " + testMandatoryNotEnforcedQName), (boolean)propertyDef.isMandatoryEnforced());
        QName testMandatoryDefaultEnforcedQName = QName.createQName((String)TEST_URL, (String)"mandatory-default-enforced");
        propertyDef = (PropertyDefinition)testEnforcedPropertyDefs.get(testMandatoryDefaultEnforcedQName);
        RepoDictionaryDAOTest.assertNotNull((String)("Property not found: " + testMandatoryDefaultEnforcedQName), (Object)propertyDef);
        RepoDictionaryDAOTest.assertTrue((String)("Expected property to be mandatory: " + testMandatoryDefaultEnforcedQName), (boolean)propertyDef.isMandatory());
        RepoDictionaryDAOTest.assertFalse((String)("Expected property to be mandatory-not-enforced: " + testMandatoryDefaultEnforcedQName), (boolean)propertyDef.isMandatoryEnforced());
    }

    public void testSubClassOf() {
        QName invalid = QName.createQName((String)TEST_URL, (String)"invalid");
        QName base = QName.createQName((String)TEST_URL, (String)"base");
        QName file = QName.createQName((String)TEST_URL, (String)"file");
        QName folder = QName.createQName((String)TEST_URL, (String)"folder");
        QName referenceable = QName.createQName((String)TEST_URL, (String)"referenceable");
        boolean testI1 = this.service.isSubClass(invalid, referenceable);
        RepoDictionaryDAOTest.assertFalse((boolean)testI1);
        boolean testI2 = this.service.isSubClass(referenceable, invalid);
        RepoDictionaryDAOTest.assertFalse((boolean)testI2);
        boolean testI3 = this.service.isSubClass(invalid, invalid);
        RepoDictionaryDAOTest.assertFalse((boolean)testI3);
        boolean test1 = this.service.isSubClass(file, referenceable);
        RepoDictionaryDAOTest.assertFalse((boolean)test1);
        boolean test2 = this.service.isSubClass(file, folder);
        RepoDictionaryDAOTest.assertFalse((boolean)test2);
        boolean test3 = this.service.isSubClass(file, file);
        RepoDictionaryDAOTest.assertTrue((boolean)test3);
        boolean test4 = this.service.isSubClass(folder, base);
        RepoDictionaryDAOTest.assertTrue((boolean)test4);
        boolean test5 = this.service.isSubClass(base, folder);
        RepoDictionaryDAOTest.assertFalse((boolean)test5);
    }

    public void testPropertyOverride() {
        TypeDefinition type1 = this.service.getType(QName.createQName((String)TEST_URL, (String)"overridetype1"));
        Map props1 = type1.getProperties();
        PropertyDefinition prop1 = (PropertyDefinition)props1.get(QName.createQName((String)TEST_URL, (String)"propoverride"));
        String def1 = prop1.getDefaultValue();
        RepoDictionaryDAOTest.assertEquals((String)"one", (String)def1);
        TypeDefinition type2 = this.service.getType(QName.createQName((String)TEST_URL, (String)"overridetype2"));
        Map props2 = type2.getProperties();
        PropertyDefinition prop2 = (PropertyDefinition)props2.get(QName.createQName((String)TEST_URL, (String)"propoverride"));
        String def2 = prop2.getDefaultValue();
        RepoDictionaryDAOTest.assertEquals((String)"two", (String)def2);
        TypeDefinition type3 = this.service.getType(QName.createQName((String)TEST_URL, (String)"overridetype3"));
        Map props3 = type3.getProperties();
        PropertyDefinition prop3 = (PropertyDefinition)props3.get(QName.createQName((String)TEST_URL, (String)"propoverride"));
        String def3 = prop3.getDefaultValue();
        RepoDictionaryDAOTest.assertEquals((String)"three", (String)def3);
    }

    public void testChildAssocPropagate() {
        AssociationDefinition assocDef = this.service.getAssociation(QName.createQName((String)TEST_URL, (String)"childassoc1"));
        RepoDictionaryDAOTest.assertNotNull((String)"No such child association found", (Object)assocDef);
        RepoDictionaryDAOTest.assertTrue((String)"Expected a child association", (boolean)(assocDef instanceof ChildAssociationDefinition));
        ChildAssociationDefinition childAssocDef = (ChildAssociationDefinition)assocDef;
        RepoDictionaryDAOTest.assertFalse((String)"Expected 'false' for default timestamp propagation", (boolean)childAssocDef.getPropagateTimestamps());
        assocDef = this.service.getAssociation(QName.createQName((String)TEST_URL, (String)"childassocPropagate"));
        RepoDictionaryDAOTest.assertNotNull((String)"No such child association found", (Object)assocDef);
        RepoDictionaryDAOTest.assertTrue((String)"Expected a child association", (boolean)(assocDef instanceof ChildAssociationDefinition));
        childAssocDef = (ChildAssociationDefinition)assocDef;
        RepoDictionaryDAOTest.assertTrue((String)"Expected 'true' for timestamp propagation", (boolean)childAssocDef.getPropagateTimestamps());
    }

    public void testADB159() throws UnsupportedEncodingException {
        SingleTServiceImpl tenantService = new SingleTServiceImpl();
        NamespaceDAOImpl namespaceDAO = new NamespaceDAOImpl();
        namespaceDAO.setTenantService((TenantService)tenantService);
        this.initNamespaceCaches(namespaceDAO);
        DictionaryDAOImpl dictionaryDAO = new DictionaryDAOImpl((NamespaceDAO)namespaceDAO);
        dictionaryDAO.setTenantService((TenantService)tenantService);
        this.initDictionaryCaches(dictionaryDAO);
        NamespaceDAOImpl namespaceDAO2 = new NamespaceDAOImpl();
        namespaceDAO2.setTenantService((TenantService)tenantService);
        this.initNamespaceCaches(namespaceDAO2);
        DictionaryDAOImpl dictionaryDAO2 = new DictionaryDAOImpl((NamespaceDAO)namespaceDAO2);
        dictionaryDAO2.setTenantService((TenantService)tenantService);
        this.initDictionaryCaches(dictionaryDAO2);
        ArrayList<String> models = new ArrayList<String>();
        models.add("alfresco/model/dictionaryModel.xml");
        models.add("alfresco/model/systemModel.xml");
        models.add("alfresco/model/contentModel.xml");
        models.add("alfresco/model/wcmModel.xml");
        models.add("alfresco/model/applicationModel.xml");
        models.add("org/alfresco/repo/security/authentication/userModel.xml");
        models.add("org/alfresco/repo/action/actionModel.xml");
        models.add("org/alfresco/repo/rule/ruleModel.xml");
        models.add("org/alfresco/repo/version/version_model.xml");
        for (String bootstrapModel : models) {
            InputStream modelStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(bootstrapModel);
            if (modelStream == null) {
                throw new DictionaryException("Could not find bootstrap model " + bootstrapModel);
            }
            try {
                M2Model model = M2Model.createModel((InputStream)modelStream);
                dictionaryDAO.putModel(model);
                ByteArrayOutputStream xml1 = new ByteArrayOutputStream();
                model.toXML((OutputStream)xml1);
                M2Model model2 = M2Model.createModel((InputStream)new ByteArrayInputStream(xml1.toByteArray()));
                dictionaryDAO2.putModel(model2);
            }
            catch (DictionaryException e) {
                throw new DictionaryException("Could not import bootstrap model " + bootstrapModel, (Throwable)e);
            }
        }
        M2Model model = M2Model.createModel((String)"test:adb25");
        model.createNamespace(TEST_URL, "test");
        model.createImport("http://www.alfresco.org/model/dictionary/1.0", "d");
        model.createImport("http://www.alfresco.org/model/system/1.0", "sys");
        model.createImport("http://www.alfresco.org/model/content/1.0", "cm");
        M2Type testType = model.createType("test:adb25");
        testType.setParentName("cm:" + ContentModel.TYPE_CONTENT.getLocalName());
        M2Property prop1 = testType.createProperty("test:prop1");
        prop1.setMandatory(false);
        prop1.setType("d:" + DataTypeDefinition.TEXT.getLocalName());
        prop1.setMultiValued(false);
        ByteArrayOutputStream xml1 = new ByteArrayOutputStream();
        model.toXML((OutputStream)xml1);
    }
}

