/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain;

import java.io.UnsupportedEncodingException;
import java.util.zip.CRC32;
import org.alfresco.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrcHelper {
    public static final String EMPTY_STRING = ".empty";

    public static Pair<String, Long> getStringCrcPair(String value, int dataLength, boolean useCharsFromStart, boolean caseSensitive) {
        Long valueCrc;
        if (value == null) {
            return new Pair(null, null);
        }
        String valueLowerCase = value.length() == 0 ? (value = EMPTY_STRING) : value.toLowerCase();
        try {
            CRC32 crc = new CRC32();
            if (caseSensitive) {
                crc.update(value.getBytes("UTF-8"));
            } else {
                crc.update(valueLowerCase.getBytes("UTF-8"));
            }
            valueCrc = crc.getValue();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding is not supported");
        }
        String valueShort = null;
        int valueLen = valueLowerCase.length();
        valueShort = valueLen < dataLength ? valueLowerCase : (useCharsFromStart ? valueLowerCase.substring(0, dataLength - 1) : valueLowerCase.substring(valueLen - dataLength));
        return new Pair((Object)valueShort, (Object)valueCrc);
    }
}

