/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.control.ibatis;

import com.ibatis.sqlmap.client.SqlMapClient;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import javax.sql.DataSource;
import org.alfresco.repo.domain.control.AbstractControlDAOImpl;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.orm.ibatis.SqlMapClientTemplate;

public class ControlDAOImpl
extends AbstractControlDAOImpl {
    protected SqlMapClientTemplate template;

    public void setSqlMapClientTemplate(SqlMapClientTemplate sqlMapClientTemplate) {
        this.template = sqlMapClientTemplate;
    }

    public void startBatch() {
        SqlMapClient sqlMapClient = this.template.getSqlMapClient();
        try {
            sqlMapClient.startTransaction();
            sqlMapClient.startBatch();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to start DAO batch.", e);
        }
    }

    public void executeBatch() {
        SqlMapClient sqlMapClient = this.template.getSqlMapClient();
        try {
            sqlMapClient.executeBatch();
            sqlMapClient.commitTransaction();
            sqlMapClient.endTransaction();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to start DAO batch.", e);
        }
    }

    public int setTransactionIsolationLevel(int isolationLevel) {
        Connection connection = DataSourceUtils.getConnection((DataSource)this.template.getDataSource());
        if (connection == null) {
            throw new NullPointerException("There is no current connection");
        }
        try {
            if (!connection.getMetaData().supportsTransactionIsolationLevel(isolationLevel)) {
                throw new IllegalStateException("Transaction isolation level not supported: " + isolationLevel);
            }
            int isolationLevelWas = connection.getTransactionIsolation();
            connection.setTransactionIsolation(isolationLevel);
            return isolationLevelWas;
        }
        catch (SQLException e) {
            throw new IllegalStateException("Failed to set transaction isolation level: " + isolationLevel, e);
        }
    }

    public static class PostgreSQL
    extends ControlDAOImpl {
        public Savepoint createSavepoint(String savepoint) {
            try {
                Connection connection = DataSourceUtils.getConnection((DataSource)this.template.getDataSource());
                return connection.setSavepoint(savepoint);
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to create SAVEPOINT: " + savepoint, e);
            }
        }

        public void rollbackToSavepoint(Savepoint savepoint) {
            try {
                Connection connection = DataSourceUtils.getConnection((DataSource)this.template.getDataSource());
                connection.rollback(savepoint);
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to create SAVEPOINT: " + savepoint, e);
            }
        }

        public void releaseSavepoint(Savepoint savepoint) {
            try {
                Connection connection = DataSourceUtils.getConnection((DataSource)this.template.getDataSource());
                connection.releaseSavepoint(savepoint);
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to create SAVEPOINT: " + savepoint, e);
            }
        }
    }
}

