/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.locale;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.repo.domain.locale.LocaleDAO;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocaleDAOTest
extends TestCase {
    private static Log logger = LogFactory.getLog(LocaleDAOTest.class);
    private ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private RetryingTransactionHelper txnHelper;
    private LocaleDAO localeDAO;

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.localeDAO = (LocaleDAO)this.ctx.getBean("localeDAO");
    }

    public void tearDown() throws Exception {
    }

    private Pair<Long, Locale> getLocale(final Locale locale, boolean expectSuccess) {
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Locale>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Locale>>(){

            @Override
            public Pair<Long, Locale> execute() throws Throwable {
                Pair<Long, Locale> localePair = LocaleDAOTest.this.localeDAO.getOrCreateLocalePair(locale);
                return localePair;
            }
        };
        try {
            return this.txnHelper.doInTransaction(callback, false);
        }
        catch (Throwable e) {
            if (expectSuccess) {
                throw new RuntimeException("Expected to get locale '" + locale + "'.", e);
            }
            return null;
        }
    }

    public void testCreateLocale() throws Exception {
        Locale locale = new Locale(GUID.generate().substring(0, 20));
        Pair<Long, Locale> localePair = this.getLocale(locale, true);
        Pair<Long, Locale> localePairCheck = this.getLocale((Locale)localePair.getSecond(), true);
        LocaleDAOTest.assertEquals((String)"Locale ID changed", (Object)localePair.getFirst(), (Object)localePairCheck.getFirst());
        this.getLocale(locale, false);
    }

    public void testCreateLocaleEmpty() throws Exception {
        Locale locale = new Locale("");
        Pair<Long, Locale> localePair = this.getLocale(locale, true);
        Pair<Long, Locale> localePairCheck = this.getLocale((Locale)localePair.getSecond(), true);
        LocaleDAOTest.assertEquals((String)"Locale ID changed", (Object)localePair.getFirst(), (Object)localePairCheck.getFirst());
    }

    public void testDefaultLocale() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Locale>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Locale>>(){

            @Override
            public Pair<Long, Locale> execute() throws Throwable {
                Locale defaultLocale = I18NUtil.getLocale();
                Pair<Long, Locale> localePair = LocaleDAOTest.this.localeDAO.getOrCreateDefaultLocalePair();
                Assert.assertNotNull((String)"Default locale should now exist", localePair);
                Assert.assertEquals((String)"The default locale returned must match the current thread's default locale", (Object)defaultLocale, (Object)localePair.getSecond());
                return localePair;
            }
        };
        this.txnHelper.doInTransaction(callback);
        I18NUtil.setLocale((Locale)Locale.CANADA_FRENCH);
        this.txnHelper.doInTransaction(callback);
    }

    public void testConcurrentLocale() throws Throwable {
        final Locale locale = Locale.SIMPLIFIED_CHINESE;
        int threadCount = 50;
        final CountDownLatch readyLatch = new CountDownLatch(threadCount);
        final CountDownLatch startLatch = new CountDownLatch(1);
        final CountDownLatch doneLatch = new CountDownLatch(threadCount);
        final List errors = Collections.synchronizedList(new ArrayList(0));
        final RetryingTransactionHelper.RetryingTransactionCallback<Long> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            @Override
            public Long execute() throws Throwable {
                String threadName = Thread.currentThread().getName();
                logger.debug((Object)("Thread " + threadName + " is READY"));
                readyLatch.countDown();
                startLatch.await();
                logger.debug((Object)("Thread " + threadName + " is GO"));
                Pair<Long, Locale> localePair = null;
                try {
                    logger.debug((Object)("Thread " + threadName + " is CREATING " + locale));
                    localePair = LocaleDAOTest.this.localeDAO.getOrCreateLocalePair(locale);
                }
                catch (Throwable e) {
                    logger.debug((Object)"Failed to create LocaleEntity.  Might retry.", e);
                    throw e;
                }
                logger.debug((Object)("Thread " + threadName + " is DONE"));
                doneLatch.countDown();
                return (Long)localePair.getFirst();
            }
        };
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    LocaleDAOTest.this.txnHelper.doInTransaction(callback);
                }
                catch (Throwable e) {
                    logger.error((Object)"Error escaped from retry", e);
                    errors.add(e);
                }
            }
        };
        for (int i = 0; i < threadCount; ++i) {
            Thread thread = new Thread(runnable, this.getName() + "-" + i);
            thread.setDaemon(true);
            thread.start();
        }
        readyLatch.await(5L, TimeUnit.SECONDS);
        startLatch.countDown();
        if (doneLatch.await(threadCount * 10, TimeUnit.SECONDS)) {
            logger.warn((Object)("Still waiting for threads to finish after " + threadCount + " seconds."));
        }
        if (errors.size() > 0) {
            throw (Throwable)errors.get(0);
        }
    }
}

